/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.spawning;

import com.pixelmonmod.pixelmon.api.spawning.SpawnInfo;
import com.pixelmonmod.pixelmon.api.spawning.SpawnLocation;
import com.pixelmonmod.pixelmon.api.spawning.conditions.SpawnCondition;
import java.util.ArrayList;

public class CompositeSpawnCondition {
    public ArrayList<SpawnCondition> conditions = new ArrayList();
    public ArrayList<SpawnCondition> anticonditions = new ArrayList();

    public CompositeSpawnCondition() {
    }

    public CompositeSpawnCondition(ArrayList<SpawnCondition> conditions, ArrayList<SpawnCondition> anticonditions) {
        this.conditions = conditions;
        this.anticonditions = anticonditions;
    }

    public boolean fits(SpawnInfo spawnInfo, SpawnLocation spawnLocation) {
        boolean fitsNormal = false;
        if (this.conditions == null || this.conditions.isEmpty()) {
            fitsNormal = true;
        } else {
            for (int i = 0; i < this.conditions.size(); ++i) {
                if (!this.conditions.get(i).fits(spawnInfo, spawnLocation)) continue;
                fitsNormal = true;
                break;
            }
        }
        boolean fitsAnti = false;
        if (this.anticonditions != null && !this.anticonditions.isEmpty()) {
            for (int i = 0; i < this.anticonditions.size(); ++i) {
                if (!this.anticonditions.get(i).fits(spawnInfo, spawnLocation)) continue;
                fitsAnti = true;
                break;
            }
        }
        return fitsNormal && !fitsAnti;
    }

    public void onImport() {
        if (this.conditions != null) {
            this.conditions.forEach(SpawnCondition::onImport);
        }
        if (this.anticonditions != null) {
            this.anticonditions.forEach(SpawnCondition::onImport);
        }
    }
}

