/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.spawning.archetypes.algorithms.selection;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.RandomHelper;
import com.pixelmonmod.pixelmon.api.spawning.AbstractSpawner;
import com.pixelmonmod.pixelmon.api.spawning.SpawnAction;
import com.pixelmonmod.pixelmon.api.spawning.SpawnInfo;
import com.pixelmonmod.pixelmon.api.spawning.SpawnLocation;
import com.pixelmonmod.pixelmon.api.spawning.SpawnSet;
import com.pixelmonmod.pixelmon.api.spawning.calculators.ISelectionAlgorithm;
import com.pixelmonmod.pixelmon.util.helpers.CollectionHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.Entity;

public class FlatDistinctAlgorithm
implements ISelectionAlgorithm {
    @Override
    public List<SpawnAction<? extends Entity>> calculateSpawnActions(AbstractSpawner spawner, List<SpawnSet> spawnSets, List<SpawnLocation> spawnLocations) {
        HashMap distinctSpawns = new HashMap();
        for (SpawnLocation spawnLocation : spawnLocations) {
            ArrayList<SpawnInfo> spawnInfos = spawner.getSuitableSpawns(spawnLocation);
            for (SpawnInfo spawnInfo : spawnInfos) {
                distinctSpawns.putIfAbsent(spawnInfo, new ArrayList());
                ((ArrayList)distinctSpawns.get(spawnInfo)).add(spawnLocation);
            }
        }
        SpawnInfo percentageSelection = this.chooseViaPercentage(spawner, new ArrayList<SpawnInfo>(distinctSpawns.keySet()));
        if (percentageSelection != null) {
            return Lists.newArrayList((Object[])new SpawnAction[]{percentageSelection.construct(spawner, (SpawnLocation)CollectionHelper.getRandomElement((List)distinctSpawns.get(percentageSelection)))});
        }
        HashMap averageRarities = new HashMap();
        float raritySum = 0.0f;
        for (Map.Entry entry : distinctSpawns.entrySet()) {
            float totalRarity = 0.0f;
            for (SpawnLocation spawnLocation : (ArrayList)entry.getValue()) {
                totalRarity += ((SpawnInfo)entry.getKey()).getAdjustedRarity(spawner, spawnLocation);
            }
            float averageRarity = totalRarity / (float)((ArrayList)entry.getValue()).size();
            raritySum += averageRarity;
            averageRarities.put(entry.getKey(), Float.valueOf(averageRarity));
        }
        SpawnInfo chosenSpawn = null;
        float f = RandomHelper.getRandomNumberBetween(0.0f, raritySum);
        raritySum = 0.0f;
        for (Map.Entry entry : averageRarities.entrySet()) {
            if (!((raritySum += ((Float)entry.getValue()).floatValue()) >= f) || !(((Float)entry.getValue()).floatValue() > 0.0f)) continue;
            chosenSpawn = (SpawnInfo)entry.getKey();
            break;
        }
        if (chosenSpawn == null) {
            return null;
        }
        return Lists.newArrayList((Object[])new SpawnAction[]{chosenSpawn.construct(spawner, (SpawnLocation)CollectionHelper.getRandomElement((List)distinctSpawns.get(chosenSpawn)))});
    }

    @Override
    public Map<SpawnInfo, Float> getAdjustedRarities(AbstractSpawner spawner, Map<SpawnLocation, List<SpawnInfo>> possibleSpawns) {
        HashMap distinctSpawns = new HashMap();
        for (Map.Entry<SpawnLocation, List<SpawnInfo>> entry : possibleSpawns.entrySet()) {
            for (SpawnInfo spawnInfo : entry.getValue()) {
                distinctSpawns.putIfAbsent(spawnInfo, new ArrayList());
                ((List)distinctSpawns.get(spawnInfo)).add(entry.getKey());
            }
        }
        HashMap<SpawnInfo, Float> adjustedRarities = new HashMap<SpawnInfo, Float>();
        for (SpawnLocation spawnLocation : possibleSpawns.keySet()) {
            for (SpawnInfo spawnInfo : possibleSpawns.get(spawnLocation)) {
                if (adjustedRarities.containsKey(spawnInfo) || spawnInfo.percentage != null && spawnInfo.percentage.floatValue() > 0.0f) continue;
                float adjusted = spawnInfo.getAdjustedRarity(spawner, spawnLocation);
                adjustedRarities.put(spawnInfo, Float.valueOf(adjusted));
            }
        }
        return adjustedRarities;
    }
}

