/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.spawning.archetypes.algorithms.selection;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.api.spawning.AbstractSpawner;
import com.pixelmonmod.pixelmon.api.spawning.SpawnAction;
import com.pixelmonmod.pixelmon.api.spawning.SpawnInfo;
import com.pixelmonmod.pixelmon.api.spawning.SpawnLocation;
import com.pixelmonmod.pixelmon.api.spawning.SpawnSet;
import com.pixelmonmod.pixelmon.api.spawning.archetypes.spawners.TickingSpawner;
import com.pixelmonmod.pixelmon.api.spawning.calculators.ISelectionAlgorithm;
import com.pixelmonmod.pixelmon.util.helpers.CollectionHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;

public class LocationWeightedAlgorithm
implements ISelectionAlgorithm {
    @Override
    public List<SpawnAction<? extends Entity>> calculateSpawnActions(AbstractSpawner spawner, List<SpawnSet> spawnSets, List<SpawnLocation> spawnLocations) {
        TickingSpawner tickingSpawner = spawner instanceof TickingSpawner ? (TickingSpawner)spawner : null;
        ArrayList<SpawnAction<? extends Entity>> toSpawn = new ArrayList<SpawnAction<? extends Entity>>();
        HashMap<SpawnLocation, SpawnInfo> potentialSpawns = new HashMap<SpawnLocation, SpawnInfo>();
        for (SpawnLocation spawnLocation : spawnLocations) {
            SpawnInfo weightedSpawnInfo = spawner.getWeightedSpawnInfo(spawnLocation);
            if (weightedSpawnInfo == null) continue;
            potentialSpawns.put(spawnLocation, weightedSpawnInfo);
        }
        while (!potentialSpawns.isEmpty() && (tickingSpawner == null || tickingSpawner.hasCapacity(toSpawn.size() + 1) && toSpawn.size() <= tickingSpawner.spawnsPerPass)) {
            SpawnLocation location = (SpawnLocation)CollectionHelper.getRandomElement(Lists.newArrayList(potentialSpawns.keySet()));
            SpawnInfo spawnInfo = (SpawnInfo)potentialSpawns.get(location);
            potentialSpawns.remove(location);
            SpawnAction<? extends Entity> action = spawnInfo.construct(spawner, location);
            BlockPos.MutableBlockPos pos = location.location.pos;
            if (action != null) {
                toSpawn.add(action);
            }
            potentialSpawns.keySet().removeIf(arg_0 -> LocationWeightedAlgorithm.lambda$calculateSpawnActions$0(tickingSpawner, location, (BlockPos)pos, arg_0));
        }
        return toSpawn;
    }

    @Override
    public Map<SpawnInfo, Float> getAdjustedRarities(AbstractSpawner spawner, Map<SpawnLocation, List<SpawnInfo>> possibleSpawns) {
        HashMap<SpawnInfo, Float> adjustedRarities = new HashMap<SpawnInfo, Float>();
        for (SpawnLocation spawnLocation : possibleSpawns.keySet()) {
            for (SpawnInfo spawnInfo : possibleSpawns.get(spawnLocation)) {
                if (spawnInfo.percentage != null && spawnInfo.percentage.floatValue() > 0.0f) continue;
                float adjusted = spawnInfo.getAdjustedRarity(spawner, spawnLocation);
                if (adjustedRarities.containsKey(spawnInfo)) {
                    adjusted += adjustedRarities.get(spawnInfo).floatValue();
                }
                adjustedRarities.put(spawnInfo, Float.valueOf(adjusted));
            }
        }
        return adjustedRarities;
    }

    private static /* synthetic */ boolean lambda$calculateSpawnActions$0(TickingSpawner tickingSpawner, SpawnLocation location, BlockPos pos, SpawnLocation spawnLocation) {
        if (tickingSpawner == null) {
            return false;
        }
        if (spawnLocation.location.world != location.location.world) {
            return false;
        }
        return !(spawnLocation.location.pos.func_185332_f(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()) >= (double)tickingSpawner.minDistBetweenSpawns);
    }
}

