/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.spawning.archetypes.entities.pokemon;

import com.google.common.collect.Sets;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.RandomHelper;
import com.pixelmonmod.pixelmon.api.item.JsonItemStack;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonSpec;
import com.pixelmonmod.pixelmon.api.spawning.AbstractSpawner;
import com.pixelmonmod.pixelmon.api.spawning.SpawnAction;
import com.pixelmonmod.pixelmon.api.spawning.SpawnInfo;
import com.pixelmonmod.pixelmon.api.spawning.SpawnLocation;
import com.pixelmonmod.pixelmon.api.spawning.archetypes.entities.pokemon.SpawnActionPokemon;
import com.pixelmonmod.pixelmon.config.BetterSpawnerConfig;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.config.PixelmonServerConfig;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.entities.pixelmon.specs.IVEVSpec;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.BaseStats;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.EntityBoundsData;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.StatsType;
import com.pixelmonmod.pixelmon.enums.EnumBossMode;
import com.pixelmonmod.pixelmon.enums.EnumMegaPokemon;
import com.pixelmonmod.pixelmon.enums.EnumPokerusType;
import com.pixelmonmod.pixelmon.enums.EnumSpecies;
import com.pixelmonmod.pixelmon.items.ItemLure;
import com.pixelmonmod.pixelmon.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.storage.playerData.CaptureCombo;
import com.pixelmonmod.pixelmon.util.helpers.CollectionHelper;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.text.translation.I18n;

public class SpawnInfoPokemon
extends SpawnInfo {
    public static final String TYPE_ID_POKEMON = "pokemon";
    public transient EnumSpecies species;
    private PokemonSpec spec = PokemonSpec.from("Psyduck");
    public ArrayList<PokemonSpec> specs = null;
    public int minLevel = 1;
    public int maxLevel = 100;
    public Float spawnSpecificShinyRate = null;
    public Float spawnSpecificBossRate = null;
    public Float spawnSpecificPokerusRate = null;
    public ArrayList<JsonItemStack> heldItems = null;

    public SpawnInfoPokemon() {
        super(TYPE_ID_POKEMON);
    }

    @Override
    public void onImport() {
        this.calculateRequiredSpace();
        super.onImport();
        if (this.minLevel > this.maxLevel) {
            Pixelmon.LOGGER.warn("A SpawnInfo for " + this.spec.name + " has minLevel=" + this.minLevel + " and maxLevel=" + this.maxLevel + " which is weird. Fixing.");
            int temp = this.minLevel;
            this.minLevel = this.maxLevel;
            this.maxLevel = temp;
        }
        if (this.spec != null) {
            Pokemon dummyPokemon = this.spec.create();
            if (BetterSpawnerConfig.INSTANCE.autoTagSpecs != null) {
                for (Map.Entry<String, PokemonSpec> entry : BetterSpawnerConfig.INSTANCE.autoTagSpecs.entrySet()) {
                    if (!entry.getValue().matches(dummyPokemon) || this.tags.contains(entry.getKey())) continue;
                    this.tags.add(entry.getKey());
                }
            }
        }
    }

    public void setPokemon(PokemonSpec spec) {
        this.spec = spec;
        this.requiredSpace = -1;
        this.calculateRequiredSpace();
    }

    public void calculateRequiredSpace() {
        if (this.spec.name != null && this.requiredSpace == -1) {
            BaseStats baseStats;
            EntityBoundsData boundsData;
            this.requiredSpace = EnumSpecies.hasPokemon(this.spec.name) ? (int)Math.ceil((boundsData = (baseStats = EnumSpecies.getFromNameAnyCaseNoTranslate(this.spec.name).getBaseStats()).getBoundsData()).getWidth() > boundsData.getHeight() ? boundsData.getWidth() : boundsData.getHeight()) : 0;
        }
    }

    public SpawnAction<EntityPixelmon> construct(AbstractSpawner spawner, SpawnLocation spawnLocation) {
        PokemonSpec usingSpec;
        PokemonSpec baseSpec;
        if (this.spec == null && this.specs != null && this.specs.size() > 0) {
            baseSpec = this.specs.get(RandomHelper.getRandomNumberBetween(0, this.specs.size()));
            usingSpec = baseSpec.copy();
        } else {
            baseSpec = this.spec;
            usingSpec = baseSpec.copy();
        }
        if (usingSpec.name == null) {
            usingSpec.name = EnumSpecies.Psyduck.name;
        } else if (usingSpec.name.equalsIgnoreCase("random")) {
            usingSpec.name = EnumSpecies.randomPoke((boolean)false).name;
        } else if (usingSpec.name.equalsIgnoreCase("randomlegendary")) {
            usingSpec.name = CollectionHelper.getRandomElement(EnumSpecies.legendaries).name;
        }
        if (usingSpec.level == null) {
            usingSpec.level = RandomHelper.getRandomNumberBetween(Math.min(this.minLevel, PixelmonServerConfig.maxLevel), Math.min(this.maxLevel, PixelmonServerConfig.maxLevel));
        }
        if (usingSpec.shiny == null) {
            if (this.spawnSpecificShinyRate != null) {
                if (this.spawnSpecificShinyRate.floatValue() == 0.0f) {
                    usingSpec.shiny = false;
                } else if (this.spawnSpecificShinyRate.floatValue() > 0.0f) {
                    usingSpec.shiny = RandomHelper.getRandomChance(1.0f / this.spawnSpecificShinyRate.floatValue());
                }
            } else if (this.set.setSpecificShinyRate != null) {
                if (this.set.setSpecificShinyRate.floatValue() == 0.0f) {
                    usingSpec.shiny = false;
                } else if (this.set.setSpecificShinyRate.floatValue() > 0.0f) {
                    usingSpec.shiny = RandomHelper.getRandomChance(1.0f / this.set.setSpecificShinyRate.floatValue());
                }
            } else if (PixelmonConfig.getShinyRate(spawnLocation.location.world.field_73011_w.getDimension()) > 0.0f) {
                float shinyChanceMultiplier = 1.0f;
                if (spawnLocation.cause instanceof EntityPlayerMP) {
                    CaptureCombo combo;
                    PlayerPartyStorage party = Pixelmon.storageManager.getParty((EntityPlayerMP)spawnLocation.cause);
                    if (party.getShinyCharm().isActive()) {
                        shinyChanceMultiplier *= 3.0f;
                    }
                    if (party.getLure() != null && party.getLure().type == ItemLure.LureType.SHINY) {
                        shinyChanceMultiplier *= (float)Math.sqrt(party.getLure().strength.multiplier);
                    }
                    if ((combo = party.transientData.captureCombo).getShinyModifier() != 1.0f && combo.getCurrentSpecies() != null && combo.getCurrentSpecies().getPokemonName().equals(usingSpec.name)) {
                        shinyChanceMultiplier *= combo.getShinyModifier();
                    }
                }
                usingSpec.shiny = RandomHelper.getRandomChance(shinyChanceMultiplier / PixelmonConfig.getShinyRate(spawnLocation.location.world.field_73011_w.getDimension()));
            } else {
                usingSpec.shiny = false;
            }
        }
        if (usingSpec.boss == null) {
            boolean willBeBoss = false;
            if (this.spawnSpecificBossRate != null && this.spawnSpecificBossRate.floatValue() > 0.0f && RandomHelper.getRandomChance(1.0f / this.spawnSpecificBossRate.floatValue())) {
                willBeBoss = true;
            } else if (PixelmonConfig.getBossRate(spawnLocation.location.world.field_73011_w.getDimension()) > 0.0f && RandomHelper.getRandomChance(1.0f / PixelmonConfig.getBossRate(spawnLocation.location.world.field_73011_w.getDimension()))) {
                willBeBoss = true;
            }
            if (willBeBoss) {
                EnumBossMode bossMode = null;
                if (PixelmonConfig.bossesAlwaysMegaIfPossible) {
                    EnumSpecies species = EnumSpecies.getFromNameAnyCaseNoTranslate(usingSpec.name);
                    boolean legendary = species.isLegendary();
                    if (EnumMegaPokemon.getMega(species) != null) {
                        bossMode = legendary ? EnumBossMode.Ultimate : EnumBossMode.getRandomModeMega();
                    } else if (legendary) {
                        bossMode = EnumBossMode.Ultimate;
                    }
                }
                if (bossMode == null) {
                    bossMode = EnumBossMode.getWeightedBossMode();
                }
                if (bossMode == null) {
                    bossMode = EnumBossMode.getRandomMode();
                }
                usingSpec.boss = (byte)bossMode.index;
            }
        }
        if (usingSpec.pokerusType == null && PixelmonConfig.pokerusEnabled) {
            if (this.spawnSpecificPokerusRate != null) {
                if (this.spawnSpecificPokerusRate.floatValue() > 0.0f) {
                    usingSpec.pokerusType = RandomHelper.getRandomChance(1.0f / this.spawnSpecificPokerusRate.floatValue()) ? Byte.valueOf((byte)EnumPokerusType.getRandomType().ordinal()) : null;
                }
            } else if (this.set.setSpecificPokerusRate != null) {
                if (this.set.setSpecificPokerusRate.floatValue() > 0.0f) {
                    usingSpec.pokerusType = RandomHelper.getRandomChance(1.0f / this.set.setSpecificPokerusRate.floatValue()) ? Byte.valueOf((byte)EnumPokerusType.getRandomType().ordinal()) : null;
                }
            } else if (PixelmonConfig.pokerusRate > 0.0f) {
                Byte by = usingSpec.pokerusType = RandomHelper.getRandomChance(1.0f / PixelmonConfig.pokerusRate) ? Byte.valueOf((byte)EnumPokerusType.getRandomType().ordinal()) : null;
            }
        }
        if (usingSpec.extraSpecs == null || usingSpec.extraSpecs.stream().noneMatch(it -> it instanceof IVEVSpec && ((IVEVSpec)it).isIVs)) {
            PlayerPartyStorage party = Pixelmon.storageManager.getParty((EntityPlayerMP)spawnLocation.cause);
            CaptureCombo combo = party.transientData.captureCombo;
            if (combo.getPerfIVCount() != 0 && combo.getCurrentSpecies() != null && combo.getCurrentSpecies().getPokemonName().equals(usingSpec.name)) {
                if (usingSpec.extraSpecs == null) {
                    usingSpec.extraSpecs = new ArrayList();
                }
                HashSet stats = Sets.newHashSet((Object[])StatsType.getStatValues());
                for (int i = 0; i < combo.getPerfIVCount(); ++i) {
                    StatsType type = (StatsType)RandomHelper.getRandomElementFromCollection(stats);
                    stats.remove(type);
                    PokemonSpec spec = PokemonSpec.from("iv" + type.name().toLowerCase() + ":31");
                    usingSpec.extraSpecs.addAll(spec.extraSpecs);
                }
            }
        }
        return new SpawnActionPokemon(this, spawnLocation, baseSpec, usingSpec);
    }

    public PokemonSpec getPokemonSpec() {
        return this.spec;
    }

    public EnumSpecies getSpecies() {
        if (this.species == null) {
            this.species = EnumSpecies.getFromNameAnyCase(this.spec.name);
            if (this.species == null) {
                Pixelmon.LOGGER.warn("Bad Pok\u00e9mon name: " + this.spec.name + " in set " + this.set.id);
            }
        }
        return this.species;
    }

    @Override
    public String toString() {
        if (this.spec.name == null || this.spec.name.equals("random")) {
            return "Random";
        }
        return I18n.func_74838_a((String)("pixelmon." + this.spec.name.toLowerCase() + ".name"));
    }
}

