/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.spawning.calculators;

import com.google.common.collect.Sets;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.events.spawning.SpawnLocationEvent;
import com.pixelmonmod.pixelmon.api.spawning.SpawnLocation;
import com.pixelmonmod.pixelmon.api.spawning.conditions.LocationType;
import com.pixelmonmod.pixelmon.api.world.BlockCollection;
import com.pixelmonmod.pixelmon.api.world.MutableLocation;
import com.pixelmonmod.pixelmon.config.BetterSpawnerConfig;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.eventhandler.Event;

public interface ICalculateSpawnLocations {
    public static final int MIN_DIAMETER = 1;

    public static ICalculateSpawnLocations getDefault() {
        return new DummyImpl();
    }

    default public int getMaxSpawnLocationDiameter() {
        return 10;
    }

    default public ArrayList<SpawnLocation> calculateSpawnableLocations(BlockCollection collection) {
        ArrayList<SpawnLocation> spawnableLocations = new ArrayList<SpawnLocation>();
        World world = collection.world;
        int minX = collection.minX + 1;
        int minY = collection.minY + 1;
        int minZ = collection.minZ + 1;
        int maxX = collection.maxX - 1;
        int maxY = collection.maxY - 1;
        int maxZ = collection.maxZ - 1;
        for (int baseX = minX; baseX <= maxX; ++baseX) {
            for (int baseZ = minZ; baseZ <= maxZ; ++baseZ) {
                IBlockState state;
                boolean canSeeSky = true;
                for (int skyY = 254; skyY >= maxY + 1; --skyY) {
                    if (BetterSpawnerConfig.doesBlockSeeSky(collection.getBlockState(baseX, skyY + 1, baseZ))) continue;
                    canSeeSky = false;
                    break;
                }
                block3: for (int baseY = maxY - 1; baseY >= minY && (state = collection.getBlockState(baseX, baseY + 1, baseZ)) != null; --baseY) {
                    MutableLocation loc;
                    SpawnLocation spawnLocation;
                    SpawnLocationEvent event;
                    List<LocationType> types;
                    if (canSeeSky && !BetterSpawnerConfig.doesBlockSeeSky(state)) {
                        canSeeSky = false;
                    }
                    if ((types = LocationType.getPotentialTypes(collection.getBlockState(baseX, baseY, baseZ))).isEmpty()) continue;
                    BlockPos base = new BlockPos(baseX, baseY + 1, baseZ);
                    int r = 0;
                    int diameter = 0;
                    block4: while (diameter <= this.getMaxSpawnLocationDiameter()) {
                        int y = base.func_177956_o() + r;
                        for (int sign : new int[]{-1, 1}) {
                            for (int x : new int[]{base.func_177958_n() + r * sign, base.func_177958_n()}) {
                                for (int z : new int[]{base.func_177952_p() + r * sign, base.func_177952_p()}) {
                                    if (x > maxX || x < minX || y > maxY || y < minY || z > maxZ || z < minZ) {
                                        if (r > 1) break block4;
                                        continue block3;
                                    }
                                    IBlockState rstate = collection.getBlockState(x, y, z);
                                    if (rstate == null) break block4;
                                    if (diameter <= 1) {
                                        types.removeIf(type -> !type.surroundingBlockCondition.test(rstate));
                                        if (types.isEmpty()) {
                                            continue block3;
                                        }
                                    } else {
                                        for (LocationType type2 : types) {
                                            if (type2.surroundingBlockCondition.test(rstate)) continue;
                                            break block4;
                                        }
                                    }
                                    if (r == 0) break;
                                }
                                if (r == 0) break;
                            }
                            ++diameter;
                        }
                        ++r;
                    }
                    int searchRad = this.getMaxSpawnLocationDiameter();
                    HashSet uniqueBlocks = Sets.newHashSet();
                    for (int x = baseX - searchRad; x < baseX + searchRad; ++x) {
                        if (x > collection.maxX || x < collection.minX) continue;
                        for (int y = baseY - searchRad; y <= baseY + searchRad; ++y) {
                            if (y > collection.maxY || y < collection.minY) continue;
                            for (int z = baseZ - searchRad; z <= baseZ + searchRad; ++z) {
                                if (z > collection.maxZ || z < collection.minZ || (state = collection.getBlockState(x, y, z)) == null) continue;
                                uniqueBlocks.add(state.func_177230_c());
                            }
                        }
                    }
                    boolean fCanSeeSky = canSeeSky;
                    HashSet finalTypes = Sets.newHashSet();
                    for (LocationType type3 : types) {
                        if (type3.seesSky != null && fCanSeeSky != type3.seesSky || type3.neededNearbyBlockCondition != null && !type3.neededNearbyBlockCondition.test(uniqueBlocks)) continue;
                        finalTypes.add(type3);
                    }
                    if (finalTypes.isEmpty() || Pixelmon.EVENT_BUS.post((Event)(event = new SpawnLocationEvent(spawnLocation = new SpawnLocation(collection.cause, loc = new MutableLocation(world, baseX, baseY + 1, baseZ), finalTypes, collection.getBlockState(baseX, baseY, baseZ).func_177230_c(), uniqueBlocks, collection.getBiome(baseX, baseZ), canSeeSky, diameter, collection.getLight(baseX, baseY + 1, baseZ)))))) continue;
                    spawnableLocations.add(event.getSpawnLocation());
                }
            }
        }
        return spawnableLocations;
    }

    public static class DummyImpl
    implements ICalculateSpawnLocations {
    }
}

