/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.spawning.calculators;

import com.pixelmonmod.pixelmon.api.spawning.AbstractSpawner;
import com.pixelmonmod.pixelmon.enums.EnumSpecies;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.command.ICommandSender;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentBase;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;

public interface ICheckSpawns {
    public static ICheckSpawns getDefault() {
        return (spawner, sender, arguments) -> sender.func_145747_a((ITextComponent)new TextComponentString("Not implemented."));
    }

    default public String getPermissionNode() {
        return "pixelmon.checkspawns.normal";
    }

    public void checkSpawns(AbstractSpawner var1, ICommandSender var2, List<String> var3);

    default public List<TextComponentBase> generateMessages(Map<String, Double> percentages, List<String> arguments) {
        ArrayList<TextComponentBase> translationMessages = new ArrayList<TextComponentBase>();
        ArrayList<String> messages = new ArrayList<String>();
        Predicate<String> caredAbout = null;
        for (String argument : arguments) {
            for (String key : percentages.keySet()) {
                if (!key.equalsIgnoreCase(argument)) continue;
                String needed = EnumSpecies.hasPokemonAnyCase(argument) ? I18n.func_74838_a((String)("pixelmon." + EnumSpecies.getFromNameAnyCase((String)argument).name.toLowerCase() + ".name")) : I18n.func_74838_a((String)argument);
                if (caredAbout == null) {
                    caredAbout = s -> s.equalsIgnoreCase(needed);
                    continue;
                }
                Predicate<String> pTemp = caredAbout;
                caredAbout = s -> pTemp.test((String)s) || s.equalsIgnoreCase(needed);
            }
        }
        if (caredAbout == null) {
            caredAbout = s -> true;
        }
        double greenThreshold = 10.0;
        double yellowThreshold = 2.0;
        double redThreshold = 0.5;
        double lightPurpleThreshold = 0.001;
        ArrayList<Map.Entry<String, Double>> sortedEntries = new ArrayList<Map.Entry<String, Double>>(percentages.entrySet());
        sortedEntries.sort(Map.Entry.comparingByValue());
        for (Map.Entry<String, Double> entry : sortedEntries) {
            if (!caredAbout.test(entry.getKey())) continue;
            TextFormatting colour = TextFormatting.DARK_PURPLE;
            if (entry.getValue() > 10.0) {
                colour = TextFormatting.GREEN;
            } else if (entry.getValue() > 2.0) {
                colour = TextFormatting.YELLOW;
            } else if (entry.getValue() > 0.5) {
                colour = TextFormatting.RED;
            } else if (entry.getValue() > 0.001) {
                colour = TextFormatting.LIGHT_PURPLE;
            }
            messages.add(TextFormatting.GOLD + entry.getKey() + TextFormatting.GRAY + ": " + colour + entry.getValue() + "%");
        }
        while (!messages.isEmpty()) {
            String message = (String)messages.remove(0);
            int onThisLine = 1;
            while (!messages.isEmpty() && onThisLine++ < 3) {
                message = message + TextFormatting.GOLD + ", " + (String)messages.remove(0);
            }
            translationMessages.add((TextComponentBase)new TextComponentString(message));
        }
        return translationMessages;
    }

    default public TextComponentTranslation translate(TextFormatting colour, String text, Object ... args) {
        TextComponentTranslation translation = new TextComponentTranslation(text, args);
        translation.func_150256_b().func_150238_a(colour);
        return translation;
    }
}

