/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.storage;

import com.google.common.base.Preconditions;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.storage.IStorageSaveAdapter;
import com.pixelmonmod.pixelmon.api.storage.IStorageSaveScheduler;
import com.pixelmonmod.pixelmon.api.storage.PCStorage;
import com.pixelmonmod.pixelmon.api.storage.PokemonStorage;
import com.pixelmonmod.pixelmon.api.storage.StoragePosition;
import com.pixelmonmod.pixelmon.blocks.tileEntities.TileEntityPC;
import com.pixelmonmod.pixelmon.comm.packetHandlers.clientStorage.newStorage.pc.ClientInitializePC;
import com.pixelmonmod.pixelmon.storage.PlayerPartyStorage;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public interface IStorageManager {
    public IStorageSaveScheduler getSaveScheduler();

    public IStorageSaveAdapter getSaveAdapter();

    public PCStorage getPCForPlayer(UUID var1);

    public PlayerPartyStorage getParty(UUID var1);

    public Iterable<PokemonStorage> getAllCachedStorages();

    public void onStorageSaved(PokemonStorage var1);

    public void clearAll();

    default public PCStorage getPC(EntityPlayerMP player, TileEntityPC pc) {
        return this.getPCForPlayer(player);
    }

    default public PCStorage getPCForPlayer(EntityPlayerMP player) {
        Preconditions.checkNotNull((Object)player);
        return this.getPCForPlayer(player.func_110124_au());
    }

    default public PlayerPartyStorage getParty(EntityPlayerMP player) {
        Preconditions.checkNotNull((Object)player);
        return this.getParty(player.func_110124_au());
    }

    default public PokemonStorage getStorage(EntityPlayerMP player, StoragePosition position) {
        if (position.box == -1) {
            return this.getParty(player);
        }
        return this.getPCForPlayer(player);
    }

    default public Pokemon getPokemon(EntityPlayerMP player, StoragePosition position) {
        if (position.box == -1) {
            return this.getParty(player).get(position);
        }
        return this.getPCForPlayer(player).get(position);
    }

    default public void initializePCForPlayer(EntityPlayerMP player, PCStorage pc) {
        Pixelmon.network.sendTo((IMessage)new ClientInitializePC(pc), player);
        pc.sendContents(player);
    }
}

