/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.attacks;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.attackAnimations.AttackAnimation;
import com.pixelmonmod.pixelmon.api.attackAnimations.AttackAnimationTypeAdapter;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.EffectBase;
import com.pixelmonmod.pixelmon.battles.attacks.EffectTypeAdapter;
import com.pixelmonmod.pixelmon.battles.attacks.MoveFlags;
import com.pixelmonmod.pixelmon.battles.attacks.TargetingInfo;
import com.pixelmonmod.pixelmon.battles.attacks.ZMove;
import com.pixelmonmod.pixelmon.battles.attacks.ZMoveAdapter;
import com.pixelmonmod.pixelmon.battles.attacks.animations.AttackAnimationData;
import com.pixelmonmod.pixelmon.battles.attacks.animations.AttackAnimationDataAdapter;
import com.pixelmonmod.pixelmon.battles.attacks.animations.particles.EnumEffectType;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.enums.EnumSpecies;
import com.pixelmonmod.pixelmon.enums.EnumType;
import com.pixelmonmod.pixelmon.enums.battle.AttackCategory;
import com.pixelmonmod.pixelmon.items.ItemHeld;
import com.pixelmonmod.pixelmon.util.ITranslatable;
import com.pixelmonmod.pixelmon.util.ResourceLocationAdapter;
import com.pixelmonmod.pixelmon.util.helpers.RCFileHelper;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Scanner;
import java.util.Set;
import net.minecraft.util.ResourceLocation;

public class AttackBase
implements ITranslatable {
    private int attackIndex;
    private String attackName;
    private EnumType attackType = EnumType.Mystery;
    private AttackCategory attackCategory;
    private int basePower;
    private int ppBase;
    private int ppMax;
    private int accuracy;
    private EnumEffectType effectType;
    private boolean makesContact;
    private boolean ignoreAbility = false;
    private TargetingInfo targetingInfo;
    private MoveFlags flags;
    public ArrayList<EffectBase> effects = new ArrayList();
    public ArrayList<AttackAnimation> animations = new ArrayList();
    public ArrayList<ZMove> z = new ArrayList();
    public static final transient ArrayList<AttackBase> ATTACKS = new ArrayList();
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().registerTypeAdapter(EffectBase.class, (Object)new EffectTypeAdapter()).registerTypeAdapter(AttackAnimation.class, (Object)AttackAnimationTypeAdapter.ADAPTER).registerTypeAdapter(AttackAnimationData.class, (Object)AttackAnimationDataAdapter.ADAPTER).registerTypeAdapter(MoveFlags.class, (Object)MoveFlags.ADAPTER).registerTypeAdapter(ResourceLocation.class, (Object)ResourceLocationAdapter.ADAPTER).registerTypeAdapter(ZMove.class, (Object)new ZMoveAdapter()).create();
    private static final Map<String, AttackBase> ATTACK_MAP = new HashMap<String, AttackBase>();

    public AttackBase(EnumType attackType, int basePower, AttackCategory attackCategory) {
        this.attackType = attackType;
        this.basePower = basePower;
        this.attackCategory = attackCategory;
        this.attackName = "";
    }

    public int getAttackId() {
        return this.attackIndex;
    }

    public String getAttackName() {
        return this.attackName;
    }

    public EnumType getAttackType() {
        return this.attackType;
    }

    public AttackCategory getAttackCategory() {
        return this.attackCategory;
    }

    public int getBasePower() {
        return this.basePower;
    }

    @Deprecated
    public void setBasePower(int basePower) {
        this.basePower = basePower;
    }

    public int getPPBase() {
        return this.ppBase;
    }

    public int getPPMax() {
        return this.ppMax;
    }

    public int getAccuracy() {
        return this.accuracy;
    }

    @Deprecated
    public void setAccuracy(int accuracy) {
        this.accuracy = accuracy;
    }

    public boolean getMakesContact() {
        return this.makesContact;
    }

    public boolean getIgnoresAbilities() {
        return this.ignoreAbility;
    }

    public TargetingInfo getTargetingInfo() {
        return this.targetingInfo;
    }

    public MoveFlags getFlags() {
        return this.flags == null ? MoveFlags.DEFAULT : this.flags;
    }

    public boolean isAttack(String name) {
        return this.attackName.equalsIgnoreCase(name) || this.getLocalizedName().equalsIgnoreCase(name);
    }

    public boolean isAttack(Attack attack) {
        return this == attack.getMove();
    }

    public int getPriority(PixelmonWrapper pixelmon) {
        int priority = 0;
        for (EffectBase effect : this.effects) {
            priority = effect.modifyPriority(priority, this, pixelmon);
        }
        return priority;
    }

    public boolean hasSecondaryEffect() {
        for (EffectBase effect : this.effects) {
            if (!effect.isChance()) continue;
            return true;
        }
        return false;
    }

    public <T extends EffectBase> boolean hasEffect(Class<T> clazz) {
        if (this.effects != null) {
            for (EffectBase effect : this.effects) {
                if (!clazz.isInstance(effect)) continue;
                return true;
            }
        }
        return false;
    }

    public ZMove getZMove(Pokemon pokemon, boolean bypassItemRequirement) {
        if (this.z != null) {
            for (ZMove zMove : this.z) {
                String itemName = pokemon.getHeldItemAsItemHeld().func_77658_a();
                String paraName = "item." + zMove.crystal;
                if (!bypassItemRequirement && !itemName.equalsIgnoreCase(paraName) || !zMove.allowedPokemon.isEmpty() && !zMove.allowedPokemon.contains(pokemon.getSpecies().name) && !zMove.allowedPokemon.contains(pokemon.getSpecies().name + pokemon.getFormEnum().getFormSuffix())) continue;
                return zMove;
            }
        }
        return null;
    }

    public ZMove getZMove(EnumSpecies species, int form, ItemHeld held, boolean bypassItemRequirement) {
        if (this.z != null) {
            for (ZMove zMove : this.z) {
                String itemName = held.func_77658_a();
                String paraName = "item." + zMove.crystal;
                if (!bypassItemRequirement && !itemName.equalsIgnoreCase(paraName) || !zMove.allowedPokemon.isEmpty() && !zMove.allowedPokemon.contains(species.name) && !zMove.allowedPokemon.contains(species.name + species.getFormEnum(form).getFormSuffix())) continue;
                return zMove;
            }
        }
        return null;
    }

    public boolean hasZMove(Pokemon pokemon) {
        if (this.z != null) {
            for (ZMove zMove : this.z) {
                String paraName;
                String itemName;
                if (pokemon == null || !(itemName = pokemon.getHeldItemAsItemHeld().func_77658_a()).equalsIgnoreCase(paraName = "item." + zMove.crystal) || !zMove.allowedPokemon.isEmpty() && !zMove.allowedPokemon.contains(pokemon.getSpecies().name) && !zMove.allowedPokemon.contains(pokemon.getSpecies().name + pokemon.getFormEnum().getFormSuffix())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public String getUnlocalizedName() {
        return "attack." + this.attackName.toLowerCase().replace(" ", "_") + ".name";
    }

    public static void loadAllAttacks() {
        ATTACKS.clear();
        File file = new File("pixelmon/moves");
        if (!PixelmonConfig.useExternalJSONFilesMoves || !file.exists()) {
            try {
                Path rootPath = RCFileHelper.pathFromResourceLocation(new ResourceLocation("pixelmon", "moves"));
                List<Path> ls = RCFileHelper.listFilesRecursively(rootPath, p -> true, true);
                Iterator iterator = ls.iterator();
                while (iterator.hasNext()) {
                    Path path = (Path)iterator.next();
                    InputStream is = AttackBase.class.getResourceAsStream(path.toUri().toString().substring(path.toUri().toString().indexOf("/assets")).replace("%20", " "));
                    Scanner s = new Scanner(is);
                    s.useDelimiter("\\A");
                    String json = s.hasNext() ? s.next() : "";
                    s.close();
                    AttackBase attackBase = null;
                    try {
                        attackBase = (AttackBase)GSON.fromJson(json, AttackBase.class);
                    }
                    catch (JsonSyntaxException e) {
                        e.printStackTrace();
                    }
                    if (attackBase == null) {
                        Pixelmon.LOGGER.error("Unable to load move JSON: " + path.toString());
                        continue;
                    }
                    ATTACKS.add(attackBase);
                    ATTACK_MAP.put(attackBase.attackName.toLowerCase(), attackBase);
                    if (!PixelmonConfig.useExternalJSONFilesMoves) continue;
                    file.mkdirs();
                    PrintWriter pw = new PrintWriter(new File("pixelmon/moves/" + attackBase.attackName + ".json"));
                    pw.write(json);
                    pw.close();
                }
            }
            catch (IOException | URISyntaxException ioe) {
                ioe.printStackTrace();
            }
        } else {
            ArrayList<File> files = new ArrayList<File>();
            RCFileHelper.recursiveJSONSearch("pixelmon/moves", files);
            for (File moveFile : files) {
                try {
                    AttackBase ab = (AttackBase)GSON.fromJson((Reader)new FileReader(moveFile), AttackBase.class);
                    ATTACKS.add(ab);
                    ATTACK_MAP.put(ab.attackName.toLowerCase(), ab);
                }
                catch (JsonIOException | JsonSyntaxException | FileNotFoundException e) {
                    Pixelmon.LOGGER.error("Unable to load external move JSON " + moveFile.getName());
                    e.printStackTrace();
                }
            }
        }
        for (AttackBase attackBase : ATTACKS) {
            if (attackBase.effects == null) continue;
            attackBase.effects.removeIf(Objects::isNull);
        }
    }

    public static Optional<AttackBase> getAttackBase(String moveName) {
        for (AttackBase attackBase : ATTACKS) {
            if (attackBase.getLocalizedName().equalsIgnoreCase(moveName)) {
                return Optional.of(attackBase);
            }
            if (!attackBase.attackName.equalsIgnoreCase(moveName)) continue;
            return Optional.of(attackBase);
        }
        return Optional.empty();
    }

    public static List<AttackBase> getAttackBases(String ... moveNames) {
        ArrayList<AttackBase> attacks = new ArrayList<AttackBase>();
        for (String moveName : moveNames) {
            AttackBase.getAttackBase(moveName).ifPresent(attacks::add);
        }
        return attacks;
    }

    public static Optional<AttackBase> getAttackBaseFromEnglishName(String name) {
        return Optional.ofNullable(ATTACK_MAP.get(name.toLowerCase()));
    }

    public static Optional<AttackBase> getAttackBase(int attackIndex) {
        for (AttackBase attackBase : ATTACKS) {
            if (attackBase.getAttackId() != attackIndex) continue;
            return Optional.of(attackBase);
        }
        return Optional.empty();
    }

    public static AttackBase getAttack(int attackIndex) {
        for (AttackBase attackBase : ATTACKS) {
            if (attackBase.getAttackId() != attackIndex) continue;
            return attackBase;
        }
        return null;
    }

    public static Set<String> getAllAttackNames() {
        return Collections.unmodifiableSet(ATTACK_MAP.keySet());
    }

    public String toString() {
        return "AttackBase{attackIndex=" + this.attackIndex + ", attackName='" + this.attackName + '\'' + '}';
    }
}

