/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.attacks;

import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.AttackBase;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.enums.EnumGigantamaxPokemon;
import com.pixelmonmod.pixelmon.enums.EnumSpecies;
import com.pixelmonmod.pixelmon.enums.EnumType;
import com.pixelmonmod.pixelmon.enums.battle.AttackCategory;
import com.pixelmonmod.pixelmon.enums.forms.IEnumForm;

public class MaxMoveConverter {
    public static Attack getMaxMoveFromAttack(Attack a, PixelmonWrapper pw) {
        Attack newAttack;
        AttackBase base = a.getActualMove();
        if (base.getAttackCategory() == AttackCategory.STATUS) {
            newAttack = new Attack("Max Guard");
            newAttack.overrideType(EnumType.Normal);
        } else {
            newAttack = new Attack(MaxMoveConverter.getMaxMoveForType(a.getType()));
            newAttack.overrideAttackCategory(a.getAttackCategory());
            newAttack.overridePower = MaxMoveConverter.getMaxMovePowerForMove(a);
            newAttack.overridePPMax(10);
            newAttack.setDisabled(a.getDisabled(), pw);
            newAttack.isMax = true;
            newAttack.originalMove = a;
        }
        return newAttack;
    }

    public static Attack getGMaxMoveFromAttack(Attack a, PixelmonWrapper pw, EnumSpecies species, IEnumForm form) {
        String gmaxMove;
        AttackBase base = a.getActualMove();
        if (base.getAttackCategory() != AttackCategory.STATUS && (gmaxMove = MaxMoveConverter.getGMaxMoveForType(a.getType(), species, form)) != null) {
            Attack newAttack = new Attack(gmaxMove);
            newAttack.overrideAttackCategory(a.getAttackCategory());
            newAttack.overridePower = species == EnumSpecies.Rillaboom || species == EnumSpecies.Cinderace || species == EnumSpecies.Inteleon ? 160 : MaxMoveConverter.getMaxMovePowerForMove(a);
            newAttack.overridePPMax(10);
            newAttack.setDisabled(a.getDisabled(), pw);
            newAttack.isMax = true;
            newAttack.originalMove = a;
            return newAttack;
        }
        return MaxMoveConverter.getMaxMoveFromAttack(a, pw);
    }

    private static String getMaxMoveForType(EnumType type) {
        switch (type) {
            case Ground: {
                return "Max Quake";
            }
            case Water: {
                return "Max Geyser";
            }
            case Ice: {
                return "Max Hailstorm";
            }
            case Bug: {
                return "Max Flutterby";
            }
            case Dark: {
                return "Max Darkness";
            }
            case Fire: {
                return "Max Flare";
            }
            case Rock: {
                return "Max Rockfall";
            }
            case Fairy: {
                return "Max Starfall";
            }
            case Ghost: {
                return "Max Phantasm";
            }
            case Grass: {
                return "Max Overgrowth";
            }
            case Steel: {
                return "Max Steelspike";
            }
            case Dragon: {
                return "Max Wyrmwind";
            }
            case Flying: {
                return "Max Airstream";
            }
            case Normal: {
                return "Max Strike";
            }
            case Poison: {
                return "Max Ooze";
            }
            case Electric: {
                return "Max Lightning";
            }
            case Psychic: {
                return "Max Mindstorm";
            }
            case Fighting: {
                return "Max Knuckle";
            }
        }
        return "Max Strike";
    }

    private static String getGMaxMoveForType(EnumType type, EnumSpecies species, IEnumForm form) {
        EnumGigantamaxPokemon egp = EnumGigantamaxPokemon.getGigantamax(species);
        if (egp != null) {
            String gmaxMove = species == EnumSpecies.Urshifu ? egp.getGmaxMoveIfPossible(type, form.getForm() > 1 ? form.getForm() - 2 : form.getForm()) : egp.getGmaxMoveIfPossible(type, 0);
            return gmaxMove;
        }
        return null;
    }

    private static int getMaxMovePowerForMove(Attack a) {
        if (a.getType() == EnumType.Fighting || a.getType() == EnumType.Poison) {
            if (a.movePower >= 150) {
                return 100;
            }
            if (a.movePower >= 110) {
                return 95;
            }
            if (a.movePower >= 75) {
                return 90;
            }
            if (a.movePower >= 65) {
                return 85;
            }
            if (a.movePower >= 55) {
                return 80;
            }
            if (a.movePower >= 45) {
                return 75;
            }
            return 70;
        }
        if (a.movePower >= 150) {
            return 150;
        }
        if (a.movePower >= 110) {
            return 140;
        }
        if (a.movePower >= 75) {
            return 130;
        }
        if (a.movePower >= 65) {
            return 120;
        }
        if (a.movePower >= 55) {
            return 110;
        }
        if (a.movePower >= 45) {
            return 100;
        }
        return 90;
    }
}

