/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.attacks.animations.particles;

import com.pixelmonmod.pixelmon.battles.attacks.AttackBase;
import com.pixelmonmod.pixelmon.battles.attacks.animations.StandardParticleAnimationData;
import com.pixelmonmod.pixelmon.battles.attacks.animations.particles.AttackSystemBase;
import com.pixelmonmod.pixelmon.battles.attacks.animations.particles.EnumEffectType;
import com.pixelmonmod.pixelmon.client.particle.ParticleArcanery;
import com.pixelmonmod.pixelmon.client.particle.particles.AttackEffect;
import com.pixelmonmod.pixelmon.enums.EnumType;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class AttackRise
extends AttackSystemBase<RiseData> {
    @Override
    @SideOnly(value=Side.CLIENT)
    public void execute(Minecraft mc, World w, double x, double y, double z, float scale, boolean shiny, double ... args) {
        this.endPos[1] = (float)(w.func_73045_a(this.endID) == null ? (double)this.endPos[1] : w.func_73045_a((int)this.endID).field_70163_u);
        for (int i = 0; i < ((RiseData)this.data).particleAmount; ++i) {
            float radius = ((RiseData)this.data).radius * (float)Math.sqrt(Math.random());
            float theta = (float)(Math.random() * 2.0 * Math.PI);
            this.endPos[0] = (float)(x + (double)radius * Math.cos(theta));
            this.endPos[2] = (float)(z + (double)radius * Math.sin(theta));
            mc.field_71452_i.func_78873_a((Particle)new ParticleArcanery(w, this.endPos[0], this.endPos[1], this.endPos[2], 0.0, 0.0, 0.0, ((RiseData)this.data).makeEffect(this).setHideTicks(((RiseData)this.data).particleAmount, true).setStartPos(this.endPos[0], this.endPos[1], this.endPos[2]).setEndPos(0.0f, 0.0f, 0.0f).setLifetimeTicks(((RiseData)this.data).durationTicks)));
        }
    }

    @Override
    public void onConstruct(AttackEffect effect) {
        effect.mX = 0.0;
        effect.mY = 0.0;
        effect.mZ = 0.0;
    }

    @Override
    public void onInit(ParticleArcanery particle, AttackEffect effect) {
        particle.setMotion(0.0, ((RiseData)this.data).speed, 0.0);
        effect.mX = 0.0;
        effect.mY = 0.0;
        effect.mZ = 0.0;
    }

    @Override
    public void onEnable(ParticleArcanery particle, AttackEffect effect) {
        effect.mX = 0.0;
        effect.mY = 0.0;
        effect.mZ = 0.0;
    }

    @Override
    public void onUpdate(ParticleArcanery particle, AttackEffect effect) {
        float height = (float)particle.getY();
        float maxHeight = this.startPos[1] + ((RiseData)this.data).endHeight;
        float yVelocity = (float)particle.getMotionY();
        yVelocity = yVelocity > 0.02f ? (yVelocity += ((RiseData)this.data).acceleration / 100.0f) : 0.02f;
        float alphaSubtraction = 0.002f / yVelocity;
        particle.func_82338_g(particle.getAlphaF() - alphaSubtraction);
        if (height > maxHeight || particle.getAlphaF() <= 0.0f && !((RiseData)this.data).sparkle) {
            particle.func_187112_i();
            return;
        }
        particle.setMotion(0.0, yVelocity, 0.0);
    }

    @Override
    public void onTarget(ParticleArcanery particle, AttackEffect effect) {
    }

    @Override
    public void onUpdateEol(ParticleArcanery particle, AttackEffect effect) {
        particle.setRGBA(particle.func_70534_d(), particle.func_70542_f(), particle.func_70535_g(), particle.getAlphaF() * 0.95f);
    }

    @Override
    public void onUpdateLast(ParticleArcanery particle, AttackEffect effect) {
    }

    @Override
    public void onPreRender(ParticleArcanery particle, float partialTicks, AttackEffect effect) {
    }

    @Override
    public void onPostRender(ParticleArcanery particle, float partialTicks, AttackEffect effect) {
    }

    @Override
    public boolean hasCustomRenderer(AttackEffect effect) {
        return false;
    }

    @Override
    public void onRender(ParticleArcanery particle, Tessellator tessellator, float partialTicks, AttackEffect effect) {
    }

    public static class RiseData
    extends StandardParticleAnimationData {
        public int durationTicks = 50;
        public int particleAmount = 15;
        public int startHeight = 0;
        public float acceleration = 0.1f;
        public float endHeight = 3.0f;
        public float radius = 1.0f;
        public boolean sparkle = false;

        @Override
        public void initFromAttack(AttackBase attackBase, int effectivePower, EnumType effectiveType) {
            if (this.power == -1) {
                this.particleAmount = effectivePower / 2;
            }
            super.initFromAttack(attackBase, effectivePower, effectiveType);
            if (this.durationTicks == 0) {
                this.durationTicks = (int)Math.ceil(Math.sqrt(effectivePower) * 3.0);
            }
        }

        @Override
        public void writeToByteBuffer(ByteBuf buf) {
            super.writeToByteBuffer(buf);
            buf.writeByte(this.durationTicks);
            buf.writeByte(this.startHeight);
            buf.writeFloat(this.endHeight);
            buf.writeBoolean(this.particleAmount != 13);
            if (this.particleAmount != 13) {
                buf.writeByte(this.particleAmount);
            }
            buf.writeBoolean(this.acceleration != 0.1f);
            if (this.acceleration != 0.1f) {
                buf.writeFloat(this.acceleration);
            }
            buf.writeBoolean(this.radius != 1.0f);
            if (this.radius != 1.0f) {
                buf.writeFloat(this.radius);
            }
            buf.writeBoolean(this.sparkle);
        }

        @Override
        public RiseData readFromByteBuffer(ByteBuf buf) {
            super.readFromByteBuffer(buf);
            this.durationTicks = buf.readByte();
            this.startHeight = buf.readByte();
            this.endHeight = buf.readFloat();
            if (buf.readBoolean()) {
                this.particleAmount = buf.readByte();
            }
            if (buf.readBoolean()) {
                this.acceleration = buf.readFloat();
            }
            if (buf.readBoolean()) {
                this.radius = buf.readFloat();
            }
            this.sparkle = buf.readBoolean();
            return this;
        }

        @Override
        public EnumEffectType getEffectEnum() {
            return EnumEffectType.RISE;
        }

        public RiseData setAcceleration(int acceleration) {
            this.acceleration = acceleration;
            return this;
        }

        public RiseData setDurationTicks(int durationTicks) {
            this.durationTicks = durationTicks;
            return this;
        }

        public RiseData setEndHeight(float endHeight) {
            this.endHeight = endHeight;
            return this;
        }

        public RiseData setRadius(float radius) {
            this.radius = radius;
            return this;
        }

        public RiseData setParticleAmount(int particleAmount) {
            this.particleAmount = particleAmount;
            return this;
        }

        public RiseData setSparkle(boolean sparkle) {
            this.sparkle = sparkle;
            return this;
        }

        public RiseData setStartHeight(int startHeight) {
            this.startHeight = startHeight;
            return this;
        }
    }
}

