/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.attacks.specialAttacks;

import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.AttackBase;
import com.pixelmonmod.pixelmon.battles.attacks.EffectBase;
import com.pixelmonmod.pixelmon.battles.attacks.animations.AttackAnimationStationary;
import com.pixelmonmod.pixelmon.battles.attacks.animations.particles.AttackStatChange;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic.OHKO;
import com.pixelmonmod.pixelmon.battles.controller.BattleControllerBase;
import com.pixelmonmod.pixelmon.battles.controller.CalcPriority;
import com.pixelmonmod.pixelmon.battles.controller.ai.MoveChoice;
import com.pixelmonmod.pixelmon.battles.controller.log.AttackResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.AbilityBase;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.Competitive;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.Contrary;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.Defiant;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.Unaware;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.BattleStats;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.StatsType;
import com.pixelmonmod.pixelmon.enums.battle.AttackCategory;
import com.pixelmonmod.pixelmon.enums.heldItems.EnumHeldItems;
import java.util.ArrayList;
import java.util.HashMap;

public class StatsEffect
extends EffectBase {
    public StatsType type;
    public int amount = 0;
    public boolean isUser = false;

    public StatsEffect() {
    }

    public StatsEffect(StatsType type, int value, boolean isUser) {
        this();
        this.type = type;
        this.amount = value;
        this.isUser = isUser;
    }

    public AttackResult applyStatEffect(PixelmonWrapper user, PixelmonWrapper target, AttackBase a) {
        PixelmonWrapper affected = target;
        if (this.isUser) {
            affected = user;
        }
        if (affected.isFainted()) {
            if (a != null && a.getAttackCategory() == AttackCategory.STATUS) {
                return AttackResult.failed;
            }
            return AttackResult.succeeded;
        }
        if (this.checkChance()) {
            boolean increase;
            if (affected.getBattleStats().modifyStat(this.amount, this.type, user, true)) {
                StatsEffect.addStatChangeAnimation(user, affected, this.type, this.amount);
                return AttackResult.succeeded;
            }
            if (a != null && a.getAttackCategory() != AttackCategory.STATUS) {
                StatsEffect.addStatChangeAnimation(user, affected, this.type, this.amount);
                return AttackResult.succeeded;
            }
            if (this.amount == 0) {
                return AttackResult.failed;
            }
            boolean bl = increase = this.amount > 0;
            if (affected.getBattleAbility(user) instanceof Contrary && (!user.attack.isZ || user.attack.isAttack("Extreme Evoboost"))) {
                increase = !increase;
            }
            affected.getBattleStats().getStatFailureMessage(this.type, increase);
            return AttackResult.failed;
        }
        return AttackResult.succeeded;
    }

    public static void addStatChangeAnimation(PixelmonWrapper user, PixelmonWrapper target, StatsType stat, int stages) {
        if (user.bc.simulateMode) {
            return;
        }
        AttackAnimationStationary animation = new AttackAnimationStationary();
        animation.effects = new HashMap();
        animation.durationTicks = 20;
        AttackStatChange.StatChangeData effect = new AttackStatChange.StatChangeData(stat, stages);
        animation.effects.put(50, effect);
        animation.groundedEndPosition = true;
        animation.initialize(user, target, user.attack == null ? new Attack("Tackle") : user.attack);
        BattleControllerBase.currentAnimations.add(animation);
    }

    @Override
    public void applyEffect(PixelmonWrapper user, PixelmonWrapper target) {
        this.applyStatEffect(user, target, null);
    }

    @Override
    public boolean cantMiss(PixelmonWrapper user) {
        return this.isUser;
    }

    public StatsType getStatsType() {
        return this.type;
    }

    public boolean getUser() {
        return this.isUser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void weightEffect(PixelmonWrapper pw, MoveChoice userChoice, ArrayList<MoveChoice> userChoices, ArrayList<MoveChoice> bestUserChoices, ArrayList<MoveChoice> opponentChoices, ArrayList<MoveChoice> bestOpponentChoices) {
        ArrayList<PixelmonWrapper> opponents;
        float chance = this.getChance();
        if (chance < 50.0f) {
            if (userChoice.isMiddleTier() || this.isUser) {
                userChoice.raiseWeight(chance / 100.0f);
            }
            return;
        }
        if (!this.isUser && this.amount < 0) {
            if (userChoice.hitsAlly()) {
                return;
            }
            for (PixelmonWrapper target : userChoice.targets) {
                if (!(target.getBattleAbility() instanceof Competitive) && !(target.getBattleAbility() instanceof Defiant)) continue;
                userChoice.weight -= 50.0f;
            }
        }
        if (this.type == StatsType.Attack || this.type == StatsType.SpecialAttack || this.type == StatsType.Defence || this.type == StatsType.SpecialDefence) {
            pw.bc.sendMessages = false;
            if (this.isUser && (this.type == StatsType.Attack || this.type == StatsType.SpecialAttack) || !this.isUser && (this.type == StatsType.Defence || this.type == StatsType.SpecialDefence)) {
                ArrayList<MoveChoice> bestChoicesAfter;
                ArrayList<MoveChoice> bestChoicesBefore = bestUserChoices;
                pw.bc.simulateMode = false;
                BattleStats[] originalStats = new BattleStats[userChoice.targets.size()];
                BattleStats[] saveStats = new BattleStats[userChoice.targets.size()];
                if (this.isUser) {
                    originalStats[0] = pw.getBattleStats();
                    saveStats[0] = new BattleStats(originalStats[0]);
                } else {
                    for (int i = 0; i < originalStats.length; ++i) {
                        originalStats[i] = userChoice.targets.get(i).getBattleStats();
                        saveStats[i] = new BattleStats(originalStats[i]);
                    }
                }
                try {
                    if (this.isUser) {
                        pw.getBattleStats().modifyStat(this.amount, this.type, pw, true);
                    } else {
                        for (PixelmonWrapper target : userChoice.targets) {
                            target.getBattleStats().modifyStat(this.amount, this.type, pw, true);
                        }
                    }
                    pw.bc.simulateMode = true;
                    bestChoicesAfter = pw.getBattleAI().getBestAttackChoices(pw);
                    pw.bc.simulateMode = false;
                }
                finally {
                    pw.bc.simulateMode = false;
                    for (int i = 0; i < originalStats.length; ++i) {
                        originalStats[i].copyStats(saveStats[i]);
                    }
                }
                boolean weightNegative = true;
                if (this.isUser) {
                    EnumHeldItems heldItem = pw.getUsableHeldItem().getHeldItemType();
                    weightNegative = heldItem != EnumHeldItems.whiteHerb && heldItem != EnumHeldItems.ginemaBerry;
                }
                pw.getBattleAI().weightFromUserOptions(pw, userChoice, bestChoicesBefore, bestChoicesAfter, weightNegative);
                if (MoveChoice.canOutspeedAnd2HKO(bestOpponentChoices, pw, bestUserChoices) && !userChoice.isOffensiveMove()) {
                    userChoice.lowerTier(1);
                }
            } else if (this.isUser && (this.type == StatsType.Defence || this.type == StatsType.SpecialDefence) || !this.isUser && (this.type == StatsType.Attack || this.type == StatsType.SpecialAttack)) {
                int i;
                opponents = this.getAffectedOpponents(pw, userChoice);
                ArrayList<ArrayList<MoveChoice>> bestChoicesBefore = MoveChoice.splitChoices(opponents, bestOpponentChoices);
                ArrayList<ArrayList<MoveChoice>> bestChoicesAfter = new ArrayList<ArrayList<MoveChoice>>(opponents.size());
                pw.bc.simulateMode = false;
                BattleStats[] originalStats = new BattleStats[userChoice.targets.size()];
                BattleStats[] saveStats = new BattleStats[userChoice.targets.size()];
                if (this.isUser) {
                    originalStats[0] = pw.getBattleStats();
                    saveStats[0] = new BattleStats(originalStats[0]);
                } else {
                    for (i = 0; i < originalStats.length; ++i) {
                        originalStats[i] = userChoice.targets.get(i).getBattleStats();
                        saveStats[i] = new BattleStats(originalStats[i]);
                    }
                }
                try {
                    if (this.isUser) {
                        pw.getBattleStats().modifyStat(this.amount, this.type, pw, true);
                    } else {
                        for (i = 0; i < saveStats.length; ++i) {
                            PixelmonWrapper target = userChoice.targets.get(i);
                            target.getBattleStats().modifyStat(this.amount, this.type, pw, true);
                        }
                    }
                    pw.bc.simulateMode = true;
                    for (PixelmonWrapper opponent : opponents) {
                        ArrayList<MoveChoice> after = pw.getBattleAI().getBestAttackChoices(opponent);
                        bestChoicesAfter.add(after);
                    }
                    pw.bc.simulateMode = false;
                }
                finally {
                    pw.bc.simulateMode = false;
                    for (int i2 = 0; i2 < saveStats.length; ++i2) {
                        originalStats[i2].copyStats(saveStats[i2]);
                    }
                }
                if (bestChoicesBefore.size() != bestChoicesAfter.size()) {
                    pw.bc.simulateMode = true;
                    pw.bc.sendMessages = true;
                    return;
                }
                pw.getBattleAI().weightFromOpponentOptions(pw, userChoice, bestChoicesBefore, bestChoicesAfter, false);
            }
            pw.bc.simulateMode = true;
            pw.bc.sendMessages = true;
        } else if (this.type == StatsType.Speed) {
            if (!this.isUser) {
                bestOpponentChoices = MoveChoice.getAffectedChoices(userChoice, bestOpponentChoices);
            }
            if (MoveChoice.hasPriority(bestUserChoices, bestOpponentChoices)) {
                return;
            }
            opponents = this.getAffectedOpponents(pw, userChoice);
            int numOutspeedingOpponentsBefore = 0;
            int numOutspeedingOpponentsAfter = 0;
            for (PixelmonWrapper opponent : opponents) {
                if (pw.bc.getFirstMover(pw, opponent) != opponent) continue;
                ++numOutspeedingOpponentsBefore;
            }
            if (numOutspeedingOpponentsBefore == 0) {
                return;
            }
            pw.bc.sendMessages = false;
            pw.bc.simulateMode = false;
            BattleStats[] originalStats = new BattleStats[userChoice.targets.size()];
            BattleStats[] saveStats = new BattleStats[userChoice.targets.size()];
            if (this.isUser) {
                originalStats[0] = pw.getBattleStats();
                saveStats[0] = new BattleStats(originalStats[0]);
            } else {
                for (int i = 0; i < originalStats.length; ++i) {
                    originalStats[i] = userChoice.targets.get(i).getBattleStats();
                    saveStats[i] = new BattleStats(originalStats[i]);
                }
            }
            try {
                if (this.isUser) {
                    pw.getBattleStats().modifyStat(this.amount, this.type, pw, true);
                } else {
                    for (PixelmonWrapper target : userChoice.targets) {
                        target.getBattleStats().modifyStat(this.amount, this.type, pw, true);
                    }
                }
                CalcPriority.checkMoveSpeed(pw.bc);
                for (PixelmonWrapper opponent : opponents) {
                    if (pw.bc.getFirstMover(pw, opponent) != opponent) continue;
                    ++numOutspeedingOpponentsAfter;
                }
            }
            finally {
                for (int i = 0; i < originalStats.length; ++i) {
                    originalStats[i].copyStats(saveStats[i]);
                }
            }
            pw.bc.simulateMode = true;
            pw.bc.sendMessages = true;
            if (numOutspeedingOpponentsAfter == 0) {
                userChoice.raiseWeight(75.0f);
            }
        } else if (this.type == StatsType.Accuracy || this.type == StatsType.Evasion) {
            boolean affectsUser;
            boolean bl = affectsUser = this.isUser && this.type == StatsType.Accuracy || !this.isUser && this.type == StatsType.Evasion;
            if (affectsUser) {
                for (MoveChoice bestUserChoice : bestUserChoices) {
                    if (!bestUserChoice.isOffensiveMove()) continue;
                    if (bestUserChoice.result.accuracy < 0 || bestUserChoice.result.accuracy == 100) {
                        return;
                    }
                    for (EffectBase effect : bestUserChoice.attack.getMove().effects) {
                        if (!(effect instanceof OHKO)) continue;
                        return;
                    }
                }
                if (MoveChoice.canOutspeedAnd2HKO(bestOpponentChoices, pw, bestUserChoices)) {
                    return;
                }
            } else {
                for (MoveChoice bestOpponentChoice : bestOpponentChoices) {
                    if (!bestOpponentChoice.isOffensiveMove()) continue;
                    if (bestOpponentChoice.result.accuracy < 0) {
                        return;
                    }
                    for (EffectBase effect : bestOpponentChoice.attack.getMove().effects) {
                        if (!(effect instanceof OHKO)) continue;
                        return;
                    }
                }
            }
            if (this.isUser && pw.getBattleAbility() instanceof Contrary) {
                return;
            }
            ArrayList<PixelmonWrapper> opponents2 = this.getAffectedOpponents(pw, userChoice);
            for (PixelmonWrapper opponent : opponents2) {
                AbilityBase opponentAbility = opponent.getBattleAbility();
                if (!(opponentAbility instanceof Unaware) && (this.isUser || !(opponentAbility instanceof Contrary))) continue;
                return;
            }
            userChoice.raiseWeight(20 * Math.abs(this.amount));
        }
        if (this.isUser && this.amount > 0 && MoveChoice.hasSuccessfulAttackChoice(userChoices, "Baton Pass", "Stored Power")) {
            userChoice.raiseWeight(10 * this.amount);
        }
        if (!this.isUser && userChoice.weight > 100.0f) {
            userChoice.weight = 100.0f;
        }
    }

    private ArrayList<PixelmonWrapper> getAffectedOpponents(PixelmonWrapper pw, MoveChoice choice) {
        return this.isUser ? pw.bc.getOpponentPokemon(pw) : choice.targets;
    }
}

