/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic;

import com.pixelmonmod.pixelmon.battles.attacks.DamageTypeEnum;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.StatsEffect;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic.SpecialAttackBase;
import com.pixelmonmod.pixelmon.battles.controller.ai.MoveChoice;
import com.pixelmonmod.pixelmon.battles.controller.log.AttackResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.StatsType;
import java.util.ArrayList;

public class ClangorousSoul
extends SpecialAttackBase {
    private static final transient float ONE_THIRD = 33.333332f;
    private static final transient StatsType[] raiseStats = new StatsType[]{StatsType.Attack, StatsType.Defence, StatsType.SpecialAttack, StatsType.SpecialDefence, StatsType.Speed};

    @Override
    public AttackResult applyEffectDuring(PixelmonWrapper user, PixelmonWrapper target) {
        boolean canUse = true;
        for (StatsType statsType : raiseStats) {
            if (user.getBattleStats().getStage(statsType) < 6) continue;
            canUse = false;
        }
        if (user.getHealthPercent() > 33.333332f && canUse) {
            user.doBattleDamage(user, user.getPercentMaxHealth(33.333332f), DamageTypeEnum.SELF);
            for (StatsType statsType : raiseStats) {
                user.getBattleStats().modifyStat(1, statsType);
            }
            return AttackResult.succeeded;
        }
        user.bc.sendToAll("pixelmon.effect.effectfailed", new Object[0]);
        return AttackResult.failed;
    }

    @Override
    public void weightEffect(PixelmonWrapper pw, MoveChoice userChoice, ArrayList<MoveChoice> userChoices, ArrayList<MoveChoice> bestUserChoices, ArrayList<MoveChoice> opponentChoices, ArrayList<MoveChoice> bestOpponentChoices) {
        if (MoveChoice.getMaxDamagePercent(pw, bestOpponentChoices) > pw.getHealthPercent() - 33.333332f) {
            return;
        }
        for (StatsType statsType : raiseStats) {
            StatsEffect effect = new StatsEffect(statsType, 1, true);
            effect.weightEffect(pw, userChoice, userChoices, bestUserChoices, opponentChoices, bestOpponentChoices);
        }
    }
}

