/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic;

import com.google.common.collect.Sets;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic.SpecialAttackBase;
import com.pixelmonmod.pixelmon.battles.controller.ai.MoveChoice;
import com.pixelmonmod.pixelmon.battles.controller.log.AttackResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import java.util.ArrayList;
import java.util.Set;

public class Copycat
extends SpecialAttackBase {
    private static final Set<String> uncopyableMoves = Sets.newHashSet((Object[])new String[]{"Baneful Bunker", "Beak Blast", "Behemoth Blast", "Behemoth Blade", "Bestow", "Celebrate", "Chatter", "Circle Throw", "Counter", "Covet", "Destiny Bond", "Detect", "Dragon Tail", "Dynamax Cannon", "Endure", "Feint", "Focus Punch", "Follow Me", "Helping Hand", "Hold Hands", "King's Shield", "Mat Block", "Mirror Coat", "Protect", "Rage Powder", "Roar", "Shell Trap", "Sketch", "Struggle", "Spiky Shield", "Spotlight", "Switcheroo", "Thief", "Transform", "Trick", "Whirlwind"});
    private static final Set<String> copyableTempMoves = Sets.newHashSet((Object[])new String[]{"Assist", "Copycat", "Metronome", "Me First", "Mimic", "Mirror Move", "Sleep Talk", "Snatch"});

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public AttackResult applyEffectStart(PixelmonWrapper user, PixelmonWrapper target) {
        if (user.bc.simulateMode) {
            return AttackResult.ignore;
        }
        if (user.bc.lastAttack == null || user.bc.lastAttack.isZ || uncopyableMoves.contains(user.bc.lastAttack.toString())) {
            user.bc.sendToAll("pixelmon.effect.effectfailed", new Object[0]);
            return AttackResult.failed;
        }
        if (copyableTempMoves.contains(user.bc.lastAttack.toString())) {
            if (user.bc.lastTempAttack != null) {
                user.useTempAttack(user.bc.lastTempAttack);
                return AttackResult.ignore;
            }
            user.bc.sendToAll("pixelmon.effect.effectfailed", new Object[0]);
            return AttackResult.failed;
        }
        user.useTempAttack(user.bc.lastAttack.isMax ? user.bc.lastAttack.originalMove : user.bc.lastAttack);
        return AttackResult.ignore;
    }

    @Override
    public void weightEffect(PixelmonWrapper pw, MoveChoice userChoice, ArrayList<MoveChoice> userChoices, ArrayList<MoveChoice> bestUserChoices, ArrayList<MoveChoice> opponentChoices, ArrayList<MoveChoice> bestOpponentChoices) {
        ArrayList<MoveChoice> possibleChoices;
        if (MoveChoice.canOutspeed(bestOpponentChoices, pw, userChoice.createList())) {
            possibleChoices = MoveChoice.createChoicesFromChoices(pw, bestOpponentChoices, false);
        } else if (pw.bc.lastAttack != null) {
            possibleChoices = pw.bc.lastAttack.createMoveChoices(pw, false);
        } else {
            return;
        }
        pw.getBattleAI().weightRandomMove(pw, userChoice, possibleChoices);
    }
}

