/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic;

import com.google.common.collect.Sets;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic.SpecialAttackBase;
import com.pixelmonmod.pixelmon.battles.controller.ai.MoveChoice;
import com.pixelmonmod.pixelmon.battles.controller.log.AttackResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.AbilityBase;
import java.util.ArrayList;
import java.util.Set;

public class Entrainment
extends SpecialAttackBase {
    private static final Set<String> invalidTargetAbilities = Sets.newHashSet((Object[])new String[]{"Truant", "Multitype", "StanceChange", "Schooling", "Comatose", "ShieldsDown", "Disguise", "RKSSystem", "BattleBond", "IceFace", "GulpMissile", "AsOne", "PowerConstruct", "ZenMode"});
    private static final Set<String> invalidUserAbilities = Sets.newHashSet((Object[])new String[]{"Trace", "Forecast", "FlowerGift", "ZenMode", "Illusion", "Imposter", "PowerOfAlchemy", "Receiver", "Disguise", "PowerConstruct", "IceFace", "HungerSwitch", "GulpMissile", "NeutralizingGas", "AsOne", "BattleBond", "Comatose", "Multitype", "RKSSystem", "Schooling", "ShieldsDown", "StanceChange"});

    @Override
    public AttackResult applyEffectDuring(PixelmonWrapper user, PixelmonWrapper target) {
        AbilityBase targetAbility = target.getBattleAbility(false);
        AbilityBase userAbility = user.getBattleAbility(false);
        if (target.isDynamax()) {
            target.bc.sendToAll("pixelmon.effect.effectfailed", new Object[0]);
            return AttackResult.failed;
        }
        if (!(targetAbility.getName().equalsIgnoreCase(userAbility.getName()) || invalidTargetAbilities.contains(targetAbility.getName()) || invalidUserAbilities.contains(userAbility.getName()))) {
            user.bc.sendToAll("pixelmon.effect.entrainment", target.getNickname(), target.getBattleAbility(false).getTranslatedName(), user.getBattleAbility(false).getTranslatedName());
            target.setTempAbility(user.getBattleAbility(false));
            return AttackResult.succeeded;
        }
        user.bc.sendToAll("pixelmon.effect.effectfailed", new Object[0]);
        return AttackResult.failed;
    }

    @Override
    public void weightEffect(PixelmonWrapper pw, MoveChoice userChoice, ArrayList<MoveChoice> userChoices, ArrayList<MoveChoice> bestUserChoices, ArrayList<MoveChoice> opponentChoices, ArrayList<MoveChoice> bestOpponentChoices) {
        AbilityBase userAbility = pw.getBattleAbility(false);
        boolean userNegativeAbility = userAbility.isNegativeAbility();
        boolean allied = userChoice.hitsAlly();
        for (PixelmonWrapper target : userChoice.targets) {
            if (target.isDynamax != 0) continue;
            AbilityBase targetAbility = target.getBattleAbility(false);
            boolean targetNegativeAbility = targetAbility.isNegativeAbility();
            if (allied && targetNegativeAbility && !userNegativeAbility) {
                userChoice.raiseWeight(40.0f);
                continue;
            }
            if (allied || targetNegativeAbility) continue;
            if (userNegativeAbility) {
                userChoice.raiseWeight(40.0f);
                continue;
            }
            userChoice.raiseWeight(25.0f);
        }
    }
}

