/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic;

import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic.SpecialAttackBase;
import com.pixelmonmod.pixelmon.battles.controller.ai.MoveChoice;
import com.pixelmonmod.pixelmon.battles.controller.log.AttackResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.AbilityBase;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.IronBarbs;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.RoughSkin;
import com.pixelmonmod.pixelmon.enums.heldItems.EnumHeldItems;
import java.util.ArrayList;

public class KnockOff
extends SpecialAttackBase {
    @Override
    public AttackResult applyEffectStart(PixelmonWrapper user, PixelmonWrapper target) {
        if (target.hasHeldItem() && !target.hasSpecialItem(user)) {
            user.attack.getMove().setBasePower((int)((double)user.attack.getMove().getBasePower() * 1.5));
        }
        return AttackResult.proceed;
    }

    @Override
    public void applyEffect(PixelmonWrapper user, PixelmonWrapper target) {
        if (user.isFainted() && (target.getBattleAbility().isAbility((Class<? extends AbilityBase>)RoughSkin.class) || target.getBattleAbility().isAbility((Class<? extends AbilityBase>)IronBarbs.class) || target.getHeldItem().getHeldItemType() == EnumHeldItems.rockyHelmet)) {
            return;
        }
        if (!user.inParentalBond && target.hasHeldItem() && target.isItemRemovable(user)) {
            user.bc.sendToAll("pixelmon.effect.knockoff", user.getNickname(), target.getNickname(), target.getHeldItem().getLocalizedName());
            target.removeHeldItem();
            target.enableReturnHeldItem();
            user.bc.modifyStats(target);
            user.bc.modifyStats(user);
        }
    }

    @Override
    public void weightEffect(PixelmonWrapper pw, MoveChoice userChoice, ArrayList<MoveChoice> userChoices, ArrayList<MoveChoice> bestUserChoices, ArrayList<MoveChoice> opponentChoices, ArrayList<MoveChoice> bestOpponentChoices) {
        if (userChoice.hitsAlly()) {
            return;
        }
        for (PixelmonWrapper target : userChoice.targets) {
            if (!target.isItemRemovable(pw)) continue;
            userChoice.raiseWeight(25.0f);
        }
    }
}

