/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic.SpecialAttackBase;
import com.pixelmonmod.pixelmon.battles.controller.CalcPriority;
import com.pixelmonmod.pixelmon.battles.controller.ai.MoveChoice;
import com.pixelmonmod.pixelmon.battles.controller.log.AttackResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.tasks.EnforcedSwitchTask;
import java.util.ArrayList;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class Pursuit
extends SpecialAttackBase {
    @Override
    public AttackResult applyEffectStart(PixelmonWrapper user, PixelmonWrapper target) {
        if (target.isSwitching || target.nextSwitchIsMove) {
            user.attack.getMove().setBasePower(user.attack.getMove().getBasePower() * 2);
            this.switchOutRetreatingTarget(user, target);
        }
        return AttackResult.proceed;
    }

    public void switchOutRetreatingTarget(PixelmonWrapper user, PixelmonWrapper target) {
        int userIndex;
        int targetIndex;
        if ((target.attack.isAttack("Parting Shot") || target.attack.isAttack("Volt Switch") || target.attack.isAttack("U-turn")) && (targetIndex = user.bc.turnList.indexOf(target)) < (userIndex = user.bc.turnList.indexOf(user)) && userIndex + 1 < user.bc.turnList.size()) {
            PixelmonWrapper nextAttacker = user.bc.turnList.get(userIndex + 1);
            if (!nextAttacker.attack.isAttack("Pursuit") || !nextAttacker.targets.contains(target)) {
                target.wait = true;
                Pixelmon.network.sendTo((IMessage)new EnforcedSwitchTask(target.bc.getPositionOfPokemon(target, target.getParticipant())), target.getPlayerOwner());
            }
        }
    }

    @Override
    public void applyEffect(PixelmonWrapper user, PixelmonWrapper target) {
        if (target.isSwitching && target.isFainted()) {
            for (int i = user.bc.turn + 1; i < user.bc.turnList.size(); ++i) {
                PixelmonWrapper pw = user.bc.turnList.get(i);
                if (pw.attack == null || !pw.attack.isAttack("Pursuit")) continue;
                CalcPriority.recalculateMoveSpeed(user.bc, user.bc.turn + 1);
                break;
            }
        }
    }

    @Override
    public void weightEffect(PixelmonWrapper pw, MoveChoice userChoice, ArrayList<MoveChoice> userChoices, ArrayList<MoveChoice> bestUserChoices, ArrayList<MoveChoice> opponentChoices, ArrayList<MoveChoice> bestOpponentChoices) {
        if (!userChoice.hitsAlly()) {
            if (userChoice.tier >= 3) {
                userChoice.raiseWeight(1.0f);
            } else {
                for (PixelmonWrapper target : userChoice.targets) {
                    if (!(target.getHealthPercent(userChoice.weight) >= 50.0f)) continue;
                    userChoice.raiseWeight(userChoice.weight);
                }
            }
        }
    }
}

