/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic;

import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.DamageTypeEnum;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic.SpecialAttackBase;
import com.pixelmonmod.pixelmon.battles.controller.ai.MoveChoice;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.EntryHazard;
import com.pixelmonmod.pixelmon.battles.status.PartialTrap;
import com.pixelmonmod.pixelmon.battles.status.StatusBase;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.StatsType;
import java.util.ArrayList;
import net.minecraft.util.text.TextComponentTranslation;

public class RapidSpin
extends SpecialAttackBase {
    @Override
    public void applyEffect(PixelmonWrapper user, PixelmonWrapper target) {
        if (user.isFainted()) {
            return;
        }
        PartialTrap partialTrap = (PartialTrap)user.getStatus(StatusType.PartialTrap);
        if (partialTrap != null) {
            user.bc.sendToAll("pixelmon.effect.freefrom", user.getNickname(), partialTrap.variant.getTranslatedName());
            user.removeStatus(partialTrap);
        }
        if (user.removeStatus(StatusType.Leech)) {
            user.bc.sendToAll("pixelmon.effect.freefrom", user.getNickname(), new TextComponentTranslation("attack.leech_seed.name", new Object[0]));
        }
        if (user.removeTeamStatus(StatusType.Spikes, StatusType.StealthRock, StatusType.ToxicSpikes, StatusType.StickyWeb)) {
            user.bc.sendToAll("pixelmon.effect.clearspikes", user.getNickname());
        }
    }

    @Override
    public void weightEffect(PixelmonWrapper pw, MoveChoice userChoice, ArrayList<MoveChoice> userChoices, ArrayList<MoveChoice> bestUserChoices, ArrayList<MoveChoice> opponentChoices, ArrayList<MoveChoice> bestOpponentChoices) {
        if (userChoice.hitsAlly()) {
            return;
        }
        for (StatusBase status : pw.getStatuses()) {
            StatusType type = status.type;
            if (type == StatusType.PartialTrap) {
                userChoice.raiseWeight(10.0f);
                continue;
            }
            if (type == StatusType.Leech) {
                userChoice.raiseWeight(20.0f);
                continue;
            }
            if (!(status instanceof EntryHazard)) continue;
            EntryHazard hazard = (EntryHazard)status;
            userChoice.raiseWeight(hazard.getAIWeight() * hazard.getNumLayers() * (pw.getParticipant().countAblePokemon() - pw.bc.rules.battleType.numPokemon));
        }
    }

    @Override
    public void dealtDamage(PixelmonWrapper attacker, PixelmonWrapper defender, Attack attack, DamageTypeEnum damageType) {
        attacker.getBattleStats().modifyStat(1, StatsType.Speed);
    }
}

