/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.controller;

import com.pixelmonmod.pixelmon.battles.attacks.EffectBase;
import com.pixelmonmod.pixelmon.battles.attacks.MaxMoveConverter;
import com.pixelmonmod.pixelmon.battles.controller.BattleControllerBase;
import com.pixelmonmod.pixelmon.battles.controller.SpeedComparator;
import com.pixelmonmod.pixelmon.battles.controller.SpeedPriorityComparator;
import com.pixelmonmod.pixelmon.battles.controller.participants.BattleParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.ParticipantType;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.enums.battle.AttackCategory;
import com.pixelmonmod.pixelmon.tools.MutableBoolean;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class CalcPriority {
    public static SpeedPriorityComparator speedPriorityComparator = new SpeedPriorityComparator();
    public static SpeedComparator speedComparator = new SpeedComparator();

    public static void checkMoveSpeed(BattleControllerBase bc) {
        ArrayList<PixelmonWrapper> fullParticipants = new ArrayList<PixelmonWrapper>(6);
        for (BattleParticipant p2 : bc.participants) {
            fullParticipants.addAll(p2.controlledPokemon);
        }
        ArrayList<PixelmonWrapper> filteredParticipants = new ArrayList<PixelmonWrapper>(fullParticipants.size());
        filteredParticipants.addAll(fullParticipants.stream().filter(p -> p.isAlive()).collect(Collectors.toList()));
        CalcPriority.sortByMoveSpeed(bc, filteredParticipants);
        bc.turnList = filteredParticipants;
    }

    private static void sortByMoveSpeed(BattleControllerBase bc, List<PixelmonWrapper> participants) {
        participants.stream().forEach(p -> {
            if (!bc.simulateMode) {
                p.priority = CalcPriority.calculatePriority(p);
            }
        });
        participants.sort(speedPriorityComparator);
        if (!bc.simulateMode) {
            participants.stream().filter(p -> p.attack != null).forEach(p -> {
                for (EffectBase e : p.attack.getMove().effects) {
                    e.applyEarlyEffect((PixelmonWrapper)p);
                }
            });
        }
    }

    public static void recalculateMoveSpeed(BattleControllerBase bc, int turn) {
        ArrayList<PixelmonWrapper> toMove = new ArrayList<PixelmonWrapper>();
        while (bc.turnList.size() > turn) {
            toMove.add(bc.turnList.remove(turn));
        }
        CalcPriority.sortByMoveSpeed(bc, toMove);
        bc.turnList.addAll(toMove.stream().filter(p -> p.isAlive()).collect(Collectors.toList()));
    }

    static List<PixelmonWrapper> getDefaultTurnOrder(BattleControllerBase bc) {
        ArrayList<PixelmonWrapper> turnOrder = new ArrayList<PixelmonWrapper>(6);
        for (BattleParticipant p : bc.participants) {
            turnOrder.addAll(p.controlledPokemon);
        }
        turnOrder.sort(speedComparator);
        return turnOrder;
    }

    public static List<PixelmonWrapper> getTurnOrder(List<PixelmonWrapper> pokemon) {
        ArrayList<PixelmonWrapper> turnOrder = new ArrayList<PixelmonWrapper>(6);
        turnOrder.addAll(pokemon);
        turnOrder.sort(speedComparator);
        return turnOrder;
    }

    public static float calculatePriority(PixelmonWrapper p) {
        float priority = 0.0f;
        if (p.willTryFlee && p.getParticipant().getType() != ParticipantType.WildPokemon) {
            priority = 8.0f;
        } else if (p.willUseItemInStack != null || p.isSwitching) {
            priority = 6.0f;
        } else if (p.attack != null) {
            if (!p.usingZ || p.attack.getMove().getAttackCategory() == AttackCategory.STATUS) {
                priority = p.isDynamax == 1 ? (float)MaxMoveConverter.getMaxMoveFromAttack(p.attack, p).getMove().getPriority(p) : (p.isDynamax == 2 ? (float)MaxMoveConverter.getGMaxMoveFromAttack(p.attack, p, p.getSpecies(), p.getFormEnum()).getMove().getPriority(p) : (float)p.attack.getMove().getPriority(p));
            }
            MutableBoolean triggered = new MutableBoolean(false);
            priority = p.getBattleAbility().modifyPriority(p, priority, triggered);
            priority = p.getUsableHeldItem().modifyPriority(p, priority, triggered);
            if (p.attack.isAttack("Pursuit") && !p.usingZ) {
                for (PixelmonWrapper target : p.targets) {
                    if (!target.isSwitching || !target.isAlive()) continue;
                    priority = 7.0f;
                    break;
                }
            }
        }
        return priority;
    }
}

