/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.controller;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.enums.ExperienceGainType;
import com.pixelmonmod.pixelmon.api.events.battles.CatchComboEvent;
import com.pixelmonmod.pixelmon.battles.controller.participants.BattleParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.ParticipantType;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.controller.participants.PlayerParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.Spectator;
import com.pixelmonmod.pixelmon.client.gui.battles.PixelmonInGui;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.SetPokemonBattleData;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.EVStore;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.Level;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.Stats;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.StatsType;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.evolution.Evolution;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.evolution.types.LevelingEvolution;
import com.pixelmonmod.pixelmon.enums.heldItems.EnumHeldItems;
import com.pixelmonmod.pixelmon.items.ItemExpAll;
import com.pixelmonmod.pixelmon.items.ItemHeld;
import com.pixelmonmod.pixelmon.items.heldItems.EVAdjusting;
import com.pixelmonmod.pixelmon.storage.playerData.CaptureCombo;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public final class Experience {
    public static void awardExp(List<BattleParticipant> participants, BattleParticipant losingTeamOwner, PixelmonWrapper faintedPokemon) {
        if (faintedPokemon == null || faintedPokemon.bc.isLevelingDisabled()) {
            return;
        }
        for (BattleParticipant teamOwner : participants) {
            if (teamOwner.team == losingTeamOwner.team || !(teamOwner instanceof PlayerParticipant)) continue;
            PlayerParticipant player = (PlayerParticipant)teamOwner;
            Set<PixelmonWrapper> attackers = faintedPokemon.getAttackers();
            for (PixelmonWrapper pw : attackers) {
                if (pw.getParticipant() != teamOwner) continue;
                Experience.calcExp(faintedPokemon, pw, 1.0);
            }
            boolean hasExpAll = false;
            ArrayList items = new ArrayList();
            items.addAll(player.player.field_71071_by.field_70462_a);
            items.addAll(player.player.field_71071_by.field_184439_c);
            for (ItemStack item : items) {
                if (item == null || !(item.func_77973_b() instanceof ItemExpAll) || !ItemExpAll.isActivated(item)) continue;
                hasExpAll = true;
                break;
            }
            for (PixelmonWrapper pw : teamOwner.allPokemon) {
                if (attackers.contains(pw)) continue;
                boolean getsExp = false;
                if (hasExpAll || pw.getHeldItem().getHeldItemType() == EnumHeldItems.expShare) {
                    getsExp = true;
                }
                if (!getsExp) continue;
                Experience.calcExp(faintedPokemon, pw, 0.5);
            }
            player.givePlayerExp(faintedPokemon);
        }
    }

    private static void calcExp(PixelmonWrapper faintedPokemon, PixelmonWrapper expReceiver, double scaleFactor) {
        if (expReceiver.isFainted()) {
            return;
        }
        ItemHeld heldItem = expReceiver.initialCopyOfPokemon.getHeldItemAsItemHeld();
        EnumHeldItems heldItemType = heldItem.getHeldItemType();
        Level level = expReceiver.getLevel();
        EVStore evStore = new EVStore(faintedPokemon.getBaseStats().evYields);
        if (heldItemType == EnumHeldItems.evAdjusting) {
            EVAdjusting item = (EVAdjusting)heldItem;
            if (item.type.statAffected == StatsType.None) {
                evStore.doubleValues();
            } else {
                evStore.addStat(item.type.statAffected, 8);
            }
        }
        if (PixelmonConfig.pokerusEnabled && expReceiver.getPokerus().isPresent()) {
            evStore.doubleValues();
        }
        Stats stats = expReceiver.getStats();
        stats.evs.gainEV(evStore);
        int beforeHP = stats.hp;
        stats.setLevelStats(expReceiver.getNature(), expReceiver.getBaseStats(), level.getLevel());
        if (stats.hp > beforeHP) {
            expReceiver.setHealth((int)Math.ceil((double)expReceiver.getHealth() / (double)beforeHP * (double)stats.hp));
            expReceiver.updateHPIncrease();
        }
        expReceiver.update(EnumUpdateType.HP, EnumUpdateType.Stats);
        if (expReceiver.getLevelNum() >= expReceiver.bc.rules.levelCap) {
            return;
        }
        double a = 1.0;
        if (faintedPokemon.getParticipant().getType() != ParticipantType.WildPokemon) {
            a = 1.5;
        }
        double t = expReceiver.getOriginalTrainer().equals(expReceiver.getParticipant().getDisplayName()) ? 1.0 : 1.5;
        double baseExp = faintedPokemon.getBaseStats().getBaseExp();
        double eggMultiplier = heldItemType == EnumHeldItems.luckyEgg ? 1.5 : 1.0;
        double faintedLevel = faintedPokemon.getLevelNum();
        PlayerParticipant participant = (PlayerParticipant)expReceiver.getParticipant();
        CaptureCombo combo = participant.getStorage().transientData.captureCombo;
        double captureCombo = 1.0;
        if (combo.getCurrentSpecies() == faintedPokemon.getSpecies()) {
            CatchComboEvent.ComboExperienceBonus event = new CatchComboEvent.ComboExperienceBonus(participant.player, combo.getExpBouns());
            Pixelmon.EVENT_BUS.post((Event)event);
            captureCombo = event.getExperienceModifier();
        }
        double exp = a * t * baseExp * eggMultiplier * captureCombo * faintedLevel * (scaleFactor *= (double)PixelmonConfig.expModifier) / 7.0;
        for (Evolution e : expReceiver.getBaseStats().getEvolutions()) {
            if (!(e instanceof LevelingEvolution) || level.getLevel() < ((LevelingEvolution)e).getLevel()) continue;
            exp *= 1.2;
            break;
        }
        level.awardEXP((int)exp, ExperienceGainType.BATTLE);
        if (!expReceiver.bc.battleEnded) {
            expReceiver.updateHPIncrease();
        }
        if (!expReceiver.bc.battleEnded && expReceiver.getParticipant() instanceof PlayerParticipant) {
            ArrayList<PixelmonWrapper> teamPokemon = participant.getTeamPokemonList();
            Pixelmon.network.sendTo((IMessage)new SetPokemonBattleData(PixelmonInGui.convertToGUI(teamPokemon), false), participant.player);
            ArrayList<Spectator> playerSpectators = expReceiver.bc.getPlayerSpectators(participant);
            playerSpectators.forEach(spectator -> spectator.sendMessage(new SetPokemonBattleData(PixelmonInGui.convertToGUI(teamPokemon), false)));
        }
    }
}

