/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.controller.ai;

import com.pixelmonmod.pixelmon.RandomHelper;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.EffectBase;
import com.pixelmonmod.pixelmon.battles.controller.ai.MoveChoice;
import com.pixelmonmod.pixelmon.battles.controller.ai.TacticalAI;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.controller.participants.RaidPixelmonParticipant;
import com.pixelmonmod.pixelmon.battles.raids.RaidGovernor;
import com.pixelmonmod.pixelmon.battles.status.ProtectVariation;
import java.util.ArrayList;
import java.util.Iterator;

public class RaidAI
extends TacticalAI {
    private final RaidPixelmonParticipant rpp;
    private final RaidGovernor governor;

    public RaidAI(RaidGovernor governor, RaidPixelmonParticipant participant) {
        super(participant);
        this.rpp = participant;
        this.governor = governor;
    }

    @Override
    protected ArrayList<MoveChoice> getAttackChoices(PixelmonWrapper pw) {
        ArrayList<MoveChoice> choices = new ArrayList<MoveChoice>();
        ArrayList<Attack> moveset = this.governor.getMoves();
        for (Attack a : moveset) {
            if (a == null || a.pp <= 0 || a.getDisabled()) continue;
            a.createMoveChoices(pw, choices, true);
        }
        if (choices.isEmpty()) {
            ArrayList<PixelmonWrapper> targets = new ArrayList<PixelmonWrapper>();
            targets.addAll(this.bc.getAdjacentPokemon(pw));
            targets.addAll(this.bc.getOpponentPokemon(this.participant));
            Attack struggle = new Attack("Struggle");
            struggle.createMoveChoices(pw, choices, false);
        }
        return choices;
    }

    public ArrayList<MoveChoice> getTopNAttackChoices(int count, PixelmonWrapper pw) {
        ArrayList<MoveChoice> choices = this.getWeightedAttackChoices(pw);
        choices.removeIf(choice -> this.isProtect(choice.attack));
        ArrayList<MoveChoice> bestChoices = this.getBestChoices(choices);
        return this.pickTopNBestChoices(count, choices, bestChoices);
    }

    protected boolean isProtect(Attack attack) {
        for (EffectBase effect : attack.getMove().effects) {
            if (!(effect instanceof ProtectVariation)) continue;
            return true;
        }
        return false;
    }

    protected ArrayList<MoveChoice> pickTopNBestChoices(int count, ArrayList<MoveChoice> choices, ArrayList<MoveChoice> bestChoices) {
        ArrayList<MoveChoice> finalChoices = new ArrayList<MoveChoice>();
        for (int i = 0; i < count; ++i) {
            MoveChoice choice;
            if (bestChoices.isEmpty()) {
                if (choices.isEmpty()) break;
                choice = RandomHelper.getRandomElementFromList(choices);
                choices.remove(choice);
                bestChoices.remove(choice);
                finalChoices.add(choice);
                continue;
            }
            if (bestChoices.size() > 1 && bestChoices.get(0).isMiddleTier()) {
                float totalWeight = 0.0f;
                for (MoveChoice choice2 : bestChoices) {
                    totalWeight += choice2.weight;
                }
                float random = RandomHelper.getRandomNumberBetween(0.0f, totalWeight);
                float counter = 0.0f;
                boolean chosen = false;
                Iterator<MoveChoice> iterator = bestChoices.iterator();
                while (iterator.hasNext()) {
                    MoveChoice choice3 = iterator.next();
                    if (!((counter += choice3.weight) >= random)) continue;
                    choices.remove(choice3);
                    iterator.remove();
                    finalChoices.add(choice3);
                    chosen = true;
                }
                if (chosen) continue;
                MoveChoice choice4 = bestChoices.get(bestChoices.size() - 1);
                choices.remove(choice4);
                bestChoices.remove(choice4);
                finalChoices.add(choice4);
                continue;
            }
            choice = RandomHelper.getRandomElementFromList(bestChoices);
            choices.remove(choice);
            bestChoices.remove(choice);
            finalChoices.add(choice);
        }
        return finalChoices;
    }
}

