/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.controller.log;

import com.pixelmonmod.pixelmon.battles.controller.BattleControllerBase;
import com.pixelmonmod.pixelmon.battles.controller.log.AttackAction;
import com.pixelmonmod.pixelmon.battles.controller.log.BagItemAction;
import com.pixelmonmod.pixelmon.battles.controller.log.BattleActionBase;
import com.pixelmonmod.pixelmon.battles.controller.log.SwitchAction;
import com.pixelmonmod.pixelmon.battles.controller.participants.BattleParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.controller.participants.PlayerParticipant;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.enums.battle.EnumBattleEndCause;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.util.Tuple;

public class BattleLog {
    private final BattleControllerBase bc;
    private int crashCount = 0;
    private final Instant battleStart = Instant.now();
    private final Map<Integer, BattleTurnLog> logs = new LinkedHashMap<Integer, BattleTurnLog>();
    private BattleTurnLog currentTurnLog;
    private Tuple<Exception, String> lastError;

    public BattleLog(BattleControllerBase bc) {
        this.bc = bc;
        this.turnTick(0);
    }

    public void addEvent(BattleActionBase event) {
        this.currentTurnLog.registerAction(event);
    }

    public BattleActionBase getActionForPokemon(int turn, PixelmonWrapper pw) {
        BattleTurnLog log = this.logs.get(turn);
        if (log != null) {
            return log.getBattleActionFor(pw);
        }
        return null;
    }

    public void turnTick(int turn) {
        this.currentTurnLog = new BattleTurnLog(turn);
        this.logs.put(turn, this.currentTurnLog);
    }

    public void onCrash(Exception exc, String error) {
        ++this.crashCount;
        this.lastError = new Tuple((Object)exc, (Object)error);
        if (PixelmonConfig.printErrors) {
            System.err.println(error);
            exc.printStackTrace();
        }
        if (this.crashCount >= 3) {
            if (PixelmonConfig.printErrors) {
                System.out.println("===Too many errors detected in battle, force-ending===");
                this.bc.participants.stream().filter(participant -> participant instanceof PlayerParticipant).forEach(participant -> ChatHandler.sendChat((Entity)participant.getEntity(), "pixelmon.general.battleerror", new Object[0]));
            }
            this.bc.endBattle(EnumBattleEndCause.FORCE);
        }
        try {
            this.exportLogFile();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public List<BattleActionBase> getAllActions() {
        return this.logs.values().stream().map(it -> ((BattleTurnLog)it).actions).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public void exportLogFile() throws Exception {
        File file = new File("./logs/battle/", this.getFilename() + ".log");
        int count = 0;
        while (file.exists()) {
            file = new File("./logs/battle/", this.getFilename() + "_" + count++ + ".log");
        }
        StringBuilder sb = new StringBuilder("Battle data " + this.battleStart.toString() + "\n");
        for (BattleParticipant participant : this.bc.participants) {
            sb.append("Team #" + participant.team + " " + participant.getType().toString() + " " + participant.getDisplayName() + "\n");
            for (PixelmonWrapper pw : participant.allPokemon) {
                sb.append("\t" + pw.getPokemonName() + "\t" + pw.getAbility().toString() + "\t" + pw.getMoveset().attacks.toString() + "\n");
            }
        }
        for (BattleTurnLog log : this.logs.values()) {
            sb.append(log.toString());
        }
        if (this.lastError != null) {
            sb.append((String)this.lastError.func_76340_b()).append('\n');
            sb.append(((Exception)this.lastError.func_76341_a()).getMessage()).append('\n');
            for (Iterator<Object> iterator : ((Exception)this.lastError.func_76341_a()).getStackTrace()) {
                sb.append(((StackTraceElement)((Object)iterator)).toString()).append('\n');
            }
        }
        file.getParentFile().mkdir();
        file.createNewFile();
        Files.write(file.toPath(), sb.toString().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }

    public String getFilename() {
        return "battle-" + this.battleStart.getEpochSecond();
    }

    private static class BattleTurnLog {
        private final List<BattleActionBase> actions = new ArrayList<BattleActionBase>();
        private final int turnNumber;

        public BattleTurnLog(int turnNumber) {
            this.turnNumber = turnNumber;
        }

        public void registerAction(BattleActionBase action) {
            this.actions.add(action);
        }

        public BattleActionBase getBattleActionFor(PixelmonWrapper wrapper) {
            for (BattleActionBase action : this.actions) {
                if (!Objects.equals(action.pokemon, wrapper)) continue;
                return action;
            }
            return null;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("Turn #" + this.turnNumber + "\n");
            for (BattleActionBase action : this.actions) {
                sb.append(" - ");
                BattleParticipant participant = action.getParticipant();
                sb.append(participant.getType().toString()).append(" ").append(participant.getDisplayName()).append(" ");
                sb.append("pokemon=").append(action.pokemon.toString()).append(", ");
                sb.append("action=").append(action.actionType().toString());
                if (action instanceof AttackAction) {
                    sb.append(", attack=").append(((AttackAction)action).attack);
                    sb.append(", results=").append(Arrays.toString(((AttackAction)action).moveResults));
                } else if (action instanceof SwitchAction) {
                    sb.append(", switchingTo=").append(((SwitchAction)action).switchingTo);
                } else if (action instanceof BagItemAction) {
                    BagItemAction ba = (BagItemAction)action;
                    sb.append(", item=").append((Object)(ba.item == null ? "null" : ba.item.getRegistryName()));
                }
                sb.append('\n');
            }
            return sb.toString();
        }
    }
}

