/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.controller.participants;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.RandomHelper;
import com.pixelmonmod.pixelmon.api.events.raids.EndRaidEvent;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.DamageTypeEnum;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic.OHKO;
import com.pixelmonmod.pixelmon.battles.controller.BattleControllerBase;
import com.pixelmonmod.pixelmon.battles.controller.ai.MoveChoice;
import com.pixelmonmod.pixelmon.battles.controller.ai.RaidAI;
import com.pixelmonmod.pixelmon.battles.controller.participants.BattleParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.ParticipantType;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.controller.participants.PlayerParticipant;
import com.pixelmonmod.pixelmon.battles.raids.RaidData;
import com.pixelmonmod.pixelmon.battles.raids.RaidGovernor;
import com.pixelmonmod.pixelmon.battles.raids.RaidSettings;
import com.pixelmonmod.pixelmon.battles.status.GastroAcid;
import com.pixelmonmod.pixelmon.battles.status.LightScreen;
import com.pixelmonmod.pixelmon.battles.status.Reflect;
import com.pixelmonmod.pixelmon.battles.status.StatusBase;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.battles.tasks.HPUpdateTask;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.Stats;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.StatsType;
import com.pixelmonmod.pixelmon.enums.EnumBossMode;
import com.pixelmonmod.pixelmon.enums.EnumSpecies;
import com.pixelmonmod.pixelmon.enums.battle.AttackCategory;
import com.pixelmonmod.pixelmon.enums.battle.EnumBattleEndCause;
import com.pixelmonmod.pixelmon.enums.forms.EnumUrshifu;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.UUID;
import net.minecraft.entity.EntityLiving;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextComponentBase;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.eventhandler.Event;

public class RaidPixelmonParticipant
extends BattleParticipant {
    private final RaidData raid;
    private final RaidGovernor governor;
    private RaidAI ai;
    private static int idCounter = 0;
    private boolean justTransformed = false;
    public static final String[] BANNED_ATTACKS = new String[]{"Bug Bite", "Curse", "Destiny Bond", "Explosion", "Incinerate", "Knock Off", "Perish Song", "Pluck", "Self-Destruct", "Self Destruct", "Super Fang"};
    private static final Set<StatusType> BLOCKED_STATUSES = new HashSet<StatusType>(Arrays.asList(StatusType.Poison, StatusType.PoisonBadly, StatusType.Burn, StatusType.Sleep, StatusType.Paralysis, StatusType.Yawn, StatusType.Freeze, StatusType.Confusion, StatusType.Infatuated));

    public RaidPixelmonParticipant(RaidData raid, RaidSettings settings, EntityPixelmon pixelmon) {
        super(1);
        this.raid = raid;
        this.governor = new RaidGovernor(settings);
        this.init(pixelmon);
    }

    public PixelmonWrapper getWrapper() {
        return (PixelmonWrapper)this.controlledPokemon.get(0);
    }

    private void init(EntityPixelmon pixelmon) {
        this.governor.init(pixelmon);
        PixelmonWrapper pw = new PixelmonWrapper((BattleParticipant)this, pixelmon, 0);
        this.allPokemon = new PixelmonWrapper[]{pw};
        this.controlledPokemon.add(pw);
    }

    @Override
    public ParticipantType getType() {
        return ParticipantType.RaidPokemon;
    }

    @Override
    public boolean hasMorePokemon() {
        return this.countAblePokemon() == 1;
    }

    @Override
    public boolean hasMorePokemonReserve() {
        return false;
    }

    @Override
    public boolean canGainXP() {
        return false;
    }

    @Override
    public void startBattle(BattleControllerBase bc) {
        super.startBattle(bc);
        PixelmonWrapper pw = this.getWrapper();
        EnumBossMode bossMode = this.governor.bossMode;
        if (bossMode != EnumBossMode.NotBoss) {
            int lvl = 1;
            for (BattleParticipant p : bc.participants) {
                if (p.team == this.team || !(p instanceof PlayerParticipant)) continue;
                int highestLevel = ((PlayerParticipant)p).getHighestLevel();
                lvl = Math.max(lvl, highestLevel);
            }
            Stats stats = pw.getStats();
            stats.ivs.maximizeIVs();
            stats.evs.randomizeMaxEVs();
            pw.setTempLevel(lvl += bossMode.getExtraLevels());
        }
        pw.setHealth(pw.getMaxHealth());
        pw.getMoveset().forEach(attack -> {
            if (attack != null) {
                attack.pp = attack.getMaxPP();
            }
        });
        this.setDynamax(pw);
        this.ai = new RaidAI(this.governor, this);
        this.setBattleAI(this.ai);
        this.governor.cycleDynamax(this);
        bc.sendHealPacket(this.getWrapper(), this.getWrapper().getMaxHealth());
    }

    private void setDynamax(PixelmonWrapper pw) {
        if (this.governor.isGigantamax()) {
            pw.setPrevForm(pw.getFormEnum());
            if (pw.getSpecies() == EnumSpecies.Urshifu) {
                EnumUrshifu form = (EnumUrshifu)pw.getFormEnum();
                pw.setForm(form.getGigantamax());
            } else {
                pw.setForm(pw.pokemon.getSpecies().getFormEnum("gmax"));
            }
            pw.isDynamax = 2;
        } else {
            pw.isDynamax = 1;
        }
        pw.dynamaxTurns = Integer.MAX_VALUE;
        pw.dynamaxAnimationTicks = 50;
        this.dynamax = pw.getPokemonUUID();
        pw.updateHPIncrease();
        pw.setHealth(pw.getMaxHealth());
        pw.update(EnumUpdateType.ALL);
    }

    @Override
    public void endBattle(EnumBattleEndCause cause) {
        Pixelmon.EVENT_BUS.post((Event)new EndRaidEvent(this.raid, this.governor, this.bc.getOpponents(this), this, this.isDefeated));
        if (this.isDefeated) {
            for (RaidData.RaidPlayer rp : this.raid.getPlayers()) {
                rp.winRaid(this, this.raid, this.governor);
            }
        } else if (!this.getEntity().func_130014_f_().field_72995_K) {
            this.raid.getDenEntity(this.getEntity().func_130014_f_()).ifPresent(den -> {
                if (!den.func_130014_f_().field_72995_K) {
                    double radius = 3.0;
                    WorldServer world = (WorldServer)den.func_130014_f_();
                    world.func_184133_a(null, den.func_180425_c(), SoundEvents.field_187539_bB, SoundCategory.BLOCKS, 4.0f, (1.0f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
                    for (int i = 0; i < 200; ++i) {
                        Vec3d sphere = RandomHelper.nextSpherePoint(radius);
                        world.func_180505_a(EnumParticleTypes.SMOKE_LARGE, false, den.field_70165_t + sphere.field_72450_a, den.field_70163_u + world.field_73012_v.nextDouble() * radius * 2.0, den.field_70161_v + sphere.field_72449_c, 1, world.field_73012_v.nextDouble() * 2.0 - 1.0, world.field_73012_v.nextDouble() * 2.0 - 1.0, world.field_73012_v.nextDouble() * 2.0 - 1.0, world.field_73012_v.nextDouble() * 0.5, new int[0]);
                    }
                }
            });
        }
        for (PixelmonWrapper pw : this.controlledPokemon) {
            pw.entity.onEndBattle();
            pw.entity.func_70106_y();
        }
    }

    private boolean shouldDespawn() {
        return true;
    }

    @Override
    public void getNextPokemon(int position) {
    }

    @Override
    public UUID getNextPokemonUUID() {
        return null;
    }

    @Override
    public TextComponentBase getName() {
        String key = "";
        if (!this.controlledPokemon.isEmpty()) {
            key = "pixelmon." + ((PixelmonWrapper)this.controlledPokemon.get((int)0)).entity.getLocalizedName().toLowerCase() + ".name";
        }
        return new TextComponentTranslation(key, new Object[0]);
    }

    @Override
    public MoveChoice getMove(PixelmonWrapper pw) {
        if (this.bc == null) {
            return null;
        }
        return this.getBattleAI().getNextMove(pw);
    }

    @Override
    public PixelmonWrapper switchPokemon(PixelmonWrapper pw, UUID newPixelmonUUID) {
        return null;
    }

    @Override
    public boolean checkPokemon() {
        boolean allGood = true;
        for (PixelmonWrapper pw : this.controlledPokemon) {
            if (!pw.getMoveset().isEmpty()) continue;
            pw.entity.getPokemonData().getMoveset().clear();
            pw.entity.getPokemonData().getMoveset().addAll(pw.entity.getPokemonData().getBaseStats().loadMoveset(pw.getLevelNum()));
            if (!pw.getMoveset().isEmpty()) continue;
            if (PixelmonConfig.printErrors) {
                Pixelmon.LOGGER.info("Couldn't load " + pw.entity.getLocalizedName() + "'s moves.");
            }
            allGood = false;
        }
        return allGood;
    }

    @Override
    public void updatePokemon(PixelmonWrapper pw) {
    }

    public EntityLiving getEntity() {
        if (this.controlledPokemon.isEmpty()) {
            return null;
        }
        return ((PixelmonWrapper)this.controlledPokemon.get((int)0)).entity;
    }

    @Override
    public void updateOtherPokemon() {
    }

    @Override
    public void setPosition(double[] ds) {
    }

    @Override
    public boolean canDynamax() {
        return true;
    }

    @Override
    public String getDisplayName() {
        Iterator iterator = this.controlledPokemon.iterator();
        if (iterator.hasNext()) {
            PixelmonWrapper pw = (PixelmonWrapper)iterator.next();
            return pw.getNickname();
        }
        return super.getDisplayName();
    }

    public boolean areShieldsUp() {
        return this.governor.shields > 0;
    }

    @Override
    public void onSwitchIn(BattleControllerBase bc, PixelmonWrapper pw) {
        this.setDynamax(pw);
    }

    @Override
    public void onEndTurn(BattleControllerBase bc) {
        if (!bc.simulateMode && this.isAlive() && !this.governor.done) {
            float hp = this.getWrapper().getHealthPercent();
            if (hp < 50.0f && this.governor.previousTurnHP >= 50.0f && !this.governor.desperate) {
                this.governor.desperate = true;
                bc.sendToAll("raid.desperate", this.getDisplayName());
            }
            this.tryShields();
            this.governor.previousTurnHP = this.getWrapper().getHealthPercent();
            int i = 0;
            for (BattleParticipant bp : this.bc.getOpponents(this)) {
                if (this.governor.isKnockedOut(i) && this.governor.tryRevive(i)) {
                    bp.isDefeated = false;
                    bp.allPokemon[0].healByPercent(100.0f);
                    String name = bp.getDisplayName();
                    bc.sendToAll("raid.recover", name);
                    this.bc.reviveAfterDefeat(bp);
                }
                if (bp.dynamax != null) {
                    this.governor.onDynamax();
                }
                ++i;
            }
            this.governor.cycleDynamax(this);
        }
    }

    @Override
    public boolean onTakeTurn(BattleControllerBase bc, PixelmonWrapper pw) {
        if (this.governor.done || bc.simulateMode) {
            return false;
        }
        if (this.governor.incrementTurnCounter()) {
            this.governor.done = true;
            bc.sendToAll("raid.storm.c", new Object[0]);
            bc.sendToAll("raid.blowout", new Object[0]);
            bc.endBattle();
            return false;
        }
        int i = 0;
        for (BattleParticipant bp : this.bc.getOpponents(this)) {
            if (this.governor.canCheer(i)) {
                this.tryCheer(bp);
            }
            ++i;
        }
        return false;
    }

    @Override
    public boolean onUseAttack(BattleControllerBase bc, PixelmonWrapper pw) {
        if (this.isAlive() && !this.governor.done && !bc.simulateMode) {
            if (this.governor.tryShockwave(pw.hasPrimaryStatus(false))) {
                this.shockwave(pw);
            }
            this.doAttacks(pw, this.governor.getAttacksPerTurn(), false);
        }
        return true;
    }

    private void doAttacks(PixelmonWrapper pw, int attacks, boolean hasTransformed) {
        if (attacks <= 0) {
            return;
        }
        ArrayList<MoveChoice> choices = this.ai.getTopNAttackChoices(attacks, pw);
        Collections.shuffle(choices);
        for (MoveChoice choice : choices) {
            if (pw.hasStatus(StatusType.Sleep)) {
                this.bc.sendToAll("pixelmon.status.stillsleeping", this.getDisplayName());
                continue;
            }
            pw.chooseMove(choice);
            pw.useAttack(false);
            if (hasTransformed || !this.justTransformed) continue;
            this.justTransformed = false;
            this.doAttacks(pw, attacks - 1, true);
            break;
        }
    }

    @Override
    public void onUseAttackPost(BattleControllerBase bc, PixelmonWrapper pw) {
        if (pw.attack.isAttack("Transform")) {
            this.governor.settings.rerollMoveset(pw.pokemon);
            this.justTransformed = true;
        }
    }

    @Override
    public boolean onUseAttackOther(BattleControllerBase bc, Attack attack, BattleParticipant bp, PixelmonWrapper user) {
        boolean fail = attack.isAttack(BANNED_ATTACKS);
        boolean ohko = attack.getActualMove().hasEffect(OHKO.class);
        if (ohko && this.areShieldsUp() && bp != this) {
            bc.sendToAll("pixelmon.battletext.used", user.getNickname(), attack.getMove().getTranslatedName());
            this.governor.shields -= 2;
            bc.sendToAll("raid.ohko", new Object[0]);
            if (this.governor.shields <= 0) {
                bc.sendToAll("raid.barrier.destroy", this.getDisplayName());
            }
            this.getWrapper().updateRaidShields(this.governor.shields);
        } else if (ohko || fail) {
            bc.sendToAll("pixelmon.battletext.used", user.getNickname(), attack.getMove().getTranslatedName());
            bc.sendToAll("pixelmon.effect.effectfailed", new Object[0]);
        }
        return fail || ohko;
    }

    public void shockwave(PixelmonWrapper pw) {
        if (this.governor.done || this.bc.simulateMode) {
            return;
        }
        this.bc.sendToAll("raid.shockwave", this.getDisplayName());
        for (PixelmonWrapper opw : this.bc.getOpponentPokemon(this)) {
            opw.addStatus(new GastroAcid(), pw);
            opw.getBattleStats().clearBattleStats();
        }
        pw.clearStatus();
    }

    @Override
    public boolean onTargeted(PixelmonWrapper user, Attack attack) {
        return !this.governor.done && this.areShieldsUp() && attack.getMove().getAttackCategory() == AttackCategory.STATUS;
    }

    @Override
    public boolean onAddStatus(BattleControllerBase bc, PixelmonWrapper user, PixelmonWrapper target, StatusBase status) {
        return this.areShieldsUp() && BLOCKED_STATUSES.contains(status.type);
    }

    @Override
    public float onHit(PixelmonWrapper source, float damage, DamageTypeEnum damageType) {
        if (this.governor.done || this.bc.simulateMode) {
            return damage;
        }
        if (this.isAlive()) {
            float hp;
            if (this.areShieldsUp() && damageType == DamageTypeEnum.ATTACK) {
                damage = Math.max(0.0f, damage * 0.1f - 10.0f);
                --this.governor.shields;
                if (this.governor.shields > 0 && source.attack != null && source.attack.isMax) {
                    --this.governor.shields;
                    this.bc.sendToAll("raid.ohko", new Object[0]);
                }
                if (this.governor.shields <= 0) {
                    this.bc.sendToAll("raid.barrier.destroy", this.getDisplayName());
                }
                this.getWrapper().updateRaidShields(this.governor.shields);
            }
            if ((hp = this.getWrapper().getHealthPercent((float)this.getWrapper().getHealth() - damage)) <= this.governor.shieldHPBound) {
                this.governor.shouldRaiseShields = true;
            }
            if (this.tryShields()) {
                int hpNow = this.getWrapper().getHealth();
                float bound = (float)(this.governor.shieldUses + 1) * this.governor.shieldHPPercent;
                this.getWrapper().setHealth(this.getWrapper().getPercentMaxHealth(bound));
                int hpThen = this.getWrapper().getHealth();
                this.bc.sendToPlayers(new HPUpdateTask(this.getWrapper(), hpThen - hpNow));
                damage = 0.0f;
            }
        }
        return damage;
    }

    private boolean tryShields() {
        if (this.governor.done || this.bc.simulateMode) {
            return false;
        }
        if (this.governor.shouldRaiseShields && this.governor.shields == 0 && this.governor.raiseShields()) {
            this.getWrapper().setRaidShields(this.governor.shields);
            this.bc.sendToAll("raid.barrier", this.getDisplayName());
            return true;
        }
        return false;
    }

    private void tryCheer(BattleParticipant cheerer) {
        if (this.governor.done || this.bc.simulateMode) {
            return;
        }
        this.bc.sendToAll("raid.cheer", cheerer.getDisplayName());
        if (this.governor.tryCheer()) {
            int effect = RandomHelper.rand.nextInt(6);
            PixelmonWrapper pw = cheerer.allPokemon[0];
            boolean success = false;
            switch (effect) {
                case 0: {
                    if (!new Reflect().apply(pw, false)) break;
                    success = true;
                    break;
                }
                case 1: {
                    if (!new LightScreen().apply(pw, false)) break;
                    success = true;
                    break;
                }
                case 2: {
                    if (this.governor.shields <= 0) break;
                    this.governor.shields = 0;
                    this.bc.sendToAll("raid.barrier.destroy", this.getDisplayName());
                    this.getWrapper().updateRaidShields(this.governor.shields);
                    success = true;
                    break;
                }
                case 3: {
                    StatsType stat = StatsType.getRandomBattleMutableStat();
                    for (PixelmonWrapper ally : this.bc.getTeamPokemon(pw)) {
                        ally.getBattleStats().increaseStat(1, stat, pw, false);
                    }
                    success = true;
                    break;
                }
                case 4: {
                    for (PixelmonWrapper ally : this.bc.getTeamPokemon(pw)) {
                        if (ally.removePrimaryStatus(true) == null) continue;
                        success = true;
                    }
                    break;
                }
                case 5: {
                    float hp = 100.0f;
                    PixelmonWrapper toHeal = null;
                    for (PixelmonWrapper ally : this.bc.getTeamPokemon(pw)) {
                        float ahp = ally.getHealthPercent();
                        if (ally.isFainted() || !(ahp < 100.0f) || !(ahp < hp)) continue;
                        hp = ahp;
                        toHeal = ally;
                    }
                    if (toHeal == null) break;
                    toHeal.healByPercent(100.0f);
                    this.getWrapper().updateHPIncrease();
                    this.bc.sendToAll("pixelmon.effect.washealed", toHeal.getNickname());
                    success = true;
                }
            }
            if (success) {
                String name = cheerer.getDisplayName();
                this.bc.sendToAll("raid.cheer.success", name);
            } else {
                this.bc.sendToAll("raid.cheer.fail", new Object[0]);
            }
        } else {
            this.bc.sendToAll("raid.cheer.fail", new Object[0]);
        }
    }

    @Override
    public void onOpponentKO(BattleControllerBase bc, PixelmonWrapper pw) {
        if (this.governor.done || bc.simulateMode) {
            return;
        }
        if (this.isAlive()) {
            int i = 0;
            for (BattleParticipant bp : this.bc.getOpponents(this)) {
                if (bp.allPokemon[0] == pw) {
                    this.governor.knockout(i);
                    break;
                }
                ++i;
            }
            ++this.governor.kills;
            if (this.governor.kills >= this.governor.getLives()) {
                this.governor.done = true;
                bc.sendToAll("raid.blowout", new Object[0]);
                bc.endBattle();
            } else {
                int message = this.governor.getLives() - this.governor.kills;
                switch (message) {
                    case 1: {
                        bc.sendToAll("raid.storm.c", new Object[0]);
                        break;
                    }
                    case 2: {
                        bc.sendToAll("raid.storm.b", new Object[0]);
                        break;
                    }
                    default: {
                        bc.sendToAll("raid.storm.a", new Object[0]);
                    }
                }
            }
        }
    }

    public boolean canDynamax(BattleParticipant participant) {
        return !this.governor.done && !this.governor.hasDynamaxOccured && this.governor.dynamaxIndex == this.getOpponents().indexOf(participant);
    }

    public boolean isAlive() {
        return this.allPokemon[0].isAlive();
    }

    public RaidGovernor getGovernor() {
        return this.governor;
    }
}

