/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.rules.clauses.tiers;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.battles.rules.clauses.BattleClauseRegistry;
import com.pixelmonmod.pixelmon.battles.rules.clauses.tiers.EnumTier;
import com.pixelmonmod.pixelmon.battles.rules.clauses.tiers.TierAllowedSet;
import com.pixelmonmod.pixelmon.battles.rules.clauses.tiers.TierSet;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.entities.npcs.registry.PokemonForm;
import com.pixelmonmod.pixelmon.entities.npcs.registry.ServerNPCRegistry;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;

public class RulesRegistry {
    private static final String ASSETS_FOLDER = File.separator + "assets";
    private static final String JSON_FOLDER = File.separator + "pixelmon";
    private static final String RULES_FOLDER = File.separator + "rules";
    private static final String TIER_FOLDER = File.separator + "tiers";
    private static final String CUSTOM_FOLDER = File.separator + "custom";
    private static final String RULESET_FOLDER = File.separator + "rulesets";
    private static final String JSON_EXTENSION = ".json";
    private static final String BATTLE_SPOT_FILE = CUSTOM_FOLDER.substring(1) + File.separator + "battlespot" + ".json";

    private RulesRegistry() {
    }

    public static void registerRules() {
        Pixelmon.LOGGER.info("Registering battle rules.");
        File rulesDir = new File("./pixelmon/rules/");
        if (PixelmonConfig.useExternalJSONFilesRules && !rulesDir.exists()) {
            Pixelmon.LOGGER.info("Creating rules directory.");
            rulesDir.mkdirs();
        }
        RulesRegistry.registerTiers();
        RulesRegistry.registerRulesets();
    }

    private static void registerTiers() {
        File tierDir = new File("./pixelmon/rules/tiers");
        File customTiers = new File(tierDir, "custom");
        if (PixelmonConfig.useExternalJSONFilesRules && !customTiers.exists()) {
            customTiers.mkdirs();
            RulesRegistry.extractTierDirs(tierDir);
        }
        for (EnumTier tier : EnumTier.values()) {
            if (tier == EnumTier.PU) continue;
            try {
                RulesRegistry.registerTier(tierDir, tier, PixelmonConfig.useExternalJSONFilesRules);
            }
            catch (IOException e) {
                RulesRegistry.printError(tier.name().toLowerCase() + JSON_EXTENSION, e);
            }
        }
        BattleClauseRegistry.getTierRegistry().removeCustomClauses();
        if (PixelmonConfig.useExternalJSONFilesRules) {
            File[] fileList = customTiers.listFiles();
            if (fileList == null) {
                fileList = new File[]{};
            }
            for (File file : fileList) {
                String fileName = file.getName();
                if (!fileName.endsWith(JSON_EXTENSION)) continue;
                try {
                    RulesRegistry.registerTier(customTiers, fileName, PixelmonConfig.useExternalJSONFilesRules);
                }
                catch (IOException e) {
                    RulesRegistry.printError(fileName, e);
                }
            }
        } else {
            try {
                RulesRegistry.registerTier(tierDir, BATTLE_SPOT_FILE, PixelmonConfig.useExternalJSONFilesRules);
            }
            catch (IOException e) {
                RulesRegistry.printError(BATTLE_SPOT_FILE, e);
            }
        }
    }

    private static void registerRulesets() {
        File rulesetDir = new File("./pixelmon/rules/rulesets");
        boolean useExternal = PixelmonConfig.useExternalJSONFilesRules;
        if (useExternal && !rulesetDir.isDirectory()) {
            rulesetDir.mkdir();
        }
    }

    private static void printError(String tierFile, Exception e) {
        Pixelmon.LOGGER.error("Error occurred when reading tier file: " + tierFile + ".");
        e.printStackTrace();
    }

    private static void registerTier(File tierDir, String tierFileName, boolean useExternal) throws IOException {
        RulesRegistry.registerTier(tierDir, null, tierFileName, true, useExternal);
    }

    private static void registerTier(File tierDir, EnumTier tier, boolean useExternal) throws IOException {
        RulesRegistry.registerTier(tierDir, tier, tier.name().toLowerCase() + JSON_EXTENSION, false, useExternal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void registerTier(File tierDir, EnumTier tier, String tierFile, boolean isCustom, boolean useExternal) throws IOException {
        try (InputStream iStream = null;){
            iStream = useExternal ? new FileInputStream(new File(tierDir, tierFile)) : ServerNPCRegistry.class.getResourceAsStream("/assets/pixelmon/rules/tiers/" + tierFile.replace(File.separator, "/"));
            JsonObject json = new JsonParser().parse((Reader)new InputStreamReader(iStream, StandardCharsets.UTF_8)).getAsJsonObject();
            if (isCustom) {
                String id = tierFile;
                int lastPeriod = id.lastIndexOf(46);
                if (lastPeriod > -1) {
                    id = id.substring(0, lastPeriod);
                }
                RulesRegistry.loadCustomTier(id, json);
            } else if (useExternal && !json.get("usecustom").getAsBoolean()) {
                RulesRegistry.registerTier(tierDir, tier, tierFile, isCustom, false);
            } else {
                RulesRegistry.loadDefaultTier(tier, json);
            }
        }
    }

    private static void loadDefaultTier(EnumTier tier, JsonObject json) {
        TierSet tierClause = (TierSet)BattleClauseRegistry.getTierRegistry().getClause(tier.getTierID());
        tierClause.setPokemon(RulesRegistry.getPokemonSet(json));
    }

    private static void loadCustomTier(String id, JsonObject json) {
        TierAllowedSet tier = new TierAllowedSet(id, RulesRegistry.getPokemonSet(json), json.get("banlist").getAsBoolean());
        BattleClauseRegistry.getTierRegistry().registerCustomClause(tier);
    }

    private static Set<PokemonForm> getPokemonSet(JsonObject json) {
        HashSet<PokemonForm> pokemonSet = new HashSet<PokemonForm>();
        JsonArray pokemonJSON = json.get("pokemon").getAsJsonArray();
        for (int i = 0; i < pokemonJSON.size(); ++i) {
            String pokemon = pokemonJSON.get(i).getAsString();
            Optional<PokemonForm> form = PokemonForm.getFromName(pokemon);
            if (form.isPresent()) {
                pokemonSet.add(form.get());
                continue;
            }
            Pixelmon.LOGGER.warn("Pok\u00e9mon not found when registering tier: " + pokemon + ".");
        }
        return pokemonSet;
    }

    private static void extractTierDirs(File tierDir) {
        for (EnumTier tier : EnumTier.values()) {
            if (tier == EnumTier.PU) continue;
            RulesRegistry.extractTierDir(tierDir, tier.name().toLowerCase() + JSON_EXTENSION);
        }
        RulesRegistry.extractTierDir(tierDir, BATTLE_SPOT_FILE);
    }

    private static void extractTierDir(File tierDir, String fileName) {
        ServerNPCRegistry.extractFile("/assets/pixelmon/rules/tiers/" + fileName, tierDir, fileName);
    }
}

