/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.rules.teamselection;

import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.storage.PartyStorage;
import com.pixelmonmod.pixelmon.storage.TrainerPartyStorage;
import java.util.ArrayList;
import java.util.List;

class ParticipantSelection {
    final PartyStorage storage;
    List<Pokemon> team = new ArrayList<Pokemon>();
    final boolean isNPC;
    boolean confirmed;
    String[] disabled = new String[6];

    ParticipantSelection(PartyStorage storage) {
        this.storage = storage;
        this.isNPC = storage instanceof TrainerPartyStorage;
        if (this.isNPC) {
            this.confirmed = true;
        }
    }

    void setTeam(int[] selection) {
        ArrayList<Pokemon> team = new ArrayList<Pokemon>();
        for (int s : selection) {
            if (s <= -1) continue;
            team.add(null);
        }
        for (int i = 0; i < selection.length; ++i) {
            int s = selection[i];
            if (s <= -1) continue;
            Pokemon pokemon = this.storage.get(i);
            if (pokemon == null) {
                return;
            }
            team.set(s, pokemon);
        }
        for (Pokemon pokemon : team) {
            if (pokemon != null) continue;
            return;
        }
        this.team = team;
    }

    void addTeamMember(int index) {
        Pokemon pokemon = this.storage.get(index);
        if (pokemon != null && pokemon.canBattle()) {
            this.team.add(pokemon);
        }
    }

    void removeTeamMember() {
        if (!this.team.isEmpty()) {
            this.team.remove(this.team.size() - 1);
        }
    }
}

