/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.status;

import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.Effectiveness;
import com.pixelmonmod.pixelmon.battles.controller.ai.MoveChoice;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.StatusBase;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.Moveset;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.StatsType;
import com.pixelmonmod.pixelmon.enums.EnumType;
import java.util.ArrayList;
import java.util.List;

public class Foresight
extends StatusBase {
    transient EnumType ignoredType;

    public Foresight() {
        super(StatusType.Foresight);
    }

    public Foresight(EnumType ignoredType) {
        super(StatusType.Foresight);
        this.ignoredType = ignoredType;
    }

    @Override
    public void applyEffect(PixelmonWrapper user, PixelmonWrapper target) {
        if (!target.hasStatus(StatusType.Foresight)) {
            target.bc.sendToAll("pixelmon.status.foresight", target.getNickname());
            EnumType type = this.getIgnoredType(user.attack);
            target.addStatus(new Foresight(type), user);
        } else {
            user.bc.sendToAll("pixelmon.effect.effectfailed", new Object[0]);
        }
    }

    private EnumType getIgnoredType(Attack attack) {
        return attack.isAttack("Miracle Eye") ? EnumType.Dark : EnumType.Ghost;
    }

    @Override
    public List<EnumType> getEffectiveTypes(PixelmonWrapper user, PixelmonWrapper target) {
        if (user.attack != null && EnumType.getEffectiveness(user.attack.getType(), this.ignoredType) == Effectiveness.None.value) {
            return EnumType.ignoreType(target.type, this.ignoredType);
        }
        return target.type;
    }

    @Override
    public void weightEffect(PixelmonWrapper pw, MoveChoice userChoice, ArrayList<MoveChoice> userChoices, ArrayList<MoveChoice> bestUserChoices, ArrayList<MoveChoice> opponentChoices, ArrayList<MoveChoice> bestOpponentChoices) {
        if (userChoice.hitsAlly()) {
            return;
        }
        for (PixelmonWrapper target : userChoice.targets) {
            EnumType ignoredType;
            int evasion = target.getBattleStats().getStage(StatsType.Evasion);
            if (evasion > 0) {
                userChoice.raiseWeight(10 * evasion);
            }
            if (!target.hasType(ignoredType = this.getIgnoredType(userChoice.attack))) continue;
            Moveset moveset = pw.getMoveset();
            if ((ignoredType != EnumType.Ghost || !moveset.hasOffensiveAttackType(EnumType.Normal, EnumType.Fighting)) && (ignoredType != EnumType.Dark || !moveset.hasOffensiveAttackType(EnumType.Psychic))) continue;
            userChoice.raiseWeight(25.0f);
        }
    }
}

