/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.status;

import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.battles.status.Weather;
import com.pixelmonmod.pixelmon.enums.EnumType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class MysteriousAirCurrent
extends Weather {
    public MysteriousAirCurrent() {
        super(StatusType.MysteriousAirCurrent, -1, null, null, null, null, true);
    }

    @Override
    protected Weather getNewInstance(int turns) {
        return new MysteriousAirCurrent();
    }

    @Override
    protected int countBenefits(PixelmonWrapper user, PixelmonWrapper target) {
        return 1;
    }

    @Override
    public List<EnumType> getEffectiveTypes(PixelmonWrapper user, PixelmonWrapper target) {
        if (user.attack != null && Attack.dealsDamage(user.attack) && target.hasType(EnumType.Flying)) {
            if (user.bc.globalStatusController.getGlobalStatus(StatusType.Gravity) != null) {
                return user.bc.globalStatusController.getGlobalStatus(StatusType.Gravity).getEffectiveTypes(user, target);
            }
            EnumType[] enumTypeArray = new EnumType[]{EnumType.Flying};
            float effectiveness = EnumType.getTotalEffectiveness(Arrays.asList(enumTypeArray), user.attack.getType(), user.bc.rules.hasClause("inverse"));
            if (effectiveness >= 2.0f) {
                ArrayList<EnumType> types = new ArrayList<EnumType>(target.type);
                if (types.size() == 1) {
                    return Arrays.asList(EnumType.Normal);
                }
                types.remove(EnumType.Flying);
                return types;
            }
        }
        return target.type;
    }
}

