/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.status;

import com.pixelmonmod.pixelmon.RandomHelper;
import com.pixelmonmod.pixelmon.battles.attacks.AttackBase;
import com.pixelmonmod.pixelmon.battles.attacks.DamageTypeEnum;
import com.pixelmonmod.pixelmon.battles.controller.ai.MoveChoice;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.StatusBase;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.MagicGuard;
import com.pixelmonmod.pixelmon.enums.heldItems.EnumHeldItems;
import java.util.ArrayList;

public class PartialTrap
extends StatusBase {
    public transient AttackBase variant;
    private transient int turnsToGo;
    private transient PixelmonWrapper trapper;

    public PartialTrap() {
        super(StatusType.PartialTrap);
    }

    public PartialTrap(AttackBase variant, PixelmonWrapper trapper) {
        super(StatusType.PartialTrap);
        this.variant = variant;
        this.trapper = trapper;
        this.turnsToGo = trapper.getUsableHeldItem().getHeldItemType() == EnumHeldItems.gripClaw ? 7 : RandomHelper.getRandomNumberBetween(4, 5);
    }

    @Override
    public void applyEffect(PixelmonWrapper user, PixelmonWrapper target) {
        AttackBase variant = user.attack.getMove();
        if (target.addStatus(new PartialTrap(variant, user), user)) {
            if (variant.isAttack("Sand Tomb") || variant.isAttack("G-Max Sandblast")) {
                user.bc.sendToAll("pixelmon.effect.sandtomb", target.getNickname());
            } else if (variant.isAttack("Clamp")) {
                user.bc.sendToAll("pixelmon.effect.clamped", user.getNickname(), target.getNickname());
            } else if (variant.isAttack("Magma Storm")) {
                user.bc.sendToAll("pixelmon.effect.swirlingmagma", target.getNickname());
            } else if (variant.isAttack("Fire Spin") || variant.isAttack("G-Max Centiferno")) {
                user.bc.sendToAll("pixelmon.effect.firevortex", target.getNickname());
            } else if (variant.isAttack("Bind")) {
                user.bc.sendToAll("pixelmon.effect.squeezed", target.getNickname(), user.getNickname());
            } else if (variant.isAttack("Wrap")) {
                user.bc.sendToAll("pixelmon.effect.wrapped", target.getNickname(), user.getNickname());
            } else if (variant.isAttack("Whirlpool")) {
                user.bc.sendToAll("pixelmon.effect.vortex", target.getNickname());
            } else if (variant.isAttack("Snap Trap")) {
                user.bc.sendToAll("pixelmon.effect.snaptrap", target.getNickname());
            }
        }
    }

    @Override
    public boolean stopsSwitching() {
        return true;
    }

    @Override
    public void applyRepeatedEffect(PixelmonWrapper pw) {
        if (!(pw.bc.getActiveUnfaintedPokemon().contains(this.trapper) || this.variant.isAttack("G-Max Sandblast") || this.variant.isAttack("G-Max Centiferno"))) {
            pw.removeStatus(this);
            return;
        }
        if (--this.turnsToGo < 0) {
            pw.removeStatus(this);
            if (this.variant.isAttack("Sand Tomb") || this.variant.isAttack("G-Max Sandblast")) {
                pw.bc.sendToAll("pixelmon.status.freefromsandtomb", pw.getNickname());
            } else if (this.variant.isAttack("Clamp")) {
                pw.bc.sendToAll("pixelmon.status.freefromclamp", pw.getNickname());
            } else if (this.variant.isAttack("Whirlpool")) {
                pw.bc.sendToAll("pixelmon.status.freefromwhirlpool", pw.getNickname());
            } else if (this.variant.isAttack("Wrap")) {
                pw.bc.sendToAll("pixelmon.status.freefromwrap", pw.getNickname());
            } else if (this.variant.isAttack("Bind")) {
                pw.bc.sendToAll("pixelmon.status.freefrombind", pw.getNickname());
            } else if (this.variant.isAttack("Fire Spin") || this.variant.isAttack("G-Max Centiferno")) {
                pw.bc.sendToAll("pixelmon.status.freefromfirespin", pw.getNickname());
            } else if (this.variant.isAttack("Snap Trap")) {
                pw.bc.sendToAll("pixelmon.status.freefromsnaptrap", pw.getNickname());
            }
            return;
        }
        if (pw.getBattleAbility() instanceof MagicGuard) {
            return;
        }
        int fraction = this.trapper.getUsableHeldItem().getHeldItemType() == EnumHeldItems.bindingBand ? 6 : 8;
        pw.doBattleDamage(pw, pw.getPercentMaxHealth(100.0f / (float)fraction), DamageTypeEnum.STATUS);
        pw.bc.sendToAll("pixelmon.status.hurtby", pw.getNickname(), this.variant.getTranslatedName());
    }

    public int getRemainingTurns() {
        return this.turnsToGo;
    }

    @Override
    public void weightEffect(PixelmonWrapper pw, MoveChoice userChoice, ArrayList<MoveChoice> userChoices, ArrayList<MoveChoice> bestUserChoices, ArrayList<MoveChoice> opponentChoices, ArrayList<MoveChoice> bestOpponentChoices) {
        if (userChoice.hitsAlly()) {
            return;
        }
        for (PixelmonWrapper target : userChoice.targets) {
            if (target.getBattleAbility() instanceof MagicGuard) {
                return;
            }
            float weight = 12.5f;
            if (pw.getUsableHeldItem().getHeldItemType() == EnumHeldItems.bindingBand) {
                weight *= 2.0f;
            }
            userChoice.raiseWeight(weight);
        }
    }
}

