/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.status;

import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.Poison;
import com.pixelmonmod.pixelmon.battles.status.StatusBase;
import com.pixelmonmod.pixelmon.battles.status.StatusPersist;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.enums.battle.AttackCategory;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextComponentTranslation;

public class PoisonBadly
extends Poison {
    private transient int poisonSeverity = 1;

    public PoisonBadly() {
        super(StatusType.PoisonBadly);
    }

    @Override
    public void applyEffect(PixelmonWrapper user, PixelmonWrapper target) {
        if (this.checkChance()) {
            PoisonBadly.poisonBadly(user, target, user.attack, true);
        }
    }

    public static boolean poisonBadly(PixelmonWrapper user, PixelmonWrapper target, Attack attack, boolean showMessage) {
        if (PoisonBadly.canPoison(user, target, attack, showMessage)) {
            boolean result;
            TextComponentTranslation message = null;
            if (showMessage) {
                message = ChatHandler.getMessage("pixelmon.effect.badlypoisoned", target.getNickname());
            }
            if (!(result = target.addStatus(new PoisonBadly(), user, message)) && attack != null && attack.getAttackCategory() == AttackCategory.STATUS) {
                user.setAttackFailed();
            }
            return result;
        }
        return false;
    }

    @Override
    public void applyRepeatedEffect(PixelmonWrapper pw) {
        super.applyRepeatedEffect(pw);
        if (!pw.isRaidPokemon()) {
            ++this.poisonSeverity;
        }
    }

    @Override
    protected float getPoisonDamage(PixelmonWrapper pw) {
        return pw.getPercentMaxHealth((float)this.poisonSeverity * 100.0f / 16.0f);
    }

    @Override
    public void applySwitchOutEffect(PixelmonWrapper outgoing, PixelmonWrapper incoming) {
        this.poisonSeverity = 1;
    }

    @Override
    public void applyEndOfBattleEffect(PixelmonWrapper pokemon) {
        int index = pokemon.getStatusIndex(StatusType.PoisonBadly);
        if (index >= 0) {
            pokemon.setStatus(index, new Poison());
        }
    }

    @Override
    public StatusPersist restoreFromNBT(NBTTagCompound nbt) {
        return new PoisonBadly();
    }

    @Override
    public StatusBase copy() {
        return new PoisonBadly();
    }
}

