/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.status;

import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.EntryHazard;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.battles.status.Terrain;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.Prankster;
import com.pixelmonmod.pixelmon.enums.EnumType;
import com.pixelmonmod.pixelmon.enums.battle.AttackCategory;
import com.pixelmonmod.pixelmon.enums.battle.EnumTerrain;
import javax.annotation.Nonnull;

public class PsychicTerrain
extends Terrain {
    public PsychicTerrain() {
        super(StatusType.PsychicTerrain, "pixelmon.status.psychicterrain", "pixelmon.status.psychicterrainend");
    }

    @Override
    public Terrain getNewInstance() {
        return new PsychicTerrain();
    }

    @Override
    @Nonnull
    public EnumTerrain getTerrainType() {
        return EnumTerrain.PSYCHIC;
    }

    @Override
    public EnumType getTypingForTerrain() {
        return EnumType.Psychic;
    }

    @Override
    public boolean stopsIncomingAttack(PixelmonWrapper pokemon, PixelmonWrapper user) {
        if (this.affectsPokemon(pokemon) && Math.round(user.priority) > 0) {
            if (user.attack.isAttack("Perish Song", "Flower Shield", "Rototiller")) {
                return false;
            }
            if (user.attack.getMove().getTargetingInfo().hitsAll || user.attack.isAttack(EntryHazard.ENTRY_HAZARDS)) {
                return false;
            }
            boolean targetsOwnTeam = true;
            for (PixelmonWrapper target : user.targets) {
                if (!user.isOpponent(target)) continue;
                targetsOwnTeam = false;
            }
            if (targetsOwnTeam) {
                return false;
            }
            user.bc.sendToAll("pixelmon.battletext.movefailed", new Object[0]);
            return true;
        }
        return false;
    }

    @Override
    public int[] modifyPowerAndAccuracyTarget(int power, int accuracy, PixelmonWrapper user, PixelmonWrapper target, Attack a) {
        if (this.affectsPokemon(user) && a.getType() == EnumType.Psychic) {
            power = (int)((double)power * 1.3);
        }
        return new int[]{power, accuracy};
    }

    @Override
    protected int countBenefits(PixelmonWrapper user, PixelmonWrapper target) {
        int benefits = 0;
        if (this.affectsPokemon(user)) {
            if (Attack.hasOffensiveAttackType(user.getMoveset(), EnumType.Psychic)) {
                ++benefits;
            }
            for (Attack a : target.getMoveset()) {
                if (a == null || a.getMove().getPriority(target) <= 0 && (a.getAttackCategory() != AttackCategory.STATUS || !(target.getAbility() instanceof Prankster))) continue;
                ++benefits;
            }
        }
        if (this.affectsPokemon(target)) {
            for (Attack a : user.getMoveset()) {
                if (a == null || a.getMove().getPriority(user) <= 0 && (a.getAttackCategory() != AttackCategory.STATUS || !(user.getAbility() instanceof Prankster))) continue;
                --benefits;
            }
        }
        return benefits;
    }
}

