/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.status;

import com.pixelmonmod.pixelmon.battles.attacks.AttackBase;
import com.pixelmonmod.pixelmon.battles.attacks.DamageTypeEnum;
import com.pixelmonmod.pixelmon.battles.controller.GlobalStatusController;
import com.pixelmonmod.pixelmon.battles.controller.ai.MoveChoice;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.GlobalStatusBase;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.MagicGuard;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;

public class RepeatDamage
extends GlobalStatusBase {
    public transient AttackBase variant;
    private transient int turnsToGo;
    private transient PixelmonWrapper cause;
    private transient int targetLocation;

    public RepeatDamage() {
        super(StatusType.GMaxRepeatDamage);
    }

    public RepeatDamage(AttackBase variant, PixelmonWrapper cause, int targetLocation) {
        super(StatusType.GMaxRepeatDamage);
        this.variant = variant;
        this.cause = cause;
        this.turnsToGo = 4;
        this.targetLocation = targetLocation;
    }

    @Override
    public void applyEffect(PixelmonWrapper user, PixelmonWrapper target) {
        AttackBase variant = user.attack.getMove();
        ArrayList<PixelmonWrapper> targets = user.bc.getAdjacentPokemonAndSelf(target);
        for (PixelmonWrapper pw : targets) {
            if (pw.isSameTeam(user)) continue;
            user.bc.globalStatusController.addGlobalStatus(new RepeatDamage(variant, user, pw.bc.getPositionOfPokemon(pw)));
        }
        if (variant.isAttack("G-Max Wildfire")) {
            user.bc.sendToPlayer((EntityPlayer)user.getPlayerOwner(), "pixelmon.effect.wildfire.user", new Object[0]);
            user.bc.sendToPlayer((EntityPlayer)target.getPlayerOwner(), "pixelmon.effect.wildfire.target", new Object[0]);
        } else if (variant.isAttack("G-Max Vine Lash")) {
            user.bc.sendToPlayer((EntityPlayer)user.getPlayerOwner(), "pixelmon.effect.vinelash.user", new Object[0]);
            user.bc.sendToPlayer((EntityPlayer)target.getPlayerOwner(), "pixelmon.effect.vinelash.target", new Object[0]);
        } else if (variant.isAttack("G-Max Cannonade")) {
            user.bc.sendToPlayer((EntityPlayer)user.getPlayerOwner(), "pixelmon.effect.cannonade.user", new Object[0]);
            user.bc.sendToPlayer((EntityPlayer)target.getPlayerOwner(), "pixelmon.effect.cannonade.target", new Object[0]);
        } else if (variant.isAttack("G-Max Volcalith")) {
            user.bc.sendToPlayer((EntityPlayer)user.getPlayerOwner(), "pixelmon.effect.volcalith.user", new Object[0]);
            user.bc.sendToPlayer((EntityPlayer)target.getPlayerOwner(), "pixelmon.effect.volcalith.target", new Object[0]);
        }
    }

    @Override
    public void applyRepeatedEffect(GlobalStatusController gsc) {
        if (--this.turnsToGo < 0) {
            gsc.removeGlobalStatus(this);
            return;
        }
        PixelmonWrapper pw = gsc.bc.getPokemonAtPosition(this.targetLocation);
        if (pw == null || pw.getBattleAbility() instanceof MagicGuard || pw.type.contains(this.variant.getAttackType()) || pw.isFainted()) {
            return;
        }
        pw.doBattleDamage(pw, pw.getPercentMaxHealth(16.666666f), DamageTypeEnum.STATUS);
        if (this.variant.isAttack("G-Max Wildfire")) {
            pw.bc.sendToAll("pixelmon.status.wildfire", pw.getNickname());
        } else if (this.variant.isAttack("G-Max Vine Lash")) {
            pw.bc.sendToAll("pixelmon.status.vinelash", pw.getNickname());
        } else if (this.variant.isAttack("G-Max Cannonade")) {
            pw.bc.sendToAll("pixelmon.status.cannonade", pw.getNickname());
        } else if (this.variant.isAttack("G-Max Volcalith")) {
            pw.bc.sendToAll("pixelmon.status.volcalith", pw.getNickname());
        }
    }

    public int getRemainingTurns() {
        return this.turnsToGo;
    }

    @Override
    public void weightEffect(PixelmonWrapper pw, MoveChoice userChoice, ArrayList<MoveChoice> userChoices, ArrayList<MoveChoice> bestUserChoices, ArrayList<MoveChoice> opponentChoices, ArrayList<MoveChoice> bestOpponentChoices) {
        if (userChoice.hitsAlly()) {
            return;
        }
        for (PixelmonWrapper target : userChoice.targets) {
            float weight = 15.0f;
            if (target.getBattleAbility() instanceof MagicGuard) {
                weight = 8.0f;
            }
            userChoice.raiseWeight(weight);
        }
    }
}

