/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.status;

import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.EntryHazard;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.MagicGuard;
import com.pixelmonmod.pixelmon.enums.EnumType;

public class Steelsurge
extends EntryHazard {
    public Steelsurge() {
        super(StatusType.Steelsurge, 1);
    }

    @Override
    public boolean isTeamStatus() {
        return true;
    }

    @Override
    public boolean isUnharmed(PixelmonWrapper pw) {
        return super.isUnharmed(pw) || pw.getBattleAbility() instanceof MagicGuard;
    }

    @Override
    public int getDamage(PixelmonWrapper pw) {
        float effectiveness = EnumType.getTotalEffectiveness(pw.type, EnumType.Steel, pw.bc.rules.hasClause("inverse"));
        float modifier = effectiveness * 12.5f;
        int damage = pw.getPercentMaxHealth(modifier);
        return damage;
    }

    @Override
    protected String getFirstLayerMessage() {
        return "pixelmon.effect.sharpsteel";
    }

    @Override
    protected String getAffectedMessage() {
        return "pixelmon.status.hurtbysharpsteel";
    }

    @Override
    public int getAIWeight() {
        return 30;
    }

    @Override
    public EntryHazard getNewInstance() {
        return new Steelsurge();
    }
}

