/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.tasks;

import com.pixelmonmod.pixelmon.battles.tasks.IBattleTask;
import com.pixelmonmod.pixelmon.client.ClientProxy;
import com.pixelmonmod.pixelmon.client.gui.battles.ClientBattleManager;
import com.pixelmonmod.pixelmon.client.gui.battles.PixelmonInGui;
import com.pixelmonmod.pixelmon.util.helpers.UUIDHelper;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import javax.annotation.Nullable;

public class HPIncreaseTask
implements IBattleTask {
    public UUID pokemonUUID;
    public int level;
    public int currentHP;
    public int maxHP;

    @Deprecated
    public HPIncreaseTask() {
    }

    public HPIncreaseTask(UUID pokemonUUID, int level, int currentHP, int maxHP) {
        this.pokemonUUID = pokemonUUID;
        this.level = level;
        this.currentHP = currentHP;
        this.maxHP = maxHP;
    }

    @Override
    public boolean process(ClientBattleManager bm) {
        for (PixelmonInGui pixelmonInGui : ClientProxy.battleManager.displayedOurPokemon) {
            this.updatePokemon(pixelmonInGui, this);
        }
        for (PixelmonInGui pixelmonInGui : ClientProxy.battleManager.displayedEnemyPokemon) {
            this.updatePokemon(pixelmonInGui, this);
        }
        for (PixelmonInGui pokemon : ClientProxy.battleManager.fullOurPokemon) {
            this.updatePokemon(pokemon, this);
        }
        if (ClientProxy.battleManager.displayedAllyPokemon != null) {
            for (PixelmonInGui pixelmonInGui : ClientProxy.battleManager.displayedAllyPokemon) {
                this.updatePokemon(pixelmonInGui, this);
            }
        }
        return false;
    }

    private void updatePokemon(PixelmonInGui pokemon, HPIncreaseTask message) {
        if (pokemon != null && pokemon.pokemonUUID.equals(message.pokemonUUID)) {
            pokemon.level = message.level;
            pokemon.health = message.currentHP;
            pokemon.maxHealth = message.maxHP;
        }
    }

    @Override
    @Nullable
    public UUID getPokemonID() {
        return this.pokemonUUID;
    }

    public void fromBytes(ByteBuf buf) {
        this.pokemonUUID = UUIDHelper.readUUID(buf);
        this.level = buf.readInt();
        this.currentHP = buf.readInt();
        this.maxHP = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        UUIDHelper.writeUUID(this.pokemonUUID, buf);
        buf.writeInt(this.level);
        buf.writeInt(this.currentHP);
        buf.writeInt(this.maxHP);
    }
}

