/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.tasks;

import com.pixelmonmod.pixelmon.battles.tasks.IBattleTask;
import com.pixelmonmod.pixelmon.client.ClientProxy;
import com.pixelmonmod.pixelmon.client.SoundHelper;
import com.pixelmonmod.pixelmon.client.gui.battles.ClientBattleManager;
import com.pixelmonmod.pixelmon.client.gui.battles.PixelmonInGui;
import com.pixelmonmod.pixelmon.util.helpers.UUIDHelper;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.init.SoundEvents;

public class RaidShieldsTask
implements IBattleTask {
    public UUID pokemonUUID;
    public int shields;
    public int maxShields;

    @Deprecated
    public RaidShieldsTask() {
    }

    public RaidShieldsTask(UUID pokemonUUID, int shields, int maxShields) {
        this.pokemonUUID = pokemonUUID;
        this.shields = shields;
        this.maxShields = maxShields;
    }

    @Override
    public boolean process(ClientBattleManager bm) {
        for (PixelmonInGui pixelmonInGui : ClientProxy.battleManager.displayedOurPokemon) {
            this.updatePokemon(pixelmonInGui, this);
        }
        for (PixelmonInGui pixelmonInGui : ClientProxy.battleManager.displayedEnemyPokemon) {
            this.updatePokemon(pixelmonInGui, this);
        }
        for (PixelmonInGui pokemon : ClientProxy.battleManager.fullOurPokemon) {
            this.updatePokemon(pokemon, this);
        }
        if (ClientProxy.battleManager.displayedAllyPokemon != null) {
            for (PixelmonInGui pixelmonInGui : ClientProxy.battleManager.displayedAllyPokemon) {
                this.updatePokemon(pixelmonInGui, this);
            }
        }
        return false;
    }

    private void updatePokemon(PixelmonInGui pokemon, RaidShieldsTask message) {
        if (pokemon != null && pokemon.pokemonUUID.equals(message.pokemonUUID)) {
            int currentShields = pokemon.shields;
            pokemon.shields = message.shields;
            pokemon.maxShields = message.maxShields;
            if (currentShields > pokemon.shields) {
                pokemon.lostShield = true;
            }
            if (currentShields == 0 && pokemon.shields > 0) {
                SoundHelper.playSound(SoundEvents.field_187716_o, 1.0f, 1.0f);
            }
        }
    }

    @Override
    @Nullable
    public UUID getPokemonID() {
        return this.pokemonUUID;
    }

    public void fromBytes(ByteBuf buf) {
        this.pokemonUUID = UUIDHelper.readUUID(buf);
        this.shields = buf.readInt();
        this.maxShields = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        UUIDHelper.writeUUID(this.pokemonUUID, buf);
        buf.writeInt(this.shields);
        buf.writeInt(this.maxShields);
    }
}

