/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.events.BerryEvent;
import com.pixelmonmod.pixelmon.blocks.BlockProperties;
import com.pixelmonmod.pixelmon.blocks.GenericRotatableModelBlock;
import com.pixelmonmod.pixelmon.blocks.enums.EnumBlockPos;
import com.pixelmonmod.pixelmon.blocks.tileEntities.TileEntityBerryTree;
import com.pixelmonmod.pixelmon.enums.EnumBerry;
import com.pixelmonmod.pixelmon.util.helpers.BlockHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.common.eventhandler.Event;

public class BlockBerryTree
extends GenericRotatableModelBlock
implements IGrowable,
IPlantable {
    public static final PropertyEnum<EnumBlockPos> BLOCKPOS = PropertyEnum.func_177709_a((String)"blockpos", EnumBlockPos.class);
    private static final AxisAlignedBB SeedStage = new AxisAlignedBB((double)0.4f, 0.0, (double)0.4f, (double)0.6f, (double)0.2f, (double)0.6f);
    private final byte ordinal;

    public BlockBerryTree(EnumBerry type) {
        super(Material.field_151585_k);
        this.ordinal = (byte)type.ordinal();
        this.func_149672_a(SoundType.field_185850_c);
        this.field_149787_q = false;
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess access, BlockPos pos) {
        return this.getBlockBounds(access, pos, blockState);
    }

    public AxisAlignedBB func_180640_a(IBlockState state, World worldIn, BlockPos pos) {
        return this.getBlockBounds((IBlockAccess)worldIn, pos, state).func_186670_a(pos);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return this.getBlockBounds(worldIn, pos, state);
    }

    protected AxisAlignedBB getBlockBounds(IBlockAccess world, BlockPos pos, IBlockState state) {
        TileEntityBerryTree tile = BlockHelper.getTileEntity(TileEntityBerryTree.class, world, pos);
        if (tile != null) {
            double mul = tile.getStage() == 3 ? 0.75 : 1.0;
            double height = (double)tile.getType().height * mul;
            double width = (double)tile.getType().width * mul;
            if (tile.getStage() < 3) {
                return SeedStage;
            }
            if (tile.getStage() == 3) {
                return new AxisAlignedBB(0.5 - width / 2.0, 0.0, 0.5 - width / 2.0, 0.5 + width / 2.0, height, 0.5 + width / 2.0);
            }
            return new AxisAlignedBB(0.5 - width / 2.0, 0.0, 0.5 - width / 2.0, 0.5 + width / 2.0, height, 0.5 + width / 2.0);
        }
        return Block.field_185505_j;
    }

    public Material func_149688_o(IBlockState state) {
        return Material.field_151585_k;
    }

    public float func_176195_g(IBlockState state, World world, BlockPos pos) {
        TileEntityBerryTree tile;
        if (state.func_177229_b(BLOCKPOS) == EnumBlockPos.TOP) {
            pos = pos.func_177977_b();
        }
        if ((tile = BlockHelper.getTileEntity(TileEntityBerryTree.class, (IBlockAccess)world, pos)) != null && tile.getStage() < 2) {
            return 1.0f;
        }
        return 2.0f;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack(this.getType().getBerry());
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        TileEntityBerryTree tile = BlockHelper.getTileEntity(TileEntityBerryTree.class, world, pos);
        if (tile == null) {
            return drops;
        }
        byte stage = tile.getStage();
        if (stage > 1 && stage < 5) {
            return drops;
        }
        if (world instanceof World) {
            ItemStack stack = new ItemStack(tile.getType().getBerry());
            stack.func_190920_e((int)(stage == 1 ? (short)1 : tile.getProjectedYield()));
            drops.add(stack);
        }
        return drops;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        if (state.func_177229_b(BLOCKPOS) == EnumBlockPos.BOTTOM) {
            return new TileEntityBerryTree(this.ordinal);
        }
        return null;
    }

    @Override
    public TileEntity func_149915_a(World worldIn, int meta) {
        return null;
    }

    public EnumBerry getType() {
        return EnumBerry.values()[this.ordinal];
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntityBerryTree tile;
        if (world.field_72995_K) {
            return true;
        }
        if (state.func_177229_b(BLOCKPOS) == EnumBlockPos.TOP) {
            pos = pos.func_177977_b();
        }
        if ((tile = BlockHelper.getTileEntity(TileEntityBerryTree.class, (IBlockAccess)world, pos)) == null) {
            return false;
        }
        if (EnumBerry.values()[this.ordinal].getBerry() != null && tile.getStage() == 5) {
            BerryEvent.PickBerry pick = new BerryEvent.PickBerry(this.getType(), pos, (EntityPlayerMP)player, tile, new ItemStack(this.getType().getBerry(), (int)tile.getProjectedYield()));
            if (!Pixelmon.EVENT_BUS.post((Event)pick)) {
                Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)pick.getPickedStack());
                tile.setStage((byte)-1);
            }
            return true;
        }
        return false;
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{BlockProperties.FACING, BLOCKPOS});
    }

    @Override
    public int func_176201_c(IBlockState state) {
        int b0 = 0;
        int i = b0 | ((EnumFacing)state.func_177229_b((IProperty)BlockProperties.FACING)).func_176736_b();
        return i |= ((EnumBlockPos)((Object)state.func_177229_b(BLOCKPOS))).toMeta() << 2;
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)BlockProperties.FACING, (Comparable)EnumFacing.func_176731_b((int)(meta & 3))).func_177226_a(BLOCKPOS, (Comparable)((Object)EnumBlockPos.fromMeta((meta & 0xF) >> 2)));
    }

    @Override
    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        worldIn.func_180501_a(pos, state.func_177226_a((IProperty)BlockProperties.FACING, (Comparable)placer.func_174811_aO().func_176734_d()), 2);
        if (placer instanceof EntityPlayer) {
            ItemBlock.func_179224_a((World)worldIn, (EntityPlayer)((EntityPlayer)placer), (BlockPos)pos, (ItemStack)stack);
        }
    }

    public boolean func_176473_a(World world, BlockPos pos, IBlockState state, boolean isClient) {
        TileEntityBerryTree tile;
        EnumBlockPos blockpos = (EnumBlockPos)((Object)state.func_177229_b(BLOCKPOS));
        BlockPos loc = pos;
        if (blockpos == EnumBlockPos.TOP) {
            loc = pos.func_177977_b();
        }
        return (tile = BlockHelper.getTileEntity(TileEntityBerryTree.class, (IBlockAccess)world, loc)) != null && !tile.isGrowthBoosted() && tile.getStage() != 5;
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        return this.func_176473_a(worldIn, pos, state, worldIn.field_72995_K);
    }

    public void func_176474_b(World world, Random rand, BlockPos pos, IBlockState state) {
        TileEntityBerryTree tile;
        EnumBlockPos blockpos = (EnumBlockPos)((Object)state.func_177229_b(BLOCKPOS));
        BlockPos loc = pos;
        if (blockpos == EnumBlockPos.TOP) {
            loc = pos.func_177977_b();
        }
        if ((tile = BlockHelper.getTileEntity(TileEntityBerryTree.class, (IBlockAccess)world, loc)) != null) {
            tile.boostGrowth();
        }
    }

    public void growStage(World world, Random rand, BlockPos pos, IBlockState state) {
        TileEntityBerryTree tile;
        EnumBlockPos blockpos = (EnumBlockPos)((Object)state.func_177229_b(BLOCKPOS));
        if (blockpos == EnumBlockPos.TOP) {
            pos = pos.func_177977_b();
        }
        if ((tile = BlockHelper.getTileEntity(TileEntityBerryTree.class, (IBlockAccess)world, pos)) == null) {
            return;
        }
        int stage = tile.getStage();
        if (stage < 5) {
            tile.setStage((byte)(++stage));
            if (stage == 5) {
                Pixelmon.EVENT_BUS.post((Event)new BerryEvent.BerryReady(this.getType(), pos, tile));
            }
            ((WorldServer)world).func_184164_w().func_180244_a(pos);
        }
    }

    public void replant(World worldIn, BlockPos pos, IBlockState state) {
        TileEntityBerryTree tile;
        EnumBlockPos blockpos = (EnumBlockPos)((Object)state.func_177229_b(BLOCKPOS));
        if (blockpos == EnumBlockPos.TOP) {
            pos = pos.func_177977_b();
        }
        if ((tile = BlockHelper.getTileEntity(TileEntityBerryTree.class, (IBlockAccess)worldIn, pos)) == null) {
            return;
        }
        tile.setStage((byte)1);
        ((WorldServer)worldIn).func_184164_w().func_180244_a(pos);
    }

    public boolean canBlockStay(World worldIn, BlockPos pos, IBlockState state) {
        Material material;
        BlockPos down = pos.func_177977_b();
        IBlockState soil = worldIn.func_180495_p(down);
        if (soil.func_177230_c() == this) {
            soil = worldIn.func_180495_p(down.func_177977_b());
        }
        if ((material = soil.func_185904_a()) == Material.field_151577_b || material == Material.field_151578_c) {
            return true;
        }
        return soil.func_177230_c() == Blocks.field_150349_c || soil.func_177230_c() == Blocks.field_150346_d || soil.func_177230_c() == Blocks.field_150458_ak;
    }

    protected void checkAndDropBlock(World worldIn, BlockPos pos, IBlockState state) {
        if (!this.canBlockStay(worldIn, pos, state)) {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
        }
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        EnumBlockPos multiPos = (EnumBlockPos)((Object)state.func_177229_b(BLOCKPOS));
        if (player.func_184812_l_()) {
            return super.removedByPlayer(state, world, pos, player, willHarvest);
        }
        if (multiPos == EnumBlockPos.TOP) {
            pos = pos.func_177977_b();
        }
        this.func_176226_b(world, pos, state, 0);
        if (world.func_180495_p(pos).func_177230_c() != this) {
            world.func_180501_a(pos.func_177984_a(), Blocks.field_150350_a.func_176223_P(), 3);
            return super.removedByPlayer(state, world, pos, player, willHarvest);
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public EnumPlantType getPlantType(IBlockAccess world, BlockPos pos) {
        return EnumPlantType.Plains;
    }

    public IBlockState getPlant(IBlockAccess world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() != this) {
            return this.func_176223_P();
        }
        return state;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        this.checkAndDropBlock(worldIn, pos, state);
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        this.checkAndDropBlock(worldIn, pos, state);
    }

    @Override
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }
}

