/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.enums.ReceiveType;
import com.pixelmonmod.pixelmon.api.events.PixelmonReceivedEvent;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.trading.NPCTrades;
import com.pixelmonmod.pixelmon.blocks.BlockProperties;
import com.pixelmonmod.pixelmon.blocks.IBlockHasOwner;
import com.pixelmonmod.pixelmon.blocks.enums.EnumPokechestVisibility;
import com.pixelmonmod.pixelmon.blocks.tileEntities.EnumPokegiftType;
import com.pixelmonmod.pixelmon.blocks.tileEntities.TileEntityPokegift;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.config.PixelmonBlocks;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.entities.pixelmon.drops.DropItemHelper;
import com.pixelmonmod.pixelmon.sounds.PixelSounds;
import com.pixelmonmod.pixelmon.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.util.helpers.BlockHelper;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class BlockPokegift
extends BlockContainer
implements IBlockHasOwner {
    private static final AxisAlignedBB AABB = new AxisAlignedBB((double)0.29f, 0.0, (double)0.29f, (double)0.72f, (double)0.44f, (double)0.72f);
    protected String itemName = "item.pokeGift.name";
    protected double xVel = 0.1;
    protected double yVel = 0.2;
    protected double zVel = 0.1;
    protected EnumPokegiftType TYPE = EnumPokegiftType.GIFT;

    public BlockPokegift() {
        super(Material.field_151592_s);
        this.func_149711_c(0.5f);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{BlockProperties.FACING});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)BlockProperties.FACING, (Comparable)EnumFacing.func_176731_b((int)meta));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)BlockProperties.FACING)).func_176736_b();
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (worldIn.field_72995_K || hand == EnumHand.OFF_HAND) {
            return true;
        }
        TileEntityPokegift tile = BlockHelper.getTileEntity(TileEntityPokegift.class, (IBlockAccess)worldIn, pos);
        if (tile != null) {
            if (!Objects.equals(playerIn.func_110124_au(), tile.getOwner())) {
                if (tile.canClaim(playerIn.func_110124_au())) {
                    if (tile.shouldBreakBlock()) {
                        if (MinecraftForge.EVENT_BUS.post((Event)new BlockEvent.BreakEvent(worldIn, pos, state, playerIn))) {
                            return true;
                        }
                        worldIn.func_175698_g(pos);
                        if (worldIn.func_180495_p(pos).func_177230_c() == this) {
                            return true;
                        }
                    }
                    if (tile.getPokemon() == null) {
                        ChatHandler.sendChat((Entity)playerIn, "pixelutilities.blocks.emptygift", new TextComponentTranslation(this.itemName, new Object[0]));
                        worldIn.func_184148_a(null, playerIn.field_70165_t, playerIn.field_70163_u, playerIn.field_70161_v, SoundEvents.field_187576_at, SoundCategory.BLOCKS, 0.8f, 1.0f);
                        return true;
                    }
                    if (NPCTrades.UNTRADEABLE.matches(tile.getPokemon())) {
                        ChatHandler.sendChat((Entity)playerIn, "pixelutilities.blocks.untradablegift", new Object[0]);
                        return true;
                    }
                    ChatHandler.sendChat((Entity)playerIn, "pixelmon.blocks.chestfound", new TextComponentTranslation(this.itemName, new Object[0]));
                    PlayerPartyStorage party = Pixelmon.storageManager.getParty((EntityPlayerMP)playerIn);
                    Pixelmon.EVENT_BUS.post((Event)new PixelmonReceivedEvent((EntityPlayerMP)playerIn, ReceiveType.PokeBall, tile.getPokemon()));
                    Pokemon pokemon = tile.getPokemon();
                    pokemon.setUUID(UUID.randomUUID());
                    party.add(pokemon);
                    tile.addClaimer(playerIn.func_110124_au());
                    worldIn.func_184148_a(null, playerIn.field_70165_t, playerIn.field_70163_u, playerIn.field_70161_v, PixelSounds.pokelootObtained, SoundCategory.BLOCKS, 0.2f, 1.0f);
                } else {
                    ChatHandler.sendChat((Entity)playerIn, "pixelmon.blocks.claimedloot", new Object[0]);
                }
            } else {
                if (playerIn.func_70093_af()) {
                    if (tile.getPokemon() != null && playerIn.func_184812_l_()) {
                        tile.setOwner(null);
                        ChatHandler.sendChat((Entity)playerIn, "pixelmon.blocks.ownerchanged", new Object[0]);
                        return true;
                    }
                    if (playerIn.func_184812_l_()) {
                        ChatHandler.sendChat((Entity)playerIn, "pixelmon.blocks.fillmefirst", new Object[0]);
                    }
                    return false;
                }
                EntityPlayerMP playerMP = (EntityPlayerMP)playerIn;
                Pokemon pokemon = tile.getPokemon();
                if (pokemon != null) {
                    if (playerIn.func_184812_l_()) {
                        String mode = "";
                        if (tile.getChestMode() && tile.getDropMode()) {
                            tile.setChestOneTime(false);
                            tile.setDropOneTime(true);
                            mode = "pixelmon.blocks.chestmodePL1D";
                        } else {
                            tile.setDropOneTime(true);
                            tile.setChestOneTime(true);
                            mode = "pixelmon.blocks.chestmodeFCFS";
                        }
                        ChatHandler.sendChat((Entity)playerIn, "pixelmon.blocks.chestmode", new TextComponentTranslation(mode, new Object[0]));
                    } else {
                        ChatHandler.sendChat((Entity)playerIn, "pixelmon.blocks.alreadyfilled", new Object[0]);
                    }
                } else {
                    PlayerPartyStorage party = Pixelmon.storageManager.getParty(playerMP);
                    if (party.countPokemon() <= 1) {
                        ChatHandler.sendChat((Entity)playerMP, "pixelmon.blocks.lastpoke", new Object[0]);
                        return false;
                    }
                    Pokemon firstPokeinWorld = null;
                    for (int i = 0; i < 6; ++i) {
                        Pokemon partypoke = party.get(i);
                        if (partypoke == null || partypoke.getPixelmonIfExists() == null) continue;
                        firstPokeinWorld = partypoke;
                        break;
                    }
                    if (firstPokeinWorld == null) {
                        ChatHandler.sendChat((Entity)playerIn, "pixelmon.blocks.nothingtoadd", new Object[0]);
                        return false;
                    }
                    firstPokeinWorld.ifEntityExists(EntityPixelmon::retrieve);
                    int position = party.getPosition((Pokemon)firstPokeinWorld).order;
                    party.set(position, null);
                    firstPokeinWorld.setStorage(null, null);
                    tile.setPokemon(firstPokeinWorld);
                }
            }
        }
        return true;
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase player) {
        int i = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        EnumFacing enumfacing = EnumFacing.func_176731_b((int)i);
        return this.func_176223_P().func_177226_a((IProperty)BlockProperties.FACING, (Comparable)enumfacing);
    }

    public float func_180647_a(IBlockState state, EntityPlayer player, World worldIn, BlockPos pos) {
        TileEntityPokegift tile = BlockHelper.getTileEntity(TileEntityPokegift.class, (IBlockAccess)worldIn, pos);
        if (tile.getOwner() == null || Objects.equals(tile.getOwner(), player.func_110124_au())) {
            return super.func_180647_a(state, player, worldIn, pos);
        }
        return -1.0f;
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (!world.field_72995_K) {
            TileEntityPokegift tile = BlockHelper.getTileEntity(TileEntityPokegift.class, (IBlockAccess)world, pos);
            Pokemon pokemon = tile.getPokemon();
            if (pokemon != null) {
                PlayerPartyStorage storage = Pixelmon.storageManager.getParty(tile.getOwner());
                pokemon.setUUID(UUID.randomUUID());
                storage.add(pokemon);
            } else {
                DropItemHelper.giveItemStack((EntityPlayerMP)player, new ItemStack(PixelmonBlocks.pokegiftBlock), false);
            }
            return super.removedByPlayer(state, world, pos, player, willHarvest);
        }
        return false;
    }

    public TileEntity func_149915_a(World par1World, int var1) {
        return new TileEntityPokegift();
    }

    public void func_180655_c(IBlockState stateIn, World world, BlockPos pos, Random random) {
        TileEntityPokegift tile = BlockHelper.getTileEntity(TileEntityPokegift.class, (IBlockAccess)world, pos);
        if (tile.getVisibility() == EnumPokechestVisibility.Hidden) {
            float rand = random.nextFloat() * 0.5f + 1.0f;
            world.func_175688_a(EnumParticleTypes.SPELL_INSTANT, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, this.xVel * (double)rand, this.yVel * (double)rand, this.zVel * (double)rand, new int[0]);
        }
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess access, BlockPos pos) {
        return AABB;
    }

    public AxisAlignedBB func_180640_a(IBlockState state, World worldIn, BlockPos pos) {
        return AABB;
    }

    @Override
    public void setOwner(BlockPos pos, EntityPlayer playerIn) {
        UUID playerID = playerIn.func_110124_au();
        TileEntityPokegift tile = BlockHelper.getTileEntity(TileEntityPokegift.class, (IBlockAccess)playerIn.field_70170_p, pos);
        tile.setOwner(playerID);
        if (PixelmonConfig.pokegiftMany) {
            tile.setChestOneTime(false);
        }
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return null;
    }
}

