/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks.tileEntities;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.RandomHelper;
import com.pixelmonmod.pixelmon.api.events.BreedEvent;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.storage.PCStorage;
import com.pixelmonmod.pixelmon.api.storage.StoragePosition;
import com.pixelmonmod.pixelmon.blocks.IPokemonOwner;
import com.pixelmonmod.pixelmon.blocks.ranch.BreedingConditions;
import com.pixelmonmod.pixelmon.blocks.ranch.RanchBounds;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.comm.packetHandlers.OpenScreen;
import com.pixelmonmod.pixelmon.comm.packetHandlers.clientStorage.newStorage.pc.ClientChangeOpenPC;
import com.pixelmonmod.pixelmon.comm.packetHandlers.ranch.EnumRanchClientPacketMode;
import com.pixelmonmod.pixelmon.comm.packetHandlers.ranch.RanchBlockClientPacket;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityBreeding;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.enums.EnumBreedingStrength;
import com.pixelmonmod.pixelmon.enums.EnumGuiScreen;
import com.pixelmonmod.pixelmon.enums.EnumSpecies;
import com.pixelmonmod.pixelmon.items.EnumCheatItemType;
import com.pixelmonmod.pixelmon.items.ItemIsisHourglass;
import com.pixelmonmod.pixelmon.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.util.Bounds;
import com.pixelmonmod.pixelmon.util.helpers.BreedLogic;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityRanchBlock
extends TileEntity
implements IPokemonOwner,
ITickable {
    private static final int REFRESH_RATE = 100;
    private static final int UPDATE_BREEDING_RATE = 400;
    protected static final int ranchWidth = 4;
    protected static final int ranchLength = 4;
    protected List<RanchPoke> pokemon = Lists.newArrayList();
    protected BiMap<RanchPoke, EntityBreeding> entityMap = HashBiMap.create((int)2);
    protected RanchBounds ranchBounds = new RanchBounds(this);
    int tick = 0;
    private UUID ownerUUID = null;
    private Pokemon egg = null;
    public boolean aboveGround = false;
    public int percentAbove = 0;
    private EnumSpecies species = null;

    public void func_73660_a() {
        ++this.tick;
        if (!this.field_145850_b.field_72995_K) {
            if (this.tick % 100 == 0 && this.isRanchOwnerInGame()) {
                EntityPlayerMP player = (EntityPlayerMP)this.field_145850_b.func_152378_a(this.ownerUUID);
                this.trySpawnPokes(player);
            }
            if (this.tick % 400 == 0 && this.isRanchOwnerInGame() && this.entityMap.size() == 2 && BreedLogic.canBreed(((EntityBreeding)this.entityMap.get((Object)this.pokemon.get(0))).getPokemonData(), ((EntityBreeding)this.entityMap.get((Object)this.pokemon.get(1))).getPokemonData())) {
                try {
                    this.pokemon.forEach(this::updateBreeding);
                    this.func_70296_d();
                }
                catch (ConcurrentModificationException concurrentModificationException) {
                    // empty catch block
                }
            }
        }
        this.checkAboveGround();
    }

    public void updateBreeding(RanchPoke poke) {
        if (poke.breedingLevel > PixelmonConfig.numBreedingLevels) {
            poke.breedingLevel = PixelmonConfig.numBreedingLevels;
        } else {
            EntityBreeding pixelmon = (EntityBreeding)this.entityMap.get((Object)poke);
            if (pixelmon == null) {
                return;
            }
            this.refreshBreedingStrength(pixelmon);
            if (this.egg != null) {
                return;
            }
            if (poke.breedingStrength == EnumBreedingStrength.NONE) {
                poke.lastBreedingTime = this.field_145850_b.func_82737_E();
                if (poke.breedingLevel > 0) {
                    BreedEvent.BreedingLevelChanged event = new BreedEvent.BreedingLevelChanged(pixelmon.func_184753_b(), this, pixelmon, poke.breedingLevel, poke.breedingLevel - 1);
                    Pixelmon.EVENT_BUS.post((Event)event);
                    poke.breedingLevel = event.getNewLevel();
                }
            } else {
                long currentTime = this.field_145850_b.func_82737_E();
                int breedingTicks = PixelmonConfig.breedingTicks;
                boolean ovalCharm = false;
                PlayerPartyStorage pps = Pixelmon.storageManager.getParty(pixelmon.func_184753_b());
                if (pps != null && pps.getOvalCharm().isActive()) {
                    ovalCharm = true;
                    breedingTicks = (int)((float)breedingTicks * PixelmonConfig.ovalCharmMultiplier);
                }
                BreedEvent.BreedingTicks ticksEvent = new BreedEvent.BreedingTicks(pixelmon.func_184753_b(), this, pixelmon, breedingTicks, ovalCharm);
                Pixelmon.EVENT_BUS.post((Event)ticksEvent);
                breedingTicks = ticksEvent.getBreedingTicks();
                while ((float)(currentTime - poke.lastBreedingTime) - (float)breedingTicks / poke.breedingStrength.value >= 0.0f) {
                    BreedEvent.BreedingLevelChanged levelChangedEvent = new BreedEvent.BreedingLevelChanged(pixelmon.func_184753_b(), this, pixelmon, poke.breedingLevel, poke.breedingLevel + 1);
                    Pixelmon.EVENT_BUS.post((Event)levelChangedEvent);
                    poke.breedingLevel = levelChangedEvent.getNewLevel();
                    poke.lastBreedingTime = (long)((float)poke.lastBreedingTime + (float)breedingTicks / poke.breedingStrength.value);
                    if (poke.breedingLevel <= PixelmonConfig.numBreedingLevels) continue;
                    break;
                }
                if (poke.breedingLevel >= PixelmonConfig.numBreedingLevels) {
                    this.updateStatus();
                }
            }
            if (pixelmon.getNumBreedingLevels() != poke.breedingLevel) {
                pixelmon.func_184212_Q().func_187227_b(EntityBreeding.dwNumBreedingLevels, (Object)((byte)poke.breedingLevel));
            }
        }
    }

    @Override
    public void updateStatus() {
        if (this.egg != null) {
            return;
        }
        if (this.entityMap.size() == 2) {
            Pokemon parent2;
            Pokemon parent1 = ((EntityBreeding)this.entityMap.get((Object)this.pokemon.get(0))).getPokemonData();
            if (BreedLogic.canBreed(parent1, parent2 = ((EntityBreeding)this.entityMap.get((Object)this.pokemon.get(1))).getPokemonData()) && this.pokemon.get(0).readyToMakeEgg() && this.pokemon.get(1).readyToMakeEgg()) {
                Pokemon pokemon = BreedLogic.makeEgg(parent1, parent2);
                BreedEvent.MakeEgg eggEvent = new BreedEvent.MakeEgg(parent1.getOwnerPlayerUUID(), this, pokemon, parent1, parent2);
                if (!Pixelmon.EVENT_BUS.post((Event)eggEvent)) {
                    this.egg = pokemon = eggEvent.getEgg();
                }
                this.pokemon.get(0).resetBreedingLevel(this.field_145850_b);
                this.pokemon.get(1).resetBreedingLevel(this.field_145850_b);
                ((WorldServer)this.field_145850_b).func_184164_w().func_180244_a(this.field_174879_c);
                this.func_70296_d();
            }
        } else {
            this.pokemon.forEach(p -> p.resetBreedingLevel(this.field_145850_b));
        }
        this.func_145831_w().func_175685_c(this.field_174879_c, this.func_145838_q(), true);
    }

    public void refreshBreedingStrength(EntityBreeding pixelmon) {
        float breedingStrengthFloat;
        if (pixelmon == null) {
            return;
        }
        if (PixelmonConfig.useBreedingEnvironment) {
            BreedingConditions conditions = ((RanchBounds)this.getBounds()).getContainingBreedingConditions(this.field_145850_b);
            breedingStrengthFloat = conditions.getBreedingStrength(pixelmon.getBaseStats().types);
        } else {
            breedingStrengthFloat = 2.0f;
        }
        RanchBounds bounds = (RanchBounds)this.getBounds();
        BreedEvent.EnvironmentStrength strengthEvent = new BreedEvent.EnvironmentStrength(pixelmon.func_184753_b(), this, pixelmon, bounds, breedingStrengthFloat);
        Pixelmon.EVENT_BUS.post((Event)strengthEvent);
        ((RanchPoke)this.entityMap.inverse().get((Object)pixelmon)).breedingStrength = EnumBreedingStrength.of(strengthEvent.breedingStrength);
    }

    public void onActivate(EntityPlayerMP player) {
        if (!PixelmonConfig.allowBreeding) {
            ChatHandler.sendChat((Entity)player, "pixelmon.general.disabledblock", new Object[0]);
            return;
        }
        if (this.tick < 100) {
            return;
        }
        this.updateStatus();
        PCStorage pc = Pixelmon.storageManager.getPCForPlayer(player);
        Pixelmon.network.sendTo((IMessage)new RanchBlockClientPacket(this, EnumRanchClientPacketMode.ViewBlock), player);
        Pixelmon.network.sendTo((IMessage)new ClientChangeOpenPC(pc.uuid), player);
        OpenScreen.open((EntityPlayer)player, EnumGuiScreen.RanchBlock, this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p());
    }

    public boolean onActivate(EntityPlayer player, EntityBreeding pixelmon, EnumHand hand) {
        this.updateStatus();
        if (this.pokemon.size() > 1) {
            Item item;
            ItemStack itemStack = player.func_184586_b(hand);
            if (!itemStack.func_190926_b() && (item = itemStack.func_77973_b()) instanceof ItemIsisHourglass && ((ItemIsisHourglass)item).type == EnumCheatItemType.Silver) {
                RanchPoke poke = (RanchPoke)this.entityMap.inverse().get((Object)pixelmon);
                if (poke.breedingStrength != EnumBreedingStrength.NONE && !this.hasEgg() && poke.breedingLevel < PixelmonConfig.numBreedingLevels && this.entityMap.size() > 1 && this.entityMap.get((Object)this.pokemon.get(0)) != null && this.entityMap.get((Object)this.pokemon.get(1)) != null) {
                    Pokemon parent1 = ((EntityBreeding)this.entityMap.get((Object)this.pokemon.get(0))).getPokemonData();
                    Pokemon parent2 = ((EntityBreeding)this.entityMap.get((Object)this.pokemon.get(1))).getPokemonData();
                    if (parent1 != null && parent2 != null && BreedLogic.canBreed(parent1, parent2)) {
                        BreedEvent.BreedingLevelChanged levelChangedEvent = new BreedEvent.BreedingLevelChanged(this.ownerUUID, this, (EntityBreeding)this.entityMap.get((Object)poke), poke.breedingLevel, poke.breedingLevel + 1);
                        Pixelmon.EVENT_BUS.post((Event)levelChangedEvent);
                        poke.breedingLevel = levelChangedEvent.getNewLevel();
                        poke.lastBreedingTime = this.field_145850_b.func_82737_E();
                        player.func_145747_a((ITextComponent)new TextComponentTranslation("ranch.hourglass.upgrade", new Object[]{pixelmon.getNickname()}));
                        if (!player.field_71075_bZ.field_75098_d) {
                            player.func_184586_b(hand).func_190918_g(1);
                        }
                        return true;
                    }
                }
                return false;
            }
            RanchPoke poke = (RanchPoke)this.entityMap.inverse().get((Object)pixelmon);
            RanchPoke otherPoke = this.pokemon.get(0) == poke ? this.pokemon.get(1) : this.pokemon.get(0);
            EntityBreeding otherPixelmon = (EntityBreeding)this.entityMap.get((Object)otherPoke);
            if (otherPixelmon != null) {
                Pokemon parent1 = pixelmon.getPokemonData();
                Pokemon parent2 = ((EntityBreeding)this.entityMap.get((Object)otherPoke)).getPokemonData();
                if (parent1 != null && parent2 != null && !BreedLogic.canBreed(parent1, parent2)) {
                    player.func_145747_a((ITextComponent)new TextComponentTranslation("pixelmon.ranch.notcompatible", new Object[]{pixelmon.getNickname()}));
                    return true;
                }
                if (otherPoke.breedingStrength == EnumBreedingStrength.NONE) {
                    this.refreshBreedingStrength(pixelmon);
                    this.refreshBreedingStrength(otherPixelmon);
                }
                if (poke.breedingLevel >= PixelmonConfig.numBreedingLevels) {
                    player.func_145747_a((ITextComponent)new TextComponentTranslation("pixelmon.ranch.maxaffection", new Object[]{pixelmon.getNickname(), otherPixelmon.getNickname()}));
                } else {
                    player.func_145747_a((ITextComponent)new TextComponentTranslation("pixelmon.ranch.level" + poke.breedingStrength.ordinal(), new Object[]{pixelmon.getNickname(), otherPixelmon.getNickname()}));
                }
                return true;
            }
            player.func_145747_a((ITextComponent)new TextComponentTranslation("pixelmon.ranch.notcompatible", new Object[]{pixelmon.getNickname()}));
            return true;
        }
        player.func_145747_a((ITextComponent)new TextComponentTranslation("pixelmon.ranch.nopartner", new Object[]{pixelmon.getNickname()}));
        return true;
    }

    public Collection<EntityBreeding> getEntities() {
        return this.entityMap.values();
    }

    public boolean canBreed() {
        Pokemon parent2;
        Pokemon parent1;
        return this.entityMap.size() == 2 && this.pokemon.size() == 2 && BreedLogic.canBreed(parent1 = ((EntityBreeding)this.entityMap.get((Object)this.pokemon.get(0))).getPokemonData(), parent2 = ((EntityBreeding)this.entityMap.get((Object)this.pokemon.get(1))).getPokemonData());
    }

    public boolean hasEgg() {
        return this.egg != null || this.species != null;
    }

    public boolean claimEgg(EntityPlayerMP player) {
        BreedEvent.CollectEgg collectEggEvent;
        if (this.egg != null && !Pixelmon.EVENT_BUS.post((Event)(collectEggEvent = new BreedEvent.CollectEgg(player.func_110124_au(), this, this.egg)))) {
            PlayerPartyStorage storage = Pixelmon.storageManager.getParty(player);
            storage.add(collectEggEvent.getEgg());
            this.egg = null;
            this.pokemon.forEach(p -> p.resetBreedingLevel(this.field_145850_b));
            this.updateStatus();
            this.func_70296_d();
            ((WorldServer)this.field_145850_b).func_184164_w().func_180244_a(this.field_174879_c);
            return true;
        }
        return false;
    }

    public void addPokemon(EntityPlayerMP player, UUID uuid, StoragePosition position) {
        try {
            int count;
            PCStorage storage = Pixelmon.storageManager.getPCForPlayer(player);
            Pokemon pokemon = storage.get(position);
            if (pokemon == null || !pokemon.getUUID().equals(uuid) || pokemon.isInRanch()) {
                boolean isNull = pokemon == null;
                boolean isInvalid = pokemon != null && !pokemon.getUUID().equals(uuid);
                boolean isInRanch = pokemon != null && pokemon.isInRanch();
                Pixelmon.LOGGER.info("TileEntityRanchBlock " + player.func_70005_c_() + " " + player.func_110124_au() + " " + this.field_174879_c + ": Attempted to add Pokemon to ranch that was not valid. isNull = " + isNull + ", isInvalid = " + isInvalid + ", isInRanch = " + isInRanch);
                return;
            }
            BreedEvent.AddPokemon event = new BreedEvent.AddPokemon(player, this, pokemon);
            if (Pixelmon.EVENT_BUS.post((Event)event) || event.getResult() == Event.Result.DENY) {
                pokemon.setInRanch(false);
                return;
            }
            if (PixelmonConfig.maxCumulativePokemonInRanch > 0 && (count = storage.findAll(Pokemon::isInRanch).size()) + 1 > PixelmonConfig.maxCumulativePokemonInRanch && event.getResult() != Event.Result.ALLOW) {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("pixelmon.ranch.maxcumulativepokemon", new Object[0]));
                pokemon.setInRanch(false);
                return;
            }
            pokemon.setInRanch(true);
            pokemon.ifEntityExists(EntityPixelmon::retrieve);
            this.pokemon.add(new RanchPoke(uuid, position));
            this.pokemon.forEach(p -> p.resetBreedingLevel(this.field_145850_b));
            this.trySpawnPokes(player);
            this.func_70296_d();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void removePokemon(EntityPlayerMP player, UUID uuid, StoragePosition position) {
        try {
            Iterator<RanchPoke> iterator = this.pokemon.iterator();
            while (iterator.hasNext()) {
                EntityBreeding breeding;
                RanchPoke poke = iterator.next();
                if (!Objects.equals(poke.pos, position)) continue;
                PCStorage storage = Pixelmon.storageManager.getPCForPlayer(player);
                Pokemon pokemon = poke.getPokemon(storage);
                if (pokemon == null || !Objects.equals(poke.uuid, uuid)) {
                    Pixelmon.LOGGER.info("Remove pokemon called with null or invalid pokemon. (But we're continuing to remove it)");
                }
                if ((breeding = (EntityBreeding)this.entityMap.remove((Object)poke)) != null) {
                    breeding.field_70170_p.func_72900_e((Entity)breeding);
                }
                iterator.remove();
                this.pokemon.forEach(p -> p.resetBreedingLevel(this.field_145850_b));
                this.func_70296_d();
                pokemon.setInRanch(false);
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void removePokemon(EntityPlayerMP player, EntityBreeding pixelmon) {
        try {
            Iterator iterator = this.entityMap.keySet().iterator();
            while (iterator.hasNext()) {
                RanchPoke poke = (RanchPoke)iterator.next();
                if (this.entityMap.get((Object)poke) != pixelmon && ((EntityBreeding)this.entityMap.get((Object)poke)).getPokemonData() != pixelmon.getPokemonData()) continue;
                Pixelmon.LOGGER.warn("Forcibly removing pokemon from ranch block at " + this.field_174879_c);
                this.pokemon.remove(poke);
                pixelmon.func_70106_y();
                iterator.remove();
                this.pokemon.forEach(p -> p.resetBreedingLevel(this.field_145850_b));
                PCStorage storage = Pixelmon.storageManager.getPCForPlayer(player);
                this.func_70296_d();
                poke.getPokemon(storage).setInRanch(false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void removeAllPokemon() {
        Iterator<RanchPoke> iterator = this.pokemon.iterator();
        while (iterator.hasNext()) {
            RanchPoke poke = iterator.next();
            EntityBreeding pixelmon = (EntityBreeding)this.entityMap.remove((Object)poke);
            if (pixelmon != null) {
                pixelmon.func_70106_y();
            }
            iterator.remove();
            PCStorage storage = Pixelmon.storageManager.getPCForPlayer(this.getOwnerUUID());
            Pokemon pokemon = poke.getPokemon(storage);
            if (pokemon != null) {
                pokemon.setInRanch(false);
            }
            this.func_70296_d();
        }
    }

    public boolean applyHourglass() {
        boolean hourglassused = false;
        for (RanchPoke poke : this.pokemon) {
            if (poke.breedingStrength == EnumBreedingStrength.NONE || poke.breedingLevel >= PixelmonConfig.numBreedingLevels) continue;
            hourglassused = true;
            BreedEvent.BreedingLevelChanged levelChangedEvent = new BreedEvent.BreedingLevelChanged(this.ownerUUID, this, (EntityBreeding)this.entityMap.get((Object)poke), poke.breedingLevel, poke.breedingLevel + 1);
            Pixelmon.EVENT_BUS.post((Event)levelChangedEvent);
            poke.breedingLevel = levelChangedEvent.getNewLevel();
            poke.lastBreedingTime = this.field_145850_b.func_82737_E();
        }
        return hourglassused;
    }

    private void trySpawnPokes(EntityPlayerMP player) {
        if (player == null) {
            return;
        }
        PCStorage storage = Pixelmon.storageManager.getPCForPlayer(player);
        Iterator<RanchPoke> iterator = this.pokemon.iterator();
        while (iterator.hasNext()) {
            RanchPoke poke = iterator.next();
            Pokemon pokemon = poke.getPokemon(storage);
            if (pokemon != null && pokemon.isInRanch()) {
                EntityBreeding pixelmon;
                if (this.entityMap.containsKey((Object)poke)) {
                    pixelmon = (EntityBreeding)this.entityMap.get((Object)poke);
                    if (pixelmon.field_70128_L || pixelmon.func_110143_aJ() <= 0.0f || pixelmon.field_70170_p.func_73045_a(pixelmon.func_145782_y()) == null) {
                        this.entityMap.remove((Object)poke);
                    } else if (!this.ranchBounds.isIn(pixelmon.func_174791_d())) {
                        // empty if block
                    }
                }
                if (this.entityMap.containsKey((Object)poke)) continue;
                if (pokemon.getHealth() <= 0) {
                    pokemon.setHealth(1);
                }
                pixelmon = new EntityBreeding(player.field_70170_p);
                pixelmon.setPokemon(pokemon);
                pixelmon.setRanchBlockOwner(this);
                if (!this.setLocationForEntity(pixelmon)) continue;
                pixelmon.field_70170_p.func_72838_d((Entity)pixelmon);
                this.entityMap.put((Object)poke, (Object)pixelmon);
                this.refreshBreedingStrength(pixelmon);
                continue;
            }
            this.entityMap.remove((Object)poke);
            Optional.ofNullable(storage.findOne(p -> Objects.equals(p.getUUID(), poke.uuid))).ifPresent(p -> p.setInRanch(false));
            PlayerPartyStorage party = Pixelmon.storageManager.getParty(player);
            Optional.ofNullable(party.findOne(p -> Objects.equals(p.getUUID(), poke.uuid))).ifPresent(p -> p.setInRanch(false));
            iterator.remove();
            Pixelmon.LOGGER.info("Removed pokemon from ranchblock at " + this.field_174879_c + " cause it was not in the correct storage pos or was not marked as in a ranch block.");
        }
        if (this.hasEgg()) {
            ((WorldServer)this.field_145850_b).func_184164_w().func_180244_a(this.field_174879_c);
        }
    }

    public List<RanchPoke> getPokemonData() {
        return this.pokemon;
    }

    public void setPokemonData(List<RanchPoke> pokemon) {
        this.pokemon = pokemon;
    }

    @Override
    public int getEntityCount() {
        return this.entityMap.size();
    }

    @Override
    public Bounds getBounds() {
        return this.ranchBounds;
    }

    public void setInitBounds() {
        this.ranchBounds = new RanchBounds(this, this.field_174879_c.func_177952_p() + 4, this.field_174879_c.func_177958_n() - 4, this.field_174879_c.func_177952_p() - 4, this.field_174879_c.func_177958_n() + 4, this.field_174879_c.func_177956_o());
    }

    public void setOwner(EntityPlayerMP entity) {
        this.ownerUUID = entity.func_110124_au();
    }

    public UUID getOwnerUUID() {
        return this.ownerUUID;
    }

    public boolean isRanchOwnerInGame() {
        return this.ownerUUID != null && this.field_145850_b.func_152378_a(this.ownerUUID) != null;
    }

    public Pokemon getEgg() {
        return this.egg;
    }

    public EnumSpecies getEggSpecies() {
        return this.egg != null ? this.egg.getSpecies() : this.species;
    }

    @SideOnly(value=Side.CLIENT)
    public void setEggSpecies(EnumSpecies species) {
        this.species = species;
    }

    protected void checkAboveGround() {
        if (this.aboveGround && this.percentAbove < 100) {
            this.percentAbove += 5;
        } else if (!this.aboveGround && this.percentAbove > 0) {
            this.percentAbove -= 5;
        }
        if (this.hasEgg()) {
            this.aboveGround = true;
        } else if (this.tick % 20 == 0) {
            int x = this.field_174879_c.func_177958_n();
            int y = this.field_174879_c.func_177956_o();
            int z = this.field_174879_c.func_177952_p();
            List closePlayers = this.field_145850_b.func_72872_a(EntityPlayer.class, new AxisAlignedBB((double)(x - 5), (double)(y - 5), (double)(z - 5), (double)(x + 5), (double)(y + 5), (double)(z + 5)));
            this.aboveGround = false;
            for (EntityPlayer closePlayer : closePlayers) {
                if (!Objects.equals(closePlayer.func_110124_au(), this.ownerUUID)) continue;
                this.aboveGround = true;
                break;
            }
        }
    }

    public void onDestroy() {
        if (!this.field_145850_b.field_72995_K) {
            try {
                this.removeAllPokemon();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private boolean setLocationForEntity(EntityBreeding pixelmon) {
        for (int i = 0; i < 5; ++i) {
            int[] xz = this.ranchBounds.getRandomLocation(this.field_145850_b.field_73012_v);
            BlockPos pos = new BlockPos(xz[0], this.field_174879_c.func_177956_o() + RandomHelper.getRandomNumberBetween(0, 3), xz[1]);
            pos = pos.func_177984_a();
            pixelmon.func_70012_b(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), 0.0f, 0.0f);
            if (!pixelmon.func_70601_bi()) continue;
            return true;
        }
        return false;
    }

    public void func_145834_a(World world) {
        super.func_145834_a(world);
        this.ranchBounds.setWorldObj(world);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        NBTTagList list = new NBTTagList();
        for (RanchPoke poke : this.pokemon) {
            NBTTagCompound compound = new NBTTagCompound();
            poke.writeToNBT(compound);
            list.func_74742_a((NBTBase)compound);
        }
        nbt.func_74782_a("PokemonList", (NBTBase)list);
        this.ranchBounds.writeToNBT(nbt);
        if (this.egg != null) {
            NBTTagCompound compound = new NBTTagCompound();
            this.egg.writeToNBT(compound);
            nbt.func_74782_a("egg", (NBTBase)compound);
        }
        if (this.ownerUUID != null) {
            nbt.func_74772_a("UUIDMost", this.ownerUUID.getMostSignificantBits());
            nbt.func_74772_a("UUIDLeast", this.ownerUUID.getLeastSignificantBits());
        }
        return nbt;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.ranchBounds.readFromNBT(nbt);
        if (nbt.func_74764_b("PokemonList")) {
            NBTTagList list = nbt.func_150295_c("PokemonList", 10);
            this.pokemon.clear();
            this.entityMap.values().forEach(pixelmon -> pixelmon.func_70106_y());
            this.entityMap.clear();
            for (NBTBase tag : list) {
                NBTTagCompound compound = (NBTTagCompound)tag;
                RanchPoke poke = new RanchPoke(null, null);
                poke.readFromNBT(compound);
                this.pokemon.add(poke);
            }
        }
        this.egg = nbt.func_74764_b("egg") ? Pixelmon.pokemonFactory.create(nbt.func_74775_l("egg")) : null;
        this.ownerUUID = nbt.func_150297_b("UUIDMost", 4) && nbt.func_150297_b("UUIDLeast", 4) ? new UUID(nbt.func_74763_f("UUIDMost"), nbt.func_74763_f("UUIDLeast")) : null;
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound nbt = new NBTTagCompound();
        super.func_189515_b(nbt);
        this.ranchBounds.writeToNBT(nbt);
        if (this.egg != null) {
            nbt.func_74768_a("eggdex", this.egg.getSpecies().getNationalPokedexInteger());
        }
        if (this.ownerUUID != null) {
            nbt.func_74772_a("UUIDMost", this.ownerUUID.getMostSignificantBits());
            nbt.func_74772_a("UUIDLeast", this.ownerUUID.getLeastSignificantBits());
        }
        return nbt;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        super.func_145839_a(pkt.func_148857_g());
        this.ranchBounds.readFromNBT(pkt.func_148857_g());
        NBTTagCompound nbt = pkt.func_148857_g();
        this.species = nbt.func_74764_b("eggdex") ? EnumSpecies.getFromDex(nbt.func_74762_e("eggdex")) : null;
        this.ownerUUID = nbt.func_150297_b("UUIDMost", 4) && nbt.func_150297_b("UUIDLeast", 4) ? new UUID(nbt.func_74763_f("UUIDMost"), nbt.func_74763_f("UUIDLeast")) : null;
        this.updateStatus();
    }

    public static class RanchPoke {
        public UUID uuid;
        public StoragePosition pos;
        int breedingLevel;
        long lastBreedingTime;
        EnumBreedingStrength breedingStrength = EnumBreedingStrength.NONE;

        public RanchPoke(UUID uuid, StoragePosition position) {
            this.uuid = uuid;
            this.pos = position;
        }

        public void resetBreedingLevel(World world) {
            this.breedingLevel = 0;
            this.lastBreedingTime = world.func_82737_E();
        }

        public boolean readyToMakeEgg() {
            return this.breedingLevel >= PixelmonConfig.numBreedingLevels;
        }

        @Nullable
        public Pokemon getPokemon(PCStorage storage) {
            Pokemon pokemon = storage.get(this.pos);
            if (pokemon != null && Objects.equals(pokemon.getUUID(), this.uuid)) {
                return pokemon;
            }
            return null;
        }

        public void writeToNBT(NBTTagCompound compound) {
            compound.func_186854_a("uuid", this.uuid);
            compound.func_74777_a("box", (short)this.pos.box);
            compound.func_74774_a("order", (byte)this.pos.order);
            compound.func_74774_a("breedLevel", (byte)this.breedingLevel);
            compound.func_74772_a("lastBreedingTime", this.lastBreedingTime);
        }

        public void readFromNBT(NBTTagCompound compound) {
            this.uuid = compound.func_186857_a("uuid");
            this.pos = new StoragePosition(compound.func_74765_d("box"), compound.func_74771_c("order"));
            this.breedingLevel = compound.func_74771_c("breedLevel");
            this.lastBreedingTime = compound.func_74763_f("lastBreedingTime");
        }

        public boolean matches(Pokemon pokemon) {
            return pokemon != null && this.pos.equals(pokemon.getPosition()) && this.uuid.equals(pokemon.getUUID());
        }
    }
}

