/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.Proxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiScreenWorking;
import net.minecraft.client.resources.FileResourcePack;
import net.minecraft.client.resources.FolderResourcePack;
import net.minecraft.client.resources.IResourcePack;
import net.minecraft.client.resources.LegacyV2Adapter;
import net.minecraft.client.resources.ResourcePackRepository;
import net.minecraft.client.resources.data.MetadataSerializer;
import net.minecraft.client.resources.data.PackMetadataSection;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.util.HttpUtil;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.comparator.LastModifiedFileComparator;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SideOnly(value=Side.CLIENT)
public class PixelmonResourcePackRepository
extends ResourcePackRepository {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final FileFilter RESOURCE_PACK_FILTER = p_accept_1_ -> {
        boolean flag = p_accept_1_.isFile() && p_accept_1_.getName().endsWith(".zip");
        boolean flag1 = p_accept_1_.isDirectory() && new File(p_accept_1_, "pack.mcmeta").isFile();
        return flag || flag1;
    };
    private static final Pattern SHA1 = Pattern.compile("^[a-fA-F0-9]{40}$");
    private static final ResourceLocation UNKNOWN_PACK_TEXTURE = new ResourceLocation("textures/misc/unknown_pack.png");
    private final File dirServerResourcepacks;
    private final ReentrantLock lock = new ReentrantLock();
    private ListenableFuture<Object> downloadingPacks;
    private static Constructor<ResourcePackRepository.Entry> constructorFile = null;
    private static Constructor<ResourcePackRepository.Entry> constructorIResourcePack = null;

    public PixelmonResourcePackRepository(File dirResourcepacksIn, File dirServerResourcepacksIn, IResourcePack rprDefaultResourcePackIn, MetadataSerializer rprMetadataSerializerIn, GameSettings settings) {
        super(dirResourcepacksIn, dirServerResourcepacksIn, rprDefaultResourcePackIn, rprMetadataSerializerIn, settings);
        this.dirServerResourcepacks = dirServerResourcepacksIn;
    }

    public static Map<String, String> getDownloadHeaders() {
        HashMap map = Maps.newHashMap();
        map.put("X-Minecraft-Username", Minecraft.func_71410_x().func_110432_I().func_111285_a());
        map.put("X-Minecraft-UUID", Minecraft.func_71410_x().func_110432_I().func_148255_b());
        map.put("X-Minecraft-Version", "1.12.2");
        return map;
    }

    private IResourcePack getResourcePack(File p_191399_1_) {
        Object iresourcepack = p_191399_1_.isDirectory() ? new FolderResourcePack(p_191399_1_) : new FileResourcePack(p_191399_1_);
        try {
            PackMetadataSection packmetadatasection = (PackMetadataSection)iresourcepack.func_135058_a(this.field_110621_c, "pack");
            if (packmetadatasection != null && packmetadatasection.func_110462_b() == 2) {
                return new LegacyV2Adapter((IResourcePack)iresourcepack);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return iresourcepack;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListenableFuture<Object> func_180601_a(String url, String hash) {
        String s = DigestUtils.sha1Hex((String)url);
        final String s1 = SHA1.matcher(hash).matches() ? hash : "";
        final File file1 = new File(this.dirServerResourcepacks, s);
        this.lock.lock();
        try {
            ListenableFuture<Object> listenablefuture;
            this.func_148529_f();
            if (file1.exists()) {
                if (this.checkHash(s1, file1)) {
                    ListenableFuture listenableFuture = this.func_177319_a(file1);
                    return listenableFuture;
                }
                LOGGER.warn("Deleting file {}", (Object)file1);
                FileUtils.deleteQuietly((File)file1);
            }
            this.deleteOldServerResourcesPacks();
            GuiScreenWorking guiscreenworking = new GuiScreenWorking();
            Map<String, String> map = PixelmonResourcePackRepository.getDownloadHeaders();
            Minecraft minecraft = Minecraft.func_71410_x();
            Futures.getUnchecked((Future)minecraft.func_152344_a(() -> minecraft.func_147108_a((GuiScreen)guiscreenworking)));
            final SettableFuture settablefuture = SettableFuture.create();
            this.downloadingPacks = HttpUtil.func_180192_a((File)file1, (String)url, map, (int)629145600, (IProgressUpdate)guiscreenworking, (Proxy)minecraft.func_110437_J());
            Futures.addCallback(this.downloadingPacks, (FutureCallback)new FutureCallback<Object>(){

                public void onSuccess(@Nullable Object p_onSuccess_1_) {
                    if (PixelmonResourcePackRepository.this.checkHash(s1, file1)) {
                        PixelmonResourcePackRepository.this.func_177319_a(file1);
                        settablefuture.set(null);
                    } else {
                        LOGGER.warn("Deleting file {}", (Object)file1);
                        FileUtils.deleteQuietly((File)file1);
                    }
                }

                public void onFailure(Throwable p_onFailure_1_) {
                    FileUtils.deleteQuietly((File)file1);
                    settablefuture.setException(p_onFailure_1_);
                }
            });
            ListenableFuture<Object> listenableFuture = listenablefuture = this.downloadingPacks;
            return listenableFuture;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkHash(String p_190113_1_, File p_190113_2_) {
        String s;
        FileInputStream is;
        block7: {
            block6: {
                is = null;
                is = new FileInputStream(p_190113_2_);
                s = DigestUtils.sha1Hex((InputStream)is);
                if (!p_190113_1_.isEmpty()) break block6;
                LOGGER.info("Found file {} without verification hash", (Object)p_190113_2_);
                boolean bl = true;
                IOUtils.closeQuietly((InputStream)is);
                return bl;
            }
            if (!s.toLowerCase(Locale.ROOT).equals(p_190113_1_.toLowerCase(Locale.ROOT))) break block7;
            LOGGER.info("Found file {} matching requested hash {}", (Object)p_190113_2_, (Object)p_190113_1_);
            boolean bl = true;
            IOUtils.closeQuietly((InputStream)is);
            return bl;
        }
        try {
            LOGGER.warn("File {} had wrong hash (expected {}, found {}).", (Object)p_190113_2_, (Object)p_190113_1_, (Object)s);
        }
        catch (IOException ioexception) {
            try {
                LOGGER.warn("File {} couldn't be hashed.", (Object)p_190113_2_, (Object)ioexception);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)is);
        }
        IOUtils.closeQuietly((InputStream)is);
        return false;
    }

    private boolean validatePack(File p_190112_1_) {
        ResourcePackRepository.Entry resourcepackrepository$entry = this.constructEntry(p_190112_1_);
        try {
            resourcepackrepository$entry.func_110516_a();
            return true;
        }
        catch (Exception exception) {
            LOGGER.warn("Server resourcepack is invalid, ignoring it", (Throwable)exception);
            return false;
        }
    }

    private void deleteOldServerResourcesPacks() {
        try {
            ArrayList list = Lists.newArrayList((Iterable)FileUtils.listFiles((File)this.dirServerResourcepacks, (IOFileFilter)TrueFileFilter.TRUE, (IOFileFilter)null));
            Collections.sort(list, LastModifiedFileComparator.LASTMODIFIED_REVERSE);
            int i = 0;
            for (File file1 : list) {
                if (i++ < 10) continue;
                LOGGER.info("Deleting old server resource pack {}", (Object)file1.getName());
                FileUtils.deleteQuietly((File)file1);
            }
        }
        catch (IllegalArgumentException illegalargumentexception) {
            LOGGER.error("Error while deleting old server resource pack : {}", (Object)illegalargumentexception.getMessage());
        }
    }

    private ResourcePackRepository.Entry constructEntry(File resourcePackFileIn) {
        if (constructorFile == null) {
            try {
                constructorFile = ResourcePackRepository.Entry.class.getDeclaredConstructor(File.class);
                constructorFile.setAccessible(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            return constructorFile.newInstance(resourcePackFileIn);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private ResourcePackRepository.Entry constructEntry(IResourcePack reResourcePackIn) {
        if (constructorIResourcePack == null) {
            try {
                constructorIResourcePack = ResourcePackRepository.Entry.class.getDeclaredConstructor(IResourcePack.class);
                constructorIResourcePack.setAccessible(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            return constructorIResourcePack.newInstance(reResourcePackIn);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

