/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.camera.movement;

import com.pixelmonmod.pixelmon.client.ClientProxy;
import com.pixelmonmod.pixelmon.client.camera.CameraMode;
import com.pixelmonmod.pixelmon.client.camera.CameraTargetEntity;
import com.pixelmonmod.pixelmon.client.camera.CameraTargetLocation;
import com.pixelmonmod.pixelmon.client.camera.EntityCamera;
import com.pixelmonmod.pixelmon.client.camera.ICameraTarget;
import com.pixelmonmod.pixelmon.client.camera.movement.CameraMovement;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.BaseStats;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import org.lwjgl.input.Keyboard;
import org.lwjgl.util.vector.Matrix3f;

public class PlayerControlledMovement
extends CameraMovement {
    private final int KEY_W = 17;
    private final int KEY_S = 31;
    private final int KEY_A = 30;
    private final int KEY_D = 32;
    private final int KEY_Q = 16;
    private final int KEY_E = 18;
    private boolean initSphere = false;
    private Vec3d centerPos;
    private Vec3d baseVec;
    private float radius = 0.0f;
    private float pitch = 0.0f;
    private float yaw = 0.0f;
    private boolean spherePosChanged = false;
    private ICameraTarget target;

    public PlayerControlledMovement(World world, EntityCamera entityCamera) {
        super(world, entityCamera);
    }

    @Override
    public void setRandomPosition(ICameraTarget t) {
        this.target = t;
    }

    @Override
    public void onLivingUpdate() {
        if (this.camera.mode == CameraMode.Evolution) {
            if (!this.initSphere && this.target != null) {
                this.generateSphere();
            }
            this.updatePosition();
        } else {
            EntityPixelmon pix = ClientProxy.battleManager.getUserPokemon(this.camera.mode);
            if (pix == null) {
                return;
            }
            EntityPlayer player = ClientProxy.battleManager.getViewPlayer();
            if (!this.initSphere && pix.field_70165_t != player.field_70165_t && pix.field_70161_v != player.field_70161_v) {
                this.generateSphere();
            }
            EntityPixelmon opp = this.getOpponentPokemon();
            this.centerPos = new Vec3d(pix.field_70165_t, pix.field_70163_u, pix.field_70161_v);
            if (opp != null) {
                this.centerPos = new Vec3d((this.centerPos.field_72450_a + opp.field_70165_t) / 2.0, (this.centerPos.field_72448_b + opp.field_70163_u) / 2.0, (this.centerPos.field_72449_c + opp.field_70161_v) / 2.0);
            }
            Vec3d playerPos = new Vec3d(player.field_70165_t, pix.field_70163_u + 1.0, player.field_70161_v);
            Vec3d vec = playerPos.func_178788_d(this.centerPos);
            vec = new Vec3d(vec.field_72450_a, 0.0, vec.field_72449_c);
            if (vec.field_72450_a == 0.0 && vec.field_72449_c == 0.0) {
                vec.func_178787_e(new Vec3d(1.0, 0.0, 0.0));
            }
            this.camera.setTarget(new CameraTargetLocation((int)this.centerPos.field_72450_a, (int)this.centerPos.field_72448_b, (int)this.centerPos.field_72449_c));
            this.baseVec = vec.func_72432_b();
            this.updatePosition();
        }
    }

    private void updatePosition() {
        if ((this.target instanceof CameraTargetEntity || !ClientProxy.battleManager.battleEnded) && this.spherePosChanged) {
            Matrix3f mat = this.constructYawMatrix();
            if (mat == null || this.baseVec == null) {
                return;
            }
            Vec3d newPos = PlayerControlledMovement.multiply(mat, this.baseVec);
            mat = this.constructRotMatrix(newPos.func_72431_c(new Vec3d(0.0, 1.0, 0.0)), this.pitch);
            Vec3d rotPos = PlayerControlledMovement.multiply(mat, newPos);
            Vec3d testPos = new Vec3d(this.centerPos.field_72450_a + rotPos.field_72450_a * (double)this.radius, this.centerPos.field_72448_b + rotPos.field_72448_b * (double)this.radius, this.centerPos.field_72449_c + rotPos.field_72449_c * (double)this.radius);
            this.camera.func_70107_b(testPos.field_72450_a, testPos.field_72448_b, testPos.field_72449_c);
            this.spherePosChanged = false;
            this.camera.updatePositionAndRotation();
        }
    }

    private EntityPixelmon getOpponentPokemon() {
        if (ClientProxy.battleManager == null || ClientProxy.battleManager.displayedEnemyPokemon == null || ClientProxy.battleManager.displayedEnemyPokemon.length == 0) {
            return null;
        }
        UUID uuid = ClientProxy.battleManager.displayedEnemyPokemon[0].pokemonUUID;
        if (uuid != null) {
            Minecraft mc = Minecraft.func_71410_x();
            if (mc.field_71441_e != null) {
                List loadedEntityList = mc.field_71441_e.field_72996_f;
                for (int i = 0; i < loadedEntityList.size(); ++i) {
                    Entity e = (Entity)loadedEntityList.get(i);
                    if (!e.func_110124_au().equals(uuid)) continue;
                    return (EntityPixelmon)e;
                }
            }
        }
        return null;
    }

    private Matrix3f constructYawMatrix() {
        return this.constructRotMatrix(new Vec3d(0.0, 1.0, 0.0), this.yaw);
    }

    private Matrix3f constructRotMatrix(Vec3d axis, float rot) {
        Matrix3f mat = new Matrix3f();
        mat.m00 = (float)(Math.cos(rot) + axis.field_72450_a * axis.field_72450_a * (1.0 - Math.cos(rot)));
        mat.m01 = (float)(axis.field_72450_a * axis.field_72448_b * (1.0 - Math.cos(rot)) - axis.field_72449_c * Math.sin(rot));
        mat.m02 = (float)(axis.field_72450_a * axis.field_72449_c * (1.0 - Math.cos(rot)) + axis.field_72448_b * Math.sin(rot));
        mat.m10 = (float)(axis.field_72450_a * axis.field_72448_b * (1.0 - Math.cos(rot)) + axis.field_72449_c * Math.sin(rot));
        mat.m11 = (float)(Math.cos(rot) + axis.field_72448_b * axis.field_72448_b * (1.0 - Math.cos(rot)));
        mat.m12 = (float)(axis.field_72448_b * axis.field_72449_c * (1.0 - Math.cos(rot)) - axis.field_72450_a * Math.sin(rot));
        mat.m20 = (float)(axis.field_72450_a * axis.field_72449_c * (1.0 - Math.cos(rot)) - axis.field_72448_b * Math.sin(rot));
        mat.m21 = (float)(axis.field_72448_b * axis.field_72449_c * (1.0 - Math.cos(rot)) + axis.field_72450_a * Math.sin(rot));
        mat.m22 = (float)(Math.cos(rot) + axis.field_72449_c * axis.field_72449_c * (1.0 - Math.cos(rot)));
        return mat;
    }

    public static Vec3d multiply(Matrix3f matrix, Vec3d vector) {
        double x = (double)matrix.m00 * vector.field_72450_a + (double)matrix.m01 * vector.field_72448_b + (double)matrix.m02 * vector.field_72449_c;
        double y = (double)matrix.m10 * vector.field_72450_a + (double)matrix.m11 * vector.field_72448_b + (double)matrix.m12 * vector.field_72449_c;
        double z = (double)matrix.m20 * vector.field_72450_a + (double)matrix.m21 * vector.field_72448_b + (double)matrix.m22 * vector.field_72449_c;
        return new Vec3d(x, y, z);
    }

    public void generateSphere() {
        if (this.camera.mode == CameraMode.Evolution) {
            this.initSphere = true;
            if (this.target.getTargetData() instanceof EntityPixelmon) {
                EntityPixelmon poke = (EntityPixelmon)this.target.getTargetData();
                BaseStats stats = poke.getBaseStats();
                float height = 0.0f;
                if (stats != null) {
                    height = stats.getHeight().floatValue();
                }
                this.centerPos = new Vec3d(this.target.getX(), this.target.getY() + (double)height, this.target.getZ());
                Vec3d lookVec = poke.func_70040_Z();
                lookVec = new Vec3d(lookVec.field_72450_a, 0.0, lookVec.field_72449_c);
                lookVec.func_72432_b();
                this.baseVec = lookVec;
                this.pitch = 0.19634955f;
                this.yaw = 0.0f;
                this.radius = (float)(poke.getBaseStats().getBoundsData().getWidth() * 4.0);
                this.radius = this.radius < 4.0f ? 4.0f : this.radius;
                this.spherePosChanged = true;
            }
        } else {
            this.initSphere = true;
            EntityPixelmon pix = ClientProxy.battleManager.getUserPokemon(this.camera.mode);
            EntityPlayer player = ClientProxy.battleManager.getViewPlayer();
            EntityPixelmon opp = this.getOpponentPokemon();
            this.centerPos = new Vec3d(pix.field_70165_t, pix.field_70163_u, pix.field_70161_v);
            if (opp != null) {
                this.centerPos = new Vec3d((this.centerPos.field_72450_a + opp.field_70165_t) / 2.0, (this.centerPos.field_72448_b + opp.field_70163_u) / 2.0, (this.centerPos.field_72449_c + opp.field_70161_v) / 2.0);
            }
            Vec3d playerPos = new Vec3d(player.field_70165_t, pix.field_70163_u + 1.0, player.field_70161_v);
            Vec3d vec = playerPos.func_178788_d(this.centerPos);
            vec = new Vec3d(vec.field_72450_a, 0.0, vec.field_72449_c);
            if (vec.field_72450_a == 0.0 && vec.field_72449_c == 0.0) {
                vec.func_178787_e(new Vec3d(1.0, 0.0, 0.0));
            }
            this.baseVec = vec.func_72432_b();
            this.pitch = 0.7853982f;
            this.yaw = 0.0f;
            this.radius = (float)playerPos.func_72438_d(this.centerPos) + 2.0f;
            this.radius = this.radius < 10.0f ? 10.0f : this.radius;
            this.spherePosChanged = true;
        }
        ClientProxy.battleManager.setViewEntity((Entity)this.camera);
    }

    @Override
    public void generatePositions() {
    }

    @Override
    public void handleKeyboardInput() {
        if (Keyboard.isKeyDown((int)17)) {
            if ((double)this.pitch <= 1.5707963267948966) {
                this.pitch = (float)((double)this.pitch + 0.01);
            }
            this.spherePosChanged = true;
        }
        if (Keyboard.isKeyDown((int)31)) {
            if ((double)this.pitch >= -1.5707963267948966) {
                this.pitch = (float)((double)this.pitch - 0.01);
            }
            this.spherePosChanged = true;
        }
        if (Keyboard.isKeyDown((int)30)) {
            this.yaw = (float)((double)this.yaw - 0.01);
            this.spherePosChanged = true;
        }
        if (Keyboard.isKeyDown((int)32)) {
            this.yaw = (float)((double)this.yaw + 0.01);
            this.spherePosChanged = true;
        }
        if (Keyboard.isKeyDown((int)16)) {
            this.radius = (float)((double)this.radius - 0.1);
            this.spherePosChanged = true;
        }
        if (Keyboard.isKeyDown((int)18)) {
            this.radius = (float)((double)this.radius + 0.1);
            this.spherePosChanged = true;
        }
        this.updatePosition();
    }

    @Override
    public void handleMouseMovement(int dx, int dy, int dwheel) {
        if (dx != 0 || dy != 0 || dwheel != 0) {
            this.yaw -= (float)dx * 0.005f;
            this.pitch -= (float)dy * 0.008f;
            this.radius -= (float)dwheel * 0.01f;
            if (this.radius > 40.0f) {
                this.radius = 40.0f;
            } else if (this.camera.mode == CameraMode.Battle) {
                if (this.radius < 4.0f) {
                    this.radius = 4.0f;
                }
            } else if (this.radius < 2.0f) {
                this.radius = 2.0f;
            }
            this.spherePosChanged = true;
            this.updatePosition();
        }
    }
}

