/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui;

import com.google.common.collect.Maps;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonSpec;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.client.gui.GuiResources;
import com.pixelmonmod.pixelmon.client.gui.battles.PixelmonInGui;
import com.pixelmonmod.pixelmon.client.gui.custom.overlays.ScoreboardJustification;
import com.pixelmonmod.pixelmon.client.render.custom.FontRendererPixelmon;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.Gender;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.Moveset;
import com.pixelmonmod.pixelmon.enums.EnumSpecies;
import com.pixelmonmod.pixelmon.enums.EnumType;
import com.pixelmonmod.pixelmon.enums.forms.EnumSpecial;
import com.pixelmonmod.pixelmon.enums.items.EnumPokeballs;
import com.pixelmonmod.pixelmon.storage.extras.PlayerExtraDataStore;
import com.pixelmonmod.pixelmon.util.helpers.CursorHelper;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.WeakHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Vector4f;

public class GuiHelper {
    private static Map<String, FontRenderer> fontRenderers = Maps.newConcurrentMap();
    private static WeakHashMap<ResourceLocation, Boolean> weakSpriteExistenceCheck = new WeakHashMap();

    public static boolean isMouseOverButton(GuiButton button, int mouseX, int mouseY) {
        return mouseX >= button.field_146128_h && mouseY >= button.field_146129_i && mouseX < button.field_146128_h + button.field_146120_f && mouseY < button.field_146129_i + button.field_146121_g;
    }

    public static void bindFontRenderer(String font, boolean extendedColours) {
        Minecraft mc = Minecraft.func_71410_x();
        if (!fontRenderers.containsKey("")) {
            fontRenderers.put("", mc.field_71466_p);
        }
        if (fontRenderers.containsKey(font)) {
            mc.field_71466_p = fontRenderers.get(font);
            return;
        }
        ResourceLocation fontResource = new ResourceLocation(font);
        mc.field_71466_p = extendedColours ? new FontRendererPixelmon(fontRenderers.get(""), fontResource) : new FontRenderer(mc.field_71474_y, fontResource, mc.func_110434_K(), mc.func_152349_b());
        fontRenderers.put(font, mc.field_71466_p);
        mc.field_110451_am.func_110542_a((IResourceManagerReloadListener)mc.field_71466_p);
    }

    public static void resetFontRenderer() {
        GuiHelper.bindFontRenderer("", false);
    }

    public static void drawStringRightAligned(String text, float x, float y, int color) {
        GuiHelper.drawStringRightAligned(text, x, y, color, false);
    }

    public static void drawStringRightAligned(String text, float x, float y, int color, boolean dropShadow) {
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        fontRenderer.func_175065_a(text, x -= (float)fontRenderer.func_78256_a(text), y, color, dropShadow);
    }

    public static void drawScaledString(String text, float x, float y, int color, float fontSize) {
        float scalar = fontSize / 16.0f;
        GlStateManager.func_179152_a((float)scalar, (float)scalar, (float)1.0f);
        Minecraft.func_71410_x().field_71466_p.func_175065_a(text, x / scalar, y / scalar, color, false);
        GlStateManager.func_179124_c((float)255.0f, (float)255.0f, (float)255.0f);
        GlStateManager.func_179152_a((float)(1.0f / scalar), (float)(1.0f / scalar), (float)1.0f);
    }

    public static void drawScaledSquashedString(String text, float x, float y, int color, float fontSize, double widthFactor) {
        float scalar = fontSize / 16.0f;
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        boolean previousFlag = fr.func_82883_a();
        fr.func_78264_a(fr.func_82883_a());
        double nameSize = fr.func_78256_a(text);
        boolean offset = false;
        nameSize -= (double)offset;
        GlStateManager.func_179094_E();
        if (nameSize > widthFactor) {
            double scaleFactor = widthFactor / nameSize;
            GlStateManager.func_179109_b((float)x, (float)0.0f, (float)0.0f);
            GlStateManager.func_179139_a((double)scaleFactor, (double)1.0, (double)1.0);
            GlStateManager.func_179109_b((float)(-x), (float)0.0f, (float)0.0f);
        }
        GlStateManager.func_179152_a((float)scalar, (float)scalar, (float)1.0f);
        fr.func_78276_b(text, (int)(x / scalar), (int)(y / scalar), color);
        fr.func_78264_a(previousFlag);
        GlStateManager.func_179121_F();
        GlStateManager.func_179124_c((float)255.0f, (float)255.0f, (float)255.0f);
    }

    public static void drawScaledCenteredString(String text, float x, float y, int color, float fontSize) {
        float scalar = fontSize / 16.0f;
        GlStateManager.func_179152_a((float)scalar, (float)scalar, (float)1.0f);
        GuiHelper.drawCenteredString(text, x / scalar, y / scalar, color);
        GlStateManager.func_179124_c((float)255.0f, (float)255.0f, (float)255.0f);
        GlStateManager.func_179152_a((float)(1.0f / scalar), (float)(1.0f / scalar), (float)1.0f);
    }

    public static void drawScaledStringWithOutline(String text, float x, float y, int color, int outlineColor, float fontSize, float outline) {
        int i = 0;
        while (i < text.length()) {
            String character = text.substring(i, i + 1);
            GuiHelper.drawScaledCenteredString(character, x, y - outline / 4.0f, outlineColor, fontSize);
            GuiHelper.drawScaledCenteredString(character, x, y, color, fontSize - outline);
            if (i == 0) {
                x -= (float)(Minecraft.func_71410_x().field_71466_p.func_78263_a(text.charAt(i)) / 2);
            }
            x += (float)Minecraft.func_71410_x().field_71466_p.func_78263_a(text.charAt(i++));
        }
    }

    public static void drawScaledStringRightAligned(String text, float x, float y, int color, boolean dropShadow, float fontSize) {
        float scalar = fontSize / 16.0f;
        GlStateManager.func_179152_a((float)scalar, (float)scalar, (float)1.0f);
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        x = (float)((double)x - (double)((float)fontRenderer.func_78256_a(text) * fontSize) / 16.0);
        fontRenderer.func_175065_a(text, x / scalar, y / scalar, color, dropShadow);
        GlStateManager.func_179152_a((float)(1.0f / scalar), (float)(1.0f / scalar), (float)1.0f);
    }

    public static String splitStringToFit(String s, int font, int width) {
        int i = 0;
        block0: while (i < s.length()) {
            int j = 0;
            while (j < width) {
                if (++i >= s.length()) {
                    return s;
                }
                j = (int)((double)j + (double)Minecraft.func_71410_x().field_71466_p.func_78263_a(s.charAt(i)) * ((double)font / 16.0));
            }
            if (s.substring(0, i).contains(" ")) {
                for (j = i; j > 0; --j) {
                    if (s.charAt(j) != ' ') continue;
                    s = s.substring(0, j).trim() + "\n" + s.substring(j).trim();
                    continue block0;
                }
                continue;
            }
            s = s.substring(0, i).trim() + "\n" + s.substring(i).trim();
        }
        return s;
    }

    public static void drawImageQuad(double x, double y, double w, float h, double us, double vs, double ue, double ve, float zLevel) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_181662_b(x, y + (double)h, (double)zLevel).func_187315_a(us, ve).func_181675_d();
        buffer.func_181662_b(x + w, y + (double)h, (double)zLevel).func_187315_a(ue, ve).func_181675_d();
        buffer.func_181662_b(x + w, y, (double)zLevel).func_187315_a(ue, vs).func_181675_d();
        buffer.func_181662_b(x, y, (double)zLevel).func_187315_a(us, vs).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void drawImage(double x, double y, double width, double height, float zLevel) {
        GuiHelper.drawImageQuad(x, y, width, (float)height, 0.0, 0.0, 1.0, 1.0, zLevel);
    }

    public static void drawImage(ResourceLocation texture, double x, double y, double width, double height, float zLevel) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(texture);
        GuiHelper.drawImageQuad(x, y, width, (float)height, 0.0, 0.0, 1.0, 1.0, zLevel);
    }

    public static void drawScaledImage(ResourceLocation texture, double scale, double x, double y, double width, double height, float zLevel) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(texture);
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)0.0);
        GlStateManager.func_179139_a((double)scale, (double)scale, (double)0.0);
        GuiHelper.drawImageQuad(0.0, 0.0, width, (float)height, 0.0, 0.0, 1.0, 1.0, zLevel);
        GlStateManager.func_179121_F();
    }

    public static void drawSquashedString(FontRenderer fr, String text, boolean unicode, double widthFactor, float x, float y, int color, boolean shadow) {
        boolean previousFlag = fr.func_82883_a();
        fr.func_78264_a(unicode);
        GlStateManager.func_179094_E();
        double nameSize = fr.func_78256_a(text);
        boolean offset = false;
        nameSize -= (double)offset;
        if (nameSize > widthFactor) {
            double scaleFactor = widthFactor / nameSize;
            GlStateManager.func_179109_b((float)x, (float)0.0f, (float)0.0f);
            GlStateManager.func_179139_a((double)scaleFactor, (double)1.0, (double)1.0);
            GlStateManager.func_179109_b((float)(-x), (float)0.0f, (float)0.0f);
        }
        if (shadow) {
            fr.func_175063_a(text, x, y, color);
        } else {
            fr.func_78276_b(text, (int)x, (int)y, color);
        }
        fr.func_78264_a(previousFlag);
        GlStateManager.func_179121_F();
    }

    public static void drawCenteredSquashedString(FontRenderer fr, String text, boolean unicode, double widthFactor, int x, int y, int color, boolean shadow) {
        boolean previousFlag = fr.func_82883_a();
        fr.func_78264_a(unicode);
        GlStateManager.func_179094_E();
        double nameSize = fr.func_78256_a(text);
        boolean offset = false;
        nameSize -= (double)offset;
        if (nameSize > widthFactor) {
            double scaleFactor = widthFactor / nameSize;
            GlStateManager.func_179109_b((float)x, (float)0.0f, (float)0.0f);
            GlStateManager.func_179139_a((double)scaleFactor, (double)1.0, (double)1.0);
            GlStateManager.func_179109_b((float)(-x), (float)0.0f, (float)0.0f);
        }
        GlStateManager.func_179137_b((double)(-nameSize / 2.0), (double)0.0, (double)0.0);
        if (shadow) {
            fr.func_175063_a(text, (float)x, (float)y, color);
        } else {
            fr.func_78276_b(text, x, y, color);
        }
        fr.func_78264_a(previousFlag);
        GlStateManager.func_179121_F();
    }

    public static void bindPokemonSprite(Pokemon pokemon, Minecraft mc) {
        if (pokemon.isEgg()) {
            mc.field_71446_o.func_110577_a(GuiResources.getEggSprite(pokemon.getSpecies(), pokemon.getEggCycles()));
        } else {
            boolean exists;
            ResourceLocation rl;
            if (pokemon.getFormEnum() == EnumSpecial.Online && pokemon.getOwnerPlayerUUID() != null) {
                PlayerExtraDataStore.get(pokemon.getOwnerPlayerUUID()).checkPokemon(pokemon);
            }
            if (!weakSpriteExistenceCheck.containsKey(rl = GuiResources.getPokemonSprite(pokemon.getSpecies(), pokemon.getForm(), pokemon.getGender(), pokemon.getCustomTexture(), pokemon.isShiny()))) {
                weakSpriteExistenceCheck.put(rl, Pixelmon.proxy.resourceLocationExists(rl));
            }
            boolean bl = exists = weakSpriteExistenceCheck.get(rl) == Boolean.TRUE;
            if (!exists) {
                rl = GuiResources.getPokemonSprite(pokemon.getSpecies(), (int)pokemon.getSpecies().getDefaultForms().get(0).getForm(), pokemon.getGender(), "", pokemon.isShiny());
            }
            mc.field_71446_o.func_110577_a(rl);
        }
        GuiHelper.texParameterReset();
    }

    public static void bindPokemonSprite(PixelmonInGui pokemon, Minecraft mc) {
        boolean exists;
        ResourceLocation rl = GuiResources.getPokemonSprite(pokemon.species, (int)pokemon.form, pokemon.getGender(), pokemon.customTexture, pokemon.shiny);
        if (!weakSpriteExistenceCheck.containsKey(rl)) {
            weakSpriteExistenceCheck.put(rl, Pixelmon.proxy.resourceLocationExists(rl));
        }
        if (exists = weakSpriteExistenceCheck.get(rl).booleanValue()) {
            mc.field_71446_o.func_110577_a(rl);
        } else {
            mc.field_71446_o.func_110577_a(GuiResources.getPokemonSprite(pokemon.species, (int)pokemon.species.getDefaultForms().get(0).getForm(), pokemon.getGender(), "", pokemon.shiny));
        }
        GuiHelper.texParameterReset();
    }

    public static void bindPokemonSprite(EnumSpecies species, int form, Gender gender, String customTexture, boolean isShiny, int eggCycles, Minecraft mc) {
        if (eggCycles > 0) {
            mc.field_71446_o.func_110577_a(GuiResources.getEggSprite(species, eggCycles));
        } else {
            boolean exists;
            ResourceLocation rl = GuiResources.getPokemonSprite(species, form, gender, customTexture, isShiny);
            if (!weakSpriteExistenceCheck.containsKey(rl)) {
                weakSpriteExistenceCheck.put(rl, Pixelmon.proxy.resourceLocationExists(rl));
            }
            if (exists = weakSpriteExistenceCheck.get(rl).booleanValue()) {
                mc.field_71446_o.func_110577_a(rl);
            } else {
                mc.field_71446_o.func_110577_a(GuiResources.getPokemonSprite(species, form, gender, "", isShiny));
            }
        }
        GuiHelper.texParameterReset();
    }

    public static void bindPokemonSprite(PokemonSpec spec, Minecraft mc) {
        EnumSpecies species = EnumSpecies.getFromNameAnyCaseNoTranslate(spec.name);
        if (species == null) {
            return;
        }
        if (spec.egg != null && spec.egg.booleanValue()) {
            mc.field_71446_o.func_110577_a(GuiResources.getEggSprite(species, species.getBaseStats().getEggCycles()));
        } else {
            int form = spec.form != null && (spec.formInvert == null || spec.formInvert == false) ? (int)spec.form.byteValue() : -1;
            Gender gender = spec.gender != null ? Gender.getGender(spec.gender.byteValue()) : Gender.Male;
            boolean shiny = spec.shiny == Boolean.TRUE;
            mc.field_71446_o.func_110577_a(GuiResources.getPokemonSprite(species, form, gender, "", shiny));
        }
        GuiHelper.texParameterReset();
    }

    public static void texParameterReset() {
        GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10242, (int)33071);
        GL11.glTexParameteri((int)3553, (int)10243, (int)33071);
    }

    public static void drawScoreboard(int top, ScoreboardJustification justification, int x, int alpha, String title, Collection<String> lines, Collection<String> scores) {
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        int tempWidth = GuiHelper.getLongestStringWidth(lines);
        if (scores != null) {
            tempWidth += GuiHelper.getLongestStringWidth(scores) + 20;
        }
        if (fontRenderer.func_78256_a(title) > tempWidth) {
            tempWidth = fontRenderer.func_78256_a(title);
        }
        int justifiedWidth = justification == ScoreboardJustification.RIGHT ? tempWidth : (justification == ScoreboardJustification.CENTER ? tempWidth / 2 : 0);
        int left = x - justifiedWidth - 3;
        int boxHeight = (lines.size() + 1) * 10;
        Gui.func_73734_a((int)left, (int)top, (int)(left + tempWidth), (int)(top + boxHeight), (int)alpha);
        GuiHelper.drawCenteredString(title, (float)left + (float)tempWidth / 2.0f, top, -1);
        int y = top;
        for (String line : lines) {
            fontRenderer.func_175063_a(line, (float)(left + 3), (float)(y += 10), -1);
        }
        y = top;
        if (scores != null) {
            for (String line : scores) {
                fontRenderer.func_175063_a(line, (float)(left + tempWidth - 3 - fontRenderer.func_78256_a(line)), (float)(y += 10), -1);
            }
        }
    }

    public static int getLongestStringWidth(Collection<String> lines) {
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        int longestStringWidth = 0;
        for (String line : lines) {
            int currentStringWidth = fontRenderer.func_78256_a(line);
            if (currentStringWidth <= longestStringWidth) continue;
            longestStringWidth = currentStringWidth;
        }
        return longestStringWidth;
    }

    public static Optional<int[]> renderTooltip(int x, int y, int gradient1, int background, int alpha, boolean centerBox, boolean centerText, String ... tooltipData) {
        List<String> tooltipCollection = Arrays.asList(tooltipData);
        return GuiHelper.renderTooltip(x, y, tooltipCollection, gradient1, background, alpha, centerBox, centerText);
    }

    public static Optional<int[]> renderTooltip(int x, int y, Collection<String> tooltipData, int gradient1, int background, int alpha, boolean centerBox, boolean centerText, float zLevel) {
        if (tooltipData.isEmpty()) {
            return Optional.empty();
        }
        boolean lighting = GL11.glGetBoolean((int)2896);
        if (lighting) {
            RenderHelper.func_74518_a();
        }
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        int longestStringWidth = GuiHelper.getLongestStringWidth(tooltipData);
        int left = x;
        int top = y;
        if (centerBox) {
            left -= longestStringWidth / 2;
        }
        int boxHeight = 8;
        if (tooltipData.size() > 1) {
            boxHeight += (tooltipData.size() - 1) * 10;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)1.0f);
        background = background & 0xFFFFFF | alpha << 24;
        Gui.func_73734_a((int)(left - 3), (int)(top - 4), (int)(left + longestStringWidth + 3), (int)(top - 3), (int)background);
        Gui.func_73734_a((int)(left - 3), (int)(top + boxHeight + 3), (int)(left + longestStringWidth + 3), (int)(top + boxHeight + 4), (int)background);
        Gui.func_73734_a((int)(left - 3), (int)(top - 3), (int)(left + longestStringWidth + 3), (int)(top + boxHeight + 3), (int)background);
        Gui.func_73734_a((int)(left - 4), (int)(top - 3), (int)(left - 3), (int)(top + boxHeight + 3), (int)background);
        Gui.func_73734_a((int)(left + longestStringWidth + 3), (int)(top - 3), (int)(left + longestStringWidth + 4), (int)(top + boxHeight + 3), (int)background);
        int gradient2 = (gradient1 & 0xFFFFFF) >> 1 | gradient1 & 0xFF000000;
        GuiHelper.drawGradientRect(left - 3, top - 3 + 1, zLevel, left - 3 + 1, top + boxHeight + 3 - 1, gradient1, gradient2);
        GuiHelper.drawGradientRect(left + longestStringWidth + 2, top - 3 + 1, zLevel, left + longestStringWidth + 3, top + boxHeight + 3 - 1, gradient1, gradient2);
        GuiHelper.drawGradientRect(left - 3, top - 3, zLevel, left + longestStringWidth + 3, top - 3 + 1, gradient1, gradient1);
        GuiHelper.drawGradientRect(left - 3, top + boxHeight + 2, zLevel, left + longestStringWidth + 3, top + boxHeight + 3, gradient2, gradient2);
        for (String line : tooltipData) {
            if (!centerText) {
                fontRenderer.func_175063_a(line, (float)left, (float)top, -1);
            } else {
                GuiHelper.drawCenteredString(line, left + longestStringWidth / 2, top, -1);
            }
            top += 10;
        }
        GlStateManager.func_179121_F();
        if (!lighting) {
            RenderHelper.func_74518_a();
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        return Optional.of(new int[]{left - 4, top - 4, left + longestStringWidth + 4, top + boxHeight + 4});
    }

    public static Optional<int[]> renderTooltip(int x, int y, Collection<String> tooltipData, int gradient1, int background, int alpha, boolean centerBox, boolean centerText) {
        return GuiHelper.renderTooltip(x, y, tooltipData, gradient1, background, alpha, centerBox, centerText, 300.0f);
    }

    public static void drawString(String text, float x, float y, int color) {
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        fontRenderer.func_175065_a(text, x, y, color, false);
    }

    public static int getStringWidth(String text) {
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        return fontRenderer.func_78256_a(text);
    }

    public static void drawCenteredString(String text, float x, float y, int color) {
        GuiHelper.drawCenteredString(text, x, y, color, false);
    }

    public static void drawCenteredString(String text, float x, float y, int color, boolean dropShadow) {
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        fontRenderer.func_175065_a(text, x - (float)(fontRenderer.func_78256_a(text) / 2), y, color, dropShadow);
    }

    public static void drawCenteredSplitString(String text, float x, float y, int maxLength, int color) {
        GuiHelper.drawCenteredSplitString(text, x, y, maxLength, color, true);
    }

    public static void drawCenteredSplitString(String text, float x, float y, int maxLength, int color, boolean dropShadow) {
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        int textWidth = fontRenderer.func_78256_a(text);
        int numLines = Math.max(1, (int)Math.ceil((float)textWidth / (float)maxLength));
        int lineWidth = text.length() / numLines;
        ArrayList<String> splitStrings = new ArrayList<String>(numLines);
        int lastIndex = 0;
        for (int i = 0; i < numLines - 1; ++i) {
            int spaceIndex = text.indexOf(" ", lastIndex + lineWidth);
            if (spaceIndex <= -1) continue;
            splitStrings.add(text.substring(lastIndex, spaceIndex + 1));
            lastIndex = spaceIndex + 1;
        }
        if (lastIndex < text.length()) {
            splitStrings.add(text.substring(lastIndex));
        }
        numLines = splitStrings.size();
        int currentY = (int)y - 6 * (numLines - 1);
        for (int i = 0; i < numLines; ++i) {
            GuiHelper.drawCenteredString((String)splitStrings.get(i), x, currentY, color, dropShadow);
            currentY += 12;
        }
    }

    public static void drawCenteredLimitedString(String text, float x, float y, int maxLength, int color) {
        GuiHelper.drawCenteredString(GuiHelper.getLimitedString(text, maxLength), x, y, color, true);
    }

    public static String getLimitedString(String text, int maxLength) {
        String ellipses = "...";
        if (maxLength <= 3) {
            return ellipses;
        }
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        int textLength = text.length();
        String drawText = text;
        if (textLength >= 4) {
            int textWidth = 0;
            for (int i = 0; i < text.length(); ++i) {
                if ((textWidth += fontRenderer.func_78263_a(text.charAt(i))) <= maxLength) continue;
                drawText = text.substring(0, i - 3) + ellipses;
                break;
            }
        }
        return drawText;
    }

    public static List<String> splitString(String text, int maxLength) {
        ArrayList<String> splitString = new ArrayList<String>();
        if (text.isEmpty()) {
            splitString.add("");
        } else {
            String[] lines;
            FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
            for (String line : lines = text.split("\n")) {
                splitString.addAll(fontRenderer.func_78271_c(line, maxLength));
            }
        }
        return splitString;
    }

    public static String removeNewLine(String string) {
        int length = string.length();
        if (length > 0 && string.charAt(length - 1) == '\n') {
            return string.substring(0, length - 1);
        }
        return string;
    }

    public static void drawGradientRect(int left, int top, float zLevel, int right, int bottom, int startColour, int endColour) {
        GuiHelper.drawGradientRect(left, top, zLevel, right, bottom, startColour, endColour, false);
    }

    public static void drawGradientRect(int left, int top, float zLevel, int right, int bottom, int startColour, int endColour, boolean horizontal) {
        float startAlpha = (float)(startColour >> 24 & 0xFF) / 255.0f;
        float startRed = (float)(startColour >> 16 & 0xFF) / 255.0f;
        float startGreen = (float)(startColour >> 8 & 0xFF) / 255.0f;
        float startBlue = (float)(startColour & 0xFF) / 255.0f;
        float endAlpha = (float)(endColour >> 24 & 0xFF) / 255.0f;
        float endRed = (float)(endColour >> 16 & 0xFF) / 255.0f;
        float endGreen = (float)(endColour >> 8 & 0xFF) / 255.0f;
        float endBlue = (float)(endColour & 0xFF) / 255.0f;
        GuiHelper.drawGradientRect(left, top, zLevel, right, bottom, new Vector4f(startRed, startGreen, startBlue, startAlpha), new Vector4f(endRed, endGreen, endBlue, endAlpha), horizontal);
    }

    public static void drawGradientRect(int left, int top, float zLevel, int right, int bottom, Vector4f startColour, Vector4f endColour, boolean horizontal) {
        float startAlpha = startColour.getW();
        float startRed = startColour.getX();
        float startGreen = startColour.getY();
        float startBlue = startColour.getZ();
        float endAlpha = endColour.getW();
        float endRed = endColour.getX();
        float endGreen = endColour.getY();
        float endBlue = endColour.getZ();
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GlStateManager.func_179118_c();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179103_j((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        buffer.func_181662_b((double)left, (double)top, (double)zLevel).func_181666_a(startRed, startGreen, startBlue, startAlpha).func_181675_d();
        if (horizontal) {
            buffer.func_181662_b((double)left, (double)bottom, (double)zLevel).func_181666_a(startRed, startGreen, startBlue, startAlpha).func_181675_d();
        } else {
            buffer.func_181662_b((double)left, (double)bottom, (double)zLevel).func_181666_a(endRed, endGreen, endBlue, endAlpha).func_181675_d();
        }
        buffer.func_181662_b((double)right, (double)bottom, (double)zLevel).func_181666_a(endRed, endGreen, endBlue, endAlpha).func_181675_d();
        if (horizontal) {
            buffer.func_181662_b((double)right, (double)top, (double)zLevel).func_181666_a(endRed, endGreen, endBlue, endAlpha).func_181675_d();
        } else {
            buffer.func_181662_b((double)right, (double)top, (double)zLevel).func_181666_a(startRed, startGreen, startBlue, startAlpha).func_181675_d();
        }
        tessellator.func_78381_a();
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179084_k();
        GlStateManager.func_179141_d();
        GlStateManager.func_179098_w();
    }

    public static void drawBar(double x, double y, double width, double height, float percent, Color color) {
        GuiHelper.drawBar(x, y, width, height, percent, color, false);
    }

    public static void drawBar(double x, double y, double width, double height, float percent, Color color, boolean flip) {
        GlStateManager.func_179091_B();
        GlStateManager.func_179142_g();
        GlStateManager.func_179094_E();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        GlStateManager.func_179090_x();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        double barWidth = width - 6.0;
        buffer.func_181662_b(x, y, 0.0).func_181666_a(0.4f, 0.4f, 0.4f, 1.0f).func_181675_d();
        buffer.func_181662_b(x, y + height, 0.0).func_181666_a(0.4f, 0.4f, 0.4f, 1.0f).func_181675_d();
        buffer.func_181662_b(x + barWidth, y + height, 0.0).func_181666_a(0.4f, 0.4f, 0.4f, 1.0f).func_181675_d();
        buffer.func_181662_b(x + barWidth, y, 0.0).func_181666_a(0.4f, 0.4f, 0.4f, 1.0f).func_181675_d();
        if (percent > 1.0f) {
            percent = 1.0f;
        }
        float curWidth = (float)((double)percent * barWidth);
        if (flip) {
            buffer.func_181662_b(x + (barWidth - (double)curWidth), y, 0.0).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).func_181675_d();
            buffer.func_181662_b(x + (barWidth - (double)curWidth), y + height, 0.0).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).func_181675_d();
            buffer.func_181662_b(x + barWidth, y + height, 0.0).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).func_181675_d();
            buffer.func_181662_b(x + barWidth, y, 0.0).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).func_181675_d();
        } else {
            buffer.func_181662_b(x, y, 0.0).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).func_181675_d();
            buffer.func_181662_b(x, y + height, 0.0).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).func_181675_d();
            buffer.func_181662_b(x + (double)curWidth, y + height, 0.0).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).func_181675_d();
            buffer.func_181662_b(x + (double)curWidth, y, 0.0).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).func_181675_d();
        }
        tessellator.func_78381_a();
        GlStateManager.func_179121_F();
        GlStateManager.func_179098_w();
        GlStateManager.func_179101_C();
        GlStateManager.func_179119_h();
    }

    public static void drawRectWithSemicircleEnds(double x, double y, double z, double w, double h, int segments, Color color) {
        GuiHelper.prepareSmoothDrawing(color);
        double segment = Math.PI / (double)segments;
        double rad = h / 2.0;
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        for (int pass = 1; pass <= 2; ++pass) {
            double dy;
            double dx;
            int i;
            if (pass == 2 && color == Color.WHITE) {
                GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA_SATURATE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            } else {
                GlStateManager.func_179112_b((int)770, (int)771);
            }
            GL11.glBegin((int)6);
            for (i = 0; i <= segments; ++i) {
                dx = -Math.sin(segment * (double)i) * rad;
                dy = Math.cos(segment * (double)i) * rad;
                GL11.glVertex3d((double)dx, (double)(dy + rad), (double)0.0);
            }
            GL11.glEnd();
            GL11.glBegin((int)6);
            for (i = 0; i <= segments; ++i) {
                dx = Math.sin(segment * (double)i) * rad;
                dy = Math.cos(segment * (double)i) * rad;
                GL11.glVertex3d((double)(w + dx), (double)(dy + rad), (double)0.0);
            }
            GL11.glEnd();
            GL11.glBegin((int)7);
            GL11.glVertex3d((double)0.0, (double)0.0, (double)0.0);
            GL11.glVertex3d((double)w, (double)0.0, (double)0.0);
            GL11.glVertex3d((double)w, (double)h, (double)0.0);
            GL11.glVertex3d((double)0.0, (double)h, (double)0.0);
            GL11.glEnd();
        }
        GuiHelper.endSmoothDrawing();
    }

    public static void drawCircle(double x, double y, double z, double d, int segments, Color color) {
        GuiHelper.drawEllipse(x, y, z, d, d, segments, color);
    }

    public static void drawEllipse(double x, double y, double z, double w, double h, int segments, Color color) {
        GuiHelper.prepareSmoothDrawing(color);
        double segment = Math.PI * 2 / (double)segments;
        double wr = w / 2.0;
        double hr = h / 2.0;
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        for (int pass = 1; pass <= 2; ++pass) {
            if (pass == 2 && color == Color.WHITE) {
                GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA_SATURATE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            } else {
                GlStateManager.func_179112_b((int)770, (int)771);
            }
            GL11.glBegin((int)6);
            for (int i = 0; i <= segments; ++i) {
                double dx = Math.sin(segment * (double)i) * wr;
                double dy = Math.cos(segment * (double)i) * hr;
                GL11.glVertex3d((double)(dx + wr), (double)(dy + hr), (double)0.0);
            }
            GL11.glEnd();
        }
        GuiHelper.endSmoothDrawing();
    }

    public static void prepareSmoothDrawing(Color color) {
        GlStateManager.func_179094_E();
        GL11.glEnable((int)2881);
        GL11.glHint((int)3155, (int)4354);
        GlStateManager.func_179129_p();
        GlStateManager.func_179090_x();
        GlStateManager.func_179141_d();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179131_c((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f), (float)((float)color.getAlpha() / 255.0f));
        GlStateManager.func_179097_i();
        GlStateManager.func_179132_a((boolean)false);
    }

    public static void drawQuad(double x1, double y1, double z1, double x2, double y2, double z2, double x3, double y3, double z3, double x4, double y4, double z4, Color color) {
        GuiHelper.prepareSmoothDrawing(color);
        for (int pass = 1; pass <= 2; ++pass) {
            if (pass == 2 && color == Color.WHITE) {
                GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA_SATURATE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            } else {
                GlStateManager.func_179112_b((int)770, (int)771);
            }
            GL11.glBegin((int)7);
            GL11.glVertex3d((double)x1, (double)y1, (double)z1);
            GL11.glVertex3d((double)x2, (double)y2, (double)z2);
            GL11.glVertex3d((double)x3, (double)y3, (double)z3);
            GL11.glVertex3d((double)x4, (double)y4, (double)z4);
            GL11.glEnd();
        }
        GuiHelper.endSmoothDrawing();
    }

    public static void endSmoothDrawing() {
        GL11.glDisable((int)2881);
        GlStateManager.func_179098_w();
        GlStateManager.func_179121_F();
        GlStateManager.func_179112_b((int)770, (int)771);
    }

    public static void drawEntity(EntityLivingBase ent, int x, int y, float scale, float rotationYaw, float rotationPitch) {
        GlStateManager.func_179142_g();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)x, (float)y, (float)50.0f);
        GlStateManager.func_179152_a((float)(-scale), (float)scale, (float)scale);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        float f2 = ent.field_70761_aq;
        float f3 = ent.field_70177_z;
        float f4 = ent.field_70125_A;
        float f5 = ent.field_70758_at;
        float f6 = ent.field_70759_as;
        GlStateManager.func_179114_b((float)135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        RenderHelper.func_74519_b();
        GlStateManager.func_179114_b((float)-135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(-((float)Math.atan(rotationPitch / 40.0f)) * 20.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        ent.field_70761_aq = (float)Math.atan(rotationYaw / 40.0f) * 20.0f;
        ent.field_70177_z = (float)Math.atan(rotationYaw / 40.0f) * 40.0f;
        ent.field_70125_A = -((float)Math.atan(rotationPitch / 40.0f)) * 20.0f;
        ent.field_70759_as = ent.field_70177_z;
        ent.field_70758_at = ent.field_70177_z;
        GlStateManager.func_179109_b((float)0.0f, (float)((float)ent.func_70033_W()), (float)0.0f);
        RenderManager renderManager = Minecraft.func_71410_x().func_175598_ae();
        renderManager.field_78735_i = 180.0f;
        renderManager.func_188391_a((Entity)ent, 0.0, 0.0, 0.0, 0.0f, 1.0f, false);
        ent.field_70761_aq = f2;
        ent.field_70177_z = f3;
        ent.field_70125_A = f4;
        ent.field_70758_at = f5;
        ent.field_70759_as = f6;
        GlStateManager.func_179121_F();
        RenderHelper.func_74518_a();
        GlStateManager.func_179101_C();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
        GlStateManager.func_179090_x();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
    }

    public static void drawPokemonInfoChooseMove(PixelmonInGui pokemon, int width, int height, float zLevel) {
        Minecraft mc = Minecraft.func_71410_x();
        GuiHelper.bindPokemonSprite(pokemon, mc);
        GuiHelper.drawImageQuad(width / 2 - 114, height / 2 - 76, 64.0, 64.0f, 0.0, 0.0, 1.0, 1.0, zLevel);
        GuiHelper.drawCenteredString(pokemon.getDisplayName(), width / 2 - 82, height / 2 + 8, 0xFFFFFF);
        EnumType type1 = pokemon.getBaseStats().getType1();
        EnumType type2 = pokemon.getBaseStats().getType2();
        float x = type1.textureX;
        float y = type1.textureY;
        float x1 = 0.0f;
        float y1 = 0.0f;
        if (type2 != null) {
            x1 = type2.textureX;
            y1 = type2.textureY;
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        mc.field_71446_o.func_110577_a(GuiResources.types);
        if (type2 != null && type2 != EnumType.Mystery) {
            GuiHelper.drawImageQuad(width / 2 - 83, height / 2 - 84, 21.0, 21.0f, x1 / 1792.0f, y1 / 768.0f, (x1 + 240.0f) / 1792.0f, (y1 + 240.0f) / 768.0f, zLevel);
            GuiHelper.drawImageQuad(width / 2 - 107, height / 2 - 84, 21.0, 21.0f, x / 1792.0f, y / 768.0f, (x + 240.0f) / 1792.0f, (y + 240.0f) / 768.0f, zLevel);
        } else {
            GuiHelper.drawImageQuad(width / 2 - 93, height / 2 - 84, 21.0, 21.0f, x / 1792.0f, y / 768.0f, (x + 240.0f) / 1792.0f, (y + 240.0f) / 768.0f, zLevel);
        }
        mc.field_71466_p.func_78276_b(I18n.func_135052_a((String)"gui.screenpokechecker.lvl", (Object[])new Object[0]) + " " + pokemon.level, width / 2 - 80, height / 2 - 94, 0xFFFFFF);
        mc.field_71466_p.func_78276_b(I18n.func_135052_a((String)"gui.screenpokechecker.number", (Object[])new Object[0]) + " " + pokemon.getDexNumber(), width / 2 - 122, height / 2 - 94, 0xFFFFFF);
    }

    public static void closeScreen() {
        Keyboard.enableRepeatEvents((boolean)false);
        Minecraft.func_71410_x().field_71439_g.func_71053_j();
    }

    public static void switchFocus(int keyInt, List<GuiTextField> textFields) {
        GuiTextField[] textFieldArray = new GuiTextField[textFields.size()];
        GuiHelper.switchFocus(keyInt, textFields.toArray(textFieldArray));
    }

    public static void switchFocus(int keyInt, GuiTextField ... textFields) {
        if (keyInt == 15) {
            for (int i = 0; i < textFields.length; ++i) {
                GuiTextField textField = textFields[i];
                if (!textField.func_146206_l()) continue;
                textField.func_146195_b(false);
                textFields[(i + 1) % textFields.length].func_146195_b(true);
                return;
            }
            textFields[0].func_146195_b(true);
        }
    }

    public static void drawAttackInfoBox(float zLevel, int width, int height) {
        Minecraft mc = Minecraft.func_71410_x();
        mc.field_71446_o.func_110577_a(GuiResources.cwPanel);
        GlStateManager.func_179124_c((float)0.5f, (float)0.5f, (float)0.5f);
        GuiHelper.drawImageQuad(width / 2 + 100, height / 2 - 90, 100.0, 140.0f, 0.0, 0.0, 1.0, 1.0, zLevel);
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        String text = I18n.func_135052_a((String)"gui.choosemoveset.attackdetails", (Object[])new Object[0]);
        mc.field_71466_p.func_78276_b(text, width + 150 - mc.field_71466_p.func_78256_a(text) / 2, height - 92, 0);
    }

    public static void drawAttackInfoList(Attack a, int width, int height) {
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        int y = height / 2 - 85;
        int x = width / 2 + 105;
        String powerString = I18n.func_135052_a((String)"gui.choosemoveset.power", (Object[])new Object[0]) + ": ";
        powerString = a.getMove().getBasePower() > 0 ? powerString + a.getMove().getBasePower() : powerString + "--";
        fontRenderer.func_78276_b(powerString, x, y + 3, 0);
        String accuracyString = I18n.func_135052_a((String)"gui.battle.accuracy", (Object[])new Object[0]) + ": ";
        accuracyString = a.getMove().getAccuracy() > 0 ? accuracyString + a.getMove().getAccuracy() : accuracyString + "--";
        fontRenderer.func_78276_b(accuracyString, x, y + 13, 0);
        fontRenderer.func_78276_b(I18n.func_135052_a((String)"nbt.pp.name", (Object[])new Object[0]) + " " + a.pp + "/" + a.getMaxPP(), x, y + 23, 0);
        String typeString = I18n.func_135052_a((String)"gui.battle.type", (Object[])new Object[0]) + " ";
        fontRenderer.func_78276_b(typeString, x, y + 33, 0);
        fontRenderer.func_78276_b(a.getMove().getAttackType().getLocalizedName(), x + fontRenderer.func_78256_a(typeString), y + 33, a.getMove().getAttackType().getColor());
        String category = a.getMove().getAttackCategory().getLocalizedName();
        fontRenderer.func_78276_b(category, x, y + 43, 0);
        fontRenderer.func_78279_b(I18n.func_135052_a((String)("attack." + a.getMove().getAttackName().replace(" ", "_").toLowerCase() + ".description"), (Object[])new Object[0]), x, y + 58, 95, 0);
    }

    public static void drawAttackInfoMoveset(Attack attack, int y, int width, int height) {
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        fontRenderer.func_78276_b(I18n.func_135052_a((String)"gui.replaceattack.power", (Object[])new Object[0]), width / 2 - 120, height / 2 + 60, 0xFFFFFF);
        fontRenderer.func_78276_b(I18n.func_135052_a((String)"gui.replaceattack.accuracy", (Object[])new Object[0]), width / 2 - 120, height / 2 + 70, 0xFFFFFF);
        int bpextra = 0;
        int acextra = 0;
        if (attack.getMove().getBasePower() >= 100) {
            bpextra = fontRenderer.func_78263_a('0');
        }
        if (attack.getMove().getAccuracy() >= 100) {
            acextra = fontRenderer.func_78263_a('0');
        }
        String powerString = attack.getMove().getBasePower() > 0 ? "" + attack.getMove().getBasePower() : "--";
        fontRenderer.func_78276_b(powerString, width / 2 - 60 - bpextra, height / 2 + 60, 0xFFFFFF);
        String accuracyString = attack.getMove().getAccuracy() > 0 ? "" + attack.getMove().getAccuracy() : "--";
        fontRenderer.func_78276_b(accuracyString, width / 2 - 60 - acextra, height / 2 + 70, 0xFFFFFF);
        fontRenderer.func_78276_b(attack.getMove().getAttackCategory().getLocalizedName(), width / 2 - 120, height / 2 + 80, 0xFFFFFF);
        fontRenderer.func_78279_b(I18n.func_135052_a((String)("attack." + attack.getMove().getAttackName().toLowerCase().replace(" ", "_") + ".description"), (Object[])new Object[0]), width / 2 - 20, y, 135, 0xFFFFFF);
    }

    public static void drawMoveset(Moveset moveset, int width, int height, float zLevel) {
        Minecraft mc = Minecraft.func_71410_x();
        for (int i = 0; i < moveset.size(); ++i) {
            Attack move = moveset.get(i);
            mc.field_71466_p.func_78276_b(move.getMove().getLocalizedName(), width / 2 + 11, height / 2 - 85 + 22 * i, 0xFFFFFF);
            mc.field_71466_p.func_78276_b(move.pp + "/" + move.getMaxPP(), width / 2 + 90, height / 2 - 83 + 22 * i, 0xFFFFFF);
            float x = move.getMove().getAttackType().textureX;
            float y = move.getMove().getAttackType().textureY;
            mc.field_71446_o.func_110577_a(GuiResources.types);
            GuiHelper.drawImageQuad(width / 2 - 23, height / 2 - 92 + 22 * i, 21.0, 21.0f, x / 1792.0f, y / 768.0f, (x + 240.0f) / 1792.0f, (y + 240.0f) / 768.0f, zLevel);
        }
    }

    public static int toColourValue(float red, float green, float blue, float alpha) {
        int r = (int)(red * 255.0f) & 0xFF;
        int g = (int)(green * 255.0f) & 0xFF;
        int b = (int)(blue * 255.0f) & 0xFF;
        int a = (int)(alpha * 255.0f) & 0xFF;
        int rgb = (a << 24) + (r << 16) + (b << 8) + g;
        return rgb;
    }

    public static EntityPixelmon getEntity(UUID pokemonUUID) {
        Minecraft mc = Minecraft.func_71410_x();
        for (int i = 0; i < mc.field_71441_e.field_72996_f.size(); ++i) {
            EntityPixelmon pokemon;
            Entity e = (Entity)mc.field_71441_e.field_72996_f.get(i);
            if (!(e instanceof EntityPixelmon) || !(pokemon = (EntityPixelmon)e).getPokemonData().getUUID().equals(pokemonUUID)) continue;
            return pokemon;
        }
        return null;
    }

    public static void drawDialogueBox(GuiScreen screen, String name, List<String> chatText, float zLevel) {
        GuiHelper.drawDialogueBox(screen, name, String.join((CharSequence)"\n", chatText), zLevel);
    }

    public static void drawDialogueBox(GuiScreen screen, ITextComponent name, ITextComponent chatText, float zLevel) {
        GuiHelper.drawDialogueBox(screen, name.func_150254_d(), chatText.func_150254_d(), zLevel);
    }

    public static void drawDialogueBox(GuiScreen screen, String name, String chatText, float zLevel) {
        screen.field_146297_k.field_71446_o.func_110577_a(GuiResources.evo);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiHelper.drawImageQuad(screen.field_146294_l / 2 - 120, screen.field_146295_m / 4 - 40, 240.0, 80.0f, 0.0, 0.0, 1.0, 1.0, zLevel);
        screen.field_146297_k.field_71466_p.func_78276_b(name, screen.field_146294_l / 2 - 107, screen.field_146295_m / 4 - 32, 0xFFFFFF);
        int index = 0;
        for (String text : screen.field_146297_k.field_71466_p.func_78271_c(chatText, 200)) {
            screen.field_146297_k.field_71466_p.func_78276_b(text, screen.field_146294_l / 2 - screen.field_146297_k.field_71466_p.func_78256_a(text) / 2, screen.field_146295_m / 4 - 20 + index++ * 12, 0xFFFFFF);
        }
    }

    public static void drawBattleTimer(GuiScreen gui, int time) {
        time = Math.max(time, 0);
        String timerString = I18n.func_135052_a((String)"battlecontroller.afktimer", (Object[])new Object[0]) + time;
        int color = time <= 5 ? 0xFF0000 : 0xFFFFFF;
        gui.func_73731_b(gui.field_146297_k.field_71466_p, timerString, gui.field_146294_l - gui.field_146297_k.field_71466_p.func_78256_a(timerString) - 5, 5, color);
    }

    public static void drawPokemonHoverInfo(Pokemon pokemon, int x, int y) {
        String form = "";
        if (pokemon.getCustomTexture() != "") {
            form = pokemon.getCustomTexture().substring(0, 1).toUpperCase() + pokemon.getCustomTexture().substring(1);
            if (I18n.func_188566_a((String)("customtexture." + pokemon.getCustomTexture() + ".name"))) {
                form = I18n.func_135052_a((String)("customtexture." + pokemon.getCustomTexture() + ".name"), (Object[])new Object[0]);
            }
            form = I18n.func_135052_a((String)"gui.screenpokechecker.form", (Object[])new Object[]{form});
        } else if (I18n.func_188566_a((String)pokemon.getFormEnum().getUnlocalizedName()) && !I18n.func_135052_a((String)pokemon.getFormEnum().getUnlocalizedName(), (Object[])new Object[0]).equals(I18n.func_135052_a((String)"gui.trainereditor.normal", (Object[])new Object[0])) && !I18n.func_135052_a((String)pokemon.getFormEnum().getUnlocalizedName(), (Object[])new Object[0]).equals(I18n.func_135052_a((String)"pixelmon.generic.form.noform", (Object[])new Object[0]))) {
            form = I18n.func_135052_a((String)"gui.screenpokechecker.form", (Object[])new Object[]{I18n.func_135052_a((String)pokemon.getFormEnum().getUnlocalizedName(), (Object[])new Object[0])});
        }
        if (x - 104 < 0) {
            x = 104;
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (!Objects.equals(form, "") && !pokemon.isEgg()) {
            GuiScreen.func_73734_a((int)(x - 104), (int)(y - 2), (int)(x + 2), (int)(y + 30), (int)-1437248170);
        } else {
            GuiScreen.func_73734_a((int)(x - 104), (int)(y - 2), (int)(x + 2), (int)(y + 20), (int)-1437248170);
        }
        String name = pokemon.getDisplayName();
        Minecraft.func_71410_x().field_71466_p.func_78276_b(name, x - 102, y, 0xFFFFFF);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(GuiResources.pixelmonOverlay);
        if (!pokemon.isEgg()) {
            if (pokemon.getGender() != Gender.None) {
                if (pokemon.getGender() == Gender.Male) {
                    Minecraft.func_71410_x().field_71446_o.func_110577_a(GuiResources.male);
                } else if (pokemon.getGender() == Gender.Female) {
                    Minecraft.func_71410_x().field_71446_o.func_110577_a(GuiResources.female);
                }
                GuiHelper.drawImageQuad(Minecraft.func_71410_x().field_71466_p.func_78256_a(name) + x - 101, y, 5.0, 8.0f, 0.0, 0.0, 1.0, 1.0, 0.0f);
            }
            int y2 = y;
            if (form != "") {
                Minecraft.func_71410_x().field_71466_p.func_78276_b(form, x - 102, y + Minecraft.func_71410_x().field_71466_p.field_78288_b, 0xFFFFFF);
                y2 += Minecraft.func_71410_x().field_71466_p.field_78288_b;
            }
            String level = I18n.func_135052_a((String)"gui.screenpokechecker.lvl", (Object[])new Object[0]) + " " + pokemon.getLevel();
            Minecraft.func_71410_x().field_71466_p.func_78276_b(level, x - 101, y2 + Minecraft.func_71410_x().field_71466_p.field_78288_b + 1, 0xFFFFFF);
            String health = pokemon.getHealth() > 0 ? I18n.func_135052_a((String)"nbt.hp.name", (Object[])new Object[0]) + " " + pokemon.getHealth() + "/" + pokemon.getMaxHealth() : I18n.func_135052_a((String)"gui.creativeinv.fainted", (Object[])new Object[0]);
            Minecraft.func_71410_x().field_71466_p.func_78276_b(health, x - 97 + Minecraft.func_71410_x().field_71466_p.func_78256_a(level), y2 + Minecraft.func_71410_x().field_71466_p.field_78288_b + 1, 0xFFFFFF);
            if (!pokemon.getHeldItem().func_190926_b()) {
                Minecraft.func_71410_x().func_175599_af().func_175042_a(pokemon.getHeldItem(), x - 16, y - 1);
            }
        }
    }

    public static void bindPokeballTexture(EnumPokeballs ball) {
        ResourceLocation tex = null;
        switch (ball) {
            case DiveBall: {
                tex = GuiResources.dive;
                break;
            }
            case FastBall: {
                tex = GuiResources.fast;
                break;
            }
            case DuskBall: {
                tex = GuiResources.dusk;
                break;
            }
            case FriendBall: {
                tex = GuiResources.friend;
                break;
            }
            case GreatBall: {
                tex = GuiResources.great;
                break;
            }
            case HealBall: {
                tex = GuiResources.heal;
                break;
            }
            case HeavyBall: {
                tex = GuiResources.heavy;
                break;
            }
            case LevelBall: {
                tex = GuiResources.level;
                break;
            }
            case LoveBall: {
                tex = GuiResources.love;
                break;
            }
            case LuxuryBall: {
                tex = GuiResources.luxury;
                break;
            }
            case MasterBall: {
                tex = GuiResources.master;
                break;
            }
            case MoonBall: {
                tex = GuiResources.moon;
                break;
            }
            case NestBall: {
                tex = GuiResources.nest;
                break;
            }
            case NetBall: {
                tex = GuiResources.net;
                break;
            }
            case DreamBall: {
                tex = GuiResources.dream;
                break;
            }
            case PokeBall: {
                tex = GuiResources.poke;
                break;
            }
            case PremierBall: {
                tex = GuiResources.premier;
                break;
            }
            case RepeatBall: {
                tex = GuiResources.repeat;
                break;
            }
            case SafariBall: {
                tex = GuiResources.safari;
                break;
            }
            case TimerBall: {
                tex = GuiResources.timer;
                break;
            }
            case UltraBall: {
                tex = GuiResources.ultra;
                break;
            }
            case CherishBall: {
                tex = GuiResources.cherish;
                break;
            }
            case GSBall: {
                tex = GuiResources.gs;
                break;
            }
            case LureBall: {
                tex = GuiResources.lure;
                break;
            }
            case ParkBall: {
                tex = GuiResources.park;
                break;
            }
            case QuickBall: {
                tex = GuiResources.quick;
                break;
            }
            case SportBall: {
                tex = GuiResources.sport;
                break;
            }
            case BeastBall: {
                tex = GuiResources.beast;
            }
        }
        Minecraft.func_71410_x().field_71446_o.func_110577_a(tex);
    }

    public static void drawScaledCenteredSplitString(String text, float x, float y, int color, float fontSize, int maxLength, boolean dropShadow) {
        float scalar = fontSize / 16.0f;
        GlStateManager.func_179152_a((float)scalar, (float)scalar, (float)1.0f);
        GuiHelper.drawCenteredSplitString(text, x / scalar, y / scalar, maxLength, color, dropShadow);
        GlStateManager.func_179124_c((float)255.0f, (float)255.0f, (float)255.0f);
        GlStateManager.func_179152_a((float)(1.0f / scalar), (float)(1.0f / scalar), (float)1.0f);
    }

    public static void drawScaledCenteredSplitString(String text, float x, float y, int color, float fontSize, int maxLength) {
        GuiHelper.drawScaledCenteredSplitString(text, x, y, color, fontSize, maxLength, true);
    }

    public static GuiScreen getCurrentScreen() {
        return Minecraft.func_71410_x().field_71462_r;
    }

    public static void bindTexture(ResourceLocation resourceLocation) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(resourceLocation);
    }

    public static void drawBattleCursor(boolean draw, float x, float y, float z) {
        if (draw) {
            CursorHelper.setCursor(CursorHelper.TRANSPARENT_CURSOR);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(GuiResources.battlePointer);
            GuiHelper.drawImageQuad(x, y, 10.5, 9.5f, 0.0, 0.0, 1.0, 1.0, z + 3.0f);
        } else {
            CursorHelper.setCursor(CursorHelper.DEFAULT_CURSOR);
        }
    }
}

