/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.battles;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.MaxMoveConverter;
import com.pixelmonmod.pixelmon.battles.attacks.TargetingInfo;
import com.pixelmonmod.pixelmon.client.ClientProxy;
import com.pixelmonmod.pixelmon.client.ServerStorageDisplay;
import com.pixelmonmod.pixelmon.client.camera.GuiChattableCamera;
import com.pixelmonmod.pixelmon.client.gui.GuiEvolve;
import com.pixelmonmod.pixelmon.client.gui.GuiHelper;
import com.pixelmonmod.pixelmon.client.gui.GuiItemDrops;
import com.pixelmonmod.pixelmon.client.gui.GuiMegaItem;
import com.pixelmonmod.pixelmon.client.gui.GuiPixelmonOverlay;
import com.pixelmonmod.pixelmon.client.gui.battles.ClientBattleManager;
import com.pixelmonmod.pixelmon.client.gui.battles.PixelmonInGui;
import com.pixelmonmod.pixelmon.client.gui.battles.battleScreens.BattleLogElement;
import com.pixelmonmod.pixelmon.client.gui.battles.battleScreens.BattleScreen;
import com.pixelmonmod.pixelmon.client.gui.battles.battleScreens.ChooseAttack;
import com.pixelmonmod.pixelmon.client.gui.battles.battleScreens.MegaEvolution;
import com.pixelmonmod.pixelmon.client.gui.battles.battleScreens.old_gui.chooseMove.ChooseEther;
import com.pixelmonmod.pixelmon.client.gui.battles.battleScreens.old_gui.chooseMove.ReplaceAttack;
import com.pixelmonmod.pixelmon.client.gui.battles.battleScreens.screens.ChooseTargets;
import com.pixelmonmod.pixelmon.client.gui.battles.battleScreens.screens.LevelUpScreen;
import com.pixelmonmod.pixelmon.client.gui.battles.battleScreens.screens.WaitingScreen;
import com.pixelmonmod.pixelmon.client.gui.battles.battleScreens.screens.bag.ApplyToPokemon;
import com.pixelmonmod.pixelmon.client.gui.battles.battleScreens.screens.bag.ChooseBag;
import com.pixelmonmod.pixelmon.client.gui.battles.battleScreens.screens.pokemon.ChoosePokemon;
import com.pixelmonmod.pixelmon.client.gui.battles.battleScreens.screens.pokemon.EnforcedSwitch;
import com.pixelmonmod.pixelmon.client.gui.battles.battleScreens.yesNo.YesNoForfeit;
import com.pixelmonmod.pixelmon.client.gui.battles.battleScreens.yesNo.YesNoReplaceMove;
import com.pixelmonmod.pixelmon.client.gui.battles.pokemonOverlays.OverlayBase;
import com.pixelmonmod.pixelmon.client.gui.battles.pokemonOverlays.OverlayNew;
import com.pixelmonmod.pixelmon.client.gui.elements.GuiChatExtension;
import com.pixelmonmod.pixelmon.client.music.BattleMusic;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.BattleGuiClosed;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.RemoveSpectator;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.gui.GuiBattleUpdatePacket;
import com.pixelmonmod.pixelmon.enums.EnumType;
import com.pixelmonmod.pixelmon.enums.battle.AttackCategory;
import com.pixelmonmod.pixelmon.enums.battle.BattleMode;
import com.pixelmonmod.pixelmon.enums.battle.EnumBattleType;
import com.pixelmonmod.pixelmon.storage.ClientData;
import com.pixelmonmod.pixelmon.util.helpers.CursorHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.input.Keyboard;

public class GuiBattle
extends GuiChattableCamera {
    private int guiWidth = 300;
    private int guiHeight = 60;
    public ClientBattleManager bm;
    ArrayList<BattleScreen> screenList = new ArrayList();
    BattleScreen currentScreen = null;
    public OverlayBase pokemonOverlay = null;
    private GuiButton stopSpectateButton = null;
    public BattleLogElement battleLog;
    public boolean showGlobalInfo = true;
    boolean first = true;
    public int mouseOverButton = 0;
    private int shutdownDelay = 0;
    private int tick;

    public GuiBattle() {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        player.func_70637_d(false);
        player.func_70095_a(false);
        player.field_70702_br = 0.0f;
        player.field_191988_bg = 0.0f;
        GuiPixelmonOverlay.isVisible = false;
        this.bm = ClientProxy.battleManager;
        this.battleLog = new BattleLogElement(this.bm);
        this.screenList.add(new ApplyToPokemon(this, BattleMode.ApplyToPokemon));
        this.screenList.add(new ChooseAttack(this, BattleMode.ChooseAttack));
        this.screenList.add(new ChooseBag(this, BattleMode.ChooseBag));
        this.screenList.add(new ChooseEther(this));
        this.screenList.add(new ChoosePokemon(this, BattleMode.ChoosePokemon));
        this.screenList.add(new ChooseTargets(this, BattleMode.ChooseTargets));
        this.screenList.add(new EnforcedSwitch(this, BattleMode.EnforcedSwitch));
        this.screenList.add(new LevelUpScreen(this, BattleMode.LevelUp));
        this.screenList.add(new MegaEvolution(this));
        this.screenList.add(new ReplaceAttack(this));
        this.screenList.add(new YesNoForfeit(this));
        this.screenList.add(new YesNoReplaceMove(this));
        this.screenList.add(new WaitingScreen(this, BattleMode.Waiting));
        this.screenList.add(new ChooseAttack(this, BattleMode.MainMenu));
        if (this.bm.teamPokemon != null && this.bm.displayedEnemyPokemon != null) {
            this.pokemonOverlay = new OverlayNew(this);
        }
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        if (this.bm.isSpectating) {
            this.addStopSpectateButton();
        }
        for (GuiScreen guiScreen : this.screenList) {
            guiScreen.func_146280_a(this.field_146297_k, this.field_146294_l, this.field_146295_m);
        }
        if (this.pokemonOverlay instanceof OverlayNew) {
            this.pokemonOverlay.func_146280_a(this.field_146297_k, this.field_146294_l, this.field_146295_m);
        }
    }

    private void addStopSpectateButton() {
        this.stopSpectateButton = new GuiButton(0, this.field_146294_l / 2 - 50, 0, 100, 20, I18n.func_135052_a((String)"gui.spectate.stopspectate", (Object[])new Object[0]));
        this.field_146292_n.add(this.stopSpectateButton);
    }

    public void restoreSettingsAndClose() {
        GuiBattle.restoreSettingsAndCloseStatic(this.bm);
    }

    public static void restoreSettingsAndCloseStatic(@Nullable ClientBattleManager bm) {
        Minecraft mc = Minecraft.func_71410_x();
        if (bm != null) {
            bm.restoreSettingsAndClose();
        }
        mc.field_71439_g.func_71053_j();
        GuiPixelmonOverlay.isVisible = true;
        if (ServerStorageDisplay.bossDrops != null) {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiItemDrops());
        } else if (bm != null && !bm.evolveList.isEmpty()) {
            mc.func_147108_a((GuiScreen)new GuiEvolve());
        } else if (ClientData.openMegaItemGui >= 0) {
            mc.func_147108_a((GuiScreen)new GuiMegaItem(ClientData.openMegaItemGui > 0));
        } else {
            Pixelmon.network.sendToServer((IMessage)new BattleGuiClosed());
        }
        BattleMusic.endBattleMusic();
        CursorHelper.setCursor(CursorHelper.DEFAULT_CURSOR);
    }

    @Override
    public void func_146281_b() {
        super.func_146281_b();
        if (this.bm.battleEnded && !this.bm.hasNewAttacks()) {
            Pixelmon.network.sendToServer((IMessage)new BattleGuiClosed());
        }
    }

    private void selectScreen() {
        for (BattleScreen bs : this.screenList) {
            if (!bs.isScreen()) continue;
            this.currentScreen = bs;
            break;
        }
    }

    public void selectScreenImmediate(BattleMode mode) {
        this.bm.mode = mode;
        this.selectScreen();
    }

    private void drawPokemonOverlays() {
        if (this.pokemonOverlay != null) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.pokemonOverlay.draw(this.field_146294_l, this.field_146295_m, this.guiWidth, this.guiHeight);
        }
    }

    public static void drawHealthBar(int x, int y, int width, int height, float health, int maxHealth) {
        float b;
        float g;
        float r;
        GlStateManager.func_179091_B();
        GlStateManager.func_179142_g();
        GlStateManager.func_179094_E();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        GlStateManager.func_179090_x();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        int barWidth = width - 6;
        buffer.func_181662_b((double)x, (double)y, 0.0).func_181666_a(0.4f, 0.4f, 0.4f, 1.0f).func_181675_d();
        buffer.func_181662_b((double)x, (double)(y + height), 0.0).func_181666_a(0.4f, 0.4f, 0.4f, 1.0f).func_181675_d();
        buffer.func_181662_b((double)(x + barWidth), (double)(y + height), 0.0).func_181666_a(0.4f, 0.4f, 0.4f, 1.0f).func_181675_d();
        buffer.func_181662_b((double)(x + barWidth), (double)y, 0.0).func_181666_a(0.4f, 0.4f, 0.4f, 1.0f).func_181675_d();
        float Percent = health / (float)maxHealth;
        if (Percent > 1.0f) {
            Percent = 1.0f;
        }
        float CurWidth = Percent * (float)barWidth;
        if (health <= (float)(maxHealth / 5)) {
            r = 0.8f;
            g = 0.0f;
            b = 0.0f;
        } else if (health <= (float)(maxHealth / 2)) {
            r = 1.0f;
            g = 1.0f;
            b = 0.4f;
        } else {
            r = 0.2f;
            g = 1.0f;
            b = 0.2f;
        }
        buffer.func_181662_b((double)x, (double)y, 0.0).func_181666_a(r, g, b, 1.0f).func_181675_d();
        buffer.func_181662_b((double)x, (double)(y + height), 0.0).func_181666_a(r, g, b, 1.0f).func_181675_d();
        buffer.func_181662_b((double)((float)x + CurWidth), (double)(y + height), 0.0).func_181666_a(r, g, b, 1.0f).func_181675_d();
        buffer.func_181662_b((double)((float)x + CurWidth), (double)y, 0.0).func_181666_a(r, g, b, 1.0f).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179121_F();
        GlStateManager.func_179098_w();
        GlStateManager.func_179101_C();
        GlStateManager.func_179119_h();
    }

    public void drawButton(BattleMode mode, int x, int y, int buttonWidth, int buttonHeight, String string, int mouseX, int mouseY, int ind) {
        this.drawButton(mode, x, y, buttonWidth, buttonHeight, string, false, mouseX, mouseY, ind);
    }

    public void drawButton(BattleMode mode, int x, int y, int buttonWidth, int buttonHeight, String string, boolean isDisabled, int mouseX, int mouseY, int ind) {
        if (mode == BattleMode.MainMenu) {
            if (mouseX > x && mouseX < x + buttonWidth && mouseY > y && mouseY < y + buttonHeight) {
                GuiHelper.drawImageQuad(x, y, buttonWidth, buttonHeight, 0.604687511920929, 0.3291666805744171, 0.7640625238418579, 0.40833333134651184, this.field_73735_i);
            }
        } else if (mode == BattleMode.ChooseAttack) {
            GuiHelper.drawImageQuad(x, y, buttonWidth, buttonHeight, 0.321875f, 0.3166666626930237, 0.614062488079071, 0.4208333194255829, this.field_73735_i);
            if (mouseX > x && mouseX < x + buttonWidth && mouseY > y && mouseY < y + buttonHeight) {
                GuiHelper.drawImageQuad(x + 2, y + 2, buttonWidth - 5, buttonHeight - 4, 0.0359375f, 0.3229166567325592, 0.3125, 0.40625, this.field_73735_i);
                this.mouseOverButton = ind;
            }
        }
        if (!isDisabled) {
            this.func_73732_a(this.field_146297_k.field_71466_p, string, x + buttonWidth / 2, y + buttonHeight / 2 - 3, 0xFFFFFF);
        } else {
            this.field_146297_k.field_71466_p.func_78276_b(string, x + buttonWidth / 2 - this.field_146297_k.field_71466_p.func_78256_a(string) / 2, y + buttonHeight / 2 - 3, 0xCCCCCC);
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    @Override
    public void func_146282_l() {
        if (Keyboard.getEventKeyState()) {
            int i = Keyboard.getEventKey();
            char c0 = Keyboard.getEventCharacter();
            this.func_73869_a(c0, i);
        }
        super.func_146282_l();
    }

    @Override
    protected void func_73869_a(char key, int keyCode) {
        super.func_73869_a(key, keyCode);
        if (GuiChatExtension.chatOpen || keyCode != 28 || this.bm.hasMoreMessages()) {
            // empty if block
        }
        if (keyCode == 1 && this.bm.mode == BattleMode.ChooseTargets) {
            this.bm.selectedAttack = -1;
            this.bm.mode = BattleMode.MainMenu;
        }
    }

    @Override
    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) {
        try {
            super.func_73864_a(mouseX, mouseY, mouseButton);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.currentScreen != null) {
            this.currentScreen.click(this.field_146294_l, this.field_146295_m, mouseX, mouseY);
        }
    }

    @Override
    public void func_146278_c(int par1) {
    }

    @Override
    public void func_146276_q_() {
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float par3) {
        super.func_73863_a(mouseX, mouseY, par3);
        this.func_146276_q_();
        if (this.bm.mode != BattleMode.YesNoReplaceMove && !this.bm.hasMoreMessages()) {
            if (this.bm.hasLevelUps()) {
                if (this.bm.mode != BattleMode.LevelUp) {
                    this.bm.oldMode = this.bm.mode;
                    this.bm.mode = BattleMode.LevelUp;
                }
            } else if (this.bm.hasNewAttacks() && this.bm.mode != BattleMode.ReplaceAttack) {
                this.bm.oldMode = this.bm.mode;
                this.bm.mode = BattleMode.ReplaceAttack;
            }
        }
        this.selectScreen();
        if (this.first) {
            this.first = false;
            if (ClientProxy.camera != null && !this.bm.battleEnded) {
                this.bm.setCameraToPlayer();
            }
        }
        if (this.isBattleComplete() && this.bm.battleType != EnumBattleType.Raid) {
            this.restoreSettingsAndClose();
            return;
        }
        RenderHelper.func_74518_a();
        GlStateManager.func_179147_l();
        if (this.bm.mode != BattleMode.LevelUp && this.bm.mode != BattleMode.ReplaceAttack && this.bm.mode != BattleMode.YesNoReplaceMove && (this.bm.mode == BattleMode.Waiting || this.bm.mode == BattleMode.MainMenu || this.bm.mode == BattleMode.ChooseAttack || this.bm.mode == BattleMode.ChooseTargets || this.bm.mode == BattleMode.EnforcedSwitch)) {
            this.drawPokemonOverlays();
        }
        if (this.currentScreen != null) {
            this.currentScreen.drawScreen(this.field_146294_l, this.field_146295_m, mouseX, mouseY);
        }
        if (this.bm.isSpectating) {
            if (this.stopSpectateButton == null) {
                this.addStopSpectateButton();
            }
            this.stopSpectateButton.func_191745_a(this.field_146297_k, mouseX, mouseY, 1.0f);
        }
        if (this.bm.afkOn && this.bm.afkTime <= 0) {
            this.bm.afkActive = true;
            this.bm.afkSelectMove();
            this.bm.resetAFKTime();
        }
        if (this.showGlobalInfo && this.bm.battleControllerIndex > -1) {
            GuiHelper.drawCenteredSquashedString(this.field_146297_k.field_71466_p, I18n.func_135052_a((String)"gui.battle.turn", (Object[])new Object[]{this.bm.battleTurn + 1}), false, 75.0, this.field_146294_l - 40, this.field_146295_m - 69, 0xFFFFFF, false);
            String timeString = this.currentScreen instanceof ChooseAttack ? (this.bm.afkOn ? I18n.func_135052_a((String)"gui.battle.turntimer", (Object[])new Object[]{this.bm.afkTime, this.bm.afkTime == 1 ? "" : "s"}) : I18n.func_135052_a((String)"gui.battle.noturntimer", (Object[])new Object[0])) : "Waiting...";
            GuiHelper.drawCenteredSquashedString(this.field_146297_k.field_71466_p, timeString, false, 75.0, this.field_146294_l - 40, this.field_146295_m - 53, 0xFFFFFF, false);
            GuiHelper.drawCenteredSquashedString(this.field_146297_k.field_71466_p, this.bm.weather == null ? I18n.func_135052_a((String)"gui.battle.noweather", (Object[])new Object[0]) : this.bm.weather.getLocalizedName(), false, 75.0, this.field_146294_l - 40, this.field_146295_m - 37, 0xFFFFFF, false);
            GuiHelper.drawCenteredSquashedString(this.field_146297_k.field_71466_p, this.bm.terrain == null ? I18n.func_135052_a((String)"gui.battle.noterrain", (Object[])new Object[0]) : this.bm.terrain.getLocalizedName(), false, 75.0, this.field_146294_l - 40, this.field_146295_m - 21, 0xFFFFFF, false);
        }
        this.showGlobalInfo = true;
        GlStateManager.func_179101_C();
        RenderHelper.func_74518_a();
        GlStateManager.func_179140_f();
        GlStateManager.func_179097_i();
        if (Pixelmon.devEnvironment && Minecraft.func_71410_x().field_71474_y.field_74330_P) {
            int centerW = this.field_146294_l / 2;
            int centerH = this.field_146295_m / 2;
            GuiHelper.drawCenteredString("x: " + mouseX + ", y: " + mouseY, mouseX, mouseY - 29, 1048575);
            GuiHelper.drawCenteredString("xcenter: " + (mouseX - centerW), mouseX, mouseY - 19, 1048575);
            GuiHelper.drawCenteredString("ycenter: " + (mouseY - centerH) + ", " + (this.field_146295_m - mouseY), mouseX, mouseY - 9, 1048575);
            GuiHelper.drawCenteredString("width: " + this.field_146294_l + ", height: " + this.field_146295_m, centerW, 20.0f, 1048575);
            GuiHelper.drawCenteredString("mode: " + this.bm.mode.name(), centerW, 40.0f, 1048575);
        }
    }

    private boolean isBattleComplete() {
        if (!(this.bm.hasMoreMessages() || this.bm.hasMoreTasks() || this.bm.hasLevelUps() || this.bm.hasNewAttacks() || this.bm.choosingPokemon || !this.bm.battleEnded)) {
            ++this.shutdownDelay;
            return this.shutdownDelay > 15;
        }
        this.shutdownDelay = 0;
        return false;
    }

    @Override
    public void func_73876_c() {
        super.func_73876_c();
        if (this.currentScreen != null) {
            this.currentScreen.func_73876_c();
        }
        ++this.tick;
        if (this.tick++ % 100 == 1) {
            Pixelmon.network.sendToServer((IMessage)new GuiBattleUpdatePacket());
        }
    }

    public int getGuiWidth() {
        return this.guiWidth;
    }

    public int getGuiHeight() {
        return this.guiHeight;
    }

    public boolean canSelectTarget(Attack attack) {
        int allyCount;
        AttackCategory attackCategory = attack.getAttackCategory();
        boolean attackHasZMove = attack.getMove().z != null;
        boolean usingZMove = this.bm.showZMoves;
        int enemyCount = this.bm.displayedEnemyPokemon != null ? this.bm.displayedEnemyPokemon.length : 0;
        int ourCount = this.bm.displayedOurPokemon != null ? this.bm.displayedOurPokemon.length : 0;
        int n = allyCount = this.bm.displayedAllyPokemon != null ? this.bm.displayedAllyPokemon.length : 0;
        if (attackCategory != AttackCategory.STATUS && attackHasZMove && usingZMove && (enemyCount > 1 || ourCount > 1 || allyCount > 0)) {
            return true;
        }
        TargetingInfo info = attack.getMove().getTargetingInfo();
        if (info.hitsOppositeFoe && info.hitsAdjacentFoe && !info.hitsAdjacentAlly && !attack.isAttack("Me First")) {
            return false;
        }
        if (info.hitsSelf && info.hitsAdjacentAlly && !info.hitsAll && this.bm.teamPokemon.length > 1) {
            return true;
        }
        if (!info.hitsSelf && !info.hitsAdjacentFoe && this.bm.teamPokemon.length == 1) {
            return false;
        }
        if (attack.isAttack("Curse") && !this.bm.getCurrentPokemon().getBaseStats().getTypeList().contains(EnumType.Ghost)) {
            return false;
        }
        return !info.hitsAll && !info.hitsSelf && (this.bm.teamPokemon.length > 1 || this.bm.displayedEnemyPokemon.length > 1);
    }

    public boolean setTargeting(PixelmonInGui pig, Attack attack, int opponentTarget, int userTarget) {
        if (this.bm.dynamaxing || pig.pokemonUUID.equals(this.bm.dynamax)) {
            attack = pig.gmaxFactor ? MaxMoveConverter.getGMaxMoveFromAttack(attack, null, pig.species, pig.species.getFormEnum(pig.form)) : MaxMoveConverter.getMaxMoveFromAttack(attack, null);
        }
        for (int i = 0; i < this.bm.targetted.length; ++i) {
            for (int j = 0; j < this.bm.targetted[i].length; ++j) {
                this.bm.targetted[i][j] = false;
            }
        }
        TargetingInfo info = attack.getMove().getTargetingInfo();
        AttackCategory attackCategory = attack.getAttackCategory();
        boolean attackHasZMove = attack.getMove().z != null;
        boolean usingZMove = this.bm.showZMoves;
        if (attackCategory != AttackCategory.STATUS && attackHasZMove && usingZMove) {
            if (opponentTarget == -1 && userTarget == -1 && !attack.isAttack("Last Resort") && info.hitsOppositeFoe && this.bm.currentPokemon < this.bm.targetted[1].length) {
                this.bm.targetted[1][this.bm.currentPokemon] = true;
                return false;
            }
            if (attack.isAttack("Last Resort")) {
                if (opponentTarget == -1 && userTarget == -1) {
                    this.bm.targetted[0][this.bm.currentPokemon] = true;
                } else if (userTarget != -1 && userTarget == this.bm.currentPokemon) {
                    this.bm.targetted[0][this.bm.currentPokemon] = true;
                }
            }
            if (opponentTarget != -1) {
                if (opponentTarget == this.bm.currentPokemon) {
                    this.bm.targetted[1][this.bm.currentPokemon] = true;
                }
                if (opponentTarget == this.bm.currentPokemon + 1) {
                    this.bm.targetted[1][this.bm.currentPokemon + 1] = true;
                }
                if (opponentTarget == this.bm.currentPokemon - 1) {
                    this.bm.targetted[1][this.bm.currentPokemon - 1] = true;
                }
            }
            if (attack.isAttack("Clanging Scales")) {
                if (this.bm.currentPokemon < this.bm.targetted[1].length) {
                    this.bm.targetted[1][this.bm.currentPokemon] = true;
                }
                if (this.bm.currentPokemon - 1 >= 0 && this.bm.currentPokemon - 1 < this.bm.targetted[1].length) {
                    this.bm.targetted[1][this.bm.currentPokemon - 1] = true;
                }
                if (this.bm.currentPokemon + 1 < this.bm.targetted[1].length) {
                    this.bm.targetted[1][this.bm.currentPokemon + 1] = true;
                }
            } else if (userTarget != -1) {
                if (userTarget == this.bm.currentPokemon + 1) {
                    this.bm.targetted[0][this.bm.currentPokemon + 1] = true;
                }
                if (userTarget == this.bm.currentPokemon - 1) {
                    this.bm.targetted[0][this.bm.currentPokemon - 1] = true;
                }
                if (userTarget == this.bm.currentPokemon) {
                    this.bm.targetted[0][this.bm.currentPokemon] = true;
                }
            }
        } else if (info.hitsAll) {
            if (info.hitsOppositeFoe && this.bm.currentPokemon < this.bm.targetted[1].length) {
                this.bm.targetted[1][this.bm.currentPokemon] = true;
            }
            if (info.hitsAdjacentFoe) {
                if (this.bm.currentPokemon - 1 >= 0 && this.bm.currentPokemon - 1 < this.bm.targetted[1].length) {
                    this.bm.targetted[1][this.bm.currentPokemon - 1] = true;
                }
                if (this.bm.currentPokemon + 1 < this.bm.targetted[1].length) {
                    this.bm.targetted[1][this.bm.currentPokemon + 1] = true;
                }
            }
            if (info.hitsExtendedFoe) {
                if (this.bm.currentPokemon - 2 >= 0 && this.bm.currentPokemon - 2 < this.bm.targetted[1].length) {
                    this.bm.targetted[1][this.bm.currentPokemon - 2] = true;
                }
                if (this.bm.currentPokemon + 2 < this.bm.targetted[1].length) {
                    this.bm.targetted[1][this.bm.currentPokemon + 2] = true;
                }
            }
            if (info.hitsSelf) {
                this.bm.targetted[0][this.bm.currentPokemon] = true;
            }
            if (info.hitsAdjacentAlly) {
                if (this.bm.currentPokemon - 1 >= 0) {
                    this.bm.targetted[0][this.bm.currentPokemon - 1] = true;
                }
                if (this.bm.currentPokemon + 1 < this.bm.targetted[0].length) {
                    this.bm.targetted[0][this.bm.currentPokemon + 1] = true;
                }
            }
            if (info.hitsExtendedAlly) {
                if (this.bm.currentPokemon - 2 >= 0) {
                    this.bm.targetted[0][this.bm.currentPokemon - 2] = true;
                }
                if (this.bm.currentPokemon + 2 < this.bm.targetted[0].length) {
                    this.bm.targetted[0][this.bm.currentPokemon + 2] = true;
                }
            }
        } else {
            if (userTarget != -1) {
                if (userTarget == this.bm.currentPokemon && info.hitsSelf) {
                    this.bm.targetted[0][this.bm.currentPokemon] = true;
                }
                if (info.hitsAdjacentAlly) {
                    if (userTarget == this.bm.currentPokemon + 1) {
                        this.bm.targetted[0][this.bm.currentPokemon + 1] = true;
                    }
                    if (userTarget == this.bm.currentPokemon - 1) {
                        this.bm.targetted[0][this.bm.currentPokemon - 1] = true;
                    }
                }
                if (info.hitsExtendedAlly) {
                    if (userTarget == this.bm.currentPokemon + 2) {
                        this.bm.targetted[0][this.bm.currentPokemon + 2] = true;
                    }
                    if (userTarget == this.bm.currentPokemon - 2) {
                        this.bm.targetted[0][this.bm.currentPokemon - 2] = true;
                    }
                }
            }
            if (opponentTarget != -1) {
                if (this.bm.rules.battleType == EnumBattleType.Horde || this.bm.rules.battleType == EnumBattleType.Raid) {
                    for (int i = 0; i < this.bm.targetted[1].length; ++i) {
                        if (i != opponentTarget) continue;
                        this.bm.targetted[1][i] = true;
                    }
                }
                if (info.hitsOppositeFoe && opponentTarget == this.bm.currentPokemon) {
                    this.bm.targetted[1][this.bm.currentPokemon] = true;
                }
                if (info.hitsAdjacentFoe) {
                    if (opponentTarget == this.bm.currentPokemon + 1) {
                        this.bm.targetted[1][this.bm.currentPokemon + 1] = true;
                    }
                    if (opponentTarget == this.bm.currentPokemon - 1) {
                        this.bm.targetted[1][this.bm.currentPokemon - 1] = true;
                    }
                }
                if (info.hitsExtendedFoe) {
                    if (opponentTarget == this.bm.currentPokemon + 2) {
                        this.bm.targetted[1][this.bm.currentPokemon + 2] = true;
                    }
                    if (opponentTarget == this.bm.currentPokemon - 2) {
                        this.bm.targetted[1][this.bm.currentPokemon - 2] = true;
                    }
                }
            }
            if (userTarget == -1 && opponentTarget == -1) {
                boolean isCurseUser;
                boolean bl = isCurseUser = attack.isAttack("Curse") && !this.bm.getCurrentPokemon().getBaseStats().getTypeList().contains(EnumType.Ghost);
                if (info.hitsSelf || isCurseUser) {
                    this.bm.targetted[0][this.bm.currentPokemon] = true;
                } else if (info.hitsOppositeFoe && this.bm.currentPokemon < this.bm.targetted[1].length) {
                    this.bm.targetted[1][this.bm.currentPokemon] = true;
                }
            }
        }
        if (userTarget >= 0) {
            return this.bm.targetted[0].length > userTarget && this.bm.targetted[0][userTarget];
        }
        if (opponentTarget >= 0) {
            return this.bm.targetted[1].length > opponentTarget && this.bm.targetted[1][opponentTarget];
        }
        return false;
    }

    public boolean isTargeted(UUID uuid) {
        int i;
        for (i = 0; i < this.bm.teamPokemon.length; ++i) {
            if (!Objects.equals(this.bm.teamPokemon[i], uuid)) continue;
            return this.bm.targetted[0].length > i && this.bm.targetted[0][i];
        }
        for (i = 0; i < this.bm.displayedEnemyPokemon.length; ++i) {
            if (!Objects.equals(this.bm.displayedEnemyPokemon[i].pokemonUUID, uuid)) continue;
            return this.bm.targetted[1].length > i && this.bm.targetted[1][i];
        }
        return false;
    }

    public boolean showTargeting() {
        return this.bm.teamPokemon.length != 1 || this.bm.displayedEnemyPokemon.length != 1;
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (button.field_146127_k == 0) {
            this.bm.endSpectate();
            Pixelmon.network.sendToServer((IMessage)new RemoveSpectator(this.bm.battleControllerIndex, this.field_146297_k.field_71439_g.func_110124_au()));
        }
    }

    public void func_175273_b(Minecraft mcIn, int w, int h) {
        super.func_175273_b(mcIn, w, h);
        for (GuiScreen guiScreen : this.screenList) {
            guiScreen.func_175273_b(mcIn, w, h);
        }
        this.pokemonOverlay.func_175273_b(this.field_146297_k, this.field_146294_l, this.field_146295_m);
    }
}

