/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.battles.battleScreens;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.client.ClientProxy;
import com.pixelmonmod.pixelmon.client.gui.GuiHelper;
import com.pixelmonmod.pixelmon.client.gui.battles.GuiBattle;
import com.pixelmonmod.pixelmon.client.gui.battles.battleScreens.BattleScreen;
import com.pixelmonmod.pixelmon.enums.battle.BattleMode;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public abstract class BattleGui
extends BattleScreen {
    public static final ResourceLocation BACKGROUND = new ResourceLocation("pixelmon", "textures/gui/battle/background.png");
    public static final ResourceLocation DETAILS = new ResourceLocation("pixelmon", "textures/gui/battle/pokemon_details.png");
    public static final ResourceLocation MENU_BAG = new ResourceLocation("pixelmon", "textures/gui/battle/menu_bag.png");
    public static final ResourceLocation MENU_BAG_DISABLED = new ResourceLocation("pixelmon", "textures/gui/battle/menu_bag_disabled.png");
    public static final ResourceLocation MENU_BAG_ICON = new ResourceLocation("pixelmon", "textures/gui/battle/menu_bag_icon.png");
    public static final ResourceLocation MENU_POKE = new ResourceLocation("pixelmon", "textures/gui/battle/menu_poke.png");
    public static final ResourceLocation MENU_POKE_DISABLED = new ResourceLocation("pixelmon", "textures/gui/battle/menu_poke_disabled.png");
    public static final ResourceLocation MENU_POKE_ICON = new ResourceLocation("pixelmon", "textures/gui/battle/menu_poke_icon.png");
    public static final ResourceLocation MENU_RUN = new ResourceLocation("pixelmon", "textures/gui/battle/menu_run.png");
    public static final ResourceLocation MENU_RUN_DISABLED = new ResourceLocation("pixelmon", "textures/gui/battle/menu_run_disabled.png");
    public static final ResourceLocation MENU_RUN_ICON = new ResourceLocation("pixelmon", "textures/gui/battle/menu_run_icon.png");
    public List<GuiButton> buttons = Lists.newArrayList();
    int chatArea;
    int detailsStart;

    public BattleGui(GuiBattle parent, BattleMode mode) {
        super(parent, mode);
    }

    public void func_73866_w_() {
        this.buttons.clear();
        this.buttons.add(new ActionButton(EnumBattleButton.BAG, this));
        this.buttons.add(new ActionButton(EnumBattleButton.POKE, this));
        this.buttons.add(new ActionButton(EnumBattleButton.RUN, this));
        if (ClientProxy.battleManager.rules.hasClause("bag")) {
            this.buttons.get((int)0).field_146124_l = false;
        }
        if (!this.bm.canSwitch) {
            this.buttons.get((int)1).field_146124_l = false;
        }
        if (!this.bm.canFlee || ClientProxy.battleManager.rules.hasClause("forfeit")) {
            this.buttons.get((int)2).field_146124_l = false;
        }
    }

    public void drawBackground(int width, int height, int mouseX, int mouseY) {
        this.chatArea = width - 40 - 80;
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(BACKGROUND);
        GuiHelper.drawImage(0.0, (float)height - 83.1f, width, 83.1f, this.field_73735_i);
        this.detailsStart = this.field_146294_l - 80;
        this.field_146297_k.field_71446_o.func_110577_a(DETAILS);
        GuiHelper.drawImage(this.detailsStart, height - 80, 80.0, 80.0, this.field_73735_i);
    }

    public void drawButtons(int mouseX, int mouseY) {
        this.buttons.get((int)1).field_146124_l = this.bm.canSwitch;
        this.buttons.get((int)2).field_146124_l = this.bm.canFlee && !ClientProxy.battleManager.rules.hasClause("forfeit");
        for (GuiButton button : this.buttons) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            button.func_191745_a(this.field_146297_k, mouseX, mouseY, 0.0f);
        }
    }

    public boolean handleButtonClick(int mouseX, int mouseY) {
        for (GuiButton button : this.buttons) {
            if (!(button instanceof ActionButton) || !button.func_146116_c(this.field_146297_k, mouseX, mouseY)) continue;
            ActionButton action = (ActionButton)button;
            if (action.button == EnumBattleButton.RUN) {
                this.bm.selectRunAction(this.bm.getCurrentPokemon().pokemonUUID);
            } else {
                ClientProxy.battleManager.mode = action.button.getBattleMode();
            }
            return true;
        }
        return false;
    }

    public static enum EnumBattleButton {
        BAG,
        POKE,
        RUN;


        @Nonnull
        public BattleMode getBattleMode() {
            switch (this) {
                case BAG: {
                    return BattleMode.ChooseBag;
                }
                case POKE: {
                    return BattleMode.ChoosePokemon;
                }
                case RUN: {
                    return BattleMode.YesNoForfeit;
                }
            }
            return null;
        }

        @Nonnull
        public ResourceLocation getTexture(boolean disabled) {
            switch (this) {
                case BAG: {
                    return disabled ? MENU_BAG_DISABLED : MENU_BAG;
                }
                case POKE: {
                    return disabled ? MENU_POKE_DISABLED : MENU_POKE;
                }
                case RUN: {
                    return disabled ? MENU_RUN_DISABLED : MENU_RUN;
                }
            }
            return null;
        }

        @Nonnull
        public void drawButton(GuiScreen screen) {
            switch (this) {
                case BAG: {
                    GuiHelper.drawImage(-1.0, this.getY(), 40.0, 24.0, 0.0f);
                    break;
                }
                case RUN: {
                    GuiHelper.drawImage(0.0, this.getY(), 40.0, 24.0, 0.0f);
                    break;
                }
                case POKE: {
                    GuiHelper.drawImage(0.0, this.getY(), 41.0, 26.0, 0.0f);
                }
            }
        }

        public int getY() {
            GuiScreen screen = Minecraft.func_71410_x().field_71462_r;
            if (screen == null) {
                return 0;
            }
            switch (this) {
                case BAG: {
                    return screen.field_146295_m - 72 - 8;
                }
                case POKE: {
                    return screen.field_146295_m - 48 - 5;
                }
                case RUN: {
                    return screen.field_146295_m - 24;
                }
            }
            return 0;
        }

        @Nonnull
        public ResourceLocation getIcon() {
            switch (this) {
                case BAG: {
                    return MENU_BAG_ICON;
                }
                case POKE: {
                    return MENU_POKE_ICON;
                }
                case RUN: {
                    return MENU_RUN_ICON;
                }
            }
            return null;
        }

        @Nonnull
        public void drawIcon(GuiScreen screen) {
            if (screen == null) {
                return;
            }
            switch (this) {
                case BAG: {
                    GuiHelper.drawImage(8.0, screen.field_146295_m - 72 - 3, 16.0, 14.0, 0.0f);
                    break;
                }
                case POKE: {
                    GuiHelper.drawImage(8.0, screen.field_146295_m - 48, 16.0, 16.0, 0.0f);
                    break;
                }
                case RUN: {
                    GuiHelper.drawImage(8.0, screen.field_146295_m - 24 + 5, 20.0, 14.0, 0.0f);
                }
            }
        }
    }

    public static class ActionButton
    extends GuiButton {
        public final EnumBattleButton button;
        public final BattleGui parent;
        private int hoveredFrames = 0;
        private boolean isPressed;

        public ActionButton(EnumBattleButton button, BattleGui parent) {
            super(button.ordinal(), 0, 0, button == EnumBattleButton.POKE ? 41 : 40, button == EnumBattleButton.POKE ? 26 : 24, "");
            this.button = button;
            this.field_146129_i = button.getY();
            this.parent = parent;
        }

        public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
            this.field_146123_n = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
            this.hoveredFrames = this.field_146123_n ? Math.min(3, this.hoveredFrames + 1) : Math.max(0, this.hoveredFrames - 1);
            mc.field_71446_o.func_110577_a(this.button.getTexture(!this.field_146124_l));
            GlStateManager.func_179094_E();
            if ((this.parent.mode == BattleMode.MainMenu || this.parent.mode == BattleMode.ChooseAttack) && this.hoveredFrames > 0 && this.field_146124_l && this.field_146125_m) {
                GlStateManager.func_179109_b((float)(-this.hoveredFrames), (float)0.0f, (float)0.0f);
            }
            GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10242, (int)33071);
            GL11.glTexParameteri((int)3553, (int)10243, (int)33071);
            this.button.drawButton(mc.field_71462_r);
            GlStateManager.func_179121_F();
            mc.field_71446_o.func_110577_a(this.button.getIcon());
            this.button.drawIcon(mc.field_71462_r);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        }

        public boolean func_146116_c(Minecraft mc, int mouseX, int mouseY) {
            this.isPressed = super.func_146116_c(mc, mouseX, mouseY);
            return this.isPressed;
        }

        public void func_146118_a(int mouseX, int mouseY) {
            this.isPressed = false;
        }
    }
}

