/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.battles.battleScreens.screens.bag;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.client.gui.battles.GuiBattle;
import com.pixelmonmod.pixelmon.client.gui.battles.battleScreens.BattleMenuGui;
import com.pixelmonmod.pixelmon.client.gui.battles.battleScreens.screens.bag.ItemMenuButton;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.BagPacket;
import com.pixelmonmod.pixelmon.config.PixelmonItems;
import com.pixelmonmod.pixelmon.config.PixelmonItemsPokeballs;
import com.pixelmonmod.pixelmon.enums.battle.BagSection;
import com.pixelmonmod.pixelmon.enums.battle.BattleMode;
import com.pixelmonmod.pixelmon.items.ItemData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class ChooseBag
extends BattleMenuGui<ItemMenuButton> {
    private final List<ItemMenuButton> BUTTONS = Lists.newArrayList();

    public ChooseBag(GuiBattle parent, BattleMode mode) {
        super(parent, mode);
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        if (this.BUTTONS.isEmpty()) {
            this.BUTTONS.add(new ItemMenuButton(0, new ItemStack(PixelmonItemsPokeballs.pokeBall), BagSection.Pokeballs.getLocalizedName(), (GuiScreen)this));
            this.BUTTONS.add(new ItemMenuButton(1, new ItemStack(PixelmonItems.potion), BagSection.HP.getLocalizedName(), (GuiScreen)this));
            this.BUTTONS.add(new ItemMenuButton(2, new ItemStack(PixelmonItems.xAttack), BagSection.BattleItems.getLocalizedName(), (GuiScreen)this));
            this.BUTTONS.add(new ItemMenuButton(3, new ItemStack(PixelmonItems.fullRestore), BagSection.StatusRestore.getLocalizedName(), (GuiScreen)this));
        }
        this.bm.bagSection = null;
    }

    @Override
    public String getTitle() {
        return this.bm.bagSection == null ? I18n.func_135052_a((String)"gui.mainmenu.bag", (Object[])new Object[0]) : this.bm.bagSection.getLocalizedName();
    }

    @Override
    public List<ItemMenuButton> generateButtons() {
        if (this.bm.getLastUsedItemIfStillAvailable().isPresent()) {
            ItemStack stack = new ItemStack(this.bm.getLastUsedItemIfStillAvailable().get().getItem());
            this.menuElement.setReuseMessage("gui.choosebag.lastitem", stack);
        }
        if (this.bm.bagSection == null) {
            return this.BUTTONS;
        }
        ArrayList list = Lists.newArrayList();
        List<ItemData> bag = this.bm.getBagItems(this.bm.bagSection);
        int index = 0;
        for (ItemData entry : bag) {
            list.add(new ItemMenuButton(index++, new ItemStack(entry.getItem()), entry.count, (GuiScreen)this));
        }
        return list;
    }

    @Override
    public void drawScreen(int width, int height, int mouseX, int mouseY) {
        super.drawScreen(width, height, mouseX, mouseY);
    }

    @Override
    public void click(int width, int height, int mouseX, int mouseY) {
        if (this.menuElement.isMouseOver(mouseX, mouseY)) {
            if (this.menuElement.isOverReturnButton(mouseX, mouseY)) {
                if (this.bm.bagSection == null) {
                    this.bm.mode = BattleMode.MainMenu;
                } else {
                    this.bm.bagSection = null;
                }
            } else if (this.menuElement.isOverReuseButton(mouseX, mouseY)) {
                this.bm.bagSection = (BagSection)this.bm.lastItem.getKey();
                this.bm.itemToUse = (ItemData)this.bm.lastItem.getValue();
                if (this.bm.bagSection == BagSection.Pokeballs) {
                    this.bm.selectedActions.clear();
                    Pixelmon.network.sendToServer((IMessage)new BagPacket(this.bm.getCurrentPokemon().pokemonUUID, this.bm.itemToUse.id, this.bm.battleControllerIndex, 0));
                    this.bm.mode = BattleMode.Waiting;
                } else {
                    this.bm.mode = BattleMode.ApplyToPokemon;
                }
            } else if (!this.menuElement.handleClickPageTurn(mouseX, mouseY)) {
                List buttons = this.menuElement.getPageButtons();
                for (ItemMenuButton button : buttons) {
                    if (!button.func_146116_c(this.field_146297_k, mouseX, mouseY)) continue;
                    if (this.bm.bagSection == null) {
                        BagSection bs = BagSection.getSection(button.field_146127_k);
                        if (bs == BagSection.Pokeballs) {
                            if (!this.bm.canCatchOpponent()) {
                                this.bm.addMessage(I18n.func_135052_a((String)"gui.choosebag.nopokeballs", (Object[])new Object[0]));
                                this.bm.mode = BattleMode.MainMenu;
                                break;
                            }
                            if (Arrays.stream(this.bm.displayedEnemyPokemon).filter(p -> p.health > 0.0f).count() > 1L) {
                                this.bm.addMessage(I18n.func_135052_a((String)"gui.choosebag.multiple", (Object[])new Object[0]));
                                this.bm.mode = BattleMode.MainMenu;
                                break;
                            }
                        }
                        this.bm.bagSection = BagSection.getSection(button.field_146127_k);
                        continue;
                    }
                    List<ItemData> bag = this.bm.getBagItems(this.bm.bagSection);
                    this.bm.itemToUse = bag.get(button.field_146127_k);
                    this.bm.lastItem = new ImmutablePair((Object)this.bm.bagSection, (Object)bag.get(button.field_146127_k));
                    if (this.bm.bagSection == BagSection.Pokeballs) {
                        this.bm.selectedActions.clear();
                        Pixelmon.network.sendToServer((IMessage)new BagPacket(this.bm.getCurrentPokemon().pokemonUUID, this.bm.itemToUse.id, this.bm.battleControllerIndex, 0));
                        this.bm.mode = BattleMode.Waiting;
                        continue;
                    }
                    this.bm.mode = BattleMode.ApplyToPokemon;
                }
            }
        }
    }
}

