/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.battles.battleScreens.yesNo;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.client.gui.battles.GuiBattle;
import com.pixelmonmod.pixelmon.client.gui.battles.battleScreens.yesNo.YesNoDialogue;
import com.pixelmonmod.pixelmon.client.storage.ClientStorageManager;
import com.pixelmonmod.pixelmon.enums.battle.BattleMode;
import net.minecraft.client.resources.I18n;

public class YesNoReplaceMove
extends YesNoDialogue {
    public YesNoReplaceMove(GuiBattle parent) {
        super(parent, BattleMode.YesNoReplaceMove);
    }

    @Override
    protected void drawConfirmText(int width, int height) {
        Attack newAttack;
        if (this.bm.newAttackList.isEmpty()) {
            this.parent.restoreSettingsAndClose();
            this.bm.mode = this.bm.oldMode;
            return;
        }
        Pokemon pokemonToLearnAttack = ClientStorageManager.party.find(this.bm.newAttackList.get((int)0).pokemonUUID);
        try {
            newAttack = this.bm.newAttackList.get((int)0).attack;
        }
        catch (Exception e) {
            Pixelmon.LOGGER.warn("User is clicking too fast.");
            Pixelmon.LOGGER.warn("New attack list is " + e.getMessage());
            this.bm.mode = this.bm.oldMode;
            return;
        }
        float textAreaWidth = 170.0f;
        if (this.bm.selectedAttack == -1) {
            String attackName = newAttack.getActualMove().getLocalizedName();
            String text = I18n.func_135052_a((String)"gui.yesno.yousure", (Object[])new Object[]{attackName});
            float textWidth = this.field_146297_k.field_71466_p.func_78256_a(text);
            int numLines = (int)(textWidth / textAreaWidth) + 1;
            this.field_146297_k.field_71466_p.func_78279_b(text, width / 2 - 109, height / 2 + 1 - numLines * 10 / 2, (int)textAreaWidth, 0);
            this.field_146297_k.field_71466_p.func_78279_b(text, width / 2 - 110, height / 2 - numLines * 10 / 2, (int)textAreaWidth, 0xFFFFFF);
        } else {
            if (pokemonToLearnAttack == null) {
                return;
            }
            String text = I18n.func_135052_a((String)"gui.yesno.replace", (Object[])new Object[]{pokemonToLearnAttack.getMoveset().get(this.bm.selectedAttack).getMove().getLocalizedName(), newAttack.getMove().getLocalizedName()});
            float textWidth = this.field_146297_k.field_71466_p.func_78256_a(text);
            int numLines = (int)(textWidth / textAreaWidth) + 1;
            this.field_146297_k.field_71466_p.func_78279_b(text, width / 2 - 109, height / 2 + 1 - numLines * 10 / 2, (int)textAreaWidth, 0);
            this.field_146297_k.field_71466_p.func_78279_b(text, width / 2 - 110, height / 2 - numLines * 10 / 2, (int)textAreaWidth, 0xFFFFFF);
        }
    }

    @Override
    protected void confirm() {
        if (this.bm.newAttackList.isEmpty()) {
            this.closeBattleScreen();
            return;
        }
        this.bm.newAttackList.remove(0);
        if (this.bm.sendPacket != null) {
            Pixelmon.network.sendToServer(this.bm.sendPacket);
        }
        if (this.bm.battleControllerIndex != -1) {
            if (this.bm.hasNewAttacks() || this.bm.hasLevelUps()) {
                this.bm.mode = this.bm.yesNoOrigin;
            } else {
                if (this.bm.battleEnded) {
                    this.closeBattleScreen();
                    return;
                }
                this.bm.mode = BattleMode.MainMenu;
                this.bm.checkClearedMessages();
            }
        } else if (this.bm.hasNewAttacks() || this.bm.hasLevelUps()) {
            this.bm.mode = this.bm.yesNoOrigin;
        } else {
            this.closeBattleScreen();
            return;
        }
    }

    private void closeBattleScreen() {
        this.parent.restoreSettingsAndClose();
        this.bm.mode = this.bm.oldMode;
    }
}

