/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.battles.pokemonOverlays;

import com.pixelmonmod.pixelmon.RandomHelper;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.client.gui.GuiElement;
import com.pixelmonmod.pixelmon.client.gui.GuiHelper;
import com.pixelmonmod.pixelmon.client.gui.GuiParticleEngine;
import com.pixelmonmod.pixelmon.client.gui.GuiResources;
import com.pixelmonmod.pixelmon.client.gui.battles.PixelmonInGui;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.config.PixelmonServerConfig;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.Gender;
import java.awt.Color;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;

public class AllyElement
extends GuiElement {
    private static final ResourceLocation ALLY = new ResourceLocation("pixelmon", "textures/gui/battle/ally.png");
    private static final ResourceLocation RAID = new ResourceLocation("pixelmon", "textures/gui/battle/raid.png");
    private static final ResourceLocation BARRIER = new ResourceLocation("pixelmon", "textures/gui/raids/barrier.png");
    private static final ResourceLocation SHINY = new ResourceLocation("pixelmon", "textures/gui/battle/shiny.png");
    private static final ResourceLocation HEALTHY = new ResourceLocation("pixelmon", "textures/gui/battle/pokemon_healthy.png");
    private static final ResourceLocation CAUTION = new ResourceLocation("pixelmon", "textures/gui/battle/pokemon_caution.png");
    private static final ResourceLocation WARNING = new ResourceLocation("pixelmon", "textures/gui/battle/pokemon_warning.png");
    private static final ResourceLocation TARGET = new ResourceLocation("pixelmon", "textures/gui/battle/target_down.png");
    private final PixelmonInGui ally;
    private final GuiScreen parent;
    private final GuiParticleEngine particleEngine;

    public AllyElement(PixelmonInGui ally, GuiScreen parent, GuiParticleEngine particleEngine) {
        this.ally = ally;
        this.parent = parent;
        this.particleEngine = particleEngine;
    }

    public PixelmonInGui getAlly() {
        return this.ally;
    }

    public void drawSelected(int x, int y, int width, int height, float scale) {
        this.setPosition(x, y, width, height);
        GlStateManager.func_179094_E();
        double tX = this.parent.field_146294_l;
        double tY = (float)(y + height) + 2.0f / scale;
        GlStateManager.func_179137_b((double)tX, (double)tY, (double)0.0);
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
        GlStateManager.func_179137_b((double)(-tX), (double)(-tY), (double)0.0);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiHelper.drawImage(TARGET, (double)x + 131.5, y - 16, 26.66666603088379, 11.0, this.zLevel);
        GlStateManager.func_179121_F();
        this.setPosition((int)((float)x * scale), (int)((float)y * scale), (int)((float)width * scale), (int)((float)height * scale));
    }

    @Override
    public void drawElement(float scale) {
        GlStateManager.func_179141_d();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiHelper.drawImage(ALLY, this.x, this.y + 5, 160.0, 50.0, this.zLevel);
        float healthPercent = this.ally.health / (float)this.ally.maxHealth;
        GuiHelper.drawBar(this.x + 13, this.y + 28, 109.0, 7.0, healthPercent, this.ally.getHealthColor(), true);
        float barWidth = this.ally.level < PixelmonServerConfig.maxLevel ? this.ally.expFraction : 1.0f;
        GuiHelper.drawBar(this.x + 13, this.y + 36, 111.0, 2.0, barWidth, new Color(69, 215, 255), true);
        this.parent.field_146297_k.func_110434_K().func_110577_a(healthPercent <= 0.5f ? (healthPercent <= 0.25f ? WARNING : CAUTION) : HEALTHY);
        GuiHelper.drawImage(this.x + 115, this.y - 2, 60.0, 60.0, this.zLevel);
        GuiHelper.bindPokemonSprite(this.ally, this.parent.field_146297_k);
        GuiHelper.drawImage(this.x + 125, this.y + 2, 40.0, 40.0, this.zLevel);
        this.particleEngine.drawAtOffset(this.ally.pokemonUUID.toString(), this.x + 130, this.y + 7, RandomHelper.rand.nextInt(26), RandomHelper.rand.nextInt(26));
        float offset = 0.0f;
        if (this.ally.getGender() != Gender.None) {
            this.parent.field_146297_k.func_110434_K().func_110577_a(this.ally.getGender() == Gender.Male ? GuiResources.male : GuiResources.female);
            GuiHelper.drawImage(this.x + 12, (float)this.y + 13.5f, 5.0, 8.0, this.zLevel);
            offset += 7.0f;
        }
        GuiHelper.drawScaledString(this.ally.getDisplayName(), (float)(this.x + 12) + offset, (float)this.y + 14.0f, this.ally.shiny ? -7545 : -986896, 16.0f);
        GuiHelper.drawScaledStringRightAligned("Lv." + this.ally.level, this.x + 114, (float)this.y + 15.0f, -986896, false, 12.0f);
        if (PixelmonConfig.advancedBattleInformation) {
            GuiHelper.drawScaledString((int)this.ally.health + "/" + this.ally.maxHealth, this.x + 15, (float)this.y + 29.0f, -986896, 11.0f);
        }
        if (this.ally.status != -1 && StatusType.getEffect(this.ally.status) != null) {
            float[] texturePair2 = StatusType.getTexturePos(StatusType.getEffect(this.ally.status));
            this.parent.field_146297_k.field_71446_o.func_110577_a(GuiResources.status);
            GuiHelper.drawImageQuad((float)(this.x + 12 + GuiHelper.getStringWidth(this.ally.getDisplayName())) + offset + 2.0f, (double)this.y + 12.5, 10.5, 10.5f, texturePair2[0] / 768.0f, texturePair2[1] / 512.0f, (texturePair2[0] + 240.0f) / 768.0f, (texturePair2[1] + 240.0f) / 512.0f, this.zLevel);
        }
        if (this.ally.shiny && RandomHelper.rand.nextInt(80) == 0) {
            int size = 7 + RandomHelper.rand.nextInt(7);
            this.particleEngine.addParticle(new GuiParticleEngine.GuiParticle(this.ally.pokemonUUID.toString(), SHINY, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0f, 0.8f, 0.3f, 0.0f, size, size, 120, particle -> {
                int x = particle.age;
                int m = particle.maxAge;
                int h = m / 2;
                particle.a = (float)(x <= h ? x : h - (x - h)) / (float)h;
            }));
        }
    }
}

