/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.battles.pokemonOverlays;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.client.gui.battles.GuiBattle;
import com.pixelmonmod.pixelmon.client.gui.battles.PixelmonInGui;
import com.pixelmonmod.pixelmon.client.gui.battles.pokemonOverlays.AllyElement;
import com.pixelmonmod.pixelmon.client.gui.battles.pokemonOverlays.OpponentElement;
import com.pixelmonmod.pixelmon.client.gui.battles.pokemonOverlays.OverlayBase;
import com.pixelmonmod.pixelmon.client.gui.battles.pokemonOverlays.RaidElement;
import com.pixelmonmod.pixelmon.enums.battle.EnumBattleType;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;

public class OverlayNew
extends OverlayBase {
    private static final ResourceLocation ACTIVE = new ResourceLocation("pixelmon", "textures/gui/battle/pokemon_active.png");
    private final List<OpponentElement> opponents = Lists.newLinkedList();
    private final List<AllyElement> allies = Lists.newLinkedList();
    private final List<AllyElement> our = Lists.newLinkedList();
    private PixelmonInGui current = this.bm.getCurrentPokemon();

    public OverlayNew(GuiBattle parent) {
        super(parent);
    }

    @Override
    public void draw(int width, int height, int guiWidth, int guiHeight) {
        try {
            this.bm.processBattleTasks();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.bm.displayedOurPokemon == null || this.bm.displayedOurPokemon.length == 0) {
            return;
        }
        GlStateManager.func_179141_d();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179147_l();
        this.generateElements();
        if (this.bm.rules.battleType == EnumBattleType.Raid && this.opponents.size() == 1) {
            float scaleOpponents = 1.0f;
            if ((float)this.parent.field_146294_l < 700.0f) {
                scaleOpponents = 1.0f / new BigDecimal(700.0f / (float)this.parent.field_146294_l).setScale(2, RoundingMode.HALF_UP).floatValue();
            }
            OpponentElement opponent = this.opponents.get(0);
            int yPos = opponent.getEnemy().xPos;
            float center = (float)this.parent.field_146294_l / 2.0f;
            float offset = 125.0f * scaleOpponents;
            if (this.parent.showTargeting() && this.parent.isTargeted(opponent.getEnemy().pokemonUUID)) {
                opponent.drawSelected((int)((center - offset) * (1.0f / scaleOpponents)), yPos, 250, 70, scaleOpponents);
            }
            opponent.drawElementScaled((int)((center - offset) * (1.0f / scaleOpponents)), yPos, 250, 70, scaleOpponents, 0, this, this.particleEngine);
        } else {
            float wo = this.parent.field_146294_l;
            float scaleOpponents = 1.0f;
            if (wo < (float)(180 * this.bm.displayedEnemyPokemon.length)) {
                scaleOpponents = 1.0f / new BigDecimal(180.0f * (float)this.bm.displayedEnemyPokemon.length / wo).setScale(2, RoundingMode.HALF_UP).floatValue();
            }
            for (int i = 0; i < this.opponents.size(); ++i) {
                OpponentElement opponent = this.opponents.get(i);
                int yPos = opponent.getEnemy().xPos;
                if (this.parent.showTargeting() && this.parent.isTargeted(opponent.getEnemy().pokemonUUID)) {
                    opponent.drawSelected(180 * i, yPos, 160, 50, scaleOpponents);
                }
                opponent.drawElementScaled(180 * i, yPos, 160, 50, scaleOpponents, i, this, this.particleEngine);
            }
        }
        PixelmonInGui pig = this.current;
        if (pig == null) {
            if (this.bm.isSpectating) {
                pig = this.bm.displayedOurPokemon[0];
            } else {
                return;
            }
        }
        float wa = this.parent.field_146294_l;
        float scaleAllies = 1.0f;
        if (wa < (float)(190 * this.our.size())) {
            scaleAllies = 1.0f / new BigDecimal(190.0f * (float)this.our.size() / wa).setScale(2, RoundingMode.HALF_UP).floatValue();
        }
        for (int i = 0; i < this.our.size(); ++i) {
            AllyElement our = this.our.get(i);
            int yPos = our.getAlly().xPos;
            if (this.parent.showTargeting() && this.parent.isTargeted(our.getAlly().pokemonUUID)) {
                our.drawSelected(this.parent.field_146294_l + 25 - 190 * (i + 1), this.parent.field_146295_m - 6 - yPos, 160, 40, scaleAllies);
            }
            our.drawElementScaled(this.parent.field_146294_l + 25 - 190 * (i + 1), this.parent.field_146295_m - 6 - yPos, 160, 40, scaleAllies, i, this, this.particleEngine);
        }
        this.particleEngine.draw("");
    }

    @Override
    public int mouseOverEnemyPokemon(int guiWidth, int guiHeight, int mouseX, int mouseY) {
        for (int i = 0; i < this.opponents.size(); ++i) {
            OpponentElement opponent = this.opponents.get(i);
            if (!opponent.isMouseOver(mouseX, mouseY)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int mouseOverUserPokemon(int width, int height, int guiWidth, int guiHeight, int mouseX, int mouseY) {
        int i = 0;
        for (AllyElement ally : this.allies) {
            if (ally.isMouseOver(mouseX, mouseY)) {
                return Lists.newArrayList((Object[])this.bm.teamPokemon).indexOf(ally.getAlly().pokemonUUID);
            }
            ++i;
        }
        i = 0;
        for (AllyElement ally : this.our) {
            if (ally.isMouseOver(mouseX, mouseY)) {
                return Lists.newArrayList((Object[])this.bm.teamPokemon).indexOf(ally.getAlly().pokemonUUID);
            }
            ++i;
        }
        return -1;
    }

    private void generateElements() {
        PixelmonInGui ally;
        if (this.bm.getCurrentPokemon() != null) {
            this.current = this.bm.getCurrentPokemon();
        }
        this.opponents.clear();
        if (this.bm.displayedEnemyPokemon != null) {
            for (int i = 0; i < this.bm.displayedEnemyPokemon.length; ++i) {
                PixelmonInGui enemy = this.bm.displayedEnemyPokemon[i];
                if (this.bm.rules.battleType == EnumBattleType.Raid) {
                    this.opponents.add(new RaidElement(enemy, this, this.particleEngine));
                    continue;
                }
                this.opponents.add(new OpponentElement(enemy, this, this.particleEngine));
            }
        }
        this.our.clear();
        this.allies.clear();
        HashSet<UUID> added = new HashSet<UUID>();
        if (this.bm.displayedOurPokemon != null) {
            for (int i = 0; i < this.bm.displayedOurPokemon.length; ++i) {
                ally = this.bm.displayedOurPokemon[i];
                if (added.contains(ally.pokemonUUID)) continue;
                this.our.add(new AllyElement(ally, this, this.particleEngine));
                added.add(ally.pokemonUUID);
            }
        }
        if (this.bm.displayedAllyPokemon != null) {
            for (int i = 0; i < this.bm.displayedAllyPokemon.length; ++i) {
                ally = this.bm.displayedAllyPokemon[i];
                if (added.contains(ally.pokemonUUID)) continue;
                this.our.add(new AllyElement(ally, this, this.particleEngine));
                added.add(ally.pokemonUUID);
            }
        }
        this.our.sort(Comparator.comparingInt(a -> -a.getAlly().position));
    }
}

