/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.battles.pokemonOverlays;

import com.pixelmonmod.pixelmon.RandomHelper;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.client.SoundHelper;
import com.pixelmonmod.pixelmon.client.gui.GuiHelper;
import com.pixelmonmod.pixelmon.client.gui.GuiParticleEngine;
import com.pixelmonmod.pixelmon.client.gui.GuiResources;
import com.pixelmonmod.pixelmon.client.gui.battles.PixelmonInGui;
import com.pixelmonmod.pixelmon.client.gui.battles.pokemonOverlays.OpponentElement;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.Gender;
import java.text.DecimalFormat;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.ResourceLocation;

public class RaidElement
extends OpponentElement {
    private static final ResourceLocation OPPONENT = new ResourceLocation("pixelmon", "textures/gui/battle/opponent.png");
    private static final ResourceLocation HEALTHY = new ResourceLocation("pixelmon", "textures/gui/battle/pokemon_healthy.png");
    private static final ResourceLocation CAUTION = new ResourceLocation("pixelmon", "textures/gui/battle/pokemon_caution.png");
    private static final ResourceLocation WARNING = new ResourceLocation("pixelmon", "textures/gui/battle/pokemon_warning.png");
    private static final ResourceLocation SHINY = new ResourceLocation("pixelmon", "textures/gui/battle/shiny.png");
    private static final ResourceLocation STAR = new ResourceLocation("pixelmon", "textures/gui/battle/star.png");
    private static final ResourceLocation CAUGHT = new ResourceLocation("pixelmon", "textures/gui/battle/caught.png");
    private static final ResourceLocation TARGET = new ResourceLocation("pixelmon", "textures/gui/battle/target_up.png");
    private static final ResourceLocation RAID = new ResourceLocation("pixelmon", "textures/gui/battle/raid.png");
    private static final ResourceLocation BARRIER = new ResourceLocation("pixelmon", "textures/gui/raids/barrier.png");
    private final GuiScreen parent;
    private final PixelmonInGui enemy;
    private final GuiParticleEngine particleEngine;

    public RaidElement(PixelmonInGui enemy, GuiScreen parent, GuiParticleEngine particleEngine) {
        super(enemy, parent, particleEngine);
        this.parent = parent;
        this.enemy = enemy;
        this.particleEngine = particleEngine;
    }

    @Override
    public PixelmonInGui getEnemy() {
        return this.enemy;
    }

    @Override
    public void drawSelected(int x, int y, int width, int height, float scale) {
        this.setPosition(x, y, width, height);
        GlStateManager.func_179094_E();
        GlStateManager.func_179141_d();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiHelper.drawImage(TARGET, x + 105, y + 75, 40.0, 16.5, this.zLevel);
        GlStateManager.func_179121_F();
        this.setPosition((int)((float)x * scale), (int)((float)y * scale), (int)((float)width * scale), (int)((float)height * scale));
    }

    @Override
    public void drawElement(float scale) {
        GlStateManager.func_179141_d();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiHelper.drawImage(RAID, this.x, this.y - 3, 250.0, 70.0, this.zLevel);
        float healthPercent = this.enemy.health / (float)this.enemy.maxHealth;
        GuiHelper.drawBar(this.x + 6, this.y + 45, 244.0, 11.5, healthPercent, this.enemy.getHealthColor());
        if (this.enemy.status != -1 && StatusType.getEffect(this.enemy.status) != null) {
            float[] texturePair2 = StatusType.getTexturePos(StatusType.getEffect(this.enemy.status));
            this.parent.field_146297_k.field_71446_o.func_110577_a(GuiResources.status);
            GuiHelper.drawImageQuad(this.x + 222, this.y + 12, 20.0, 20.0f, texturePair2[0] / 768.0f, texturePair2[1] / 512.0f, (texturePair2[0] + 240.0f) / 768.0f, (texturePair2[1] + 240.0f) / 512.0f, this.zLevel);
        }
        float offset = 0.0f;
        if (this.enemy.shields > 0) {
            offset = 6.0f;
            for (int i = 0; i < this.enemy.maxShields; ++i) {
                if (this.enemy.shields <= i) {
                    GlStateManager.func_179131_c((float)0.4f, (float)0.4f, (float)0.4f, (float)1.0f);
                    if (this.enemy.lostShield) {
                        this.enemy.lostShield = false;
                        float diffScale = 1.0f - scale;
                        float oX = 22.0f * diffScale * 0.5f;
                        float oY = 7.0f * diffScale * 0.5f;
                        SoundHelper.playSound(SoundEvents.field_187767_eL, 0.25f, 0.8f + this.parent.field_146297_k.field_71441_e.field_73012_v.nextFloat() * 0.4f);
                        this.particleEngine.addParticle(new GuiParticleEngine.GuiParticle("", BARRIER, ((float)(this.x + 128 + 18 * i) - (float)(18 * this.enemy.maxShields) / 2.0f - 2.0f) * scale - oX, ((double)this.y + 30.5) * (double)scale - (double)oY, 2.0, 0.0, 0.0, 0.0, 0.843f, 0.0314f, 0.478f, 0.0f, 22.0f, 7.0f, 40, particle -> {
                            particle.a = 1.0f - (float)particle.age / (float)particle.maxAge;
                            float growth = 0.5f * scale;
                            float yMult = 0.5f;
                            particle.x -= (double)growth;
                            particle.w += growth * 2.0f;
                            particle.y -= (double)(growth * yMult);
                            particle.h += growth * 2.0f * yMult;
                        }));
                    }
                } else {
                    GlStateManager.func_179131_c((float)0.843f, (float)0.0314f, (float)0.478f, (float)1.0f);
                }
                GuiHelper.drawImage(BARRIER, (float)(this.x + 128 + 18 * i) - (float)(18 * this.enemy.maxShields) / 2.0f - 2.0f, (double)this.y + 30.5, 22.0, 7.0, 1.0f);
            }
        } else if (this.enemy.lostShield) {
            this.enemy.lostShield = false;
            SoundHelper.playSound(SoundEvents.field_187769_eM, 0.8f, 0.8f + this.parent.field_146297_k.field_71441_e.field_73012_v.nextFloat() * 0.4f);
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.enemy.getGender() != Gender.None) {
            this.parent.field_146297_k.func_110434_K().func_110577_a(this.enemy.getGender() == Gender.Male ? GuiResources.male : GuiResources.female);
            GuiHelper.drawImage(this.x + 8, this.y + 13, 10.0, 16.0, this.zLevel);
        }
        GuiHelper.drawScaledCenteredString(this.enemy.getDisplayName(), this.x + 128, (float)this.y + 14.0f - offset, this.enemy.shiny ? -7545 : -986896, 34.0f);
        if (PixelmonConfig.advancedBattleInformation) {
            DecimalFormat df = new DecimalFormat(".#");
            String percentage = df.format((double)healthPercent * 100.0).replace(".0", "");
            if (percentage.isEmpty()) {
                percentage = "0";
            }
            GuiHelper.drawScaledCenteredString(percentage + "%", this.x + 128, (float)this.y + 46.0f, -986896, 20.0f);
        }
        if (this.enemy.shiny && RandomHelper.rand.nextInt(80) == 0) {
            int size = 7 + RandomHelper.rand.nextInt(7);
            this.particleEngine.addParticle(new GuiParticleEngine.GuiParticle("", SHINY, (float)this.parent.field_146294_l / 2.0f + (float)RandomHelper.rand.nextInt(80) - 40.0f, (double)this.parent.field_146295_m * 0.04 + (double)RandomHelper.rand.nextInt(16) - 10.0, 1.0, 0.0, 0.0, 0.0, 1.0f, 0.8f, 0.3f, 0.0f, size, size, 120, particle -> {
                int x = particle.age;
                int m = particle.maxAge;
                int h = m / 2;
                particle.a = (float)(x <= h ? x : h - (x - h)) / (float)h;
            }));
        }
    }
}

