/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.factory.config;

import com.pixelmonmod.pixelmon.client.gui.factory.config.ReflectionNodeElement;
import com.pixelmonmod.pixelmon.config.Node;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.spawning.PixelmonSpawning;
import info.pixelmon.repack.ninja.leaping.configurate.commented.CommentedConfigurationNode;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.fml.client.config.DummyConfigElement;
import net.minecraftforge.fml.client.config.GuiConfig;
import net.minecraftforge.fml.client.config.IConfigElement;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class PixelmonConfigGui
extends GuiConfig {
    public PixelmonConfigGui(GuiScreen parentScreen) {
        super(parentScreen, PixelmonConfigGui.getConfigElements(), "pixelmon", false, false, I18n.func_135052_a((String)"pixelmon.config.title", (Object[])new Object[0]));
    }

    private static List<IConfigElement> getConfigElements() {
        ArrayList<IConfigElement> elements = new ArrayList<IConfigElement>();
        HashMap<String, DummyConfigElement.DummyCategoryElement> map = new HashMap<String, DummyConfigElement.DummyCategoryElement>();
        CommentedConfigurationNode defaults = (CommentedConfigurationNode)ReflectionHelper.getPrivateValue(PixelmonConfig.class, null, (String[])new String[]{"defaults"});
        for (PixelmonConfig.Category category : PixelmonConfig.Category.values()) {
            if (!category.shouldShowInGui()) continue;
            ArrayList configElements = new ArrayList();
            DummyConfigElement.DummyCategoryElement element = new DummyConfigElement.DummyCategoryElement(category.getTitle(), "pixelmon.config." + category.getTitle().toLowerCase().replaceAll(" ", ""), configElements);
            element.setRequiresMcRestart(category.requiresMcRestart());
            elements.add((IConfigElement)element);
            map.put(category.getTitle(), element);
        }
        try {
            for (Field field : PixelmonConfig.class.getDeclaredFields()) {
                Node node;
                PixelmonConfig.Category category;
                if (!Modifier.isPublic(field.getModifiers()) || !Modifier.isStatic(field.getModifiers()) || field.getAnnotation(Node.class) == null || !(category = (node = field.getAnnotation(Node.class)).category()).shouldShowInGui()) continue;
                String name = node.nameOverride().isEmpty() ? field.getName() : node.nameOverride();
                CommentedConfigurationNode categoryNode = defaults;
                for (String cat : category.getTitle().split("\\.")) {
                    categoryNode = categoryNode.getNode(cat);
                }
                CommentedConfigurationNode defaultNode = categoryNode.getNode(name);
                List<Object> defaultValue = defaultNode.hasListChildren() ? defaultNode.getList(o -> o) : defaultNode.getValue();
                ReflectionNodeElement element = new ReflectionNodeElement(field, defaultValue);
                if (category == PixelmonConfig.Category.SPAWNING || category == PixelmonConfig.Category.SPAWNINGGENS) {
                    element.setReloadFunction(o -> PixelmonSpawning.totalReload());
                }
                ((DummyConfigElement.DummyCategoryElement)map.get(category.getTitle())).getChildElements().add(element);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return elements;
    }
}

