/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.npcEditor;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.battles.attacks.AttackBase;
import com.pixelmonmod.pixelmon.client.gui.GuiHelper;
import com.pixelmonmod.pixelmon.client.gui.GuiResources;
import com.pixelmonmod.pixelmon.client.gui.chooseMoveset.GuiMoveList;
import com.pixelmonmod.pixelmon.client.gui.chooseMoveset.IElementClicked;
import com.pixelmonmod.pixelmon.client.gui.elements.GuiScreenDropDown;
import com.pixelmonmod.pixelmon.client.gui.elements.GuiTabCompleteTextField;
import com.pixelmonmod.pixelmon.client.gui.npc.GuiTutor;
import com.pixelmonmod.pixelmon.client.gui.npcEditor.TextureEditorNPC;
import com.pixelmonmod.pixelmon.comm.packetHandlers.npc.DeleteNPC;
import com.pixelmonmod.pixelmon.comm.packetHandlers.npc.StoreTutorData;
import com.pixelmonmod.pixelmon.entities.npcs.EntityNPC;
import com.pixelmonmod.pixelmon.entities.npcs.NPCTutor;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.BaseStatsLearnType;
import com.pixelmonmod.pixelmon.util.ITranslatable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import org.lwjgl.input.Keyboard;

public class GuiTutorEditor
extends GuiScreenDropDown
implements IElementClicked<NPCTutor.LearnableMove> {
    public static EnumSet<BaseStatsLearnType> learnTypes = EnumSet.noneOf(BaseStatsLearnType.class);
    private final Map<String, Item> itemMap = new HashMap<String, Item>();
    private final Map<String, Item> idMap = new HashMap<String, Item>();
    private final Map<String, Item> modAndIdMap = new HashMap<String, Item>();
    NPCTutor tutor;
    List<ItemStack> cost;
    int listTop;
    int listLeft;
    int listHeight;
    int listWidth;
    GuiMoveList guiMoveList;
    int selectedMove = -1;
    GuiTextField newMove;
    GuiTextField newItem;
    GuiTextField newItemAmount;
    GuiTextField newItemDamage;
    GuiButton okayButton;
    GuiButton addMove;
    GuiButton deleteMove;
    GuiButton addItem;
    GuiButton[] deleteCost = new GuiButton[4];
    GuiButton[] learnTypeButtons = new GuiButton[BaseStatsLearnType.GEN8_DEFAULT.length];
    GuiButton deleteTutor;
    private TextureEditorNPC textureEditor;

    public GuiTutorEditor(int tutorID) {
        Keyboard.enableRepeatEvents((boolean)true);
        Optional<NPCTutor> entityNPCOptional = EntityNPC.locateNPCClient((World)Minecraft.func_71410_x().field_71441_e, tutorID, NPCTutor.class);
        if (!entityNPCOptional.isPresent()) {
            GuiHelper.closeScreen();
            return;
        }
        this.tutor = entityNPCOptional.get();
        this.listHeight = 150;
        this.listWidth = 90;
        ForgeRegistries.ITEMS.getValuesCollection().stream().map(ItemStack::new).forEach(itemStack -> {
            Item item = itemStack.func_77973_b();
            this.itemMap.put(itemStack.func_82833_r(), item);
            ResourceLocation location = itemStack.func_77973_b().getRegistryName();
            this.idMap.put(location.func_110623_a().toLowerCase(), item);
            this.modAndIdMap.put((location.func_110624_b() + ":" + location.func_110623_a()).toLowerCase(), item);
        });
    }

    @Override
    public void func_73866_w_() {
        int i;
        super.func_73866_w_();
        this.listTop = this.field_146295_m / 2 - 62;
        this.listLeft = this.field_146294_l / 2 - 68;
        this.guiMoveList = new GuiMoveList(this, GuiTutor.moveList, this.listWidth, this.listHeight, this.listTop, this.listLeft, this.field_146297_k);
        this.field_146292_n.add(new GuiButton(1, this.field_146294_l / 2 + 155, this.field_146295_m / 2 + 90, 50, 20, I18n.func_135052_a((String)"gui.pokemoneditor.save", (Object[])new Object[0])));
        this.okayButton = new GuiButton(10, this.field_146294_l / 2 + 20, this.field_146295_m / 2 + 90, 50, 20, I18n.func_135052_a((String)"gui.guiItemDrops.ok", (Object[])new Object[0]));
        this.newMove = new GuiTabCompleteTextField(1, this.field_146297_k.field_71466_p, this.field_146294_l / 2 + 54, this.field_146295_m / 2 - 100, 90, 16).setCompletions(AttackBase.ATTACKS.stream().map(ITranslatable::getLocalizedName).collect(Collectors.toSet()));
        this.newItem = new GuiTabCompleteTextField(2, this.field_146297_k.field_71466_p, this.field_146294_l / 2 + 80, this.field_146295_m / 2 + 30, 70, 16).setCompletions(this.itemMap.keySet());
        this.newItemAmount = new GuiTextField(3, this.field_146297_k.field_71466_p, this.field_146294_l / 2 + 80, this.field_146295_m / 2 + 50, 70, 16);
        this.newItemDamage = new GuiTextField(4, this.field_146297_k.field_71466_p, this.field_146294_l / 2 + 80, this.field_146295_m / 2 + 70, 70, 16);
        this.addMove = new GuiButton(2, this.field_146294_l / 2 + 69, this.field_146295_m / 2 - 80, 60, 20, I18n.func_135052_a((String)"gui.tutor.addmove", (Object[])new Object[0]));
        this.deleteMove = new GuiButton(3, this.field_146294_l / 2 + 64, this.field_146295_m / 2 - 45, 70, 20, I18n.func_135052_a((String)"gui.tutor.deletemove", (Object[])new Object[0]));
        this.addItem = new GuiButton(4, this.field_146294_l / 2 + 80, this.field_146295_m / 2 + 90, 60, 20, I18n.func_135052_a((String)"gui.tutor.addcost", (Object[])new Object[0]));
        if (this.selectedMove > -1) {
            this.field_146292_n.add(this.addItem);
            this.field_146292_n.add(this.deleteMove);
            this.field_146292_n.add(this.okayButton);
        } else {
            i = 0;
            for (BaseStatsLearnType type : BaseStatsLearnType.GEN8_DEFAULT) {
                this.learnTypeButtons[i] = new GuiButton(11 + i, this.field_146294_l / 2 + 150, this.field_146295_m / 2 - 34 + 16 * i, 20, 16, learnTypes.contains((Object)type) ? "O" : "X");
                this.field_146292_n.add(this.learnTypeButtons[i]);
                ++i;
            }
        }
        for (i = 0; i < this.deleteCost.length; ++i) {
            this.deleteCost[i] = new GuiButton(5 + i, this.field_146294_l / 2 + 80 + 20 * i, this.field_146295_m / 2 + 8, 20, 20, "X");
        }
        this.deleteTutor = new GuiButton(9, this.field_146294_l / 2 - 193, this.field_146295_m / 2 - 100, 80, 20, I18n.func_135052_a((String)"gui.tutor.deletetutor", (Object[])new Object[0]));
        this.textureEditor = new TextureEditorNPC(this, this.tutor, this.field_146294_l / 2 - 190, this.field_146295_m / 2 + 55, 100, -28);
        this.field_146292_n.add(this.addMove);
    }

    @Override
    protected void drawBackgroundUnderMenus(float mFloat, int mouseX, int mouseY) {
        this.func_146276_q_();
        this.field_146297_k.field_71446_o.func_110577_a(GuiResources.cwPanel);
        GlStateManager.func_179124_c((float)0.9f, (float)0.9f, (float)0.9f);
        float sixteenthWidth = 40.0f;
        float sixteenthHeight = 20.0f;
        GuiHelper.drawImageQuad(0.0f + sixteenthWidth, 0.0f + sixteenthHeight, (float)this.field_146294_l - sixteenthWidth * 2.0f, (float)this.field_146295_m - sixteenthHeight * 2.0f, 0.0, 0.0, 1.0, 1.0, this.field_73735_i);
        RenderHelper.func_74518_a();
        String text = I18n.func_135052_a((String)"pixelmon.npc.tutorname", (Object[])new Object[0]);
        this.field_146297_k.field_71466_p.func_78276_b(text, this.field_146294_l / 2 - this.field_146289_q.func_78256_a(text) / 2, this.field_146295_m / 2 - 100, 0);
        text = I18n.func_135052_a((String)"gui.choosemoveset.choosemove", (Object[])new Object[0]);
        this.field_146297_k.field_71466_p.func_78276_b(text, this.field_146294_l / 2 - 33 - this.field_146289_q.func_78256_a(text) / 2, this.field_146295_m / 2 - 76, 0);
        if (!GuiTutor.moveList.isEmpty()) {
            this.guiMoveList.drawScreen(mouseX, mouseY, mFloat);
        }
        GuiHelper.drawEntity((EntityLivingBase)this.tutor, this.field_146294_l / 2 - 133, this.field_146295_m / 2 + 50, 50.0f, 0.0f, 0.0f);
        this.newMove.func_146194_f();
        if (this.selectedMove >= 0) {
            text = GuiTutor.moveList.get(this.selectedMove).attack().getLocalizedName();
            this.field_146297_k.field_71466_p.func_78276_b(text, this.field_146294_l / 2 + 99 - this.field_146289_q.func_78256_a(text) / 2, this.field_146295_m / 2 - 20, 0);
            text = I18n.func_135052_a((String)"gui.choosemoveset.cost", (Object[])new Object[0]);
            this.field_146297_k.field_71466_p.func_78276_b(text, this.field_146294_l / 2 + 74 - this.field_146289_q.func_78256_a(text), this.field_146295_m / 2 - 5, 0);
            if (this.cost.size() < 4) {
                this.newItem.func_146194_f();
                this.newItemAmount.func_146194_f();
                this.newItemDamage.func_146194_f();
                text = I18n.func_135052_a((String)"gui.tutor.itemname", (Object[])new Object[0]);
                this.field_146297_k.field_71466_p.func_78276_b(text, this.field_146294_l / 2 + 75 - this.field_146289_q.func_78256_a(text), this.field_146295_m / 2 + 35, 0);
                text = I18n.func_135052_a((String)"gui.tutor.itemamount", (Object[])new Object[0]);
                this.field_146297_k.field_71466_p.func_78276_b(text, this.field_146294_l / 2 + 75 - this.field_146289_q.func_78256_a(text), this.field_146295_m / 2 + 55, 0);
                text = I18n.func_135052_a((String)"gui.tutor.itemdamage", (Object[])new Object[0]);
                this.field_146297_k.field_71466_p.func_78276_b(text, this.field_146294_l / 2 + 75 - this.field_146289_q.func_78256_a(text), this.field_146295_m / 2 + 75, 0);
            }
        } else {
            text = I18n.func_135052_a((String)"gui.tutor.learntypes", (Object[])new Object[0]);
            this.field_146297_k.field_71466_p.func_78276_b(text, this.field_146294_l / 2 + 160 - this.field_146289_q.func_78256_a(text), this.field_146295_m / 2 - 45, 0);
            int count = 0;
            for (BaseStatsLearnType type : BaseStatsLearnType.GEN8_DEFAULT) {
                text = I18n.func_135052_a((String)("gui.tutor.learntype." + type.name().toLowerCase()), (Object[])new Object[0]);
                this.field_146297_k.field_71466_p.func_78276_b(text, this.field_146294_l / 2 + 140 - this.field_146289_q.func_78256_a(text), this.field_146295_m / 2 - 30 + 16 * count, 0);
                ++count;
            }
        }
        this.textureEditor.drawCustomTextBox();
        if (this.cost != null && !this.cost.isEmpty()) {
            int i = 0;
            for (ItemStack item : this.cost) {
                this.field_146296_j.func_180450_b(item, this.field_146294_l / 2 + 80 + i * 21, this.field_146295_m / 2 - 10);
                this.field_146296_j.func_180453_a(this.field_146297_k.field_71466_p, item, this.field_146294_l / 2 + 80 + i * 21, this.field_146295_m / 2 - 10, null);
                if (i < this.deleteCost.length && !this.field_146292_n.contains(this.deleteCost[i])) {
                    this.field_146292_n.add(this.deleteCost[i]);
                }
                ++i;
            }
        }
    }

    @Override
    protected void mouseClickedUnderMenus(int x, int y, int mouseButton) throws IOException {
        this.newMove.func_146192_a(x, y, mouseButton);
        this.newItem.func_146192_a(x, y, mouseButton);
        this.newItemAmount.func_146192_a(x, y, mouseButton);
        this.newItemDamage.func_146192_a(x, y, mouseButton);
        this.textureEditor.mouseClicked(x, y, mouseButton);
    }

    @Override
    public void elementClicked(List<NPCTutor.LearnableMove> list, int index) {
        if (!GuiTutor.moveList.isEmpty() && index < GuiTutor.moveList.size()) {
            this.selectedMove = index;
            this.cost = GuiTutor.moveList.get(index).costs();
            if (!this.field_146292_n.contains(this.deleteMove)) {
                this.field_146292_n.add(this.deleteMove);
            }
            if (!this.field_146292_n.contains(this.addItem) && this.cost.size() < 4) {
                this.field_146292_n.add(this.addItem);
                this.field_146292_n.add(this.okayButton);
            }
            for (GuiButton deleteCostButton : this.deleteCost) {
                this.field_146292_n.remove(deleteCostButton);
            }
            this.field_146292_n.removeAll(Arrays.asList(this.learnTypeButtons));
        }
    }

    protected void func_73869_a(char key, int keyCode) {
        this.newMove.func_146201_a(key, keyCode);
        ArrayList<GuiTextField> textFields = new ArrayList<GuiTextField>();
        textFields.add(this.newMove);
        if (this.selectedMove >= 0 && this.cost.size() < 4) {
            this.newItem.func_146201_a(key, keyCode);
            this.newItemAmount.func_146201_a(key, keyCode);
            this.newItemDamage.func_146201_a(key, keyCode);
            textFields.addAll(Arrays.asList(this.newItem, this.newItemAmount, this.newItemDamage));
        }
        if (keyCode != 15) {
            this.textureEditor.keyTyped(key, keyCode, textFields.toArray(new GuiTextField[0]));
        }
        if (keyCode == 1 || keyCode == 28) {
            this.saveFields();
        }
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146127_k == 1) {
            this.saveFields();
        } else if (button.field_146127_k == 2) {
            Optional<AttackBase> optional = AttackBase.getAttackBase(this.newMove.func_146179_b());
            if (optional.isPresent()) {
                AttackBase move = optional.get();
                if (GuiTutor.moveList.stream().noneMatch(it -> it.attack() == move)) {
                    GuiTutor.moveList.add(new NPCTutor.LearnableMove(move, Lists.newArrayList(), true));
                }
            }
        } else if (button.field_146127_k == 3) {
            if (this.selectedMove >= 0 && this.selectedMove < GuiTutor.moveList.size()) {
                GuiTutor.moveList.remove(this.selectedMove);
                this.cost = null;
                this.selectedMove = -1;
                this.field_146292_n.remove(this.addItem);
                this.field_146292_n.remove(this.okayButton);
                this.field_146292_n.remove(this.deleteMove);
                for (GuiButton deleteCostButton : this.deleteCost) {
                    this.field_146292_n.remove(deleteCostButton);
                }
                this.field_146292_n.addAll(Arrays.asList(this.learnTypeButtons));
            }
        } else if (button.field_146127_k == 4) {
            if (this.cost.size() < 4) {
                String itemString = this.newItem.func_146179_b();
                Item item = null;
                if (this.itemMap.containsKey(itemString)) {
                    item = this.itemMap.get(itemString);
                } else if (this.idMap.containsKey(itemString.toLowerCase())) {
                    item = this.idMap.get(itemString.toLowerCase());
                } else if (this.modAndIdMap.containsKey(itemString.toLowerCase())) {
                    item = this.modAndIdMap.get(itemString.toLowerCase());
                } else {
                    try {
                        int id = Integer.parseInt(itemString);
                        if (Item.func_150899_d((int)id) != null) {
                            item = Item.func_150899_d((int)id);
                        }
                    }
                    catch (Exception id) {
                        // empty catch block
                    }
                }
                if (item != null) {
                    int amount = 1;
                    int damage = 0;
                    try {
                        amount = Math.max(amount, Integer.parseInt(this.newItemAmount.func_146179_b()));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    try {
                        damage = Math.max(damage, Integer.parseInt(this.newItemDamage.func_146179_b()));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    ItemStack newItem = new ItemStack(item, amount);
                    if (amount > newItem.func_77976_d()) {
                        newItem.func_190920_e(newItem.func_77976_d());
                    }
                    newItem.func_77964_b(damage);
                    this.cost.add(newItem);
                    if (this.cost.size() >= 4) {
                        this.field_146292_n.remove(this.addItem);
                    }
                }
            }
        } else if (button.field_146127_k >= 5 && button.field_146127_k <= 8) {
            int deleteButtonIndex = button.field_146127_k - 5;
            if (this.cost.size() > deleteButtonIndex) {
                this.cost.remove(deleteButtonIndex);
                for (GuiButton deleteCostButton : this.deleteCost) {
                    this.field_146292_n.remove(deleteCostButton);
                }
                if (!this.field_146292_n.contains(this.addItem)) {
                    this.field_146292_n.add(this.addItem);
                }
            }
        } else if (button.field_146127_k == 9) {
            Pixelmon.network.sendToServer((IMessage)new DeleteNPC(this.tutor.getId()));
            GuiHelper.closeScreen();
        } else if (button.field_146127_k == 10) {
            this.cost = null;
            this.selectedMove = -1;
            this.field_146292_n.remove(this.addItem);
            this.field_146292_n.remove(this.okayButton);
            this.field_146292_n.remove(this.deleteMove);
            for (GuiButton deleteCostButton : this.deleteCost) {
                this.field_146292_n.remove(deleteCostButton);
            }
            this.field_146292_n.addAll(Arrays.asList(this.learnTypeButtons));
        } else if (button.field_146127_k >= 11 && button.field_146127_k <= 11 + this.learnTypeButtons.length) {
            int index = button.field_146127_k - 11;
            if (this.learnTypeButtons[index].field_146126_j.equals("X")) {
                this.learnTypeButtons[index].field_146126_j = "O";
                learnTypes.add(BaseStatsLearnType.GEN8_DEFAULT[index]);
            } else {
                this.learnTypeButtons[index].field_146126_j = "X";
                learnTypes.remove((Object)BaseStatsLearnType.GEN8_DEFAULT[index]);
            }
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    private void saveFields() {
        if (!GuiTutor.moveList.isEmpty()) {
            if (this.tutor != null) {
                Pixelmon.network.sendToServer((IMessage)new StoreTutorData(this.tutor.getId(), GuiTutor.moveList, learnTypes));
                this.textureEditor.saveCustomTexture();
            }
            GuiHelper.closeScreen();
        }
    }
}

