/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.pokemoneditor;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.RandomHelper;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.client.gui.GuiHelper;
import com.pixelmonmod.pixelmon.client.gui.GuiResources;
import com.pixelmonmod.pixelmon.client.gui.elements.GuiDropDown;
import com.pixelmonmod.pixelmon.client.gui.elements.GuiScreenDropDown;
import com.pixelmonmod.pixelmon.client.gui.elements.GuiTabCompleteTextField;
import com.pixelmonmod.pixelmon.client.gui.pokemoneditor.GuiIndividualEditorBase;
import com.pixelmonmod.pixelmon.config.PixelmonItems;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.EVStore;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.StatsType;
import com.pixelmonmod.pixelmon.enums.EnumNature;
import com.pixelmonmod.pixelmon.items.ItemHeld;
import com.pixelmonmod.pixelmon.util.ITranslatable;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class GuiPokemonEditorAdvanced
extends GuiScreenDropDown {
    private GuiIndividualEditorBase previousScreen;
    private Pokemon data;
    private GuiTextField[] evText = new GuiTextField[6];
    private GuiTextField[] ivText = new GuiTextField[6];
    private StatsType[] stats = new StatsType[]{StatsType.HP, StatsType.Attack, StatsType.Defence, StatsType.SpecialAttack, StatsType.SpecialDefence, StatsType.Speed};
    private GuiTextField heldText;
    private ItemStack heldItem = ItemStack.field_190927_a;
    private GuiTextField natureText;
    private GuiTextField friendshipText;
    private GuiDropDown<String> abilityDropDown;
    private GuiTextField[] allText;
    private static final int BUTTON_OKAY = 1;
    private static final int BUTTON_MAX_IVS = 3;
    private static final int BUTTON_MIN_IVS = 4;
    private static final int BUTTON_RANDOM_IVS = 5;
    private static final int BUTTON_RESET_EVS = 6;

    public GuiPokemonEditorAdvanced(GuiIndividualEditorBase previousScreen) {
        this.previousScreen = previousScreen;
        this.data = this.previousScreen.p;
    }

    @Override
    public void func_73866_w_() {
        if (this.abilityDropDown != null) {
            this.checkFields();
        }
        super.func_73866_w_();
        this.field_146292_n.add(new GuiButton(1, this.field_146294_l / 2 + 155, this.field_146295_m / 2 + 90, 30, 20, I18n.func_135052_a((String)"gui.guiItemDrops.ok", (Object[])new Object[0])));
        String[] allAbilities = this.data.getBaseStats().getAbilitiesArray();
        List<String> abilityList = Arrays.stream(allAbilities).filter(Objects::nonNull).collect(Collectors.toList());
        int abilityWidth = this.getLongestString(abilityList);
        this.abilityDropDown = new GuiDropDown<String>(abilityList, this.data.getAbilityName(), this.field_146294_l / 2 - 130, this.field_146295_m / 2 - 40, 80, 50, Math.max(80, abilityWidth)).setGetOptionString(ability -> I18n.func_135052_a((String)("ability." + ability + ".name"), (Object[])new Object[0]));
        this.addDropDown(this.abilityDropDown);
        this.field_146292_n.add(new GuiButton(3, this.field_146294_l / 2 + 125, this.field_146295_m / 2 - 50, 60, 20, I18n.func_135052_a((String)"gui.trainereditor.maxivs", (Object[])new Object[0])));
        this.field_146292_n.add(new GuiButton(4, this.field_146294_l / 2 + 125, this.field_146295_m / 2 - 25, 60, 20, I18n.func_135052_a((String)"gui.trainereditor.minivs", (Object[])new Object[0])));
        this.field_146292_n.add(new GuiButton(5, this.field_146294_l / 2 + 125, this.field_146295_m / 2, 60, 20, I18n.func_135052_a((String)"gui.trainereditor.randomivs", (Object[])new Object[0])));
        this.field_146292_n.add(new GuiButton(6, this.field_146294_l / 2 + 125, this.field_146295_m / 2 + 35, 60, 20, I18n.func_135052_a((String)"gui.trainereditor.resetevs", (Object[])new Object[0])));
        this.allText = new GuiTextField[15];
        for (int i = 0; i < this.stats.length; ++i) {
            this.evText[i] = new GuiTextField(i, this.field_146297_k.field_71466_p, this.field_146294_l / 2 + 45, this.field_146295_m / 2 - 55 + i * 25, 30, 20);
            this.evText[i].func_146180_a(String.valueOf(this.data.getEVs().getArray()[i]));
            this.ivText[i] = new GuiTextField(i + this.evText.length, this.field_146297_k.field_71466_p, this.field_146294_l / 2 + 85, this.field_146295_m / 2 - 55 + i * 25, 30, 20);
            this.ivText[i].func_146180_a(String.valueOf(this.data.getIVs().getArray()[i]));
            this.allText[i] = this.evText[i];
            this.allText[i + this.evText.length] = this.ivText[i];
        }
        this.heldText = new GuiTabCompleteTextField(13, this.field_146297_k.field_71466_p, this.field_146294_l / 2 - 130, this.field_146295_m / 2 - 4, 80, 20).setCompletions(PixelmonItems.getAllItems().stream().filter(item -> item instanceof ItemHeld).map(ItemStack::new).map(ItemStack::func_82833_r).collect(Collectors.toSet()));
        if (!this.data.getHeldItem().func_190926_b()) {
            this.heldText.func_146180_a(I18n.func_135052_a((String)this.data.getHeldItem().func_77977_a(), (Object[])new Object[0]));
            this.updateHeldItem();
        }
        this.natureText = new GuiTabCompleteTextField(14, this.field_146297_k.field_71466_p, this.field_146294_l / 2 - 130, this.field_146295_m / 2 + 34, 80, 20).setCompletions(Arrays.stream(EnumNature.values()).map(ITranslatable::getLocalizedName).collect(Collectors.toSet()));
        this.natureText.func_146180_a(this.data.getBaseNature().getLocalizedName());
        this.friendshipText = new GuiTextField(14, this.field_146297_k.field_71466_p, this.field_146294_l / 2 - 130, this.field_146295_m / 2 + 70, 80, 20);
        this.friendshipText.func_146180_a(String.valueOf(this.data.getFriendship()));
        this.allText[12] = this.heldText;
        this.allText[13] = this.natureText;
        this.allText[14] = this.friendshipText;
    }

    private int getLongestString(List<String> items) {
        return GuiHelper.getLongestStringWidth(items.stream().map(s -> I18n.func_135052_a((String)("ability." + s + ".name"), (Object[])new Object[0])).collect(Collectors.toList())) + 2;
    }

    @Override
    protected void drawBackgroundUnderMenus(float renderPartialTicks, int mouseX, int mouseY) {
        this.field_146297_k.field_71446_o.func_110577_a(GuiResources.cwPanel);
        GuiHelper.drawImageQuad(this.field_146294_l / 2 - 200, this.field_146295_m / 2 - 120, 400.0, 240.0f, 0.0, 0.0, 1.0, 1.0, this.field_73735_i);
        RenderHelper.func_74518_a();
        GuiHelper.drawCenteredString(this.previousScreen.titleText, this.field_146294_l / 2, this.field_146295_m / 2 - 90, 0, false);
        for (GuiTextField textField : this.allText) {
            textField.func_146194_f();
        }
        for (int i = 0; i < this.stats.length; ++i) {
            GuiHelper.drawStringRightAligned(this.stats[i].getLocalizedName(), this.field_146294_l / 2 + 40, this.field_146295_m / 2 - 50 + i * 25, 0, false);
        }
        this.field_146297_k.field_71466_p.func_78276_b(I18n.func_135052_a((String)"gui.trainereditor.evs", (Object[])new Object[0]), this.field_146294_l / 2 + 50, this.field_146295_m / 2 - 70, 0);
        this.field_146297_k.field_71466_p.func_78276_b(I18n.func_135052_a((String)"gui.trainereditor.ivs", (Object[])new Object[0]), this.field_146294_l / 2 + 90, this.field_146295_m / 2 - 70, 0);
        GuiHelper.drawCenteredString(I18n.func_135052_a((String)"gui.screenpokechecker.ability", (Object[])new Object[0]), this.field_146294_l / 2 - 90, this.abilityDropDown.getTop() - 10, 0, false);
        GuiHelper.drawCenteredString(I18n.func_135052_a((String)"gui.trainereditor.helditem", (Object[])new Object[0]), this.field_146294_l / 2 - 90, this.heldText.field_146210_g - 10, 0, false);
        GuiHelper.drawCenteredString(I18n.func_135052_a((String)"gui.screenpokechecker.nature", (Object[])new Object[0]), this.field_146294_l / 2 - 90, this.natureText.field_146210_g - 10, 0, false);
        GuiHelper.drawCenteredString(I18n.func_135052_a((String)"gui.screenpokechecker.happiness", (Object[])new Object[0]), this.field_146294_l / 2 - 90, this.friendshipText.field_146210_g - 10, 0, false);
        if (!this.heldItem.func_190926_b()) {
            this.field_146296_j.func_180450_b(this.heldItem, this.field_146294_l / 2 - 150, this.heldText.field_146210_g);
        }
        GuiHelper.bindPokemonSprite(this.data, this.field_146297_k);
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        GuiHelper.drawImageQuad(this.field_146294_l / 2 - 157, this.field_146295_m / 2 - 73, 20.0, 20.0f, 0.0, 0.0, 1.0, 1.0, 1.0f);
    }

    protected void func_73869_a(char key, int keyCode) throws IOException {
        for (GuiTextField textField : this.allText) {
            textField.func_146201_a(key, keyCode);
        }
        if (this.heldText.func_146206_l()) {
            this.updateHeldItem();
        }
        if (keyCode == 1 || keyCode == 28) {
            this.saveFields();
        }
    }

    @Override
    protected void mouseClickedUnderMenus(int mouseX, int mouseY, int clickedButton) throws IOException {
        for (GuiTextField textField : this.allText) {
            textField.func_146192_a(mouseX, mouseY, clickedButton);
        }
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        block5: {
            block8: {
                block7: {
                    block6: {
                        block4: {
                            super.func_146284_a(button);
                            if (button.field_146127_k != 1) break block4;
                            this.saveFields();
                            break block5;
                        }
                        if (button.field_146127_k != 3) break block6;
                        for (GuiTextField iv : this.ivText) {
                            iv.func_146180_a("31");
                        }
                        break block5;
                    }
                    if (button.field_146127_k != 4) break block7;
                    for (GuiTextField iv : this.ivText) {
                        iv.func_146180_a("0");
                    }
                    break block5;
                }
                if (button.field_146127_k != 5) break block8;
                for (GuiTextField iv : this.ivText) {
                    iv.func_146180_a(String.valueOf(RandomHelper.getRandomNumberBetween(0, 31)));
                }
                break block5;
            }
            if (button.field_146127_k != 6) break block5;
            for (GuiTextField ev : this.evText) {
                ev.func_146180_a("0");
            }
        }
    }

    private void saveFields() {
        if (this.checkFields()) {
            this.field_146297_k.func_147108_a((GuiScreen)this.previousScreen);
        }
    }

    private void updateHeldItem() {
        try {
            Item newItem = PixelmonItems.getItemFromName(this.heldText.func_146179_b());
            if (newItem instanceof ItemHeld) {
                this.heldItem = new ItemStack(newItem);
            } else if (!"en_us".equals(Minecraft.func_71410_x().func_135016_M().func_135041_c().func_135034_a())) {
                for (Item item : PixelmonItems.getAllItems()) {
                    if (!(item instanceof ItemHeld) || !new ItemStack(item).func_82833_r().equalsIgnoreCase(this.heldText.func_146179_b())) continue;
                    this.heldItem = new ItemStack(item);
                    return;
                }
                this.heldItem = ItemStack.field_190927_a;
            } else {
                this.heldItem = ItemStack.field_190927_a;
            }
        }
        catch (Exception e) {
            Pixelmon.LOGGER.warn("Failed to update held item!");
            e.printStackTrace();
        }
    }

    private boolean checkFields() {
        boolean isValid = true;
        for (GuiTextField iv : this.ivText) {
            try {
                int ivNumber = Integer.parseInt(iv.func_146179_b());
                if (ivNumber < 0) {
                    isValid = false;
                    iv.func_146180_a("0");
                    continue;
                }
                if (ivNumber <= 31) continue;
                isValid = false;
                iv.func_146180_a("31");
            }
            catch (NumberFormatException e) {
                isValid = false;
                iv.func_146180_a("0");
            }
        }
        int evTotal = 0;
        for (GuiTextField ev : this.evText) {
            int evNumber;
            try {
                evNumber = Integer.parseInt(ev.func_146179_b());
                if (evNumber < 0) {
                    isValid = false;
                    ev.func_146180_a("0");
                    evNumber = 0;
                } else if (evNumber > EVStore.MAX_EVS) {
                    isValid = false;
                    ev.func_146180_a(EVStore.MAX_EVS + "");
                    evNumber = EVStore.MAX_EVS;
                }
            }
            catch (NumberFormatException e) {
                isValid = false;
                ev.func_146180_a("0");
                evNumber = 0;
            }
            if ((evTotal += evNumber) <= EVStore.MAX_TOTAL_EVS) continue;
            isValid = false;
            ev.func_146180_a(String.valueOf(evNumber - (evTotal - EVStore.MAX_TOTAL_EVS)));
            evTotal = EVStore.MAX_TOTAL_EVS;
        }
        EnumNature newNature = EnumNature.natureFromString(this.natureText.func_146179_b());
        if (newNature == null) {
            isValid = false;
            this.natureText.func_146180_a(this.data.getBaseNature().getLocalizedName());
        }
        this.updateHeldItem();
        if (this.heldItem.func_190926_b() && !this.heldText.func_146179_b().equals("")) {
            this.heldText.func_146180_a("");
            isValid = false;
        }
        int newFriendship = this.data.getFriendship();
        try {
            newFriendship = Integer.parseInt(this.friendshipText.func_146179_b());
            if (newFriendship > 255) {
                this.friendshipText.func_146180_a(String.valueOf(255));
                isValid = false;
            } else if (newFriendship < 0) {
                this.friendshipText.func_146180_a("0");
                isValid = false;
            }
        }
        catch (NumberFormatException iv) {
            // empty catch block
        }
        if (isValid) {
            try {
                for (int i = 0; i < this.stats.length; ++i) {
                    this.data.getEVs().setStat(this.stats[i], Integer.parseInt(this.evText[i].func_146179_b()));
                    this.data.getIVs().setStat(this.stats[i], Integer.parseInt(this.ivText[i].func_146179_b()));
                }
                this.data.setNature(newNature);
                this.data.setHeldItem(this.heldItem);
                this.data.setAbility(this.abilityDropDown.getSelected());
                this.data.setFriendship(newFriendship);
            }
            catch (NumberFormatException e) {
                isValid = false;
            }
        }
        return isValid;
    }
}

