/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.raids;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.RandomHelper;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.battles.raids.RaidData;
import com.pixelmonmod.pixelmon.client.ClientProxy;
import com.pixelmonmod.pixelmon.client.SoundHelper;
import com.pixelmonmod.pixelmon.client.gui.GuiHelper;
import com.pixelmonmod.pixelmon.client.gui.GuiParticleEngine;
import com.pixelmonmod.pixelmon.client.gui.battles.GuiBattle;
import com.pixelmonmod.pixelmon.client.gui.raids.RaidButton;
import com.pixelmonmod.pixelmon.client.models.smd.AnimationType;
import com.pixelmonmod.pixelmon.client.render.RenderPixelmon;
import com.pixelmonmod.pixelmon.comm.packetHandlers.raids.RaidAction;
import com.pixelmonmod.pixelmon.config.PixelmonItemsPokeballs;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.enums.EnumGrowth;
import com.pixelmonmod.pixelmon.items.ItemPokeball;
import com.pixelmonmod.pixelmon.sounds.PixelSounds;
import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.input.Mouse;

public class GuiRaidCatch
extends GuiScreen {
    private static final ResourceLocation WATERMARK = new ResourceLocation("pixelmon", "textures/gui/raids/watermark.png");
    private static final ResourceLocation STAR = new ResourceLocation("pixelmon", "textures/gui/raids/star.png");
    private static final ResourceLocation SHINY = new ResourceLocation("pixelmon", "textures/gui/battle/shiny.png");
    private final ArrayList<RaidButton> buttons = new ArrayList();
    private RaidData raid;
    private EntityPixelmon pixelmon;
    private boolean shiny;
    private ItemStack[] drops;
    private ArrayList<Tuple<Integer, ItemStack>> balls = new ArrayList();
    private boolean canCatch;
    private boolean sentToPC;
    private boolean catchSuccess = false;
    private boolean pcFull = false;
    private boolean inCatchAnimation = false;
    private int shakes = 0;
    private int ticker = 0;
    private int delay = -1;
    private boolean shakeSound = false;
    private boolean shouldRefresh = false;
    private int ballIndex = 0;
    private int scrollIndex = 0;
    private boolean closing = false;
    protected GuiParticleEngine particleEngine = new GuiParticleEngine();
    private boolean scrolling = false;
    private boolean click = false;
    private long lastTime = -1L;

    public GuiRaidCatch(RaidData raid, boolean shiny, ItemStack[] drops, boolean canCatch) {
        this.field_146297_k = Minecraft.func_71410_x();
        SoundHelper.playSound(SoundEvents.field_194228_if, 0.5f, 1.0f);
        this.drops = drops;
        this.canCatch = canCatch;
        if (this.canCatch) {
            for (int i = 0; i < this.field_146297_k.field_71439_g.field_71071_by.func_70302_i_(); ++i) {
                ItemStack stack = this.field_146297_k.field_71439_g.field_71071_by.func_70301_a(i);
                if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemPokeball)) continue;
                this.balls.add((Tuple<Integer, ItemStack>)new Tuple((Object)i, (Object)stack));
            }
        }
        this.shiny = shiny;
        this.setRaid(raid);
    }

    public void setRaid(RaidData raid) {
        this.setRaid(raid, null);
    }

    public void setRaid(RaidData raid, GuiRaidCatch old) {
        this.raid = raid;
        if (old != null) {
            this.pixelmon = old.pixelmon;
        } else {
            Pokemon pokemon = Pixelmon.pokemonFactory.create(raid.getSpecies());
            if (raid.getForm() != null) {
                pokemon.setForm(raid.getForm());
            }
            pokemon.setGrowth(EnumGrowth.Ordinary);
            pokemon.setShiny(this.shiny);
            this.pixelmon = new EntityPixelmon((World)this.field_146297_k.field_71441_e);
            this.pixelmon.setPokemon(pokemon);
            this.pixelmon.setAnimation(AnimationType.IDLE);
            this.pixelmon.checkAnimation();
            this.pixelmon.initAnimation();
        }
        this.shouldRefresh = true;
    }

    public void setShakes(int shakes, boolean sentToPC) {
        if (!this.inCatchAnimation && this.canCatch) {
            if (shakes < 0) {
                this.pcFull = true;
            } else {
                SoundHelper.playSound(PixelSounds.pokeballCapture, 0.4f, 1.0f);
                this.inCatchAnimation = true;
                this.ticker = -500;
                this.shakes = MathHelper.func_76125_a((int)shakes, (int)1, (int)3);
                this.catchSuccess = this.shakes == 3;
                this.canCatch = false;
                this.sentToPC = sentToPC;
            }
            this.shouldRefresh = true;
        }
    }

    private void initButtons() {
        this.buttons.clear();
        if (this.canCatch) {
            this.buttons.add(new RaidButton((double)this.field_146294_l * 0.5, (double)this.field_146295_m / 1.06 - (double)((int)((double)this.field_146295_m * 0.08 * 2.0)), 1.0, 0.0, (float)this.field_146295_m / 17.0f, "<", this.raid, button -> {
                boolean prev = this.canUseCurrentBall();
                --this.ballIndex;
                if (this.ballIndex < 0) {
                    this.ballIndex = this.balls.size() - 1;
                }
                if (this.canUseCurrentBall() != prev) {
                    this.shouldRefresh = true;
                }
            }).setEnabled(this.balls.size() > 1).setVisible(this.canCatch));
            this.buttons.add(new RaidButton((double)this.field_146294_l * 0.6, (double)this.field_146295_m / 1.06 - (double)((int)((double)this.field_146295_m * 0.08 * 2.0)), 1.0, 0.0, (float)this.field_146295_m / 17.0f, ">", this.raid, button -> {
                boolean prev = this.canUseCurrentBall();
                ++this.ballIndex;
                if (this.ballIndex >= this.balls.size()) {
                    this.ballIndex = 0;
                }
                if (this.canUseCurrentBall() != prev) {
                    this.shouldRefresh = true;
                }
            }).setEnabled(this.balls.size() > 1).setVisible(this.canCatch));
            this.buttons.add(new RaidButton((double)this.field_146294_l * 0.643, (double)this.field_146295_m / 1.06 - (double)((int)((double)this.field_146295_m * 0.08 * 2.0)), 1.0, (float)this.field_146294_l / 7.0f, (float)this.field_146295_m / 17.0f, this.pcFull ? I18n.func_135052_a((String)"raid.button.pcfull", (Object[])new Object[0]) : (this.balls.isEmpty() ? I18n.func_135052_a((String)"raid.button.noballs", (Object[])new Object[0]) : (this.canUseCurrentBall() ? I18n.func_135052_a((String)"raid.button.catch", (Object[])new Object[0]) : I18n.func_135052_a((String)"raid.button.cantuse", (Object[])new Object[0]))), this.raid, button -> Pixelmon.network.sendToServer((IMessage)new RaidAction(this.raid.getDen(), 10, (Integer)this.balls.get(this.ballIndex).func_76341_a()))).setEnabled(this.canCatch && !this.balls.isEmpty() && !this.pcFull && this.canUseCurrentBall()).setVisible(this.canCatch));
            this.buttons.add(new RaidButton((double)this.field_146294_l * 0.83, (double)this.field_146295_m / 1.06 - (double)((int)((double)this.field_146295_m * 0.08 * 2.0)), 1.0, (float)this.field_146294_l / 7.0f, (float)this.field_146295_m / 17.0f, I18n.func_135052_a((String)"raid.button.dontcatch", (Object[])new Object[0]), this.raid, button -> {
                this.closing = true;
                GuiBattle.restoreSettingsAndCloseStatic(ClientProxy.battleManager);
            }).setEnabled(this.canCatch).setVisible(this.canCatch));
        } else {
            this.buttons.add(new RaidButton((double)this.field_146294_l * 0.55, (double)this.field_146295_m / 1.06 - (double)((int)((double)this.field_146295_m * 0.08 * 2.0)), 1.0, (float)this.field_146294_l / 2.365f, (float)this.field_146295_m / 17.0f, I18n.func_135052_a((String)"raid.button.done", (Object[])new Object[0]), this.raid, button -> {
                this.closing = true;
                GuiBattle.restoreSettingsAndCloseStatic(ClientProxy.battleManager);
            }).setEnabled(!this.inCatchAnimation && !this.canCatch).setVisible(!this.canCatch));
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        float scale;
        if (this.buttons.isEmpty() || this.shouldRefresh) {
            this.shouldRefresh = false;
            this.initButtons();
        }
        this.func_146276_q_();
        GlStateManager.func_179141_d();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (RaidButton button : this.buttons) {
            button.draw(mouseX, mouseY, partialTicks);
        }
        this.field_146297_k.field_71446_o.func_110577_a(STAR);
        int starSize = (int)((double)this.field_146294_l * 0.05);
        double sw = this.raid.getStars() * starSize;
        for (int i = 0; i < this.raid.getStars(); ++i) {
            GuiHelper.drawImage((double)((float)this.field_146294_l * 0.75f + (float)(starSize * i)) - sw / 2.0, (float)this.field_146295_m * 0.185f, starSize, starSize, 1.0f);
        }
        float fs = (float)this.field_146294_l * 0.045f;
        GuiHelper.drawScaledCenteredString(I18n.func_135052_a((String)(this.catchSuccess && !this.inCatchAnimation ? "raid.caught" : "raid.defeated"), (Object[])new Object[]{this.raid.getSpecies().getPokemonName()}), (float)this.field_146294_l * 0.755f, (float)this.field_146295_m * 0.125f - fs / 4.0f, -1, fs);
        this.drawDrops(mouseX, mouseY);
        if (!this.balls.isEmpty() && this.canCatch) {
            scale = (float)this.field_146294_l / 960.0f * 3.0f;
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)((float)this.field_146294_l * 0.525f), (double)((double)this.field_146295_m * 0.7675), (double)0.0);
            GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
            this.drawItem((ItemStack)this.balls.get(this.ballIndex).func_76340_b(), 0.0f, 0.0f, 770, 771);
            GlStateManager.func_179121_F();
        }
        if (this.canCatch || this.ticker < 0 || !this.raid.canAllCatch && !this.raid.isOwner(this.field_146297_k.field_71439_g.func_110124_au())) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179142_g();
            GlStateManager.func_179126_j();
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_179109_b((float)((float)this.field_146294_l / 4.0f), (float)((float)this.field_146295_m / 4.0f * 3.0f), (float)300.0f);
            double referenceW = (float)this.field_146295_m / 3.0f;
            double referenceH = (float)this.field_146295_m / 4.0f;
            double dh = this.pixelmon.getBaseStats().getBoundsData().getHeight() - referenceH;
            double dw = this.pixelmon.getBaseStats().getBoundsData().getWidth() - referenceW;
            double scalar = 1.0;
            scalar = dh > dw ? referenceH / this.pixelmon.getBaseStats().getBoundsData().getHeight() : referenceW / this.pixelmon.getBaseStats().getBoundsData().getWidth();
            GlStateManager.func_179139_a((double)scalar, (double)scalar, (double)scalar);
            if (this.ticker < 0) {
                float shrink = (float)Math.max(0, -this.ticker) / 500.0f;
                GlStateManager.func_179152_a((float)shrink, (float)shrink, (float)shrink);
            }
            GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            RenderHelper.func_74519_b();
            try {
                RenderManager renderManager = Minecraft.func_71410_x().func_175598_ae();
                Render entityClassRenderObject = renderManager.func_78715_a(EntityPixelmon.class);
                RenderPixelmon rp = (RenderPixelmon)entityClassRenderObject;
                rp.renderPixelmon(this.pixelmon, 0.0, 0.0, 0.0, partialTicks, true);
                renderManager.field_78735_i = 180.0f;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            GlStateManager.func_179121_F();
            if (this.shiny && RandomHelper.rand.nextInt(80) == 0) {
                double dx = (RandomHelper.rand.nextDouble() - 0.5) * (double)this.field_146295_m * 0.5;
                double dy = (RandomHelper.rand.nextDouble() - 0.5) * (double)this.field_146295_m * 0.5;
                int size = 15 + RandomHelper.rand.nextInt(15);
                this.particleEngine.addParticle(new GuiParticleEngine.GuiParticle(SHINY, (double)this.field_146294_l * 0.225 + dx, (double)this.field_146295_m * 0.5 + dy, 1000.0, 0.0, 0.0, 0.0, 1.0f, 0.8f, 0.3f, 0.0f, size, size, 120, particle -> {
                    int x = particle.age;
                    int m = particle.maxAge;
                    int h = m / 2;
                    particle.a = (float)(x <= h ? x : h - (x - h)) / (float)h;
                }));
            }
        }
        if (!this.canCatch) {
            GlStateManager.func_179094_E();
            scale = (float)this.field_146294_l / 960.0f * 6.0f;
            GlStateManager.func_179137_b((double)((float)this.field_146294_l * 0.201f), (double)((double)this.field_146295_m * 0.58), (double)200.0);
            GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
            if (this.inCatchAnimation) {
                long ms = this.getMillis();
                if (this.shakes > 0) {
                    boolean tick = true;
                    float scalar = 0.5f;
                    float speed = 1.0f;
                    float angle = 0.0f;
                    float shrink = 1.0f;
                    if (this.ticker >= 0) {
                        if (this.delay == -1) {
                            this.delay = 500;
                        }
                        if (this.delay > 0) {
                            this.delay = (int)((long)this.delay - ms);
                            tick = false;
                        }
                        if ((float)this.ticker < 100.0f * speed) {
                            angle = (float)(-this.ticker) * scalar;
                        } else if ((float)this.ticker < 300.0f * speed) {
                            angle = ((float)this.ticker - 200.0f * speed) * scalar;
                            if ((float)this.ticker < 200.0f * speed && !this.shakeSound) {
                                SoundHelper.playSound(SoundEvents.field_187676_dE, 1.0f, 1.0f);
                                this.shakeSound = true;
                            }
                        } else if ((float)this.ticker < 400.0f * speed) {
                            angle = (400.0f * speed - (float)this.ticker) * scalar;
                        } else if ((float)this.ticker > 500.0f * speed) {
                            this.ticker = 0;
                            --this.shakes;
                            this.shakeSound = false;
                        }
                    } else {
                        shrink = 1.0f - (float)Math.max(0, -this.ticker) / 500.0f;
                    }
                    GlStateManager.func_179109_b((float)8.0f, (float)16.0f, (float)0.0f);
                    GlStateManager.func_179152_a((float)shrink, (float)shrink, (float)shrink);
                    GlStateManager.func_179114_b((float)angle, (float)0.0f, (float)0.0f, (float)1.0f);
                    GlStateManager.func_179109_b((float)-8.0f, (float)-16.0f, (float)0.0f);
                    if (tick) {
                        this.ticker = (int)((double)this.ticker + (double)ms / 2.5);
                    }
                } else {
                    this.inCatchAnimation = false;
                    this.shouldRefresh = true;
                    if (this.catchSuccess) {
                        SoundHelper.playSound(PixelSounds.pokeballCaptureSuccess, 0.2f, 1.0f);
                        for (int i = 0; i < 15; ++i) {
                            int r = RandomHelper.rand.nextInt(360);
                            double dx = (RandomHelper.rand.nextDouble() * 2.0 - 1.0) * (double)this.field_146294_l * 0.05;
                            double dy = (RandomHelper.rand.nextDouble() * 2.0 - 1.0) * (double)this.field_146294_l * 0.05;
                            this.particleEngine.addParticle(new GuiParticleEngine.GuiParticle(STAR, (double)((float)this.field_146294_l * 0.251f) + dx, (double)this.field_146295_m * 0.675 + dy, 0.0, 0.0, 0.0, 0.0, 0.96f, 0.78f, 0.0f, 0.0f, 0.0f, 0.0f, RandomHelper.rand.nextInt(100) + 100, particle -> {
                                int x = particle.age;
                                int m = particle.maxAge;
                                int h = m / 2;
                                float s = (float)(x <= h ? x : h - (x - h)) / (float)h;
                                GlStateManager.func_179137_b((double)particle.x, (double)particle.y, (double)0.0);
                                GlStateManager.func_179114_b((float)(r + x), (float)0.0f, (float)0.0f, (float)1.0f);
                                GlStateManager.func_179137_b((double)(-particle.x), (double)(-particle.y), (double)0.0);
                                GlStateManager.func_179109_b((float)(-particle.w / 2.0f), (float)(-particle.h / 2.0f), (float)0.0f);
                                particle.a = s;
                                particle.w = s * (float)this.field_146294_l * 0.0525f;
                                particle.h = s * (float)this.field_146294_l * 0.0525f;
                            }));
                        }
                    } else {
                        ItemStack[] stacks;
                        SoundHelper.playSound(SoundEvents.field_187635_cQ, 0.8f, 0.8f + this.field_146297_k.field_71441_e.field_73012_v.nextFloat() * 0.4f);
                        ItemPokeball ball = (ItemPokeball)((ItemStack)this.balls.get(this.ballIndex).func_76340_b()).func_77973_b();
                        for (ItemStack stack : stacks = new ItemStack[]{new ItemStack((Item)ball.type.getLid()), new ItemStack(PixelmonItemsPokeballs.ironBase), new ItemStack(Blocks.field_150430_aB)}) {
                            double mY = 0.1 + (RandomHelper.rand.nextDouble() * 0.1 - 0.05);
                            this.particleEngine.addParticle(new GuiParticleEngine.GuiParticle(null, (float)this.field_146294_l * 0.201f, (double)this.field_146295_m * 0.58, 0.0, RandomHelper.rand.nextDouble() * 2.0 - 1.0, -2.0, 0.0, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 300, particle -> {
                                GlStateManager.func_179094_E();
                                GlStateManager.func_179137_b((double)particle.x, (double)particle.y, (double)200.0);
                                GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
                                this.drawItem(stack, 0.0f, 0.0f, 770, 771);
                                GlStateManager.func_179121_F();
                                particle.mY += mY;
                            }));
                        }
                    }
                }
            }
            if (this.shakes > 0 || this.catchSuccess) {
                this.drawItem((ItemStack)this.balls.get(this.ballIndex).func_76340_b(), 0.0f, 0.0f, 770, 771, this.shakes == 0);
            }
            GlStateManager.func_179121_F();
        }
        this.checkMouseWheel(mouseX, mouseY);
        this.particleEngine.draw();
    }

    private void drawDrops(int mouseX, int mouseY) {
        int index;
        float fs = (float)this.field_146294_l * 0.045f;
        for (int i = 0; i < 6 && (index = this.scrollIndex + i) < this.drops.length; ++i) {
            ItemStack stack = this.drops[index];
            float h = (float)this.field_146295_m * (0.3f + 0.076f * (float)i);
            this.field_146297_k.field_71446_o.func_110577_a(STAR);
            float scale = (float)this.field_146294_l / 960.0f * 2.0f;
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)((float)this.field_146294_l * 0.55f), (double)((double)h - (double)this.field_146295_m * 0.015), (double)0.0);
            GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
            this.drawItem(stack, 0.0f, 0.0f, 770, 771);
            GlStateManager.func_179121_F();
            GuiHelper.drawScaledSquashedString(stack.func_82833_r(), (float)this.field_146294_l * 0.595f, h, -1, fs, 100.0);
            GuiHelper.drawScaledString("x " + stack.func_190916_E(), (float)this.field_146294_l * 0.89f, h - (float)this.field_146295_m * 0.005f, -1, fs);
        }
        if (this.drops.length > 6) {
            boolean mouseOver;
            int top = (int)((double)this.field_146295_m * 0.29);
            int bottom = (int)((double)this.field_146295_m * 0.735);
            int diff = bottom - top;
            int div = this.drops.length - 5;
            float dy = (float)diff / (float)div;
            Gui.func_73734_a((int)((int)((double)this.field_146294_l * 0.972)), (int)top, (int)((int)((double)this.field_146294_l * 0.9825)), (int)bottom, (int)-298897617);
            int bX1 = (int)((double)this.field_146294_l * 0.972);
            int bY1 = (int)((float)top + dy * (float)this.scrollIndex);
            int bX2 = (int)((double)this.field_146294_l * 0.9825);
            int bY2 = (int)((float)top + dy * (float)(this.scrollIndex + 1));
            boolean bl = mouseOver = mouseX >= bX1 && mouseY >= bY1 && mouseX <= bX2 && mouseY <= bY2;
            if (this.click && mouseOver) {
                this.scrolling = true;
            }
            if (!Mouse.isButtonDown((int)0)) {
                this.scrolling = false;
            }
            if (this.scrolling) {
                if (mouseY > bY2) {
                    ++this.scrollIndex;
                    if (this.scrollIndex > this.drops.length - 6) {
                        this.scrollIndex = Math.max(0, this.drops.length - 6);
                    }
                } else if (mouseY < bY1) {
                    --this.scrollIndex;
                    if (this.scrollIndex < 0) {
                        this.scrollIndex = 0;
                    }
                }
            }
            Gui.func_73734_a((int)bX1, (int)bY1, (int)bX2, (int)bY2, (int)(mouseOver || this.scrolling ? -289686597 : -292318317));
        }
        this.click = false;
    }

    private void drawItem(ItemStack stack, float x, float y, int srcFactor, int destFactor) {
        this.drawItem(stack, x, y, srcFactor, destFactor, false);
    }

    private void drawItem(ItemStack stack, float x, float y, int srcFactor, int destFactor, boolean darken) {
        IBakedModel bakedmodel = this.field_146296_j.func_184393_a(stack, null, null);
        GlStateManager.func_179094_E();
        this.field_146297_k.field_71446_o.func_110577_a(TextureMap.field_110575_b);
        this.field_146297_k.field_71446_o.func_110581_b(TextureMap.field_110575_b).func_174936_b(false, false);
        GlStateManager.func_179091_B();
        GlStateManager.func_179141_d();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179126_j();
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)srcFactor, (int)destFactor);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179109_b((float)x, (float)y, (float)(100.0f + this.field_73735_i));
        GlStateManager.func_179109_b((float)8.0f, (float)8.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)1.0f, (float)-1.0f, (float)1.0f);
        GlStateManager.func_179152_a((float)16.0f, (float)16.0f, (float)16.0f);
        if (darken) {
            GlStateManager.func_179145_e();
        } else {
            GlStateManager.func_179140_f();
        }
        bakedmodel = ForgeHooksClient.handleCameraTransforms((IBakedModel)bakedmodel, (ItemCameraTransforms.TransformType)ItemCameraTransforms.TransformType.GUI, (boolean)false);
        this.field_146296_j.func_180454_a(stack, bakedmodel);
        GlStateManager.func_179118_c();
        GlStateManager.func_179101_C();
        GlStateManager.func_179140_f();
        GlStateManager.func_179121_F();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179097_i();
        this.field_146297_k.field_71446_o.func_110577_a(TextureMap.field_110575_b);
        this.field_146297_k.field_71446_o.func_110581_b(TextureMap.field_110575_b).func_174935_a();
    }

    private void checkMouseWheel(int mouseX, int mouseY) {
        int mousewheelDirection = Mouse.getDWheel();
        if ((double)mouseX >= (double)this.field_146294_l * 0.525 && (double)mouseY >= (double)this.field_146295_m * 0.25 && (double)mouseY <= (double)this.field_146295_m * 0.75) {
            if (mousewheelDirection == -120) {
                ++this.scrollIndex;
                if (this.scrollIndex > this.drops.length - 6) {
                    this.scrollIndex = Math.max(0, this.drops.length - 6);
                }
            } else if (mousewheelDirection == 120) {
                --this.scrollIndex;
                if (this.scrollIndex < 0) {
                    this.scrollIndex = 0;
                }
            }
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        for (RaidButton button : this.buttons) {
            button.onClick(mouseX, mouseY, mouseButton);
        }
        this.click = true;
    }

    public void func_146276_q_() {
        this.func_73733_a(0, 0, this.field_146294_l, this.field_146295_m, -1596523265, -1866285374);
        int bgBar = (int)((double)this.field_146295_m * 0.125);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)this.field_146294_l, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        this.raid.getDenEntity((World)this.field_146297_k.field_71441_e).map(den -> {
            GuiHelper.drawGradientRect(bgBar, 0, 0.0f, this.field_146295_m - bgBar, this.field_146294_l, den.getColorUIA().getRGB(), den.getColorUIB().getRGB());
            Color c3 = den.getColorUIC();
            GlStateManager.func_179131_c((float)((float)c3.getRed() / 255.0f), (float)((float)c3.getGreen() / 255.0f), (float)((float)c3.getBlue() / 255.0f), (float)0.4f);
            return true;
        }).orElseGet(() -> {
            GuiHelper.drawGradientRect(bgBar, 0, 0.0f, this.field_146295_m - bgBar, this.field_146294_l, -37796, -5752007);
            GlStateManager.func_179131_c((float)0.8f, (float)0.0f, (float)0.0f, (float)0.4f);
            return true;
        });
        GlStateManager.func_179121_F();
        this.field_146297_k.field_71446_o.func_110577_a(WATERMARK);
        GlStateManager.func_179147_l();
        GlStateManager.func_179141_d();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179094_E();
        GlStateManager.func_179114_b((float)-35.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GuiHelper.drawImage((float)this.field_146294_l / 2.8f, (float)this.field_146295_m / 1.2f, (float)this.field_146294_l / 3.75f, (double)((float)this.field_146294_l / 3.75f) * 1.65591398, 2.0f);
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        GuiHelper.drawQuad(this.field_146294_l, (double)bgBar * 0.5, 0.0, (double)this.field_146294_l - (double)this.field_146294_l * 0.475, (double)bgBar * 0.5, 0.0, (double)this.field_146294_l - (double)this.field_146294_l * 0.5, (double)bgBar * 1.5, 0.0, this.field_146294_l, (double)bgBar * 1.5, 0.0, Color.BLACK);
        GlStateManager.func_179121_F();
    }

    public void func_73876_c() {
        this.pixelmon.getAnimationVariables().tick();
    }

    public void func_175273_b(Minecraft mc, int nw, int nh) {
        super.func_175273_b(mc, nw, nh);
        this.initButtons();
    }

    public void func_146281_b() {
        super.func_146281_b();
        if (!this.closing) {
            this.field_146297_k.func_152344_a(() -> this.field_146297_k.func_147108_a((GuiScreen)this));
        } else if (this.sentToPC) {
            this.field_146297_k.field_71439_g.func_145747_a((ITextComponent)new TextComponentTranslation("pixelmon.storage.partyfull", new Object[]{this.pixelmon.func_145748_c_()}));
        }
    }

    public void func_146282_l() throws IOException {
    }

    public boolean func_73868_f() {
        return false;
    }

    public long getMillis() {
        if (this.lastTime < 0L) {
            this.lastTime = System.currentTimeMillis();
            return 0L;
        }
        long time = System.currentTimeMillis();
        long diff = time - this.lastTime;
        this.lastTime = time;
        return diff;
    }

    private boolean canUseCurrentBall() {
        if (this.balls.isEmpty()) {
            return false;
        }
        ItemPokeball ball = (ItemPokeball)((ItemStack)this.balls.get(this.ballIndex).func_76340_b()).func_77973_b();
        return this.raid.canUseMaster || ball.type.getBallBonus() < 255.0;
    }
}

